/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.result;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;
import kd.taxc.tctrc.common.util.PageShowCommon;

public class RiskCollectPlugin
extends AbstractFormPlugin
implements ItemClickListener {
    private static final String BTN_COLLECT = "collect";
    private static final String BTN_UNCOLLECT = "uncollect";
    private static final String BTN_CANCEL = "cancelcollect";
    private static final String MY_COLLECT = "mycollect";
    private static final String COLLECT_ID = "collectId";
    private static final String ENTITY = "tctrc_collect_explain";
    private static final String ENTITY_COLLECT_EXPLAIN = "tctrc_collect_explain";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbar"});
    }

    public void afterCreateNewData(EventObject e) {
        this.initCollectBtn();
    }

    public void initCollectBtn() {
        String riskNumber = (String)this.getModel().getValue("number");
        QFilter q = new QFilter("number", "=", (Object)riskNumber);
        DynamicObject define = BusinessDataServiceHelper.loadSingle((String)"tctrc_risk_definition", (String)"id", (QFilter[])new QFilter[]{q});
        String riskDefineId = null;
        if (define != null) {
            riskDefineId = define.getString("id");
            this.getPageCache().put("riskname", define.getString("name"));
        }
        this.getPageCache().put("defineId", riskDefineId);
        String user = RequestContext.get().getUserId();
        QFilter qFilter = new QFilter("risk", "=", (Object)(EmptyCheckUtils.isNotEmpty((Object)riskDefineId) ? Long.parseLong(riskDefineId) : 0L));
        QFilter qFilter1 = new QFilter("user", "=", (Object)Long.parseLong(user));
        QFilter[] qFilters = new QFilter[]{qFilter, qFilter1};
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"tctrc_collect_explain", (String)"id", (QFilter[])qFilters);
        if (null != dynamicObject) {
            long id = dynamicObject.getLong("id");
            this.getPageCache().put(COLLECT_ID, String.valueOf(id));
            this.provideUncollectBtn();
        } else {
            this.getPageCache().remove(COLLECT_ID);
            this.provideCollectBtn();
        }
    }

    public void provideCollectBtn() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"collected"});
        this.getView().setVisible(Boolean.TRUE, new String[]{BTN_COLLECT});
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_UNCOLLECT});
    }

    public void provideUncollectBtn() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"collected"});
        this.getView().setVisible(Boolean.TRUE, new String[]{BTN_UNCOLLECT});
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_COLLECT});
    }

    public void itemClick(ItemClickEvent evt) {
        String id;
        String key = evt.getItemKey();
        if (BTN_COLLECT.equals(key)) {
            this.openForm();
        } else if (MY_COLLECT.equals(key)) {
            this.openBill();
        } else if (BTN_UNCOLLECT.equals(key) && null != (id = this.getPageCache().get(COLLECT_ID))) {
            DeleteServiceHelper.delete((String)"tctrc_collect_explain", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(id))});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u6210\u529f\u3002", (String)"RiskCollectPlugin_0", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            this.provideCollectBtn();
            String riskId = this.getPageCache().get("defineId");
            if (EmptyCheckUtils.isNotEmpty((Object)riskId)) {
                DynamicObject riskDefineDynamicObject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(riskId), (String)"tctrc_risk_definition");
                riskDefineDynamicObject.set(BTN_COLLECT, (Object)0);
                DynamicObject[] riskDefineDynamicObjects = new DynamicObject[]{riskDefineDynamicObject};
                SaveServiceHelper.save((DynamicObject[])riskDefineDynamicObjects);
                QFilter riskIdFilter = new QFilter("risk.id", "=", (Object)Long.parseLong(riskId));
                this.updateCollectStatus("tctrc_risk_run_result", riskIdFilter);
                this.updateCollectStatus("tctrc_risk_run_list", riskIdFilter);
            }
            this.getPageCache().remove(COLLECT_ID);
        }
    }

    public void updateCollectStatus(String entity, QFilter riskIdFilter) {
        DynamicObjectCollection riskResultCollection = QueryServiceHelper.query((String)entity, (String)"id", (QFilter[])new QFilter[]{riskIdFilter});
        ArrayList idList = new ArrayList();
        if (EmptyCheckUtils.isNotEmpty((Object)riskResultCollection)) {
            riskResultCollection.forEach(r -> idList.add(r.getString("id")));
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entity);
        DynamicObject[] objects = BusinessDataServiceHelper.load((Object[])idList.stream().map(v -> Long.parseLong(v)).collect(Collectors.toList()).toArray(), (DynamicObjectType)mainEntityType);
        Arrays.stream(objects).forEach(d -> d.set(BTN_COLLECT, (Object)0));
        SaveServiceHelper.save((DynamicObject[])objects);
    }

    public void openForm() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tctrc_collect_explain");
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        String riskId = this.getPageCache().get("defineId");
        String riskName = this.getPageCache().get("riskname");
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("riskId", riskId);
        customParams.put("riskName", riskName);
        customParams.put(COLLECT_ID, this.getPageCache().get(COLLECT_ID));
        showParameter.setCustomParams(customParams);
        StyleCss sc = new StyleCss();
        sc.setHeight("500px");
        sc.setWidth("960px");
        showParameter.getOpenStyle().setInlineStyleCss(sc);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "tctrc_collect_explain");
        showParameter.setCloseCallBack(closeCallBack);
        PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"tctrc_collect_explain", (IFormView)this.getView(), customParams, (IFormPlugin)this);
    }

    public void openBill() {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setFormId("bos_list");
        parameter.setBillFormId("tctrc_collect_explain");
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        this.setCustomParams(customParams);
        parameter.setCustomParams(customParams);
        StyleCss sc = new StyleCss();
        sc.setHeight("580px");
        sc.setWidth("960px");
        parameter.getOpenStyle().setInlineStyleCss(sc);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, MY_COLLECT);
        parameter.setCloseCallBack(closeCallBack);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void setCustomParams(Map<String, Object> customParams) {
        String riskId = this.getPageCache().get("defineId");
        String riskName = this.getPageCache().get("riskname");
        customParams.put("riskId", riskId);
        customParams.put("riskName", riskName);
        customParams.put(COLLECT_ID, this.getPageCache().get(COLLECT_ID));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"tctrc_collect_explain")) {
            String collectId = (String)closedCallBackEvent.getReturnData();
            if (StringUtils.isNotEmpty((CharSequence)collectId)) {
                this.getPageCache().put(COLLECT_ID, collectId);
                this.initCollectBtn();
            }
        } else if (StringUtils.equals((CharSequence)actionId, (CharSequence)MY_COLLECT)) {
            this.initCollectBtn();
        }
    }
}

