/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.result;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tctrc.business.tctrc.TctrcRiskEvaluationBusiness;
import kd.taxc.tctrc.common.enums.ProcessStateEnum;
import kd.taxc.tctrc.common.util.ListUtils;
import kd.taxc.tctrc.common.util.RiskEvalutionUtils;

public class RiskEvaluationFramePlugin
extends AbstractFormPlugin {
    private static final String BTN_OK_KEY = "btnsubmit";
    private static final String IMAGE_NORMAL_KEY = "normal";
    private static final String IMAGE_HAPPY_KEY = "happy";
    public static final String PARAM_STARS_KEY = "stars";
    public static final String PARAM_NUMBER_KEY = "number";
    private static final String URL_NORMAL_IMAGE = "/kingdee/taxc/images/pc/riskresult/normal.png";
    private static final String URL_NORMAL_SELECTED_IMAGE = "/kingdee/taxc/images/pc/riskresult/normal_selected.png";
    private static final String URL_HAPPY_IMAGE = "/kingdee/taxc/images/pc/riskresult/happy.png";
    private static final String URL_HAPPY_SELECTED_IMAGE = "/kingdee/taxc/images/pc/riskresult/happy_selected.png";
    private static final String FIELD_ADVICE_INPUT_KEY = "adviceinput";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK_KEY, IMAGE_NORMAL_KEY, IMAGE_HAPPY_KEY});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String evaluation = "";
        if (customParams.containsKey(PARAM_STARS_KEY) && StringUtils.isNotEmpty((CharSequence)customParams.get(PARAM_STARS_KEY).toString())) {
            String stars = customParams.get(PARAM_STARS_KEY).toString();
            this.getView().getModel().setValue(PARAM_STARS_KEY, (Object)stars);
            evaluation = stars.equals("1") ? IMAGE_NORMAL_KEY : IMAGE_HAPPY_KEY;
        }
        this.showImage(evaluation);
        if (!customParams.containsKey(PARAM_NUMBER_KEY)) {
            return;
        }
        List numberList = (List)customParams.get(PARAM_NUMBER_KEY);
        if (CollectionUtils.isEmpty((Collection)numberList)) {
            return;
        }
        QFilter filter = new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId()).and(new QFilter("riskcode", "in", (Object)numberList)).and(new QFilter("riskresultfid", "=", (Object)customParams.get("resultid").toString())).and(new QFilter("processstate", "!=", (Object)"2"));
        DynamicObject riskEvaluation = TctrcRiskEvaluationBusiness.getOneRiskEvaluation((QFilter[])new QFilter[]{filter}, (String)"evaluation,id,feeback,processresult,processcontent,processstate");
        if (riskEvaluation == null) {
            return;
        }
        String processState = riskEvaluation.getString("processstate");
        if (ProcessStateEnum.PROCESS_1.getCode().equals(processState)) {
            this.getPageCache().put("ids", String.valueOf(riskEvaluation.get("id")));
        }
        this.getModel().setValue(FIELD_ADVICE_INPUT_KEY, (Object)riskEvaluation.getString("feeback"));
        evaluation = riskEvaluation.getString("evaluation").equals("1") ? IMAGE_NORMAL_KEY : IMAGE_HAPPY_KEY;
        this.getModel().setValue(PARAM_STARS_KEY, (Object)riskEvaluation.getString("evaluation"));
        this.showImage(evaluation);
    }

    private void showImage(String evaluation) {
        if (StringUtils.isEmpty((CharSequence)evaluation)) {
            this.updateImageControlImageUrl(IMAGE_NORMAL_KEY, URL_NORMAL_IMAGE);
            this.updateImageControlImageUrl(IMAGE_HAPPY_KEY, URL_HAPPY_IMAGE);
        } else if (evaluation.equals(IMAGE_NORMAL_KEY)) {
            this.updateImageControlImageUrl(IMAGE_NORMAL_KEY, URL_NORMAL_SELECTED_IMAGE);
            this.updateImageControlImageUrl(IMAGE_HAPPY_KEY, URL_HAPPY_IMAGE);
        } else if (evaluation.equals(IMAGE_HAPPY_KEY)) {
            this.updateImageControlImageUrl(IMAGE_NORMAL_KEY, URL_NORMAL_IMAGE);
            this.updateImageControlImageUrl(IMAGE_HAPPY_KEY, URL_HAPPY_SELECTED_IMAGE);
        }
    }

    private void updateImageControlImageUrl(String imageControlKey, String imageUrl) {
        HashMap<String, String> imageUrlMap = new HashMap<String, String>(1);
        imageUrlMap.put("imageKey", imageUrl);
        this.getView().updateControlMetadata(imageControlKey, imageUrlMap);
    }

    public void click(EventObject evt) {
        String key;
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "happy": 
            case "normal": {
                this.showImage(key);
                this.getModel().setValue(PARAM_STARS_KEY, (Object)(key.equals(IMAGE_HAPPY_KEY) ? "0" : "1"));
                break;
            }
            case "btnsubmit": {
                this.submit();
            }
        }
    }

    private void submit() {
        IDataModel model = this.getModel();
        String starLevel = (String)model.getValue(PARAM_STARS_KEY);
        if (StringUtils.isEmpty((CharSequence)starLevel)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ed9\u51fa\u8bc4\u4ef7\u548c\u5efa\u8bae\u518d\u63d0\u4ea4\u3002", (String)"TctrcEvalutionFramePlugin_5", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            return;
        }
        String advice = (String)model.getValue(FIELD_ADVICE_INPUT_KEY);
        if ("1".equals(starLevel) && StringUtils.isEmpty((CharSequence)advice)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u610f\u89c1\u53cd\u9988\u5185\u5bb9\u3002", (String)"TctrcEvalutionFramePlugin_4", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            return;
        }
        String ids = this.getPageCache().get("ids");
        List idList = ListUtils.stringToList((String)ids);
        DynamicObject dynamicObject = null;
        Map customMap = this.getView().getFormShowParameter().getCustomParams();
        List numberList = (List)customMap.get(PARAM_NUMBER_KEY);
        String datasource = (String)customMap.get("datasource");
        if (CollectionUtils.isEmpty((Collection)numberList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u98ce\u9669\u518d\u8fdb\u884c\u8bc4\u4ef7\u3002", (String)"TctrcEvalutionFramePlugin_6", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<DynamicObject> saveObjects = new ArrayList<DynamicObject>(numberList.size());
        for (int i = 0; i < numberList.size(); ++i) {
            String id = null;
            if (idList != null && i < idList.size()) {
                id = (String)idList.get(i);
            }
            Long numberId = (Long)numberList.get(i);
            if (StringUtils.isNotEmpty(id)) {
                dynamicObject = TctrcRiskEvaluationBusiness.getTctrcRiskEvaluationBusSin((Object)id);
            } else {
                dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tctrc_risk_evaluation_new");
                String number = RiskEvalutionUtils.getCodeRuleNumber();
                dynamicObject.set(PARAM_NUMBER_KEY, (Object)number);
            }
            String orgId = (String)customMap.get("orgid");
            dynamicObject.set("orgid", (Object)Long.parseLong(orgId));
            dynamicObject.set("creator", (Object)RequestContext.get().getUserId());
            dynamicObject.set("feeback", (Object)advice);
            dynamicObject.set("evaluation", (Object)starLevel);
            String processstate = "";
            if ("0".equals(starLevel) && StringUtils.isEmpty((CharSequence)advice)) {
                processstate = ProcessStateEnum.PROCESS_0.getCode();
            } else if ("0".equals(starLevel) && StringUtils.isNotEmpty((CharSequence)advice) || "1".equals(starLevel)) {
                processstate = ProcessStateEnum.PROCESS_1.getCode();
            }
            dynamicObject.set("processstate", (Object)processstate);
            dynamicObject.set("datasource", (Object)datasource);
            dynamicObject.set("riskcode", (Object)numberId);
            String riskName = (String)customMap.get("riskname");
            dynamicObject.set("riskname", (Object)riskName);
            dynamicObject.set("modifytime", this.getModel().getValue("createdatefield"));
            Long riskResultId = (Long)customMap.get("resultid");
            dynamicObject.set("riskresultfid", (Object)riskResultId);
            saveObjects.add(dynamicObject);
        }
        SaveServiceHelper.save((DynamicObject[])saveObjects.toArray(new DynamicObject[saveObjects.size()]));
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("starLevel", starLevel);
        map.put("submited", Boolean.TRUE);
        this.getView().returnDataToParent(map);
        this.getView().close();
    }
}

