/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.result;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tctrc.business.tctrc.TctrcRiskEvaluationBusiness;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;
import kd.taxc.tctrc.common.util.RiskEvalutionUtils;
import org.apache.commons.collections.CollectionUtils;

public class RiskNewEvalutionPlugin
extends AbstractFormPlugin {
    private static final String TCTRC_RISK_EVALUATION_NEW = "tctrc_risk_evaluation_new";
    private static final String STAR_LEVEL = "starlevel";
    private static final String EVALUATION = "evaluation";
    private static final String STARS = "stars";
    private static final String ADVICE = "advice";
    private static final String NUMBER = "number";
    private static final String RISKCODE = "riskcode";
    private static final String USER = "user";
    private static final String TYPE = "type";
    private static final String ADVICE_INPUT = "adviceinput";
    private static final String KEY_ENTRY = "entryentity";
    private static final String MODIFY_TIME = "modifydatefield";
    private static final String CREATE_TIME = "createdatefield";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"vectorap11", "vectorap_l11", "vectorap12", "vectorap_l12", "vectorap13", "vectorap_l13", "vectorap14", "vectorap_l14", "vectorap15", "vectorap_l15"});
        this.addClickListeners(new String[]{"vectorap111", "vectorap_l111", "vectorap121", "vectorap_l121", "vectorap131", "vectorap_l131", "vectorap141", "vectorap_l141", "vectorap151", "vectorap_l151"});
        this.addClickListeners(new String[]{"btnsubmit", "btncancel"});
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap29", "flexpanelap291"});
    }

    public void beforeBindData(EventObject e) {
        this.initEvalution();
    }

    private void initEvalution() {
        Map customMap = this.getView().getFormShowParameter().getCustomParams();
        String number = (String)this.getView().getModel().getValue("numberid");
        Long riskResultId = (Long)customMap.get("resultid");
        String userId = RequestContext.get().getUserId();
        QFilter q = new QFilter("creator", "=", (Object)Long.parseLong(userId)).and(new QFilter(RISKCODE, "=", (Object)Long.parseLong(number))).and(new QFilter("riskresultfid", "=", (Object)String.valueOf(riskResultId)));
        DynamicObject dynamicObject = TctrcRiskEvaluationBusiness.getTctrcRiskEvaluationQue((QFilter)q);
        if (dynamicObject == null) {
            return;
        }
        this.getPageCache().put("ids", String.valueOf(dynamicObject.get("id")));
        this.getModel().setValue(ADVICE_INPUT, (Object)dynamicObject.getString("feeback"));
        String evaluation = dynamicObject.getString(EVALUATION);
        String processresult = dynamicObject.getString("processresult");
        String processcontent = dynamicObject.getString("processcontent");
        String processstate = dynamicObject.getString("processstate");
        this.displayStar(Integer.parseInt(evaluation) + 1);
        this.displayProcess(processresult, processcontent, processstate);
    }

    private void displayProcess(String processresult, String processcontent, String processstate) {
        if ("2".equals(processstate)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap29", "flexpanelap291"});
            this.getView().getModel().setValue("processresult", (Object)processresult);
            this.getView().getModel().setValue("processcontent", (Object)processcontent);
            this.getView().setVisible(Boolean.FALSE, new String[]{"buttontool"});
        }
    }

    public void click(EventObject evt) {
        String key;
        Control c = (Control)evt.getSource();
        switch (key = c.getKey()) {
            case "vectorap11": 
            case "vectorap_l11": {
                this.displayStar(1);
                break;
            }
            case "vectorap12": 
            case "vectorap_l12": {
                this.displayStar(2);
                break;
            }
            case "btnsubmit": {
                String numbers = (String)this.getModel().getValue(NUMBER);
                this.btnSubmit(numbers);
                break;
            }
            case "btncancel": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"myevaluationflexup"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"myevaluationflexdown"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"myevaluationedit"});
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)TCTRC_RISK_EVALUATION_NEW)) {
            this.initEvalution();
        }
    }

    public void displayStar(int star) {
        IDataModel model = this.getModel();
        switch (star) {
            case 1: {
                model.setValue(STARS, (Object)"0");
                this.getView().setVisible(Boolean.FALSE, new String[]{"vectorap11", "vectorap_l12"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"vectorap_l11", "vectorap12"});
                break;
            }
            case 2: {
                model.setValue(STARS, (Object)"1");
                this.getView().setVisible(Boolean.FALSE, new String[]{"vectorap_l11", "vectorap12"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"vectorap11", "vectorap_l12"});
                break;
            }
        }
    }

    private void btnSubmit(String numbers) {
        IDataModel model = this.getModel();
        String starLevel = (String)model.getValue(STARS);
        String advice = (String)model.getValue(ADVICE_INPUT);
        if ("1".equals(starLevel) && StringUtils.isEmpty((CharSequence)advice)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u610f\u89c1\u53cd\u9988\u5185\u5bb9\u3002", (String)"RiskNewEvalutionPlugin_0", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isEmpty((CharSequence)starLevel)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ed9\u51fa\u8bc4\u4ef7\u548c\u5efa\u8bae\u518d\u63d0\u4ea4\u3002", (String)"RiskNewEvalutionPlugin_1", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            return;
        }
        String ids = this.getPageCache().get("ids");
        ArrayList<String> idList = new ArrayList<String>();
        if (null != ids && 0 < ids.trim().length()) {
            idList.add(ids);
        }
        DynamicObject dynamicObject = null;
        Map customMap = this.getView().getFormShowParameter().getCustomParams();
        ArrayList<String> numberList = new ArrayList<String>();
        numberList.add(numbers);
        if (CollectionUtils.isEmpty(numberList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u98ce\u9669\u518d\u8fdb\u884c\u8bc4\u4ef7\u3002", (String)"RiskNewEvalutionPlugin_2", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            return;
        }
        for (int i = 0; i < numberList.size(); ++i) {
            String id = null;
            if (idList != null && i < idList.size()) {
                id = (String)idList.get(i);
            }
            if (StringUtils.isNotEmpty(id)) {
                dynamicObject = TctrcRiskEvaluationBusiness.getTctrcRiskEvaluationBusSin(id);
                dynamicObject.set("creator", (Object)RequestContext.get().getUserId());
                dynamicObject.set("feeback", (Object)advice);
                dynamicObject.set(EVALUATION, (Object)starLevel);
                dynamicObject.set("modifytime", (Object)new Date());
            } else {
                dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)TCTRC_RISK_EVALUATION_NEW);
                String orgid = (String)customMap.get("orgid");
                String riskname = (String)customMap.get("riskname");
                String datasource = (String)customMap.get("datasource");
                Long riskResultId = (Long)customMap.get("resultid");
                QFilter riskResultFiler = new QFilter("riskresultfid", "=", (Object)riskResultId.toString());
                QFilter datasourceFiler = new QFilter("datasource", "=", (Object)datasource);
                QFilter createrFiler = new QFilter("creator", "=", (Object)Long.parseLong(RequestContext.get().getUserId()));
                DynamicObject eleResList = TctrcRiskEvaluationBusiness.getTctrcRiskEvaluationBusSin2((QFilter)riskResultFiler.and(datasourceFiler).and(createrFiler));
                if (eleResList != null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u5df2\u63d0\u4ea4\u4e00\u6761\u98ce\u9669\u8bc4\u4ef7\uff0c\u65e0\u9700\u91cd\u590d\u63d0\u4ea4\u3002", (String)"RiskNewEvalutionPlugin_3", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (EmptyCheckUtils.isNotEmpty((Object)orgid)) {
                    dynamicObject.set("orgid", (Object)Long.parseLong(orgid));
                }
                dynamicObject.set("creator", (Object)RequestContext.get().getUserId());
                dynamicObject.set("feeback", (Object)advice);
                dynamicObject.set(EVALUATION, (Object)starLevel);
                String processstate = "";
                if ("0".equals(starLevel) && StringUtils.isEmpty((CharSequence)advice)) {
                    processstate = "0";
                } else if ("0".equals(starLevel) && StringUtils.isNotEmpty((CharSequence)advice) || "1".equals(starLevel)) {
                    processstate = "1";
                }
                String number = RiskEvalutionUtils.getCodeRuleNumber();
                dynamicObject.set(NUMBER, (Object)number);
                dynamicObject.set("processstate", (Object)processstate);
                dynamicObject.set("datasource", (Object)datasource);
                dynamicObject.set(RISKCODE, (Object)((Long)customMap.get(NUMBER)));
                dynamicObject.set("riskname", (Object)riskname);
                dynamicObject.set("modifytime", (Object)new Date());
                dynamicObject.set("riskresultfid", (Object)riskResultId);
            }
            DynamicObject[] dynamicObjects = new DynamicObject[]{dynamicObject};
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bc4\u4ef7\u6210\u529f\u3002", (String)"RiskNewEvalutionPlugin_4", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        this.initEvalution();
    }
}

