/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.result;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.operate.formop.Refresh;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.ImageAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.mvc.form.ClientViewProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.tctrc.business.element.ElementBusiness;
import kd.taxc.tctrc.business.element.ElementResultBusiness;
import kd.taxc.tctrc.business.riskdefinition.RiskNumberBusiness;
import kd.taxc.tctrc.business.riskresult.RiskResultBusiness;
import kd.taxc.tctrc.business.tdm.TdmElementGroupBusiness;
import kd.taxc.tctrc.business.tdm.TdmElementResultBusiness;
import kd.taxc.tctrc.common.element.ElementSqlService;
import kd.taxc.tctrc.common.element.Formula;
import kd.taxc.tctrc.common.element.RiskCalSerivce;
import kd.taxc.tctrc.common.element.TimeDeviatedEnum;
import kd.taxc.tctrc.common.util.BigDecimalUtil;
import kd.taxc.tctrc.common.util.DateUtils;
import kd.taxc.tctrc.common.util.ElementUtil;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;
import kd.taxc.tctrc.common.util.LabelUtils;
import kd.taxc.tctrc.common.util.StringUtil;
import kd.taxc.tctrc.formplugin.result.AbstractRiskResultNumberAndVerifyPlugin;

public class RiskNumberResultPlugin
extends AbstractRiskResultNumberAndVerifyPlugin
implements RowClickEventListener,
ClickListener {
    private static final Log LOGGER = LogFactory.getLog(RiskNumberResultPlugin.class);
    private static final String ENTITY_RUN_RESULT = "tctrc_risk_run_result";
    private static final String FIELD_RISK = "risk";
    private static final String FIELD_ASSIGNORG = "assignorg";
    private static final String FIELD_RUNORG = "runorg";
    private static final String FIELD_PLANNUMBER = "plannumber";
    private static final String FIELD_RESULT = "result";
    private static final String RISK_LEVEL_CAL_ERROR = "4";
    private static final String ELEMENT_TYPE_1 = "1";
    private static final String TYPE_RATE = "2";
    private static final String BORDER_NO_INCLUDE = "1";
    private static final String BORDER_INCLUDE = "2";
    private static final Map<String, String> RISK_SHOW_COLOR = new HashMap<String, String>();
    private static final String FLEX_METRICS_TRACE_KEY = "metricstrace";
    private static final String PREFIX_INDEX_TRACE_ELEMENT_LABEL_KEY = "indextrace_elementname_";
    private static final String CACHE_CURRENT_SELECT_ELEMENT_KEY = "curselectelementkey";
    private static final String PREFIX_INDEX_TRACE_FLEX_KEY = "indextrace_";
    private static final String PREFIX_COMPARE_ITEM_ELEMENT_LABEL_KEY = "compareitemelement_";

    @Override
    public void afterCreateNewData(EventObject e) {
        this.getPageCache().put("isfirst", "isfirst");
        super.afterCreateNewData(e);
        Map map = this.getView().getFormShowParameter().getCustomParams();
        if (EmptyCheckUtils.isNotEmpty(map.get("isemptyfielderrormsg"))) {
            this.showMessage(this.getView(), String.valueOf(map.get("isemptyfielderrormsg")));
        } else if (EmptyCheckUtils.isNotEmpty(map.get("isdenominatorzeroerrormsg"))) {
            this.showMessage(this.getView(), String.valueOf(map.get("isdenominatorzeroerrormsg")));
        }
        this.getPageCache().remove("isfirst");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Refresh) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            formShowParameter.setPageId(this.getView().getPageId());
            formShowParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
            this.getView().showForm(formShowParameter);
            args.setCancel(true);
        }
    }

    public String replace(String s) {
        if (null != s && s.indexOf(46) > 0) {
            s = s.replaceAll("0+?$", "");
            s = s.replaceAll("[.]$", "");
        }
        return s;
    }

    private void initRiskLevelShow(BigDecimal bmvalue, Object resultValue, DynamicObject riskDefineDynamicObject, String riskLevel, List<DynamicObject> pianchaList) {
        String resultShow = riskDefineDynamicObject.getString("resultshow");
        if ("1".equals(resultShow)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"percentleft"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"percentright"});
            this.getModel().setValue("bmvalue", (Object)bmvalue);
            this.getModel().setValue("resultvalue", EmptyCheckUtils.isEmpty((Object)resultValue) ? this.getFormatNoValueString() : BigDecimalUtil.setScale((Object)resultValue, (int)4));
        } else {
            if (EmptyCheckUtils.isEmpty((Object)resultValue)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"percentleft"});
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{"percentright"});
            this.getModel().setValue("bmvalue", (Object)bmvalue.multiply(BigDecimalUtil.toBigDecimal((Object)100)).setScale(2, 4));
            this.getModel().setValue("resultvalue", EmptyCheckUtils.isEmpty((Object)resultValue) ? this.getFormatNoValueString() : BigDecimalUtil.toBigDecimal((Object)resultValue).multiply(BigDecimalUtil.toBigDecimal((Object)100)).setScale(2, 4));
        }
        boolean isRisk = false;
        if (EmptyCheckUtils.isNotEmpty(pianchaList)) {
            this.getModel().deleteEntryData("entryrisk");
            for (DynamicObject dos : pianchaList) {
                HashMap<String, String> propertiesMap;
                String rangemaxString100;
                String rangemaxString;
                BigDecimal bigDecimalRange;
                String offsetResult = null;
                String offsetType = dos.getString("offset");
                String benchMarking = dos.getString("benchmarking1");
                double bmValue = BigDecimalUtil.toBigDecimal((Object)dos.get("bmvalue1")).doubleValue();
                int index = this.getModel().createNewEntryRow("entryrisk");
                String range = dos.getString("range");
                String rangemax = dos.getString("rangemax");
                if (range == null) {
                    range = "-\u221e";
                }
                if (rangemax == null) {
                    rangemax = "+\u221e";
                }
                range = RiskCalSerivce.getRangeValueString((String)range);
                rangemax = RiskCalSerivce.getRangeValueString((String)rangemax);
                String levelid = dos.getString("rlevel.id");
                String levelname = dos.getString("rlevel.name");
                this.getModel().setValue("grade", (Object)levelname, index);
                if ("2".equals(offsetType)) {
                    if ("1".equals(benchMarking)) {
                        offsetResult = EmptyCheckUtils.isEmpty((Object)resultValue) ? "null" : Double.valueOf((Double.parseDouble(String.valueOf(resultValue)) - bmValue) / bmValue * 100.0);
                    }
                } else if ("1".equals(benchMarking)) {
                    String string = offsetResult = EmptyCheckUtils.isEmpty((Object)resultValue) ? "null" : Double.valueOf(Double.parseDouble(String.valueOf(resultValue)) - bmValue);
                }
                BigDecimal bigDecimal = BigDecimalUtil.toBigDecimal((Object)range).compareTo(BigDecimal.valueOf(Integer.MIN_VALUE)) <= 0 ? BigDecimalUtil.toBigDecimal((Object)range) : (bigDecimalRange = "2".equals(offsetType) ? BigDecimalUtil.toBigDecimal((Object)range) : BigDecimal.valueOf(bmValue).add(BigDecimalUtil.toBigDecimal((Object)range)));
                BigDecimal bigDecimalRangemax = BigDecimalUtil.toBigDecimal((Object)rangemax).compareTo(BigDecimal.valueOf(Integer.MAX_VALUE)) >= 0 ? BigDecimalUtil.toBigDecimal((Object)rangemax) : ("2".equals(offsetType) ? BigDecimalUtil.toBigDecimal((Object)rangemax) : BigDecimal.valueOf(bmValue).add(BigDecimalUtil.toBigDecimal((Object)rangemax)));
                String rangeString = bigDecimalRange.compareTo(BigDecimal.ZERO) == 0 ? "0" : this.replace(String.valueOf(bigDecimalRange));
                String string = rangemaxString = bigDecimalRangemax.compareTo(BigDecimal.ZERO) == 0 ? "0" : this.replace(String.valueOf(bigDecimalRangemax));
                if (bigDecimalRange.compareTo(BigDecimal.valueOf(Integer.MIN_VALUE)) <= 0) {
                    rangeString = "-\u221e";
                }
                if (String.valueOf(Integer.MIN_VALUE).equals(range)) {
                    rangeString = "-\u221e";
                }
                if (bigDecimalRangemax.compareTo(BigDecimal.valueOf(Integer.MAX_VALUE)) >= 0) {
                    rangemaxString = "+\u221e";
                }
                String rangeString100 = bigDecimalRange.compareTo(BigDecimal.ZERO) == 0 ? "0" : rangeString;
                String string2 = rangemaxString100 = bigDecimalRangemax.compareTo(BigDecimal.ZERO) == 0 ? "0" : rangemaxString;
                if (offsetType.equalsIgnoreCase("1")) {
                    rangeString100 = BigDecimalUtil.multiplyObject((Object)rangeString100, (Object)new BigDecimal(100), (int)2).toPlainString() + "%";
                    rangemaxString100 = BigDecimalUtil.multiplyObject((Object)rangemaxString100, (Object)new BigDecimal(100), (int)2).toPlainString() + "%";
                } else {
                    rangeString100 = rangeString100 + "%";
                    rangemaxString100 = rangemaxString100 + "%";
                }
                if (bigDecimalRange.compareTo(BigDecimal.valueOf(Integer.MIN_VALUE)) <= 0) {
                    rangeString100 = "-\u221e";
                }
                if (bigDecimalRangemax.compareTo(BigDecimal.valueOf(Integer.MAX_VALUE)) >= 0) {
                    rangemaxString100 = "+\u221e";
                }
                if ("2".equals(resultShow)) {
                    this.getModel().setValue("range", (Object)rangeString100, index);
                    this.getModel().setValue("rangemax", (Object)rangemaxString100, index);
                } else {
                    if (StringUtil.equals((CharSequence)rangeString, (CharSequence)"-\u221e")) {
                        this.getModel().setValue("range", (Object)rangeString, index);
                    } else {
                        this.getModel().setValue("range", (Object)BigDecimalUtil.setScale((Object)rangeString, (int)4), index);
                    }
                    if (StringUtil.equals((CharSequence)rangemaxString, (CharSequence)"+\u221e")) {
                        this.getModel().setValue("rangemax", (Object)rangemaxString, index);
                    } else {
                        this.getModel().setValue("rangemax", (Object)BigDecimalUtil.setScale((Object)rangemaxString, (int)4), index);
                    }
                }
                boolean isBigThanMinBorder = false;
                boolean isSmallThanMaxBorder = false;
                if (!isRisk) {
                    isRisk = EmptyCheckUtils.isEmpty((Object)offsetResult) || "null".equalsIgnoreCase(String.valueOf(offsetResult)) ? false : this.analyzeOffSetBorder(isRisk, dos, BigDecimalUtil.toBigDecimal((Object)offsetResult).doubleValue(), isBigThanMinBorder, isSmallThanMaxBorder);
                }
                if (isRisk && !RISK_LEVEL_CAL_ERROR.equals(riskLevel)) {
                    propertiesMap = new HashMap(16);
                    HashMap propertiesMap1 = new HashMap(16);
                    HashMap pmap = new HashMap(16);
                    propertiesMap.put("bgik", RISK_SHOW_COLOR.get(levelid));
                    pmap.put("cardentryflex", propertiesMap);
                    pmap.put("cardentryflexlevel", propertiesMap1);
                    pmap.put("cardentrylineleft", propertiesMap1);
                    pmap.put("cardentrylineright", propertiesMap1);
                    pmap.put("cardentryflexsmall", propertiesMap1);
                    pmap.put("cardentryflexbig", propertiesMap1);
                    ClientViewProxy client = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
                    client.invokeControlMethod("entryrisk", "setCustomProperties", new Object[]{index, pmap});
                    isRisk = false;
                    continue;
                }
                propertiesMap = new HashMap<String, String>(1);
                propertiesMap.put("bgik", "linear-gradient(90deg,rgba(198,207,226,0.1) 0%,rgba(198,207,226,0.5) 50%,rgba(198,207,226,0.1) 100%)");
                HashMap<String, HashMap<String, String>> pmap = new HashMap<String, HashMap<String, String>>(1);
                pmap.put("cardentryflex", propertiesMap);
                ClientViewProxy client = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
                client.invokeControlMethod("entryrisk", "setCustomProperties", new Object[]{index, pmap});
            }
        }
    }

    private boolean analyzeOffSetBorder(boolean isRisk, DynamicObject dos, double offsetResult, boolean isBigThanMinBorder, boolean isSmallThanMaxBorder) {
        String minBorder = dos.getString("minborder");
        double ranged = RiskCalSerivce.getRangeBigDecimal((String)dos.getString("range")).doubleValue();
        String rangeString = dos.getString("range");
        String maxBorder = dos.getString("maxborder");
        double rangeMax = RiskCalSerivce.getRangeBigDecimal((String)dos.getString("rangemax")).doubleValue();
        String rangeMaxString = dos.getString("rangemax");
        if ((offsetResult > ranged || StringUtils.equals((CharSequence)rangeString, (CharSequence)"-\u221e")) && "1".equals(minBorder)) {
            isBigThanMinBorder = true;
        } else if ((offsetResult >= ranged || StringUtils.equals((CharSequence)rangeString, (CharSequence)"-\u221e")) && "2".equals(minBorder)) {
            isBigThanMinBorder = true;
        }
        if ((offsetResult < rangeMax || StringUtils.equals((CharSequence)rangeMaxString, (CharSequence)"+\u221e")) && "1".equals(maxBorder)) {
            isSmallThanMaxBorder = true;
        } else if ((offsetResult <= rangeMax || StringUtils.equals((CharSequence)rangeMaxString, (CharSequence)"+\u221e")) && "2".equals(maxBorder)) {
            isSmallThanMaxBorder = true;
        }
        if (isBigThanMinBorder && isSmallThanMaxBorder) {
            isRisk = true;
        }
        return isRisk;
    }

    public boolean checkDisplayType(DynamicObject runResultDynamicObject) {
        boolean isRateDisplay = false;
        DynamicObject risk = runResultDynamicObject.getDynamicObject(FIELD_RISK);
        String displayType = risk.getString("resultshow");
        if ("2".equals(displayType)) {
            isRateDisplay = true;
        }
        return isRateDisplay;
    }

    private static int getDiffMonths(Date startDate, Date endDate, Date riskStart) {
        return RiskNumberResultPlugin.getDiffMonths(startDate, endDate, riskStart, false);
    }

    @Override
    public void initOtherBizContent(DynamicObject riskResultDynamicObject) {
        Map customParams;
        super.initOtherBizContent(riskResultDynamicObject);
        DynamicObject riskDefineDynamicObject = riskResultDynamicObject.getDynamicObject(FIELD_RISK);
        this.setBmValueLabel(riskResultDynamicObject, riskDefineDynamicObject);
        String orgid = riskResultDynamicObject.getString("runorg.id");
        Map<String, List> resultMap = this.getTargetForPeriod(riskDefineDynamicObject.getLong("id"), riskResultDynamicObject.getDynamicObject(FIELD_RUNORG).getLong("id"), riskResultDynamicObject.getString(FIELD_PLANNUMBER), riskResultDynamicObject.getDynamicObject(FIELD_ASSIGNORG).getLong("id"), riskResultDynamicObject.getString("caltype"), riskResultDynamicObject.getDate("startdate"), riskResultDynamicObject.getDate("enddate"));
        DynamicObjectCollection dys = riskDefineDynamicObject.getDynamicObjectCollection("entryentity");
        BigDecimal bmvalue = BigDecimal.ZERO;
        ArrayList<DynamicObject> pianchaList = null;
        if (EmptyCheckUtils.isNotEmpty((Object)dys)) {
            ArrayList<DynamicObject> defaultPianchaList = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> customPianchaList = new ArrayList<DynamicObject>();
            for (DynamicObject riskDefinition : dys) {
                if (EmptyCheckUtils.isEmpty((Object)riskDefinition.get("itemid")) || "0".equals(riskDefinition.get("itemid")) || EmptyCheckUtils.isEmpty((Object)riskDefinition.get("orgs1"))) {
                    defaultPianchaList.add(riskDefinition);
                    continue;
                }
                if (!String.valueOf(riskDefinition.get("orgs1")).contains(orgid)) continue;
                customPianchaList.add(riskDefinition);
            }
            ArrayList<DynamicObject> arrayList = pianchaList = EmptyCheckUtils.isEmpty(customPianchaList) ? defaultPianchaList : customPianchaList;
            if (EmptyCheckUtils.isNotEmpty(pianchaList)) {
                Object bmvalueTemp = ((DynamicObject)pianchaList.get(0)).get("bmvalue1");
                bmvalue = BigDecimalUtil.toBigDecimal((Object)bmvalueTemp).setScale(4);
            }
        }
        String riskName = riskDefineDynamicObject.getString("name");
        Object resultValue = riskResultDynamicObject.get(FIELD_RESULT);
        if (EmptyCheckUtils.isEmpty((Object)resultValue) || "null".equalsIgnoreCase(String.valueOf(resultValue))) {
            resultValue = null;
        }
        String rlevel = riskResultDynamicObject.getString("rlevel.id");
        this.initRiskLevelShow(bmvalue, resultValue, riskDefineDynamicObject, rlevel, pianchaList);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String keynew = (String)formShowParameter.getCustomParam("elementkey");
        HashMap<String, String> stylemap = new HashMap<String, String>(8);
        stylemap.put("bc", "#5582F3");
        stylemap.put("fc", "#FFFFFF");
        if (keynew != null) {
            this.getView().updateControlMetadata(keynew.toLowerCase(), stylemap);
        }
        if (EmptyCheckUtils.isNotEmpty(formShowParameter.getCustomParams().get("relcaltips"))) {
            this.getView().showTipNotification(String.valueOf(formShowParameter.getCustomParams().get("relcaltips")));
        }
        if ((customParams = this.getView().getFormShowParameter().getCustomParams()).containsKey(CACHE_CURRENT_SELECT_ELEMENT_KEY) && this.getPageCache().get(CACHE_CURRENT_SELECT_ELEMENT_KEY) == null) {
            String currentSelectElementKey = customParams.get(CACHE_CURRENT_SELECT_ELEMENT_KEY).toString();
            this.getPageCache().put(CACHE_CURRENT_SELECT_ELEMENT_KEY, currentSelectElementKey);
            this.selectedMetricsTraceElement(currentSelectElementKey, riskResultDynamicObject);
        }
    }

    @Override
    protected Map<String, Object> getOpenHandlePageParam() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("isHigherStandardValue", this.getPageCache().get("numriskresulttype"));
        return params;
    }

    @Override
    protected Map<String, Object> getOpenTransmitPageParam() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("numriskresulttype", this.getPageCache().get("numriskresulttype"));
        return params;
    }

    private void setBmValueLabel(DynamicObject dynamicObject, DynamicObject risk) {
        Label bmValueLabel = (Label)this.getView().getControl("labelap6");
        BigDecimal bmValue = risk.getBigDecimal("bmvalue");
        if (bmValueLabel != null) {
            bmValueLabel.setText(new DecimalFormat("0.0000").format(bmValue));
        }
        Label valueLabel = (Label)this.getView().getControl("labelap4");
        String riskResultStr = dynamicObject.getString(FIELD_RESULT);
        BigDecimal riskResult = BigDecimalUtil.toBigDecimal((Object)riskResultStr);
        if (valueLabel != null && riskResultStr != null) {
            valueLabel.setText(new DecimalFormat("0.0000").format(riskResult));
        } else if (valueLabel != null && riskResultStr == null) {
            valueLabel.setText(null);
        }
        int numResult = riskResult.compareTo(bmValue);
        this.getPageCache().put("numriskresulttype", String.valueOf(numResult));
    }

    private String findTrueEleInfo(String tempEleCode) {
        Map customMap = this.getView().getFormShowParameter().getCustomParams();
        if (EmptyCheckUtils.isEmpty(customMap.get("eletruekeys"))) {
            throw new KDBizException("unknow exception");
        }
        List trueKeys = (List)customMap.get("eletruekeys");
        return trueKeys.stream().filter(v -> {
            String[] arr = v.split("&&&");
            return arr[0].equalsIgnoreCase(tempEleCode);
        }).findFirst().get();
    }

    private Map<String, List> getTargetForPeriod(long risk, long runorg, String plannumber, long assignorg, String caltype, Date startDate, Date endDate) {
        String year;
        String[] timeStr;
        LOGGER.info("\u5f00\u59cb\u8ba1\u7b97\u65e5\u671f\u96c6\u5408\u3002");
        ArrayList<String> periodList = new ArrayList<String>();
        HashMap<String, List> mapResult = new HashMap<String, List>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        Date start = new Date();
        if (TimeDeviatedEnum.TIME_DEVIATION_MONTH.getDeviatedType().equals(caltype)) {
            calendar.add(2, -12);
            for (int i = 0; i < 12; ++i) {
                calendar.add(2, 1);
                if (i == 0) {
                    start = calendar.getTime();
                }
                String dd = DateUtils.formatMonth((Date)calendar.getTime());
                periodList.add(dd);
            }
        } else if (TimeDeviatedEnum.TIME_DEVIATION_SEASON.getDeviatedType().equals(caltype)) {
            HashMap<String, String> quarterStr = new HashMap<String, String>(){
                {
                    this.put("01", "Q1");
                    this.put("02", "Q1");
                    this.put("03", "Q1");
                    this.put("04", "Q2");
                    this.put("05", "Q2");
                    this.put("06", "Q2");
                    this.put("07", "Q3");
                    this.put("08", "Q3");
                    this.put("09", "Q3");
                    this.put("10", "Q4");
                    this.put("11", "Q4");
                    this.put("12", "Q4");
                }
            };
            calendar.add(2, -12);
            for (int i = 0; i < 4; ++i) {
                calendar.add(2, 3);
                if (i == 0) {
                    start = calendar.getTime();
                }
                String dd = DateUtils.format((Date)calendar.getTime());
                String[] timeStr2 = dd.split("-");
                String year2 = timeStr2[0];
                String month = timeStr2[1];
                periodList.add(year2 + "-" + (String)quarterStr.get(month));
            }
        } else if (TimeDeviatedEnum.TIME_DEVIATION_HALF_YEAR.getDeviatedType().equals(caltype)) {
            calendar.add(2, -12);
            for (int i = 0; i < 2; ++i) {
                calendar.add(2, 6);
                if (i == 0) {
                    start = calendar.getTime();
                }
                String dd = DateUtils.format((Date)calendar.getTime());
                timeStr = dd.split("-");
                year = timeStr[0];
                String half = Integer.parseInt(timeStr[1]) >= 7 ? ResManager.loadKDString((String)"\u4e0b\u534a", (String)"FigureTargetResultPlugin_15", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e0a\u534a", (String)"FigureTargetResultPlugin_16", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]);
                periodList.add(String.format(ResManager.loadKDString((String)"%s\u5e74", (String)"FigureTargetResultPlugin_6", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), year + half));
            }
        } else {
            calendar.add(1, -2);
            for (int i = 0; i < 2; ++i) {
                calendar.add(1, 1);
                if (i == 0) {
                    start = calendar.getTime();
                }
                String dd = DateUtils.format((Date)calendar.getTime());
                timeStr = dd.split("-");
                year = timeStr[0];
                periodList.add(String.format(ResManager.loadKDString((String)"%s\u5e74", (String)"FigureTargetResultPlugin_6", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), year));
            }
        }
        QFilter qrisk = new QFilter(FIELD_RISK, "=", (Object)risk);
        QFilter qplannumber = new QFilter(FIELD_PLANNUMBER, "=", (Object)plannumber);
        QFilter qrunorg = new QFilter(FIELD_RUNORG, "=", (Object)runorg);
        QFilter qassignorg = new QFilter(FIELD_ASSIGNORG, "=", (Object)assignorg);
        QFilter qDate = new QFilter("startdate", ">=", (Object)start);
        QFilter enddata = new QFilter("enddate", "<=", (Object)DateUtils.getLastDateOfMonth((Date)endDate));
        QFilter qcaltype = new QFilter("caltype", "=", (Object)caltype);
        qDate.and(enddata);
        QFilter[] qcoll = new QFilter[]{qrisk, qplannumber, qrunorg, qassignorg, qDate, qcaltype};
        DynamicObject[] dArr = BusinessDataServiceHelper.load((String)ENTITY_RUN_RESULT, (String)"result,startdate,isemptyfield", (QFilter[])qcoll);
        HashMap<String, String> emptyFieldMap = new HashMap<String, String>(dArr.length);
        HashMap<String, String> map = new HashMap<String, String>(dArr.length);
        for (DynamicObject d : dArr) {
            String year3;
            String[] timeStr3;
            String dateStr = DateUtils.format((Date)d.getDate("startdate"));
            if (TimeDeviatedEnum.TIME_DEVIATION_MONTH.getDeviatedType().equals(caltype)) {
                timeStr3 = dateStr.split("-");
                year3 = timeStr3[0];
                String month = timeStr3[1];
                dateStr = year3 + "-" + month;
            } else if (TimeDeviatedEnum.TIME_DEVIATION_SEASON.getDeviatedType().equals(caltype)) {
                HashMap<String, String> quarterStr = new HashMap<String, String>(){
                    {
                        this.put("01", "Q1");
                        this.put("04", "Q2");
                        this.put("07", "Q3");
                        this.put("10", "Q4");
                    }
                };
                String[] timeStr4 = dateStr.split("-");
                String year4 = timeStr4[0];
                String month = timeStr4[1];
                dateStr = year4 + "-" + (String)quarterStr.get(month);
            } else if (TimeDeviatedEnum.TIME_DEVIATION_HALF_YEAR.getDeviatedType().equals(caltype)) {
                timeStr3 = dateStr.split("-");
                year3 = timeStr3[0];
                String half = Integer.parseInt(timeStr3[1]) >= 7 ? ResManager.loadKDString((String)"\u4e0b\u534a", (String)"FigureTargetResultPlugin_15", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e0a\u534a", (String)"FigureTargetResultPlugin_16", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]);
                dateStr = String.format(ResManager.loadKDString((String)"%s\u5e74", (String)"FigureTargetResultPlugin_6", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), year3 + half);
            } else if (TimeDeviatedEnum.TIME_DEVIATION_YEAR.getDeviatedType().equals(caltype)) {
                timeStr3 = dateStr.split("-");
                year3 = timeStr3[0];
                dateStr = String.format(ResManager.loadKDString((String)"%s\u5e74", (String)"FigureTargetResultPlugin_6", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), year3);
            }
            LOGGER.info("dateStr:" + dateStr + ",result:" + d.getString(FIELD_RESULT) + ",isemptyfield\uff1a" + d.getString("isemptyfield"));
            map.put(dateStr, d.getString(FIELD_RESULT));
            emptyFieldMap.put(dateStr, d.getString("isemptyfield"));
        }
        ArrayList<BigDecimal> resultList = new ArrayList<BigDecimal>(periodList.size());
        ArrayList<String> isEmptyFieldList = new ArrayList<String>(periodList.size());
        for (String period : periodList) {
            String val = (String)map.get(period);
            String isEmptyFiled = (String)emptyFieldMap.get(period);
            resultList.add(BigDecimalUtil.toBigDecimal((Object)val).setScale(4, 4));
            isEmptyFieldList.add(isEmptyFiled);
        }
        mapResult.put("period", periodList);
        mapResult.put(FIELD_RESULT, resultList);
        mapResult.put("isEmptyField", isEmptyFieldList);
        LOGGER.info("\u7ed3\u675f\u8ba1\u7b97\u65e5\u671f\u96c6\u5408\u3002getTargetForPeriod()");
        return mapResult;
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (source.getKey().equals("eleinfolabel")) {
            FormShowParameter param = new FormShowParameter();
            String elementKey = this.getPageCache().get("elementkey");
            if (EmptyCheckUtils.isEmpty((Object)elementKey)) {
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                elementKey = (String)formShowParameter.getCustomParam("elementkey");
            }
            if (EmptyCheckUtils.isEmpty((Object)elementKey)) {
                return;
            }
            String[] elementKeyArr = elementKey.split("_&");
            String trueEleInfo = this.findTrueEleInfo(elementKeyArr[2]);
            String[] trueEleInfoArr = trueEleInfo.split("&&&");
            Map map = this.getView().getFormShowParameter().getCustomParams();
            Object resultId = map.get("resultid");
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle(resultId, (String)ENTITY_RUN_RESULT);
            HashMap<String, Object> customParams = new HashMap<String, Object>(4);
            customParams.put("number", trueEleInfoArr[0]);
            String orgid = ((DynamicObject)this.getModel().getValue(FIELD_RUNORG)).getString("id");
            customParams.put("orgid", orgid);
            customParams.put("sssjq", DateUtils.getFirstDateOfMonth((Date)dynamicObject.getDate("startdate")));
            customParams.put("sssjz", DateUtils.getLastDateOfMonth((Date)dynamicObject.getDate("enddate")));
            customParams.put("runtime", dynamicObject.getDate("runtime"));
            customParams.put("eleval", trueEleInfoArr[1]);
            DynamicObject[] eles = TdmElementGroupBusiness.getTdmElementGroupDetails((QFilter)new QFilter("number", "=", (Object)trueEleInfoArr[0]));
            if (EmptyCheckUtils.isEmpty((Object)eles)) {
                return;
            }
            boolean bottom = eles[0].getBoolean("bottom");
            if (bottom) {
                QFilter qFilter = new QFilter("org", "=", (Object)Long.parseLong(orgid));
                QFilter usetype = new QFilter("usetype", "=", (Object)"0");
                QFilter element = new QFilter("element", "=", (Object)trueEleInfoArr[0]);
                QFilter startdata = new QFilter("startdata", "=", (Object)DateUtils.getFirstDateOfMonth((Date)dynamicObject.getDate("startdate")));
                QFilter enddata = new QFilter("enddata", "=", (Object)DateUtils.getLastDateOfMonth((Date)dynamicObject.getDate("enddate")));
                enddata.or(new QFilter("enddata", "=", (Object)dynamicObject.getDate("enddate")));
                DynamicObject[] tdm_element_results = TdmElementResultBusiness.getTdmElementResult((QFilter)qFilter.and(usetype).and(element).and(startdata).and(enddata));
                if (null != tdm_element_results && tdm_element_results.length > 0) {
                    Date eleenddate;
                    Date elestartdate = tdm_element_results[0].getDate("elestartdate");
                    if (EmptyCheckUtils.isNotEmpty((Object)elestartdate)) {
                        elestartdate = DateUtils.getFirstDateOfMonth((Date)elestartdate);
                    }
                    if (EmptyCheckUtils.isNotEmpty((Object)(eleenddate = tdm_element_results[0].getDate("eleenddate")))) {
                        eleenddate = DateUtils.getLastDateOfMonth((Date)eleenddate);
                    }
                    if (EmptyCheckUtils.isNotEmpty((Object)elestartdate)) {
                        customParams.put("sssjq", elestartdate);
                    }
                    if (EmptyCheckUtils.isNotEmpty((Object)eleenddate)) {
                        customParams.put("sssjz", eleenddate);
                    }
                }
            }
            customParams.put("caltype", this.getModel().getValue("caltype"));
            param.setFormId(bottom ? "tdm_ele_bottom_info" : "tdm_element_info");
            param.setStatus(OperationStatus.VIEW);
            param.setCustomParams(customParams);
            param.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(param);
        } else if (source.getKey().startsWith("label_")) {
            String keynew = source.getKey();
            String keyold = this.getPageCache().get("elementkey");
            if (null == keyold) {
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                keyold = (String)formShowParameter.getCustomParam("elementkey");
            }
            this.getPageCache().put("elementkey", keynew);
            HashMap<String, String> stylemap1 = new HashMap<String, String>(8);
            stylemap1.put("bc", "#fff");
            stylemap1.put("fc", "#5E80EB");
            this.getView().updateControlMetadata(keyold.toLowerCase(), stylemap1);
            HashMap<String, String> stylemap = new HashMap<String, String>(8);
            stylemap.put("bc", "#5582F3");
            stylemap.put("fc", "#FFFFFF");
            if (keynew != null) {
                this.getView().updateControlMetadata(keynew.toLowerCase(), stylemap);
            }
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        this.initTargetThroughFormula(e);
    }

    private void selectedMetricsTraceElement(String currentSelectElementKey, DynamicObject riskResultObject) {
        String[] elementKeySplit = currentSelectElementKey.split("_");
        this.changeIndexRangeSelectedStyle(currentSelectElementKey, "1px solid #5582F3", "#5582F3");
        Map elementNumberKeyMap = ElementSqlService.queryAllEnableEleInfoMap();
        String elementIdInit = elementKeySplit[2];
        String indexTraceFlexKey = PREFIX_INDEX_TRACE_FLEX_KEY + elementIdInit;
        List<Object> elementIds = new ArrayList<Long>();
        List<Formula> formulas = new ArrayList();
        DynamicObject elementInit = (DynamicObject)ElementBusiness.queryElementByIds(Collections.singletonList(Long.parseLong(elementIdInit)), (String)"id,name,number,formula,bottom").get(0);
        boolean flag = true;
        if (elementKeySplit.length > 4 && StringUtil.isNumeric((CharSequence)elementKeySplit[3])) {
            indexTraceFlexKey = PREFIX_INDEX_TRACE_FLEX_KEY + elementIdInit + "_" + elementKeySplit[3];
            formulas = ElementUtil.getFormulaObject((String)elementInit.getString("formula"));
            List elementCodes = formulas.stream().filter(p -> "1".equals(p.getType())).map(Formula::getCode).collect(Collectors.toList());
            for (String elementCode : elementCodes) {
                if (((DynamicObject)elementNumberKeyMap.get(elementCode)).getBoolean("bottom")) continue;
                flag = false;
            }
            DynamicObjectCollection elements = ElementBusiness.queryElementByNumbers(elementCodes, (String)"id,name,number");
            elementIds = elements.stream().map(p -> p.getLong("id")).collect(Collectors.toList());
        } else {
            elementIds.add(Long.parseLong(elementIdInit));
        }
        HashMap<String, Object> map = new HashMap<String, Object>(6);
        map.put("rd", "8px");
        map.put("bc", "#F2F6FF");
        HashMap<String, String> marginMap = new HashMap<String, String>(1);
        marginMap.put("b", "20px");
        HashMap<String, HashMap<String, String>> styleMap = new HashMap<String, HashMap<String, String>>(1);
        styleMap.put("m", marginMap);
        map.put("s", styleMap);
        ArrayList flexCollectionList = new ArrayList();
        if (elementKeySplit.length > 4 && StringUtil.isNumeric((CharSequence)elementKeySplit[3])) {
            elementIds.add(Long.parseLong(elementIdInit));
            Map<String, String> elementIdResultMap = this.getElementIdResultMap(new HashSet<Object>(elementIds), riskResultObject.getDate("startdate"), riskResultObject.getDate("enddate"), riskResultObject.getLong("runorg.id"));
            elementIdResultMap.put(elementIdInit, riskResultObject.getString(FIELD_RESULT));
            FlexPanelAp elementFormulaFlexPanelAp = this.createIndexTraceConstantFlexPanelAp("||", "left", "31px", "15px", "100px", "");
            if (flag) {
                elementFormulaFlexPanelAp.getItems().add(this.createIndexTraceExpandElementFormulaFlexPanelAp(elementInit, elementIdResultMap, formulas, elementNumberKeyMap, "", false));
            } else {
                formulas.forEach(formula -> {
                    if ("1".equals(formula.getType())) {
                        FlexPanelAp flexPanelAp = this.createBlankFlexPanelAp("#F2F3FB");
                        DynamicObject element = (DynamicObject)elementNumberKeyMap.get(formula.getCode());
                        FlexPanelAp bottmMetricsTraceCollection = this.getBottmMetricsTraceCollection(riskResultObject, elementNumberKeyMap, element.getLong("id"));
                        flexPanelAp.getItems().add(bottmMetricsTraceCollection);
                        elementFormulaFlexPanelAp.getItems().add(flexPanelAp);
                    } else if ("2".equals(formula.getType())) {
                        if (!"(".equals(formula.getName()) && !")".equals(formula.getName())) {
                            FlexPanelAp flexPanelAp = this.createBlankFlexPanelAp();
                            FlexPanelAp linkOperatorPanelAp = this.createIndexTraceOperatorFlexPanelAp(formula.getName());
                            flexPanelAp.getItems().add(linkOperatorPanelAp);
                            elementFormulaFlexPanelAp.getItems().add(flexPanelAp);
                        }
                    } else if ("3".equals(formula.getType())) {
                        FlexPanelAp flexPanelAp = this.createBlankFlexPanelAp("#F2F3FB");
                        FlexPanelAp expandConstantFlexPanelAp = this.createIndexTraceConstantFlexPanelAp(formula.getName());
                        flexPanelAp.getItems().add(expandConstantFlexPanelAp);
                        elementFormulaFlexPanelAp.getItems().add(flexPanelAp);
                    }
                });
            }
            elementFormulaFlexPanelAp.setDirection("column");
            Collection collection = (Collection)elementFormulaFlexPanelAp.createControl().get("items");
            flexCollectionList.addAll(collection);
        } else {
            elementIds.forEach(elementId -> {
                FlexPanelAp indexTraceFlexPanelAp = this.getBottmMetricsTraceCollection(riskResultObject, elementNumberKeyMap, (Long)elementId);
                Collection collection = (Collection)indexTraceFlexPanelAp.createControl().get("items");
                flexCollectionList.addAll(collection);
            });
        }
        map.put("items", flexCollectionList);
        map.put("vi", 1);
        this.getView().updateControlMetadata(indexTraceFlexKey, map);
    }

    private FlexPanelAp createBlankFlexPanelAp() {
        return this.createBlankFlexPanelAp(null);
    }

    private FlexPanelAp createBlankFlexPanelAp(String backgroundColor) {
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        String key = UUID.randomUUID().toString();
        flexPanelAp.setKey(key);
        flexPanelAp.setWidth(new LocaleString("100%"));
        Style style = new Style();
        LabelUtils.setMargin((Style)style, (String)"31px", (String)"", (String)"100px", (String)"");
        if (EmptyCheckUtils.isNotEmpty((Object)backgroundColor)) {
            flexPanelAp.setBackColor(backgroundColor);
        }
        return flexPanelAp;
    }

    private FlexPanelAp getBottmMetricsTraceCollection(DynamicObject riskResultObject, Map<String, DynamicObject> elementNumberKeyMap, Long elementId) {
        DynamicObject element = (DynamicObject)ElementBusiness.queryElementByIds(Collections.singletonList(elementId), (String)"id,name,number,formula,bottom").get(0);
        FlexPanelAp indexTraceFlexPanelAp = this.createIndexTraceFlexPanelApAfterSelected(element.getString("name"));
        Date startdate = riskResultObject.getDate("startdate");
        Date enddate = riskResultObject.getDate("enddate");
        String orgid = riskResultObject.getDynamicObject(FIELD_RUNORG).getString("id");
        List formulasSingle = RiskCalSerivce.queryFormula((String)element.getString("formula"), (String)"1", (Date)startdate, (Date)enddate, (String)orgid, elementNumberKeyMap);
        Set elementCodes = formulasSingle.stream().filter(p -> "1".equals(p.getType())).map(Formula::getCode).collect(Collectors.toSet());
        DynamicObjectCollection bottomElements = ElementBusiness.queryElementByNumbers(elementCodes, (String)"id,name,number");
        Set<Long> elementBottomIds = bottomElements.stream().map(p -> p.getLong("id")).collect(Collectors.toSet());
        elementBottomIds.add(elementId);
        Map<String, String> elementIdBottomResultMap = this.getElementIdResultMap(elementBottomIds, riskResultObject.getDate("startdate"), riskResultObject.getDate("enddate"), riskResultObject.getLong("runorg.id"));
        FlexPanelAp flexPanelAp = this.createIndexTraceExpandElementFormulaFlexPanelAp(element, elementIdBottomResultMap, formulasSingle, bottomElements.stream().collect(Collectors.toMap(k -> k.getString("number"), v -> v)), null, false);
        indexTraceFlexPanelAp.getItems().add(flexPanelAp);
        return indexTraceFlexPanelAp;
    }

    private FlexPanelAp createIndexTraceFlexPanelApAfterSelected(String panelName) {
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey(UUID.randomUUID().toString());
        flexPanelAp.getItems().add(this.createIndexTraceTitleFlexPanelAp(panelName));
        return flexPanelAp;
    }

    private void changeIndexRangeSelectedStyle(String key, String borderStyle, String foreColor) {
        HashMap<String, String> borderMap = new HashMap<String, String>(4);
        borderMap.put("r", borderStyle);
        borderMap.put("l", borderStyle);
        borderMap.put("t", borderStyle);
        borderMap.put("b", borderStyle);
        HashMap<String, HashMap<String, String>> styleMap = new HashMap<String, HashMap<String, String>>(1);
        styleMap.put("b", borderMap);
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("s", styleMap);
        if (StringUtils.isNotEmpty((CharSequence)foreColor)) {
            map.put("fc", foreColor);
        }
        this.getView().updateControlMetadata(key, map);
    }

    private void initTargetThroughFormula(LoadCustomControlMetasArgs e) {
        DynamicObject[] risk;
        String jsonHistory;
        FormShowParameter formParamter = (FormShowParameter)e.getSource();
        Map customerParam = formParamter.getCustomParams();
        Object result = customerParam.get("resultid");
        if (result == null) {
            return;
        }
        long resultId = (Long)result;
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)resultId, (String)ENTITY_RUN_RESULT);
        Date lastRunTime = dynamicObject.getDate("runtime");
        DynamicObject riskObject = dynamicObject.getDynamicObject(FIELD_RISK);
        String riskCode = riskObject.getString("number");
        String riskName = riskObject.getString("name");
        Date riskModifyTime = riskObject.getDate("modifytime");
        String jsonNew = riskObject.getString("json");
        if (null != riskModifyTime && riskModifyTime.compareTo(lastRunTime) > 0) {
            formParamter.setCustomParam("relcaltips", (Object)ResManager.loadKDString((String)"\u98ce\u9669\u5b9a\u4e49\u6709\u6539\u53d8\uff0c\u5efa\u8bae\u91cd\u65b0\u8ba1\u7b97\u8fd9\u6761\u98ce\u9669\u7ed3\u679c\u3002", (String)"FigureTargetResultPlugin_17", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        }
        String json = EmptyCheckUtils.isEmpty((Object)(jsonHistory = dynamicObject.getString("json"))) ? jsonNew : jsonHistory;
        String type0 = "0";
        Date startdate = dynamicObject.getDate("startdate");
        Date enddate = dynamicObject.getDate("enddate");
        formParamter.setCustomParam("startdate", (Object)startdate);
        formParamter.setCustomParam("enddate", (Object)enddate);
        String orgid = dynamicObject.getDynamicObject(FIELD_RUNORG).getString("id");
        LOGGER.info("startdate:" + startdate + ",enddate:" + enddate + ",riskCode:" + riskCode + ",type:" + type0 + ",orgid:" + orgid);
        Map code2EleInfoMap = ElementSqlService.queryAllEnableEleInfoMap();
        List formulasNo = RiskCalSerivce.queryFormula((String)json, (String)type0, (Date)startdate, (Date)enddate, (String)orgid, (Map)code2EleInfoMap);
        this.showErrorMsg(formulasNo, json, formParamter);
        formulasNo.forEach(formula -> LOGGER.info("startdate:" + formula.getStartDate() + ""));
        try {
            formParamter.setCustomParam("formulasNo", (Object)SerializationUtils.toJsonString((Object)formulasNo));
        }
        catch (Exception e1) {
            LOGGER.error("formulasNo\u516c\u5f0f\u8f6c\u6362\u51fa\u9519\u3002", (Throwable)e1);
        }
        String type1 = "1";
        LOGGER.info("startdate:" + startdate + ",enddate:" + enddate + ",riskCode:" + riskCode + ",type:" + type1 + ",orgid:" + orgid);
        List formulas = RiskCalSerivce.queryFormula((String)json, (String)type1, (Date)startdate, (Date)enddate, (String)orgid, (Map)code2EleInfoMap);
        try {
            formParamter.setCustomParam("formulas", (Object)SerializationUtils.toJsonString((Object)formulas));
        }
        catch (Exception e1) {
            LOGGER.error("formulas\u516c\u5f0f\u8f6c\u6362\u51fa\u9519\u3002", (Throwable)e1);
        }
        int i = 2;
        for (Formula f : formulas) {
            if ("1".equals(f.getType())) {
                formParamter.setCustomParam("eleName", (Object)f.getName());
                formParamter.setCustomParam("eleNumber", (Object)f.getCode());
                formParamter.setCustomParam("elementdesc", (Object)f.getDescribe());
                String keynew = "label_&bottom_&" + f.getCode() + "_&" + i;
                formParamter.setCustomParam("elementkey", (Object)keynew);
                break;
            }
            ++i;
        }
        if (EmptyCheckUtils.isNotEmpty((Object)(risk = RiskNumberBusiness.getRiskNumber(Collections.singleton(riskObject.getLong("id")))))) {
            Long elementId = risk[0].getDynamicObject("element").getLong("id");
            String riskResultValue = dynamicObject.getString(FIELD_RESULT);
            DynamicObject element = (DynamicObject)ElementBusiness.queryElementByIds(Collections.singletonList(elementId), (String)"id,name,number,formula,bottom").get(0);
            List formulasObject = ElementUtil.getFormulaObject((String)element.getString("formula"));
            Set elementCodes = formulasObject.stream().filter(p -> "1".equals(p.getType())).map(Formula::getCode).collect(Collectors.toSet());
            DynamicObjectCollection elements = ElementBusiness.queryElementByNumbers(elementCodes, (String)"id,name,number");
            Set<Long> elementIds = elements.stream().map(p -> p.getLong("id")).collect(Collectors.toSet());
            elementIds.add(elementId);
            Map<String, String> elementIdResultMap = this.getElementIdResultMap(elementIds, dynamicObject.getDate("startdate"), dynamicObject.getDate("enddate"), dynamicObject.getLong("runorg.id"));
            this.setFormula(e, "metricsTraceElementPanel", element, riskResultValue, formulasObject, elementIdResultMap, code2EleInfoMap, resultId);
        }
    }

    private void showErrorMsg(List<Formula> formulasNo, String json, FormShowParameter formParamter) {
        Boolean isEmptyField = Boolean.TRUE;
        for (Formula formula : formulasNo) {
            if ("1".equalsIgnoreCase(formula.getType())) {
                json = ElementUtil.replaceContentToValue((String)json, (Formula)formula);
                if (!"false".equalsIgnoreCase(formula.getIsEmptyField())) continue;
                isEmptyField = Boolean.FALSE;
                continue;
            }
            if (!"3".equalsIgnoreCase(formula.getType())) continue;
            isEmptyField = Boolean.FALSE;
        }
        if (isEmptyField.booleanValue()) {
            formParamter.getCustomParams().put("isemptyfielderrormsg", this.getCalNoValueMessage());
        } else {
            String json2 = json.replaceAll("null", "0");
            Boolean isDenominatorZero = RiskCalSerivce.isDenominatorZero((String)json2);
            if (isDenominatorZero.booleanValue()) {
                formParamter.getCustomParams().put("isdenominatorzeroerrormsg", this.getCalNoValueMessage());
            }
        }
    }

    private void setFormula(LoadCustomControlMetasArgs e, String flexPanelKey, DynamicObject element, String riskResultValue, List<Formula> formulas, Map<String, String> elementIdResultMap, Map<String, DynamicObject> code2EleInfoMap, long resultId) {
        FlexPanelAp indexTraceFlexPanelAp = this.createIndexTraceFlexPanelAp(flexPanelKey);
        HashMap<String, String> mapHead = new HashMap<String, String>(5);
        FlexPanelAp flexPanelAp = this.createIndexTraceElementFormulaFlexPanelAp(element, elementIdResultMap, formulas, code2EleInfoMap, riskResultValue, true, resultId);
        indexTraceFlexPanelAp.getItems().add(flexPanelAp);
        mapHead.put("id", FLEX_METRICS_TRACE_KEY);
        mapHead.put("items", (String)indexTraceFlexPanelAp.createControl().get("items"));
        e.getItems().add(mapHead);
    }

    private FlexPanelAp createIndexTraceFlexPanelAp(String key) {
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey(key);
        return flexPanelAp;
    }

    private FlexPanelAp createIndexTraceTitleFlexPanelAp(String labelName) {
        FlexPanelAp titleFlexPanelAp = new FlexPanelAp();
        titleFlexPanelAp.setKey(UUID.randomUUID().toString());
        Style titleStyle = new Style();
        LabelUtils.setMargin((Style)titleStyle, (String)"20px", (String)"", (String)"20px", (String)"");
        titleFlexPanelAp.setStyle(titleStyle);
        ImageAp imageAp = new ImageAp();
        imageAp.setWidth(new LocaleString("20px"));
        imageAp.setHeight(new LocaleString("20px"));
        imageAp.setKey(UUID.randomUUID().toString());
        imageAp.setImageKey("/kingdee/taxc/images/pc/riskresult/creditscore_2.png");
        titleFlexPanelAp.getItems().add(imageAp);
        LabelAp titleLabel = LabelUtils.createLabelAp((String)UUID.randomUUID().toString(), (String)labelName, (Integer)16, (String)"#212121", (String)"", (String)"600");
        Style titleLabelStyle = new Style();
        LabelUtils.setMargin((Style)titleLabelStyle, (String)"", (String)"", (String)"10px", (String)"");
        titleLabel.setStyle(titleLabelStyle);
        titleFlexPanelAp.getItems().add(titleLabel);
        return titleFlexPanelAp;
    }

    public Map<String, String> getElementIdResultMap(Set<Long> elementIdSet, Date startDate, Date endDate, Long orgId) {
        DynamicObjectCollection elementResults = ElementResultBusiness.queryRiskElementResult(elementIdSet, (Date)startDate, (Date)endDate, (Long)orgId, (String)"elementdef,value");
        return elementResults.stream().collect(Collectors.toMap(k -> k.getString("elementdef"), v -> v.getString("value")));
    }

    private FlexPanelAp createIndexTraceElementFormulaFlexPanelAp(DynamicObject elementObject, Map<String, String> elementIdResultMap, List<Formula> formulas, Map<String, DynamicObject> elementNumberKeyMap, String riskResultValue, boolean isRisk, Long resultId) {
        DynamicObject element;
        FlexPanelAp elementFormulaFlexPanelAp = new FlexPanelAp();
        elementFormulaFlexPanelAp.setKey(UUID.randomUUID().toString());
        elementFormulaFlexPanelAp.setWidth(new LocaleString("100%"));
        Style elementFormulaFlexStyle = new Style();
        LabelUtils.setMargin((Style)elementFormulaFlexStyle, (String)"10px", (String)"20px", (String)"20px", (String)"");
        elementFormulaFlexPanelAp.setStyle(elementFormulaFlexStyle);
        elementFormulaFlexPanelAp.setCustomeStyles("eyJ0eXBlIjowLCJjb250ZW50IjoiJCB7XG4gIGRpc3BsYXk6IGZsZXg7XG4gIGZsZXgtd3JhcDogd3JhcDtcbiAganVzdGlmeS1jb250ZW50OiBmbGV4LXN0YXJ0O1xuICBnYXA6IDEwcHg7XG59In0=");
        if (isRisk) {
            elementFormulaFlexPanelAp.getItems().add(this.createIndexTraceElementFlexPanelAp(elementObject, riskResultValue, resultId));
        } else {
            elementFormulaFlexPanelAp.getItems().add(this.createIndexTraceElementFlexPanelAp(elementObject, elementIdResultMap.get(elementObject.getString("id")), null));
        }
        if (elementObject.getBoolean("bottom")) {
            return elementFormulaFlexPanelAp;
        }
        elementFormulaFlexPanelAp.getItems().add(this.createIndexTraceOperatorLabelAp("="));
        for (Formula formula : formulas) {
            if ("1".equals(formula.getType())) {
                element = elementNumberKeyMap.get(formula.getCode());
                elementFormulaFlexPanelAp.getItems().add(this.createIndexTraceElementFlexPanelAp(element, elementIdResultMap.get(element.getString("id")), null));
                continue;
            }
            if ("2".equals(formula.getType())) {
                elementFormulaFlexPanelAp.getItems().add(this.createIndexTraceOperatorLabelAp(formula.getName()));
                continue;
            }
            if (!"3".equals(formula.getType())) continue;
            elementFormulaFlexPanelAp.getItems().add(this.createIndexTraceConstantFlexPanelAp(formula.getName()));
        }
        if (isRisk) {
            elementFormulaFlexPanelAp.getItems().add(this.createIndexTraceFlexPanelAp(elementObject, String.valueOf(resultId)));
        }
        for (Formula formula : formulas) {
            if (!"1".equals(formula.getType())) continue;
            element = elementNumberKeyMap.get(formula.getCode());
            elementFormulaFlexPanelAp.getItems().add(this.createIndexTraceFlexPanelAp(element, null));
        }
        return elementFormulaFlexPanelAp;
    }

    private FlexPanelAp createIndexTraceFlexPanelAp(DynamicObject element, String extend) {
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        String key = PREFIX_INDEX_TRACE_FLEX_KEY + element.getString("id");
        if (EmptyCheckUtils.isNotEmpty((Object)extend)) {
            key = PREFIX_INDEX_TRACE_FLEX_KEY + element.getString("id") + "_" + extend;
        }
        flexPanelAp.setKey(key);
        flexPanelAp.setWidth(new LocaleString("100%"));
        return flexPanelAp;
    }

    private FlexPanelAp createIndexTraceExpandElementFormulaFlexPanelAp(DynamicObject elementObject, Map<String, String> elementIdResultMap, List<Formula> formulas, Map<String, DynamicObject> elementNumberKeyMap, String riskResultValue, boolean isRisk) {
        FlexPanelAp elementFormulaFlexPanelAp = new FlexPanelAp();
        elementFormulaFlexPanelAp.setKey(UUID.randomUUID().toString());
        elementFormulaFlexPanelAp.setWidth(new LocaleString("100%"));
        Style elementFormulaFlexStyle = new Style();
        LabelUtils.setMargin((Style)elementFormulaFlexStyle, (String)"10px", (String)"20px", (String)"20px", (String)"");
        elementFormulaFlexPanelAp.setStyle(elementFormulaFlexStyle);
        elementFormulaFlexPanelAp.setCustomeStyles("eyJ0eXBlIjowLCJjb250ZW50IjoiJCB7XG4gIGRpc3BsYXk6IGZsZXg7XG4gIGZsZXgtd3JhcDogd3JhcDtcbiAganVzdGlmeS1jb250ZW50OiBmbGV4LXN0YXJ0O1xuICBnYXA6IDEwcHg7XG59In0=");
        if (isRisk) {
            elementFormulaFlexPanelAp.getItems().add(this.createIndexTraceExpandElementFlexPanelAp(elementObject, riskResultValue));
        } else {
            elementFormulaFlexPanelAp.getItems().add(this.createIndexTraceExpandElementFlexPanelAp(elementObject, elementIdResultMap.get(elementObject.getString("id"))));
        }
        if (elementObject.getBoolean("bottom")) {
            return elementFormulaFlexPanelAp;
        }
        elementFormulaFlexPanelAp.getItems().add(this.createIndexTraceOperatorLabelAp("="));
        for (Formula formula : formulas) {
            if ("1".equals(formula.getType())) {
                DynamicObject element = elementNumberKeyMap.get(formula.getCode());
                elementFormulaFlexPanelAp.getItems().add(this.createIndexTraceExpandElementFlexPanelAp(element, elementIdResultMap.get(element.getString("id"))));
                continue;
            }
            if ("2".equals(formula.getType())) {
                elementFormulaFlexPanelAp.getItems().add(this.createIndexTraceOperatorLabelAp(formula.getName()));
                continue;
            }
            if (!"3".equals(formula.getType())) continue;
            elementFormulaFlexPanelAp.getItems().add(this.createIndexTraceConstantFlexPanelAp(formula.getName()));
        }
        return elementFormulaFlexPanelAp;
    }

    private FlexPanelAp createIndexTraceElementFlexPanelAp(DynamicObject elementObject, String elementResult, Long resultId) {
        FlexPanelAp flexPanelAp = this.createElementFlexPanelAp();
        String elementNameKey = PREFIX_INDEX_TRACE_ELEMENT_LABEL_KEY + elementObject.getString("id") + "_" + UUID.randomUUID();
        if (EmptyCheckUtils.isNotEmpty((Object)resultId)) {
            elementNameKey = PREFIX_INDEX_TRACE_ELEMENT_LABEL_KEY + elementObject.getString("id") + "_" + resultId + "_" + UUID.randomUUID();
        }
        LabelAp elementNameLabel = LabelUtils.createLabelAp((String)elementNameKey, (String)elementObject.getString("name"), (Integer)14, (String)"#212121", (String)"#F2F3FB", (String)"400");
        elementNameLabel.setWidth(new LocaleString("226px"));
        elementNameLabel.setRadius("8px");
        elementNameLabel.setTextAlign("center");
        Style elementNameStyle = new Style();
        LabelUtils.setPadding((Style)elementNameStyle, (String)"3px", (String)"3px", (String)"5px", (String)"5px");
        LabelUtils.setMargin((Style)elementNameStyle, (String)"10px", (String)"10px", (String)"10px", (String)"10px");
        elementNameLabel.setStyle(elementNameStyle);
        elementNameLabel.setCustomeStyles("eyJ0eXBlIjowLCJjb250ZW50IjoiJCB7XG4gIG1heC13aWR0aDoyMjZweDtcbn0ifQ==");
        elementNameLabel.setClickable(true);
        flexPanelAp.getItems().add(elementNameLabel);
        LabelAp elementResultLabel = LabelUtils.createLabelAp((String)UUID.randomUUID().toString(), (String)(StringUtils.isEmpty((CharSequence)elementResult) || "null".equals(elementResult) ? this.getFormatNoValueString() : elementResult), (Integer)24, (String)"#212121", (String)"", (String)"700");
        elementResultLabel.setWidth(new LocaleString("226px"));
        elementResultLabel.setTextAlign("center");
        Style elementResultStyle = new Style();
        LabelUtils.setMargin((Style)elementResultStyle, (String)"", (String)"5px", (String)"", (String)"");
        elementResultLabel.setStyle(elementResultStyle);
        flexPanelAp.getItems().add(elementResultLabel);
        return flexPanelAp;
    }

    private FlexPanelAp createIndexTraceExpandElementFlexPanelAp(DynamicObject elementObject, String elementResult) {
        FlexPanelAp flexPanelAp = this.createElementFlexPanelAp();
        String elementNameKey = PREFIX_INDEX_TRACE_FLEX_KEY + elementObject.getString("id") + "_" + UUID.randomUUID();
        LabelAp elementNameLabel = LabelUtils.createLabelAp((String)elementNameKey, (String)(elementObject.getString("name") + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; >"), (Integer)14, (String)"#212121", (String)"#F2F3FB", (String)"400");
        elementNameLabel.setWidth(new LocaleString("226px"));
        elementNameLabel.setRadius("8px");
        elementNameLabel.setTextAlign("center");
        Style elementNameStyle = new Style();
        LabelUtils.setPadding((Style)elementNameStyle, (String)"3px", (String)"3px", (String)"5px", (String)"5px");
        LabelUtils.setMargin((Style)elementNameStyle, (String)"10px", (String)"10px", (String)"10px", (String)"10px");
        elementNameLabel.setStyle(elementNameStyle);
        elementNameLabel.setCustomeStyles("eyJ0eXBlIjowLCJjb250ZW50IjoiJCB7XG4gIG1heC13aWR0aDoyMjZweDtcbn0ifQ==");
        elementNameLabel.setClickable(true);
        flexPanelAp.getItems().add(elementNameLabel);
        LabelAp elementResultLabel = LabelUtils.createLabelAp((String)UUID.randomUUID().toString(), (String)(StringUtils.isEmpty((CharSequence)elementResult) || "null".equals(elementResult) ? this.getFormatNoValueString() : elementResult), (Integer)24, (String)"#212121", (String)"", (String)"700");
        elementResultLabel.setWidth(new LocaleString("226px"));
        elementResultLabel.setTextAlign("center");
        Style elementResultStyle = new Style();
        LabelUtils.setMargin((Style)elementResultStyle, (String)"", (String)"5px", (String)"", (String)"");
        elementResultLabel.setStyle(elementResultStyle);
        flexPanelAp.getItems().add(elementResultLabel);
        return flexPanelAp;
    }

    private FlexPanelAp createElementFlexPanelAp() {
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey(UUID.randomUUID().toString());
        flexPanelAp.setWidth(new LocaleString("226px"));
        flexPanelAp.setHeight(new LocaleString("86px"));
        flexPanelAp.setRadius("4px");
        flexPanelAp.setBackColor("#FFFFFF");
        Style style = new Style();
        LabelUtils.setBorder((Style)style, (String)"1px solid #d7d7e5");
        flexPanelAp.setStyle(style);
        flexPanelAp.setCustomeStyles("eyJ0eXBlIjowLCJjb250ZW50IjoiJCB7XG4gIG1heC13aWR0aDoyMjZweDtcbn0ifQ==");
        return flexPanelAp;
    }

    private FlexPanelAp createExpandOperatorFlexPanelAp() {
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey(UUID.randomUUID().toString());
        flexPanelAp.setWidth(new LocaleString("113px"));
        flexPanelAp.setHeight(new LocaleString("43px"));
        flexPanelAp.setRadius("16px");
        flexPanelAp.setBackColor("#FFFFFF");
        Style style = new Style();
        LabelUtils.setBorder((Style)style, (String)"1px solid #d7d7e5");
        LabelUtils.setMargin((Style)style, (String)"10px", (String)"10px", (String)"20px", (String)"");
        flexPanelAp.setStyle(style);
        flexPanelAp.setCustomeStyles("eyJ0eXBlIjowLCJjb250ZW50IjoiJCB7XG4gIG1heC13aWR0aDoyMjZweDtcbn0ifQ==");
        return flexPanelAp;
    }

    private LabelAp createIndexTraceOperatorLabelAp(String operator) {
        LabelAp labelAp = LabelUtils.createLabelAp((String)UUID.randomUUID().toString(), (String)operator, (Integer)32, (String)"#212121", (String)"", (String)"400");
        labelAp.setHeight(new LocaleString("100%"));
        labelAp.setTextAlign("center");
        labelAp.setCustomeStyles("eyJ0eXBlIjowLCJjb250ZW50IjoiJCB7XG4gIG1heC13aWR0aDoyMjZweDtcbn0ifQ==");
        return labelAp;
    }

    private FlexPanelAp createIndexTraceConstantFlexPanelAp(String constant) {
        return this.createIndexTraceConstantFlexPanelAp(constant, "center", "31px", "", "", "");
    }

    private FlexPanelAp createIndexTraceConstantFlexPanelAp(String constant, String textAlign, String marginTop, String marginBottom, String marginLeft, String marginRight) {
        FlexPanelAp flexPanelAp = this.createElementFlexPanelAp();
        LabelAp elementResultLabel = LabelUtils.createLabelAp((String)UUID.randomUUID().toString(), (String)constant, (Integer)24, (String)"#212121", (String)"", (String)"700");
        elementResultLabel.setWidth(new LocaleString("100%"));
        elementResultLabel.setTextAlign(textAlign);
        Style elementResultStyle = new Style();
        LabelUtils.setMargin((Style)elementResultStyle, (String)marginTop, (String)marginBottom, (String)marginLeft, (String)marginRight);
        elementResultLabel.setStyle(elementResultStyle);
        flexPanelAp.getItems().add(elementResultLabel);
        return flexPanelAp;
    }

    private FlexPanelAp createIndexTraceOperatorFlexPanelAp(String operator) {
        return this.createIndexTraceExpandFlexPanelAp(operator, "center", "8px", "", "", "");
    }

    private FlexPanelAp createIndexTraceExpandFlexPanelAp(String operator, String textAlign, String marginTop, String marginBottom, String marginLeft, String marginRight) {
        FlexPanelAp flexPanelAp = this.createExpandOperatorFlexPanelAp();
        LabelAp elementResultLabel = LabelUtils.createLabelAp((String)UUID.randomUUID().toString(), (String)operator, (Integer)24, (String)"#212121", (String)"", (String)"700");
        elementResultLabel.setWidth(new LocaleString("100%"));
        elementResultLabel.setTextAlign(textAlign);
        Style elementResultStyle = new Style();
        LabelUtils.setMargin((Style)elementResultStyle, (String)marginTop, (String)marginBottom, (String)marginLeft, (String)marginRight);
        elementResultLabel.setStyle(elementResultStyle);
        flexPanelAp.getItems().add(elementResultLabel);
        return flexPanelAp;
    }

    private static int getDiffMonths(Date startDate, Date endDate, Date riskStart, boolean deviation) {
        if (deviation) {
            return (startDate.getYear() - riskStart.getYear()) * 12 + (startDate.getMonth() - riskStart.getMonth());
        }
        return 0;
    }

    public void onGetControl(OnGetControlArgs e) {
        String key = e.getKey();
        if (key.startsWith(PREFIX_INDEX_TRACE_ELEMENT_LABEL_KEY)) {
            String selectedCompareItemElement = this.getPageCache().get(CACHE_CURRENT_SELECT_ELEMENT_KEY);
            if (StringUtils.isNotEmpty((CharSequence)selectedCompareItemElement)) {
                this.changeIndexRangeSelectedStyle(selectedCompareItemElement, "1px solid #F2F6FF", "#212121");
                String[] elementKeySplit = selectedCompareItemElement.split("_");
                String elementId = elementKeySplit[2];
                String indexTraceFlexKey = PREFIX_INDEX_TRACE_FLEX_KEY + elementId;
                if (elementKeySplit.length > 4 && StringUtil.isNumeric((CharSequence)elementKeySplit[3])) {
                    indexTraceFlexKey = PREFIX_INDEX_TRACE_FLEX_KEY + elementId + "_" + elementKeySplit[3];
                }
                HashMap<String, Serializable> map = new HashMap<String, Serializable>(2);
                map.put("items", new ArrayList());
                map.put("vi", Integer.valueOf(0));
                this.getView().updateControlMetadata(indexTraceFlexKey, map);
            }
            if (key.equals(selectedCompareItemElement)) {
                this.getPageCache().remove(CACHE_CURRENT_SELECT_ELEMENT_KEY);
                return;
            }
            Long riskResultId = Long.parseLong(this.getPageCache().get("resultid"));
            DynamicObject riskResultObject = RiskResultBusiness.getDataById((Long)riskResultId, (String)"risk,startdate,enddate,runorg,json,result");
            this.selectedMetricsTraceElement(key, riskResultObject);
            this.getPageCache().put(CACHE_CURRENT_SELECT_ELEMENT_KEY, key);
        } else if (key.startsWith(PREFIX_INDEX_TRACE_FLEX_KEY)) {
            Long elementId = Long.parseLong(key.split("_")[1]);
            DynamicObject elementObject = (DynamicObject)ElementBusiness.queryElementByIds(Collections.singletonList(elementId), (String)"id,bottom,number").get(0);
            this.showElementInfoForm(elementObject);
        }
    }

    static {
        RISK_SHOW_COLOR.put("3", "linear-gradient(90deg,rgba(19,199,245,0.1) 0%,rgba(19,199,245,0.5) 50%,rgba(19,199,245,0.1) 100%)");
        RISK_SHOW_COLOR.put("2", "linear-gradient(90deg,rgba(86,141,255,0.1) 0%,rgba(86,141,255,0.5) 50%,rgba(86,141,255,0.1) 100%)");
        RISK_SHOW_COLOR.put("1", "linear-gradient(90deg,rgba(255,125,120,0.1) 0%,rgba(255,125,120,0.5) 50%,rgba(255,125,120,0.1) 100%)");
        RISK_SHOW_COLOR.put("0", "");
    }
}

