/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.result;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tctrc.business.riskdefinition.RiskDefinitionBusiness;
import kd.taxc.tctrc.business.riskresult.RiskResultBusiness;
import kd.taxc.tctrc.common.enums.BooleanEnum;
import kd.taxc.tctrc.common.enums.DealStatusEnum;
import kd.taxc.tctrc.common.enums.RiskHandleGuidanceEnum;
import kd.taxc.tctrc.common.enums.RiskHandleResultEnum;
import kd.taxc.tctrc.common.enums.RiskTypeEnum;
import kd.taxc.tctrc.common.util.PageShowCommon;

public class RiskResultHandleEditPlugin
extends AbstractFormPlugin {
    public static final String CACHE_HIGHER_STANDARD_VALUE_KEY = "isHigherStandardValue";
    public static final String CACHE_RISK_TYPE_KEY = "riskType";
    public static final String CACHE_RISK_ID_KEY = "riskId";
    public static final String CACHE_RISK_RESULT_KEY = "riskResult";
    public static final String CACHE_RESULT_ID_KEY = "resultid";
    private static final String IMAGE_NORMAL_KEY = "normal";
    private static final String IMAGE_HAPPY_KEY = "happy";
    private static final String URL_NORMAL_IMAGE = "/kingdee/taxc/images/pc/riskresult/normal.png";
    private static final String URL_NORMAL_SELECTED_IMAGE = "/kingdee/taxc/images/pc/riskresult/normal_selected.png";
    private static final String URL_HAPPY_IMAGE = "/kingdee/taxc/images/pc/riskresult/happy.png";
    private static final String URL_HAPPY_SELECTED_IMAGE = "/kingdee/taxc/images/pc/riskresult/happy_selected.png";

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object resultId = customParams.get(CACHE_RESULT_ID_KEY);
        this.getModel().setValue(CACHE_RESULT_ID_KEY, resultId);
        this.updateImageControlImageUrl(IMAGE_NORMAL_KEY, URL_NORMAL_IMAGE);
        this.updateImageControlImageUrl(IMAGE_HAPPY_KEY, URL_HAPPY_IMAGE);
        this.setPageCache(customParams);
        this.getModel().setValue("result", (Object)RiskHandleResultEnum.NORMAL.getCode());
        this.setHandleOptionDefaultValue();
    }

    private void setPageCache(Map<String, Object> customParams) {
        this.getPageCache().put(CACHE_RESULT_ID_KEY, customParams.get(CACHE_RESULT_ID_KEY).toString());
        if (customParams.containsKey(CACHE_HIGHER_STANDARD_VALUE_KEY)) {
            this.getPageCache().put(CACHE_HIGHER_STANDARD_VALUE_KEY, customParams.get(CACHE_HIGHER_STANDARD_VALUE_KEY).toString());
        }
        this.getPageCache().put(CACHE_RISK_TYPE_KEY, customParams.get(CACHE_RISK_TYPE_KEY).toString());
        this.getPageCache().put(CACHE_RISK_ID_KEY, customParams.get(CACHE_RISK_ID_KEY).toString());
        this.getPageCache().put(CACHE_RISK_RESULT_KEY, customParams.get(CACHE_RISK_RESULT_KEY).toString());
    }

    private void setHandleOptionDefaultValue() {
        String riskType = this.getPageCache().get(CACHE_RISK_TYPE_KEY);
        RiskTypeEnum riskTypeEnum = RiskTypeEnum.getEnumByKey((String)riskType);
        RiskHandleGuidanceEnum guidanceEnum = this.getRiskHandleGuidanceEnum(riskTypeEnum);
        Long riskId = Long.parseLong(this.getPageCache().get(CACHE_RISK_ID_KEY));
        DynamicObject riskObject = RiskDefinitionBusiness.getDataById((String)riskTypeEnum.getFormid(), (Long)riskId);
        DynamicObjectCollection guidanceCollection = riskObject.getDynamicObjectCollection(guidanceEnum.getDocumentKey());
        StringJoiner joiner = new StringJoiner("\r\n");
        int index = 1;
        for (DynamicObject guidance : guidanceCollection) {
            joiner.add(index++ + "." + guidance.getString(guidanceEnum.getGuidanceContentKey()));
        }
        this.getModel().setValue("handleoption", (Object)joiner.toString());
        this.getView().updateView("handleoption");
    }

    private RiskHandleGuidanceEnum getRiskHandleGuidanceEnum(RiskTypeEnum riskTypeEnum) {
        String result = this.getModel().getValue("result").toString();
        if (RiskTypeEnum.NUMBER == riskTypeEnum) {
            boolean isHigherStandardValue = this.getPageCache().get(CACHE_HIGHER_STANDARD_VALUE_KEY).equals(BooleanEnum.YES.getCode());
            if (isHigherStandardValue) {
                return RiskHandleResultEnum.NORMAL.getCode().equals(result) ? RiskHandleGuidanceEnum.HIGHER_NORMAL : RiskHandleGuidanceEnum.HIGHER_RISK;
            }
            return RiskHandleResultEnum.NORMAL.getCode().equals(result) ? RiskHandleGuidanceEnum.LOWER_NORMAL : RiskHandleGuidanceEnum.LOWER_RISK;
        }
        return RiskHandleResultEnum.NORMAL.getCode().equals(result) ? RiskHandleGuidanceEnum.HIGHER_NORMAL : RiskHandleGuidanceEnum.HIGHER_RISK;
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{IMAGE_NORMAL_KEY, IMAGE_HAPPY_KEY, "history"});
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "normal": {
                this.updateImageControlImageUrl(IMAGE_NORMAL_KEY, URL_NORMAL_SELECTED_IMAGE);
                this.updateImageControlImageUrl(IMAGE_HAPPY_KEY, URL_HAPPY_IMAGE);
                this.openEvaluationForm("1");
                break;
            }
            case "happy": {
                this.updateImageControlImageUrl(IMAGE_NORMAL_KEY, URL_NORMAL_IMAGE);
                this.updateImageControlImageUrl(IMAGE_HAPPY_KEY, URL_HAPPY_SELECTED_IMAGE);
                this.openEvaluationForm("0");
                break;
            }
            case "history": {
                Map customMap1 = this.getView().getFormShowParameter().getCustomParams();
                PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"tctrc_handle_history", (IFormView)this.getView(), (Map)customMap1, (IFormPlugin)this);
            }
        }
    }

    private void updateImageControlImageUrl(String imageControlKey, String imageUrl) {
        HashMap<String, String> imageUrlMap = new HashMap<String, String>(1);
        imageUrlMap.put("imageKey", imageUrl);
        this.getView().updateControlMetadata(imageControlKey, imageUrlMap);
    }

    public void openEvaluationForm(String star) {
        long resultId = Long.parseLong(this.getPageCache().get(CACHE_RESULT_ID_KEY));
        DynamicObject riskResultObject = RiskResultBusiness.getDataById((Long)resultId);
        ArrayList<Long> numberList = new ArrayList<Long>(1);
        String orgId = "";
        String riskName = "";
        if (riskResultObject != null) {
            numberList.add(riskResultObject.getLong("risk.id"));
            orgId = riskResultObject.getString("runorg.id");
            riskName = riskResultObject.getString("risk.name");
        }
        Map customMap = this.getView().getFormShowParameter().getCustomParams();
        customMap.put("user", RequestContext.get().getCurrUserId());
        customMap.put("number", numberList);
        customMap.put("datasource", "1");
        customMap.put("orgid", orgId);
        customMap.put("riskname", riskName);
        customMap.put("stars", star);
        PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"tctrc_evaluation_frame", (IFormView)this.getView(), (Map)customMap, (IFormPlugin)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Save) {
            this.getModel().setValue("handler", (Object)RequestContext.get().getCurrUserId());
            this.getModel().setValue("time", (Object)new Date());
            this.getModel().setValue("handletype", (Object)"rgcl");
            this.getModel().setValue("riskresult", (Object)this.getPageCache().get(CACHE_RISK_RESULT_KEY));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (e.getProperty().getName().equals("result")) {
            this.setHandleOptionDefaultValue();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if ("save".equals(args.getOperateKey())) {
            long resultId = Long.parseLong(this.getPageCache().get(CACHE_RESULT_ID_KEY));
            DynamicObject riskResultObject = RiskResultBusiness.getDataById((Long)resultId);
            IDataModel model = this.getModel();
            riskResultObject.set("modifier", model.getValue("handler"));
            riskResultObject.set("modifydate", model.getValue("time"));
            riskResultObject.set("dealresult", model.getValue("result"));
            riskResultObject.set("handleid", model.getValue("id"));
            riskResultObject.set("status", (Object)DealStatusEnum.DONE.getCode());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{riskResultObject});
            this.getView().getParentView().invokeOperation("refresh");
            this.getView().close();
        }
    }
}

