/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.result;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.taxc.bdtaxr.common.util.UUID;
import kd.taxc.tctrc.business.resultrecords.ResultRecordsBusiness;
import kd.taxc.tctrc.common.enums.BooleanEnum;
import kd.taxc.tctrc.common.util.LabelUtils;
import kd.taxc.tctrc.common.util.PageShowCommon;
import kd.taxc.tctrc.common.util.StringUtil;
import kd.taxc.tctrc.formplugin.result.AbstractRiskResultDetailPlugin;

public class RiskSampleResultPlugin
extends AbstractRiskResultDetailPlugin {
    private static final String FLEX_SAMPLE_ITEM_RISK_STANDARD = "sampleitemriskstandard";
    private static final String FLEX_SAMPLE_RESULT_SHOW_KEY = "sampleresultshow";
    private static final String CACHE_CURRENT_SELECT_RECORD_ID = "currentSelectRecordId";
    private static final String DYNAMIC_CREATE_FLEX_PANEL_AP_KEY_PREFIX = "flexpanelapentityrowrecord_";

    @Override
    public void initOtherBizContent(DynamicObject riskResultObject) {
        long riskResultId = riskResultObject.getLong("id");
        DynamicObject[] resultRecords = ResultRecordsBusiness.getResultRecordsByRiskResultId((Long)riskResultId, (String)"id,entryentity,entryentity.index,entryentity.key,entryentity.value,fieldid");
        this.initPageCache(resultRecords);
        if (resultRecords != null && resultRecords.length > 0) {
            this.getPageCache().put(CACHE_CURRENT_SELECT_RECORD_ID, resultRecords[0].getString("id"));
            this.showSampleResult(resultRecords[0].getString("id"));
        }
    }

    private void initPageCache(DynamicObject[] resultRecords) {
        IPageCache pageCache = this.getPageCache();
        HashMap<String, HashMap<String, String>> temp = new HashMap<String, HashMap<String, String>>(16);
        for (DynamicObject record : resultRecords) {
            ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>(16);
            String recordId = record.getString("id");
            DynamicObjectCollection recordEntryEntities = record.getDynamicObjectCollection("entryentity");
            for (DynamicObject recordEntryEntity : recordEntryEntities) {
                String index = recordEntryEntity.getString("index");
                String key = recordId + "-" + index;
                HashMap<String, String> map = (HashMap<String, String>)temp.get(key);
                if (map == null) {
                    map = new HashMap<String, String>(16);
                    temp.put(key, map);
                    map.put("id", index);
                    list.add(map);
                }
                map.put(recordEntryEntity.getString("key"), recordEntryEntity.getString("value"));
            }
            pageCache.put(recordId, SerializationUtils.toJsonString(list));
            pageCache.put(record.getString("id") + "-fieldid", record.getString("fieldid"));
        }
    }

    private void showSampleResult(String recordId) {
        HashMap<String, String> customParams = new HashMap<String, String>(3);
        customParams.put("recordId", recordId);
        customParams.put("data", this.getPageCache().get(recordId));
        customParams.put(recordId + "-fieldid", this.getPageCache().get(recordId + "-fieldid"));
        PageShowCommon.showForm((String)FLEX_SAMPLE_RESULT_SHOW_KEY, (String)"tctrc_sampling_list", (IFormView)this.getView(), customParams);
    }

    @Override
    protected Map<String, Object> getOpenHandlePageParam() {
        return new HashMap<String, Object>(0);
    }

    @Override
    protected Map<String, Object> getOpenTransmitPageParam() {
        return null;
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        FormShowParameter formParameter = (FormShowParameter)e.getSource();
        Map map = formParameter.getCustomParams();
        Object result = map.get("resultid");
        if (result == null) {
            return;
        }
        long resultId = Long.parseLong(String.valueOf(result));
        FlexPanelAp headPanelAp = this.dynamicCreateSampleItemFlexPanelAp(resultId);
        HashMap<String, String> mapHead = new HashMap<String, String>(2);
        mapHead.put("id", FLEX_SAMPLE_ITEM_RISK_STANDARD);
        mapHead.put("items", (String)headPanelAp.createControl().get("items"));
        e.getItems().add(mapHead);
    }

    private FlexPanelAp dynamicCreateSampleItemFlexPanelAp(Long riskResultId) {
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey("sampleItemFlexPanel");
        DynamicObject[] resultRecords = ResultRecordsBusiness.getResultRecordsByRiskResultId((Long)riskResultId, (String)"id,text,exist,title,fieldid");
        int rowIndex = 0;
        for (DynamicObject resultRecord : resultRecords) {
            Margin margin;
            FlexPanelAp rowFlexPanelAp = new FlexPanelAp();
            rowFlexPanelAp.setKey("FlexPanelApEntityRow_" + resultRecord.getString("id"));
            rowFlexPanelAp.setHeight(new LocaleString("89px"));
            if (rowIndex > 0) {
                LabelAp andLabelAp = LabelUtils.createLabelAp((String)UUID.randomUUID(), (String)ResManager.loadKDString((String)"\u4e14", (String)"RiskSampleResultPlugin_2", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), (Integer)16, (String)"#212121", (String)"", (String)"");
                margin = new Margin();
                margin.setRight("8px");
                Style style = new Style();
                style.setMargin(margin);
                andLabelAp.setStyle(style);
                rowFlexPanelAp.getItems().add(andLabelAp);
            }
            FlexPanelAp rowRecordFlexPanelAp = new FlexPanelAp();
            rowRecordFlexPanelAp.setKey(DYNAMIC_CREATE_FLEX_PANEL_AP_KEY_PREFIX + resultRecord.getString("id"));
            rowRecordFlexPanelAp.setHeight(new LocaleString("80px"));
            rowRecordFlexPanelAp.setClickable(true);
            Style borderStyle = new Style();
            if (rowIndex == 0) {
                LabelUtils.setBorder((Style)borderStyle, (String)"1px solid #5582f3");
            } else {
                LabelUtils.setBorder((Style)borderStyle, (String)"1px solid #d7d7e5");
            }
            if (rowIndex == 0 && resultRecords.length > 1) {
                margin = new Margin();
                margin.setLeft("24px");
                borderStyle.setMargin(margin);
            }
            rowRecordFlexPanelAp.setStyle(borderStyle);
            rowRecordFlexPanelAp.setRadius("8px");
            String title = BooleanEnum.YES.getCode().equalsIgnoreCase(resultRecord.getString("exist")) || StringUtil.isEmpty((CharSequence)resultRecord.getString("exist")) ? ResManager.loadKDString((String)"\u5b58\u5728\u4ee5\u4e0b\u60c5\u51b5\u65f6\u5224\u5b9a\u4e3a\u98ce\u9669\uff1a", (String)"RiskSampleResultPlugin_0", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u4ee5\u4e0b\u60c5\u51b5\u65f6\u5224\u5b9a\u4e3a\u98ce\u9669\uff1a", (String)"RiskSampleResultPlugin_1", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]);
            LabelAp titleLabelAp = this.createTitleLabelAp("title_" + resultRecord.getString("fieldid"), title);
            rowRecordFlexPanelAp.getItems().add(titleLabelAp);
            FlexPanelAp sampleItemDetailFlex = LabelUtils.createSampleItemDetailFlex((String)(rowIndex + "FlexPanelApEntity"), (String)resultRecord.getString("title"), (String)resultRecord.getString("text"));
            rowRecordFlexPanelAp.getItems().add(sampleItemDetailFlex);
            rowFlexPanelAp.getItems().add(rowRecordFlexPanelAp);
            flexPanelAp.getItems().add(rowFlexPanelAp);
            ++rowIndex;
        }
        return flexPanelAp;
    }

    private LabelAp createTitleLabelAp(String controlKey, String title) {
        LabelAp label = LabelUtils.createLabel1((String)controlKey, (String)title, null);
        label.setFontSize(14);
        Style style = new Style();
        Padding padding = new Padding();
        padding.setTop("6px");
        padding.setBottom("6px");
        padding.setLeft("20px");
        padding.setRight("20px");
        style.setPadding(padding);
        label.setStyle(style);
        label.setForeColor("#666666");
        label.setWidth(new LocaleString("100%"));
        return label;
    }

    public void onGetControl(OnGetControlArgs e) {
        String key = e.getKey();
        if (key.startsWith(DYNAMIC_CREATE_FLEX_PANEL_AP_KEY_PREFIX)) {
            String recordId = key.split("_")[1];
            if (recordId.equals(this.getPageCache().get(CACHE_CURRENT_SELECT_RECORD_ID))) {
                return;
            }
            this.changeBorderStyle(DYNAMIC_CREATE_FLEX_PANEL_AP_KEY_PREFIX + this.getPageCache().get(CACHE_CURRENT_SELECT_RECORD_ID), "1px solid #d7d7e5");
            this.changeBorderStyle(key, "1px solid #5582f3");
            this.getPageCache().put(CACHE_CURRENT_SELECT_RECORD_ID, recordId);
            this.showSampleResult(recordId);
        }
    }

    private void changeBorderStyle(String key, String borderStyle) {
        HashMap<String, String> borderMap = new HashMap<String, String>(4);
        borderMap.put("r", borderStyle);
        borderMap.put("l", borderStyle);
        borderMap.put("t", borderStyle);
        borderMap.put("b", borderStyle);
        HashMap<String, HashMap<String, String>> styleMap = new HashMap<String, HashMap<String, String>>(1);
        styleMap.put("b", borderMap);
        HashMap<String, HashMap<String, HashMap<String, String>>> map = new HashMap<String, HashMap<String, HashMap<String, String>>>(1);
        map.put("s", styleMap);
        this.getView().updateControlMetadata(key, map);
    }
}

