/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.result;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.ImageAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.taxc.tctrc.business.element.ElementBusiness;
import kd.taxc.tctrc.business.element.ElementResultBusiness;
import kd.taxc.tctrc.business.resultrecords.ResultRecordsBusiness;
import kd.taxc.tctrc.business.riskresult.RiskResultBusiness;
import kd.taxc.tctrc.common.element.Formula;
import kd.taxc.tctrc.common.entity.FilterElement;
import kd.taxc.tctrc.common.enums.BooleanEnum;
import kd.taxc.tctrc.common.util.ElementUtil;
import kd.taxc.tctrc.common.util.LabelUtils;
import kd.taxc.tctrc.common.util.StringUtil;
import kd.taxc.tctrc.formplugin.result.AbstractRiskResultNumberAndVerifyPlugin;
import org.apache.commons.lang3.ObjectUtils;

public class RiskVerifyResultPlugin
extends AbstractRiskResultNumberAndVerifyPlugin {
    private static final Log LOGGER = LogFactory.getLog(RiskVerifyResultPlugin.class);
    private static final String FLEX_COMPARE_ITEM_RISK_STANDARD_KEY = "compareitemriskstandard";
    private static final String PREFIX_COMPARE_ITEM_FLEX_KEY = "compareitem_";
    private static final String PREFIX_COMPARE_ITEM_ELEMENT_LABEL_KEY = "compareitemelement_";
    private static final String PREFIX_INDEX_TRACE_FLEX_KEY = "indextrace_";
    private static final String PREFIX_INDEX_TRACE_ELEMENT_FLEX_KEY = "indextrace_element_";
    private static final String PREFIX_INDEX_TRACE_ELEMENT_LABEL_KEY = "indextrace_elementname_";
    private static final String CACHE_CURRENT_SELECT_ELEMENT_KEY = "curselectelementkey";

    @Override
    public void initOtherBizContent(DynamicObject riskResultObject) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.containsKey(CACHE_CURRENT_SELECT_ELEMENT_KEY) && this.getPageCache().get(CACHE_CURRENT_SELECT_ELEMENT_KEY) == null) {
            String currentSelectElementKey = customParams.get(CACHE_CURRENT_SELECT_ELEMENT_KEY).toString();
            this.getPageCache().put(CACHE_CURRENT_SELECT_ELEMENT_KEY, currentSelectElementKey);
            this.selectedCompareItemElement(currentSelectElementKey, riskResultObject);
        }
    }

    private void selectedCompareItemElement(String currentSelectElementKey, DynamicObject riskResultObject) {
        String[] elementKeySplit = currentSelectElementKey.split("_");
        this.changeIndexRangeSelectedStyle(currentSelectElementKey, "1px solid #5582F3", "#5582F3");
        String resultRecordId = elementKeySplit[1];
        String elementId = elementKeySplit[2];
        String rowIndex = elementKeySplit[4];
        String indexTraceFlexKey = PREFIX_INDEX_TRACE_FLEX_KEY + resultRecordId + "_" + rowIndex;
        FlexPanelAp indexTraceFlexPanelAp = this.createIndexTraceFlexPanelApAfterSelected();
        HashMap<String, Object> map = new HashMap<String, Object>(6);
        map.put("rd", "8px");
        map.put("bc", "#F2F6FF");
        HashMap<String, String> marginMap = new HashMap<String, String>(1);
        marginMap.put("b", "20px");
        HashMap<String, HashMap<String, String>> styleMap = new HashMap<String, HashMap<String, String>>(1);
        styleMap.put("m", marginMap);
        map.put("s", styleMap);
        DynamicObject element = (DynamicObject)ElementBusiness.queryElementByIds(Collections.singletonList(Long.parseLong(elementId)), (String)"id,name,number,formula,bottom").get(0);
        List formulas = ElementUtil.getFormulaObject((String)element.getString("formula"));
        Set elementCodes = formulas.stream().filter(p -> "1".equals(p.getType())).map(p -> p.getCode()).collect(Collectors.toSet());
        DynamicObjectCollection elements = ElementBusiness.queryElementByNumbers(elementCodes, (String)"id,name,number");
        Set<Long> elementIds = elements.stream().map(p -> p.getLong("id")).collect(Collectors.toSet());
        elementIds.add(Long.parseLong(elementId));
        Map<String, String> elementIdResultMap = this.getElementIdResultMap(elementIds, riskResultObject.getDate("startdate"), riskResultObject.getDate("enddate"), riskResultObject.getLong("runorg.id"));
        LOGGER.info("=====kd.taxc.tctrc.formplugin.result.RiskVerifyResultPlugin.selectedCompareItemElement==element:{}====elementIdResultMap:{}", (Object)SerializationUtils.toJsonString((Object)element), (Object)SerializationUtils.toJsonString(elementIdResultMap));
        FlexPanelAp flexPanelAp = this.createIndexTraceElementFormulaFlexPanelAp(element, elementIdResultMap, formulas, elements.stream().collect(Collectors.toMap(k -> k.getString("number"), v -> v)));
        indexTraceFlexPanelAp.getItems().add(flexPanelAp);
        map.put("items", indexTraceFlexPanelAp.createControl().get("items"));
        map.put("vi", 1);
        this.getView().updateControlMetadata(indexTraceFlexKey, map);
    }

    private void changeIndexRangeSelectedStyle(String key, String borderStyle, String foreColor) {
        HashMap<String, String> borderMap = new HashMap<String, String>(4);
        borderMap.put("r", borderStyle);
        borderMap.put("l", borderStyle);
        borderMap.put("t", borderStyle);
        borderMap.put("b", borderStyle);
        HashMap<String, HashMap<String, String>> styleMap = new HashMap<String, HashMap<String, String>>(1);
        styleMap.put("b", borderMap);
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("s", styleMap);
        if (StringUtils.isNotEmpty((CharSequence)foreColor)) {
            map.put("fc", foreColor);
        }
        this.getView().updateControlMetadata(key, map);
    }

    @Override
    protected Map<String, Object> getOpenHandlePageParam() {
        return null;
    }

    @Override
    protected Map<String, Object> getOpenTransmitPageParam() {
        return null;
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        FormShowParameter formParameter = (FormShowParameter)e.getSource();
        Map map = formParameter.getCustomParams();
        Object result = map.get("resultid");
        if (result == null) {
            return;
        }
        long resultId = Long.parseLong(String.valueOf(result));
        FlexPanelAp headPanelAp = this.dynamicCreateCompareItemFlexPanelAp(resultId, map);
        HashMap<String, String> mapHead = new HashMap<String, String>(2);
        mapHead.put("id", FLEX_COMPARE_ITEM_RISK_STANDARD_KEY);
        mapHead.put("items", (String)headPanelAp.createControl().get("items"));
        e.getItems().add(mapHead);
    }

    private FlexPanelAp dynamicCreateCompareItemFlexPanelAp(Long riskResultId, Map<String, Object> customParamMap) {
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey("compareItemFlexPanel");
        DynamicObject[] resultRecords = ResultRecordsBusiness.getResultRecordsByRiskResultId((Long)riskResultId, (String)"id,json_tag,exist,title,fieldid");
        Map<Long, List<FilterElement>> resultRecordFilterElementMap = Arrays.stream(resultRecords).collect(Collectors.toMap(k -> k.getLong("id"), v -> SerializationUtils.fromJsonStringToList((String)v.getString("json_tag"), FilterElement.class)));
        Set<Long> elementIds = this.getElementIds(resultRecordFilterElementMap.values().stream().flatMap(p -> p.stream()).collect(Collectors.toList()));
        Map<String, String> elementIdNameMap = this.getElementIdNameMap(elementIds);
        DynamicObject riskResult = RiskResultBusiness.getDataById((Long)riskResultId, (String)"startdate,enddate,runorg");
        Map<String, String> elementIdResultMap = this.getElementIdResultMap(elementIds, riskResult.getDate("startdate"), riskResult.getDate("enddate"), riskResult.getLong("runorg.id"));
        int rowIndex = 1;
        for (DynamicObject resultRecord : resultRecords) {
            FlexPanelAp compareItemFlexPanelAp = this.createCompareItemFlexPanelAp(resultRecord, rowIndex);
            compareItemFlexPanelAp.getItems().add(this.createCompareItemTitleFlexPanelAp(resultRecord));
            compareItemFlexPanelAp.getItems().add(this.createCompareItemExistLabelAp(resultRecord));
            compareItemFlexPanelAp.getItems().add(this.createCompareItemContent(resultRecord, resultRecordFilterElementMap, elementIdNameMap, elementIdResultMap, rowIndex, customParamMap));
            flexPanelAp.getItems().add(compareItemFlexPanelAp);
            flexPanelAp.getItems().add(this.createIndexTraceFlexPanelAp(resultRecord, rowIndex));
            ++rowIndex;
        }
        return flexPanelAp;
    }

    private Set<Long> getElementIds(List<FilterElement> elements) {
        HashSet<Long> elementIdSet = new HashSet<Long>(16);
        for (FilterElement element : elements) {
            if (element.getElement() != null && StringUtils.isNotEmpty((CharSequence)element.getElement().getId())) {
                elementIdSet.add(Long.parseLong(element.getElement().getId()));
            }
            if (element.getContrastValue() == null || element.getContrastValue().getElement() == null || !StringUtils.isNotEmpty((CharSequence)element.getContrastValue().getElement().getId()) || "undefined".equalsIgnoreCase(element.getContrastValue().getElement().getId())) continue;
            elementIdSet.add(Long.parseLong(element.getContrastValue().getElement().getId()));
        }
        return elementIdSet;
    }

    private Map<String, String> getElementIdNameMap(Set<Long> elementIdSet) {
        DynamicObjectCollection elementObjects = ElementBusiness.queryElementByIds(elementIdSet, (String)"id,name");
        return elementObjects.stream().collect(Collectors.toMap(k -> k.getString("id"), v -> v.getString("name")));
    }

    public Map<String, String> getElementIdResultMap(Set<Long> elementIdSet, Date startDate, Date endDate, Long orgId) {
        DynamicObjectCollection elementResults = ElementResultBusiness.queryRiskElementResult(elementIdSet, (Date)startDate, (Date)endDate, (Long)orgId, (String)"elementdef,value");
        return elementResults.stream().collect(Collectors.toMap(k -> k.getString("elementdef"), v -> v.getString("value")));
    }

    private FlexPanelAp createCompareItemFlexPanelAp(DynamicObject resultRecord, int rowIndex) {
        FlexPanelAp compareItemFlexPanelAp = new FlexPanelAp();
        compareItemFlexPanelAp.setKey(PREFIX_COMPARE_ITEM_FLEX_KEY + resultRecord.getString("id") + "_" + rowIndex);
        compareItemFlexPanelAp.setRadius("8px");
        Style style = new Style();
        LabelUtils.setBorder((Style)style, (String)"1px solid #d7d7e5");
        LabelUtils.setMargin((Style)style, (String)"", (String)"20px", (String)"", (String)"");
        compareItemFlexPanelAp.setStyle(style);
        return compareItemFlexPanelAp;
    }

    private FlexPanelAp createCompareItemTitleFlexPanelAp(DynamicObject resultRecord) {
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey(UUID.randomUUID().toString());
        flexPanelAp.setWidth(new LocaleString("100%"));
        Style style = new Style();
        LabelUtils.setMargin((Style)style, (String)"10px", (String)"", (String)"20px", (String)"");
        flexPanelAp.setStyle(style);
        LabelAp labelAp = LabelUtils.createLabelAp((String)UUID.randomUUID().toString(), (String)resultRecord.getString("title"), (Integer)16, (String)"#212121", (String)"", (String)"600");
        flexPanelAp.getItems().add(labelAp);
        return flexPanelAp;
    }

    private LabelAp createCompareItemExistLabelAp(DynamicObject resultRecord) {
        String text = BooleanEnum.YES.getCode().equalsIgnoreCase(resultRecord.getString("exist")) || StringUtil.isEmpty((CharSequence)resultRecord.getString("exist")) ? ResManager.loadKDString((String)"\u5b58\u5728\u4ee5\u4e0b\u60c5\u51b5\u65f6\u5224\u5b9a\u4e3a\u98ce\u9669\uff1a", (String)"RiskSampleResultPlugin_0", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u4ee5\u4e0b\u60c5\u51b5\u65f6\u5224\u5b9a\u4e3a\u98ce\u9669\uff1a", (String)"RiskSampleResultPlugin_1", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]);
        LabelAp labelAp = LabelUtils.createLabelAp((String)UUID.randomUUID().toString(), (String)text, (Integer)14, (String)"#666666", (String)"", (String)"");
        Style style = new Style();
        LabelUtils.setMargin((Style)style, (String)"10px", (String)"", (String)"20px", (String)"");
        labelAp.setStyle(style);
        return labelAp;
    }

    private FlexPanelAp createCompareItemContent(DynamicObject resultRecord, Map<Long, List<FilterElement>> resultRecordFilterElementMap, Map<String, String> elementIdNameMap, Map<String, String> elementIdResultMap, int rowIndex, Map<String, Object> customParamMap) {
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey(UUID.randomUUID().toString());
        flexPanelAp.setWidth(new LocaleString("100%"));
        Style style = new Style();
        LabelUtils.setMargin((Style)style, (String)"10px", (String)"10px", (String)"20px", (String)"");
        flexPanelAp.setStyle(style);
        List<FilterElement> filterElements = resultRecordFilterElementMap.get(resultRecord.getLong("id"));
        boolean isSelectedElement = false;
        int index = 0;
        for (FilterElement filterElement : filterElements) {
            String[] elementId;
            String symbol;
            int n;
            if (StringUtils.isNotEmpty((CharSequence)filterElement.getBracketLeft())) {
                String[] stringArray = filterElement.getBracketLeft().split("");
                int n2 = stringArray.length;
                for (n = 0; n < n2; ++n) {
                    symbol = stringArray[n];
                    flexPanelAp.getItems().add(this.createFilterElementSymbolLabel(symbol));
                }
            }
            if (filterElement.getElement() != null) {
                elementId = filterElement.getElement().getId();
                LabelAp filterElementElementLabel = this.createFilterElementElementLabel(resultRecord.getString("id"), elementIdNameMap.get(elementId), (String)elementId, elementIdResultMap.get(elementId), rowIndex);
                if (rowIndex == 1 && !isSelectedElement) {
                    isSelectedElement = true;
                }
                flexPanelAp.getItems().add(filterElementElementLabel);
            }
            if (StringUtils.isNotEmpty((CharSequence)filterElement.getCondition())) {
                flexPanelAp.getItems().add(this.createFilterElementSymbolLabel(filterElement.getCondition()));
            }
            if ("1".equals(filterElement.getContrasType())) {
                elementId = filterElement.getContrastValue().getElement().getId();
                LabelAp filterElementElementLabel = this.createFilterElementElementLabel(resultRecord.getString("id"), elementIdNameMap.get(elementId), (String)elementId, elementIdResultMap.get(elementId), rowIndex);
                if (rowIndex == 1 && !isSelectedElement) {
                    isSelectedElement = true;
                }
                flexPanelAp.getItems().add(filterElementElementLabel);
            } else {
                flexPanelAp.getItems().add(this.createFilterElementConstantLabel(filterElement.getContrastValue().getInput()));
            }
            if (StringUtils.isNotEmpty((CharSequence)filterElement.getBracketRight())) {
                elementId = filterElement.getBracketRight().split("");
                int n3 = elementId.length;
                for (n = 0; n < n3; ++n) {
                    symbol = elementId[n];
                    flexPanelAp.getItems().add(this.createFilterElementSymbolLabel(symbol));
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)filterElement.getOperator()) && index < filterElements.size() - 1) {
                String value = !ObjectUtils.notEqual((Object)"&", (Object)filterElement) ? ResManager.loadKDString((String)"\u4e14", (String)"RiskSampleResultPlugin_2", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6216", (String)"RiskVerifyResultPlugin_1", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]);
                flexPanelAp.getItems().add(this.createFilterElementConditionLabel(value));
            }
            ++index;
        }
        return flexPanelAp;
    }

    private LabelAp createFilterElementSymbolLabel(String symbol) {
        LabelAp labelAp = LabelUtils.createLabelAp((String)UUID.randomUUID().toString(), (String)symbol, (Integer)20, (String)"#212121", (String)"", (String)"400px");
        Style style = new Style();
        LabelUtils.setMargin((Style)style, (String)"3px", (String)"3px", (String)"", (String)"10px");
        labelAp.setStyle(style);
        return labelAp;
    }

    private LabelAp createFilterElementConstantLabel(String constant) {
        LabelAp labelAp = LabelUtils.createLabelAp((String)UUID.randomUUID().toString(), (String)constant, (Integer)16, (String)"#212121", (String)"", (String)"400px");
        Style style = new Style();
        LabelUtils.setMargin((Style)style, (String)"5px", (String)"5px", (String)"", (String)"10px");
        labelAp.setStyle(style);
        return labelAp;
    }

    private LabelAp createFilterElementConditionLabel(String condition) {
        LabelAp labelAp = LabelUtils.createLabelAp((String)UUID.randomUUID().toString(), (String)condition, (Integer)14, (String)"#212121", (String)"", (String)"400px");
        Style style = new Style();
        LabelUtils.setMargin((Style)style, (String)"6px", (String)"6px", (String)"", (String)"10px");
        labelAp.setStyle(style);
        return labelAp;
    }

    private LabelAp createFilterElementElementLabel(String resultRecordId, String elementName, String elementId, String value, int index) {
        String key = PREFIX_COMPARE_ITEM_ELEMENT_LABEL_KEY + resultRecordId + "_" + elementId + "_" + UUID.randomUUID() + "_" + index;
        String labelName = elementName + "  \uff08" + (StringUtils.isEmpty((CharSequence)value) || "null".equals(value) ? this.getFormatNoValueString() : value) + "\uff09";
        LabelAp labelAp = LabelUtils.createLabelAp((String)key, (String)labelName, (Integer)14, (String)"#212121", (String)"#F2F6FF", (String)"400px");
        labelAp.setRadius("4px");
        Style style = new Style();
        LabelUtils.setPadding((Style)style, (String)"5px", (String)"5px", (String)"5px", (String)"5px");
        LabelUtils.setBorder((Style)style, (String)"1px solid #F2F6FF");
        LabelUtils.setMargin((Style)style, (String)"", (String)"", (String)"", (String)"10px");
        labelAp.setStyle(style);
        labelAp.setClickable(true);
        return labelAp;
    }

    private FlexPanelAp createIndexTraceFlexPanelAp(DynamicObject resultRecord, int rowIndex) {
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey(PREFIX_INDEX_TRACE_FLEX_KEY + resultRecord.getString("id") + "_" + rowIndex);
        flexPanelAp.setWidth(new LocaleString("100%"));
        return flexPanelAp;
    }

    private FlexPanelAp createIndexTraceFlexPanelApAfterSelected() {
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey(UUID.randomUUID().toString());
        flexPanelAp.getItems().add(this.createIndexTraceTitleFlexPanelAp());
        return flexPanelAp;
    }

    private FlexPanelAp createIndexTraceTitleFlexPanelAp() {
        FlexPanelAp titleFlexPanelAp = new FlexPanelAp();
        titleFlexPanelAp.setKey(UUID.randomUUID().toString());
        Style titleStyle = new Style();
        LabelUtils.setMargin((Style)titleStyle, (String)"20px", (String)"", (String)"20px", (String)"");
        titleFlexPanelAp.setStyle(titleStyle);
        ImageAp imageAp = new ImageAp();
        imageAp.setWidth(new LocaleString("20px"));
        imageAp.setHeight(new LocaleString("20px"));
        imageAp.setKey(UUID.randomUUID().toString());
        imageAp.setImageKey("/kingdee/taxc/images/pc/riskresult/creditscore_2.png");
        titleFlexPanelAp.getItems().add(imageAp);
        LabelAp titleLabel = LabelUtils.createLabelAp((String)UUID.randomUUID().toString(), (String)ResManager.loadKDString((String)"\u6bd4\u5bf9\u9879\u8ffd\u6eaf", (String)"RiskVerifyResultPlugin_0", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), (Integer)16, (String)"#212121", (String)"", (String)"600");
        Style titleLabelStyle = new Style();
        LabelUtils.setMargin((Style)titleLabelStyle, (String)"", (String)"", (String)"10px", (String)"");
        titleLabel.setStyle(titleLabelStyle);
        titleFlexPanelAp.getItems().add(titleLabel);
        return titleFlexPanelAp;
    }

    private FlexPanelAp createIndexTraceElementFormulaFlexPanelAp(DynamicObject elementObject, Map<String, String> elementIdResultMap, List<Formula> formulas, Map<String, DynamicObject> elementNumberKeyMap) {
        FlexPanelAp elementFormulaFlexPanelAp = new FlexPanelAp();
        elementFormulaFlexPanelAp.setKey(UUID.randomUUID().toString());
        elementFormulaFlexPanelAp.setWidth(new LocaleString("100%"));
        Style elementFormulaFlexStyle = new Style();
        LabelUtils.setMargin((Style)elementFormulaFlexStyle, (String)"10px", (String)"20px", (String)"20px", (String)"");
        elementFormulaFlexPanelAp.setStyle(elementFormulaFlexStyle);
        elementFormulaFlexPanelAp.setCustomeStyles("eyJ0eXBlIjowLCJjb250ZW50IjoiJCB7XG4gIGRpc3BsYXk6IGZsZXg7XG4gIGZsZXgtd3JhcDogd3JhcDtcbiAganVzdGlmeS1jb250ZW50OiBmbGV4LXN0YXJ0O1xuICAvKiBnYXA6MTBweDsgKi9cbn1cblxuLyog5Zue6YCA5qC35byPICovXG4kID4gKiB7XG4gICAgbWFyZ2luLXJpZ2h0OiAxMHB4O1xuICAgIG1hcmdpbi1ib3R0b206IDEwcHg7XG59XG5cbi8qIOacgOWQjuS4gOS4quWFg+e0oOWOu+aOieWPs+i+uei3neWSjOS4i+i+uei3nSAqL1xuJCA+ICo6bGFzdC1jaGlsZCB7XG4gICAgbWFyZ2luLXJpZ2h0OiAwO1xuICAgIG1hcmdpbi1ib3R0b206IDA7XG59In0=");
        elementFormulaFlexPanelAp.getItems().add(this.createIndexTraceElementFlexPanelAp(elementObject, elementIdResultMap.get(elementObject.getString("id"))));
        if (elementObject.getBoolean("bottom")) {
            return elementFormulaFlexPanelAp;
        }
        elementFormulaFlexPanelAp.getItems().add(this.createIndexTraceOperatorLabelAp("="));
        for (Formula formula : formulas) {
            if ("1".equals(formula.getType())) {
                DynamicObject element = elementNumberKeyMap.get(formula.getCode());
                elementFormulaFlexPanelAp.getItems().add(this.createIndexTraceElementFlexPanelAp(element, elementIdResultMap.get(element.getString("id"))));
                continue;
            }
            if ("2".equals(formula.getType())) {
                elementFormulaFlexPanelAp.getItems().add(this.createIndexTraceOperatorLabelAp(formula.getName()));
                continue;
            }
            if (!"3".equals(formula.getType())) continue;
            elementFormulaFlexPanelAp.getItems().add(this.createIndexTraceConstantFlexPanelAp(formula.getName()));
        }
        return elementFormulaFlexPanelAp;
    }

    private FlexPanelAp createIndexTraceElementFlexPanelAp(DynamicObject elementObject, String elementResult) {
        FlexPanelAp flexPanelAp = this.createElementFlexPanelAp();
        String elementNameKey = PREFIX_INDEX_TRACE_ELEMENT_LABEL_KEY + elementObject.getString("id") + "_" + UUID.randomUUID();
        LabelAp elementNameLabel = LabelUtils.createLabelAp((String)elementNameKey, (String)(elementObject.getString("name") + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; >"), (Integer)14, (String)"#212121", (String)"#F2F3FB", (String)"400");
        elementNameLabel.setWidth(new LocaleString("226px"));
        elementNameLabel.setRadius("8px");
        elementNameLabel.setTextAlign("center");
        Style elementNameStyle = new Style();
        LabelUtils.setPadding((Style)elementNameStyle, (String)"3px", (String)"3px", (String)"5px", (String)"5px");
        LabelUtils.setMargin((Style)elementNameStyle, (String)"10px", (String)"10px", (String)"10px", (String)"10px");
        elementNameLabel.setStyle(elementNameStyle);
        elementNameLabel.setCustomeStyles("eyJ0eXBlIjowLCJjb250ZW50IjoiJCB7XG4gIG1heC13aWR0aDoyMjZweDtcbn0ifQ==");
        elementNameLabel.setClickable(true);
        flexPanelAp.getItems().add(elementNameLabel);
        LabelAp elementResultLabel = LabelUtils.createLabelAp((String)UUID.randomUUID().toString(), (String)(StringUtils.isEmpty((CharSequence)elementResult) || "null".equals(elementResult) ? this.getFormatNoValueString() : elementResult), (Integer)24, (String)"#212121", (String)"", (String)"700");
        elementResultLabel.setWidth(new LocaleString("226px"));
        elementResultLabel.setTextAlign("center");
        Style elementResultStyle = new Style();
        LabelUtils.setMargin((Style)elementResultStyle, (String)"", (String)"5px", (String)"", (String)"");
        elementResultLabel.setStyle(elementResultStyle);
        flexPanelAp.getItems().add(elementResultLabel);
        return flexPanelAp;
    }

    private FlexPanelAp createElementFlexPanelAp() {
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey(UUID.randomUUID().toString());
        flexPanelAp.setWidth(new LocaleString("226px"));
        flexPanelAp.setHeight(new LocaleString("88px"));
        flexPanelAp.setRadius("4px");
        flexPanelAp.setBackColor("#FFFFFF");
        Style style = new Style();
        LabelUtils.setBorder((Style)style, (String)"1px solid #d7d7e5");
        flexPanelAp.setStyle(style);
        flexPanelAp.setCustomeStyles("eyJ0eXBlIjowLCJjb250ZW50IjoiJCB7XG4gIG1heC13aWR0aDoyMjZweDtcbn0ifQ==");
        return flexPanelAp;
    }

    private FlexPanelAp createIndexTraceConstantFlexPanelAp(String constant) {
        FlexPanelAp flexPanelAp = this.createElementFlexPanelAp();
        LabelAp elementResultLabel = LabelUtils.createLabelAp((String)UUID.randomUUID().toString(), (String)constant, (Integer)24, (String)"#212121", (String)"", (String)"700");
        elementResultLabel.setCustomeStyles("eyJ0eXBlIjowLCJjb250ZW50IjoiJCB7XG4gICBwb3NpdGlvbjphYnNvbHV0ZTtcbiAgIHRvcDogNTAlO1xuICAgbGVmdDogNTAlO1xuICAgdHJhbnNmb3JtOiB0cmFuc2xhdGUoLTUwJSwgLTUwJSlcbn0ifQ==");
        flexPanelAp.getItems().add(elementResultLabel);
        return flexPanelAp;
    }

    private LabelAp createIndexTraceOperatorLabelAp(String operator) {
        LabelAp labelAp = LabelUtils.createLabelAp((String)UUID.randomUUID().toString(), (String)operator, (Integer)32, (String)"#212121", (String)"", (String)"400");
        labelAp.setHeight(new LocaleString("100%"));
        labelAp.setTextAlign("center");
        labelAp.setCustomeStyles("eyJ0eXBlIjowLCJjb250ZW50IjoiJCB7XG4gIG1heC13aWR0aDoyMjZweDtcbn0ifQ==");
        return labelAp;
    }

    public void onGetControl(OnGetControlArgs e) {
        String key = e.getKey();
        if (key.startsWith(PREFIX_COMPARE_ITEM_ELEMENT_LABEL_KEY)) {
            String selectedCompareItemElement = this.getPageCache().get(CACHE_CURRENT_SELECT_ELEMENT_KEY);
            if (StringUtils.isNotEmpty((CharSequence)selectedCompareItemElement)) {
                this.changeIndexRangeSelectedStyle(selectedCompareItemElement, "1px solid #F2F6FF", "#212121");
                String[] elementKeySplit = selectedCompareItemElement.split("_");
                String resultRecordId = elementKeySplit[1];
                String rowIndex = elementKeySplit[4];
                String indexTraceFlexKey = PREFIX_INDEX_TRACE_FLEX_KEY + resultRecordId + "_" + rowIndex;
                HashMap<String, Serializable> map = new HashMap<String, Serializable>(2);
                map.put("items", new ArrayList(0));
                map.put("vi", Integer.valueOf(0));
                this.getView().updateControlMetadata(indexTraceFlexKey, map);
            }
            if (key.equals(selectedCompareItemElement)) {
                this.getPageCache().remove(CACHE_CURRENT_SELECT_ELEMENT_KEY);
                return;
            }
            Long riskResultId = Long.parseLong(this.getPageCache().get("resultid"));
            DynamicObject riskResultObject = RiskResultBusiness.queryDataById((Long)riskResultId, (String)"startdate,enddate,runorg.id");
            this.selectedCompareItemElement(key, riskResultObject);
            this.getPageCache().put(CACHE_CURRENT_SELECT_ELEMENT_KEY, key);
        } else if (key.startsWith(PREFIX_INDEX_TRACE_ELEMENT_LABEL_KEY)) {
            Long elementId = Long.parseLong(key.split("_")[2]);
            DynamicObject elementObject = (DynamicObject)ElementBusiness.queryElementByIds(Collections.singletonList(elementId), (String)"id,bottom,number").get(0);
            this.showElementInfoForm(elementObject);
        }
    }
}

