/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.result;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.list.BillList;
import kd.bos.list.DecimalListColumn;
import kd.bos.list.ListColumnContext;
import kd.bos.list.events.CreateListColumnsListener;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.list.events.ListRowSortEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;

public class SamplingListPlugin
extends AbstractListPlugin
implements CreateListColumnsListener,
CreateListDataProviderListener,
Consumer<ListRowSortEvent> {
    private static final Log LOGGER = LogFactory.getLog(SamplingListPlugin.class);

    public void initialize() {
        BillList billlistap = (BillList)this.getControl("billlistap");
        billlistap.addCreateListColumnsListener((CreateListColumnsListener)this);
        billlistap.addCreateListDataProviderListener((CreateListDataProviderListener)this);
        billlistap.addListRowSortListeners((Consumer)this);
        this.switchToRealEntity();
        this.filterData();
    }

    private void switchToRealEntity() {
        String fieldid;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String recordId = (String)customParams.get("recordId");
        DynamicObjectCollection fieldList = this.getFieldList(recordId, fieldid = (String)customParams.get(recordId + "-fieldid"));
        if (fieldList.size() > 0) {
            DynamicObject config = (DynamicObject)fieldList.get(0);
            String name = config.getString("name");
            String subname = config.getString("subname");
            String ischild = config.getString("ischild");
            if ("false".equals(ischild) && StringUtils.isNotEmpty((CharSequence)subname)) {
                BillList billlistap = (BillList)this.getControl("billlistap");
                billlistap.setEntityId(subname);
            } else {
                BillList billlistap = (BillList)this.getControl("billlistap");
                billlistap.setEntityId(name);
            }
        }
    }

    private DynamicObjectCollection getFieldList(String recordId, String fieldid) {
        DynamicObjectCollection fieldList = new DynamicObjectCollection();
        if (null != recordId && null != fieldid) {
            fieldList = QueryServiceHelper.query((String)"tctb_custom_datasource", (String)"name,subname,ischild,entryentity.fieldsubname,entryentity.id,entryentity.fieldname,entryentity.bizsubname", (QFilter[])new QFilter[]{new QFilter("entryentity.id", "in", Arrays.stream(fieldid.split(",")).map(Long::parseLong).collect(Collectors.toList()))});
        }
        return fieldList;
    }

    public void createListColumns(BeforeCreateListColumnsArgs args) {
        String fieldid;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String recordId = (String)customParams.get("recordId");
        DynamicObjectCollection fieldList = this.getFieldList(recordId, fieldid = (String)customParams.get(recordId + "-fieldid"));
        if (fieldList.size() > 0) {
            Map<String, DynamicObject> collect = fieldList.stream().collect(Collectors.toMap(o -> o.getString("entryentity.id"), Function.identity()));
            if (EmptyCheckUtils.isNotEmpty((Object)fieldid) && EmptyCheckUtils.isNotEmpty(collect)) {
                List seqColumns = args.getListColumns().stream().filter(p -> "fseq".equals(p.getListFieldKey())).collect(Collectors.toList());
                args.getListColumns().clear();
                args.getListColumns().addAll(seqColumns);
                this.buildDynamicColumn(args, fieldid, collect);
                this.setCacheEntity(fieldList);
            }
        }
    }

    private void setCacheEntity(DynamicObjectCollection fieldList) {
        DynamicObject config = (DynamicObject)fieldList.get(0);
        String name = config.getString("name");
        String subname = config.getString("subname");
        String ischild = config.getString("ischild");
        if ("false".equals(ischild) && StringUtils.isNotEmpty((CharSequence)subname)) {
            this.getPageCache().put("entityname", subname);
        } else {
            this.getPageCache().put("entityname", name);
        }
    }

    private void buildDynamicColumn(BeforeCreateListColumnsArgs args, String fieldid, Map<String, DynamicObject> collect) {
        if (EmptyCheckUtils.isNotEmpty((Object)fieldid)) {
            for (String field : fieldid.split(",")) {
                DynamicObject object = collect.get(field);
                if (object == null) continue;
                DecimalListColumn e = new DecimalListColumn();
                String fieldName = object.getString("entryentity.fieldname");
                e.setCaption(new LocaleString(object.getString("entryentity.bizsubname")));
                e.setKey(fieldName);
                e.setListFieldKey(fieldName);
                e.setZeroShow(true);
                e.setContext(new ListColumnContext(Collections.singletonList(fieldName), false));
                e.setColumnOrderAndFilter(false);
                e.setUserConfigColumnSettings(null);
                String width = 100 / fieldid.split(",").length + "%";
                e.setWidth(new LocaleString(width));
                args.getListColumns().add(e);
            }
        }
    }

    public void filterData() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String data = (String)customParams.get("data");
        List list = (List)SerializationUtils.fromJsonString((String)data, List.class);
        BillList billList = (BillList)this.getControl("billlistap");
        FilterParameter queryFilterParameter = billList.getQueryFilterParameter();
        ArrayList<Long> idList = new ArrayList<Long>(10);
        for (Map map : list) {
            if (!StringUtils.isNotEmpty((CharSequence)((CharSequence)map.get("id")))) continue;
            idList.add(Long.parseLong((String)map.get("id")));
        }
        if (CollectionUtils.isEmpty(idList)) {
            queryFilterParameter.getQFilters().add(new QFilter("id", "is null", null));
        } else {
            LOGGER.info("SamplingListPlugin.idList={}", (Object)((Object)idList).toString());
            queryFilterParameter.getQFilters().add(new QFilter("id", "in", idList));
        }
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs args) {
    }

    @Override
    public void accept(ListRowSortEvent listRowSortEvent) {
        listRowSortEvent.getSource();
    }
}

