/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.risk;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.ReportList;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.taxc.tctrc.common.entity.risk.RiskResultCardInfoBean;
import kd.taxc.tctrc.common.entity.risk.SortBean;
import kd.taxc.tctrc.common.enums.QueryContainerEnum;
import kd.taxc.tctrc.common.enums.SumColEnum;
import kd.taxc.tctrc.common.util.DateUtils;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;
import kd.taxc.tctrc.common.util.KdToolUtils;
import kd.taxc.tctrc.common.util.PermissionUtils;
import kd.taxc.tctrc.common.util.biz.BizCommomUtil;
import kd.taxc.tctrc.common.util.biz.RiskLevelUtils;
import kd.taxc.tctrc.formplugin.risk.RiskReusltRptQueryPlugin;
import org.apache.commons.lang3.StringUtils;

public class RiskReusltRptPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener,
SelectRowsEventListener,
RowClickEventListener {
    private static Log logger = LogFactory.getLog(RiskReusltRptPlugin.class);
    private static final Integer NO = 10;

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
        this.getView().getModel().setValue("cstartdate", (Object)DateUtils.getFirstDateOfYear((Date)new Date()));
        this.getView().getModel().setValue("cenddate", (Object)new Date());
    }

    protected void filterContainerInit(FilterContainerInitEvent contInitEvent, ReportQueryParam queryParam) {
        super.filterContainerInit(contInitEvent, queryParam);
    }

    public void loadOtherEntryFilter(DynamicObject scheme) {
        super.loadOtherEntryFilter(scheme);
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().getModel().setValue("cstartdate", (Object)DateUtils.getFirstDateOfYear((Date)new Date()));
        this.getView().getModel().setValue("cenddate", (Object)new Date());
        this.getView().setVisible(Boolean.FALSE, new String[]{"splitcontainerap"});
    }

    public void afterBindData(EventObject e) {
        this.initDefaultOrg();
    }

    public void entryRowClick(RowClickEvent evt) {
        String[] pkidarr = ((DynamicObject)this.getModel().getEntryEntity("tctrc_risk_run_result").get(evt.getRow())).getString("pkids").split(",");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("id", "in", (Object)KdToolUtils.stringToLong((String[])pkidarr)));
        this.getQueryParam().getFilter().setQFilters(qFilters);
        if (null != this.getPageCache().get("isFirst")) {
            this.getPageCache().remove("isFirst");
            this.getPageCache().remove("selectrow");
        } else {
            this.getPageCache().put("isFirst", "1");
            this.getPageCache().put("selectrow", String.valueOf(evt.getRow()));
            this.getView().refresh();
        }
    }

    private void initDefaultOrg() {
        List<Long> defaultOrgIds = this.getDefaultOrgIds();
        if (CollectionUtils.isEmpty(defaultOrgIds)) {
            this.getView().getModel().setValue("runorgsbak", null);
        } else {
            this.getView().getModel().setValue("runorgsbak", (Object)defaultOrgIds.toArray());
        }
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        if (e.getProperty().getName().equals("runorgs")) {
            if (ObjectUtils.isEmpty((Object)e.getChangeSet()[0].getNewValue())) {
                this.initDefaultOrg();
                return;
            }
            if (e.getChangeSet()[0].getNewValue() instanceof LinkedHashMap) {
                LinkedHashMap hashMap = (LinkedHashMap)e.getChangeSet()[0].getNewValue();
                Set set = hashMap.keySet();
                this.getView().getModel().setValue("runorgsbak", (Object)set.toArray());
            } else {
                Object[] orgids = (Object[])e.getChangeSet()[0].getNewValue();
                if (EmptyCheckUtils.isEmpty((Object)orgids)) {
                    this.initDefaultOrg();
                } else {
                    this.getView().getModel().setValue("runorgsbak", (Object)orgids);
                }
            }
        }
    }

    public void registerListener(EventObject e) {
        ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
        MulBasedataEdit org = (MulBasedataEdit)this.getView().getControl("runorgs");
        org.addBeforeF7SelectListener(this::orgAddBeforeF7SelectListener);
        BasedataEdit risk = (BasedataEdit)this.getView().getControl("risks");
        risk.addBeforeF7SelectListener(this::addBeforeF7SelectListener);
        CardEntry incomecardList = (CardEntry)this.getView().getControl("tctrc_risk_run_result");
        incomecardList.addSelectRowsListener((SelectRowsEventListener)this);
        incomecardList.addRowClickListener((RowClickEventListener)this);
    }

    public List<Long> getDefaultOrgIds() {
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            return hasPermOrgResult.getHasPermOrgs();
        }
        return null;
    }

    public List<Long> getOrgIds() {
        DynamicObjectCollection runorg = (DynamicObjectCollection)this.getView().getModel().getValue("runorgs");
        if (ObjectUtils.isEmpty((Object)runorg)) {
            return this.getDefaultOrgIds();
        }
        return BizCommomUtil.getListValByDynamicObjectCollection((DynamicObjectCollection)runorg, v -> ((DynamicObject)v.get(1)).getLong("id"));
    }

    public void orgAddBeforeF7SelectListener(BeforeF7SelectEvent event) {
        ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
        formShowParameter.setCustomParam("orgViewSchemeNumber", (Object)"40");
        formShowParameter.getCustomParams().put("orgFuncId", "40");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7", (String)"RiskReusltRptPlugin_6", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        List<Long> orgIds = this.getDefaultOrgIds();
        if (CollectionUtils.isEmpty(orgIds)) {
            return;
        }
        QFilter orgIdsFilter = new QFilter("id", "in", orgIds);
        formShowParameter.getListFilterParameter().getQFilters().add(orgIdsFilter);
    }

    public void addBeforeF7SelectListener(BeforeF7SelectEvent event) {
        ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u98ce\u9669", (String)"RiskReusltRptPlugin_1", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        List<Long> riskIds = this.getRiskIds();
        QFilter riskIdsFilter = new QFilter("id", "in", riskIds);
        formShowParameter.getListFilterParameter().getQFilters().add(riskIdsFilter);
    }

    private List<Long> getRiskIds() {
        QFilter[] qFilterArray;
        List<Long> orgIds = this.getOrgIds();
        QFilter runorgFilter = new QFilter("runorg", "in", orgIds);
        QFilter startFilter = new QFilter("startdate", ">=", this.getModel().getValue("cstartdate"));
        QFilter endFilter = new QFilter("enddate", "<=", this.getModel().getValue("cenddate"));
        if (CollectionUtils.isEmpty(orgIds)) {
            QFilter[] qFilterArray2 = new QFilter[2];
            qFilterArray2[0] = startFilter;
            qFilterArray = qFilterArray2;
            qFilterArray2[1] = endFilter;
        } else {
            QFilter[] qFilterArray3 = new QFilter[3];
            qFilterArray3[0] = startFilter;
            qFilterArray3[1] = endFilter;
            qFilterArray = qFilterArray3;
            qFilterArray3[2] = runorgFilter;
        }
        QFilter[] qFilters = qFilterArray;
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"tctrc_risk_run_result", (String)"risk", (QFilter[])qFilters);
        return BizCommomUtil.getListValByDynamicObjectCollection((DynamicObjectCollection)dynamicObjects, v -> v.getLong("risk"));
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        Date yearBeginDate = filterInfo.getDate("cstartdate");
        Date yearEndDate = filterInfo.getDate("cenddate");
        if (null == yearBeginDate) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u6790\u533a\u95f4\u201c\u5f00\u59cb\u65f6\u95f4\u201d\u3002", (String)"RiskReusltRptPlugin_2", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (null == yearEndDate) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u6790\u533a\u95f4\u201c\u7ed3\u675f\u65f6\u95f4\u201d\u3002", (String)"RiskReusltRptPlugin_3", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            return false;
        }
        String totalBase = filterInfo.getString("totalbase");
        if (StringUtil.isEmpty((CharSequence)totalBase)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6c47\u603b\u4f9d\u636e\u201d\u3002", (String)"RiskReusltRptPlugin_4", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        DynamicObjectCollection dyoList = RiskLevelUtils.getRiskLevelDb();
        IPageCache pageCache = this.getPageCache();
        pageCache.put("riskLevel", SerializationUtils.toJsonString((Object)dyoList));
        this.clearUserSetting();
        this.createDynamicCol();
        this.initCard();
        super.beforeQuery(queryParam);
        this.getView().setVisible(Boolean.TRUE, new String[]{"splitcontainerap"});
    }

    private List<Map<String, Object>> getPageCache(IPageCache pageCache) {
        String cacheStr = pageCache.get("riskLevel");
        if (StringUtils.isNotEmpty((CharSequence)cacheStr)) {
            return (List)SerializationUtils.fromJsonString((String)cacheStr, List.class);
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u98ce\u9669\u7b49\u7ea7\u7f13\u5b58\u5931\u8d25", (String)"RiskReusltRptPlugin_8", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
    }

    private void initCard() {
        IPageCache pageCache = this.getPageCache();
        List<Map<String, Object>> dyoList = this.getPageCache(pageCache);
        Object val = this.getView().getModel().getValue("totalbase");
        if (ObjectUtils.isEmpty((Object)val)) {
            return;
        }
        SumColEnum sumColEnum = SumColEnum.getEnumByCode((String)String.valueOf(val));
        ArrayList<Object> idList = new ArrayList<Object>(20);
        for (Map<String, Object> stringObjectMap : dyoList) {
            idList.add(stringObjectMap.get("id"));
        }
        QFilter filter = new QFilter("startdate", ">=", this.getModel().getValue("cstartdate")).and("enddate", "<=", this.getModel().getValue("cenddate")).and(QueryContainerEnum.getQFilter(t -> this.getModel().getValue(t), idList));
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"tctrc_risk_run_result", (String)"id,risk,runorg,rlevel.id", (QFilter[])new QFilter[]{filter});
        List data = Arrays.stream(dynamicObjects).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty((Object)this.getModel().getValue("lables"))) {
            List ids = BizCommomUtil.getListValByDynamicObjectCollection((DynamicObjectCollection)((DynamicObjectCollection)this.getModel().getValue("lables")), v -> ((DynamicObject)v.get(1)).getLong("id"));
            data = data.stream().filter(v -> !ObjectUtils.isEmpty((Object)v.getDynamicObject("risk"))).filter(v -> !ObjectUtils.isEmpty((Object)v.getDynamicObject("risk").getDynamicObjectCollection("labelentity"))).filter(v -> this.labelFilter(v.getDynamicObject("risk").getDynamicObjectCollection("labelentity"), ids)).collect(Collectors.toList());
        }
        Function<SortBean, RiskResultCardInfoBean> doCreateCardInfoFunc = k -> this.doCreateCardInfo(k.getValue(), sumColEnum);
        Function<Map.Entry, SortBean> createSortBeanFunc = m -> new SortBean((String)m.getKey(), (List)m.getValue(), ((List)m.getValue()).size());
        List<RiskResultCardInfoBean> cardInfoBeanList = data.stream().filter(v -> !ObjectUtils.isEmpty((Object)v.getDynamicObject(sumColEnum.getGroupField()))).collect(Collectors.groupingBy(k -> ((DynamicObject)k.get(sumColEnum.getGroupField())).getString("id"))).entrySet().stream().map(createSortBeanFunc).sorted(Comparator.comparing(SortBean::getSize).reversed()).map(doCreateCardInfoFunc).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(cardInfoBeanList)) {
            this.doInitCard(cardInfoBeanList);
            CardEntry cardEntry = (CardEntry)this.getControl("tctrc_risk_run_result");
            if (null != this.getPageCache().get("selectrow")) {
                cardEntry.selectCard(Integer.valueOf(this.getPageCache().get("selectrow")));
            } else {
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                qFilters.add(new QFilter("id", "in", cardInfoBeanList.get(0).getPkids().stream().map(v -> Long.parseLong(v)).collect(Collectors.toList())));
                this.getQueryParam().getFilter().setQFilters(qFilters);
                cardEntry.selectCard(Integer.valueOf(0));
            }
            for (int i = dyoList.size(); i < 10; ++i) {
                for (int j = 0; j < cardInfoBeanList.size(); ++j) {
                    cardEntry.setChildVisible(false, j, new String[]{"risktotalcard" + i});
                }
            }
        } else {
            this.getModel().deleteEntryData("tctrc_risk_run_result");
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter("id", "=", (Object)-1L));
            this.getQueryParam().getFilter().setQFilters(qFilters);
        }
    }

    private boolean labelFilter(DynamicObjectCollection dynamicObjectCollection, List<Long> ids) {
        List labelids = dynamicObjectCollection.stream().map(v -> v.getDynamicObject("labelid").getLong("masterid")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(labelids)) {
            return false;
        }
        for (Long selectLabelID : ids) {
            if (!labelids.contains(selectLabelID)) continue;
            return true;
        }
        return false;
    }

    private void doInitCard(List<RiskResultCardInfoBean> cardInfoBeanList) {
        this.getModel().deleteEntryData("tctrc_risk_run_result");
        this.getModel().batchCreateNewEntryRow("tctrc_risk_run_result", cardInfoBeanList.size());
        int row = 0;
        for (RiskResultCardInfoBean bean : cardInfoBeanList) {
            this.getModel().setValue("index", (Object)(row + 1), row);
            this.getModel().setValue("pkids", (Object)bean.getPkids().stream().collect(Collectors.joining(",")), row);
            this.getModel().setValue("title", (Object)bean.getTitle(), row);
            this.getModel().setValue("risktotalcard", (Object)bean.getRisktotal(), row);
            for (int i = 0; i < NO; ++i) {
                PropertyDescriptor propertyDescriptor = null;
                try {
                    propertyDescriptor = new PropertyDescriptor("risklevel" + i, RiskResultCardInfoBean.class);
                    this.getModel().setValue("risktotalcard" + i, propertyDescriptor.getReadMethod().invoke((Object)bean, new Object[0]), row);
                    continue;
                }
                catch (Exception e) {
                    logger.error("\uff08\u98ce\u9669\u9891\u7387\u7edf\u8ba1\uff09RiskReusltRptPlugin\u98ce\u9669\u7b49\u7ea7\u83b7\u53d6\u503c\u5931\u8d25", (Throwable)e);
                    throw new KDBizException(ResManager.loadKDString((String)"\u98ce\u9669\u9891\u7387\u7edf\u8ba1\u98ce\u9669\u7b49\u7ea7\u83b7\u53d6\u503c\u5931\u8d25\u3002", (String)"RiskReusltRptPlugin_7", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
                }
            }
            ++row;
        }
    }

    private RiskResultCardInfoBean doCreateCardInfo(List<DynamicObject> rowList, SumColEnum sumColEnum) {
        Map<String, List<DynamicObject>> risklevelMap = rowList.stream().collect(Collectors.groupingBy(k -> k.getString("rlevel.id")));
        RiskResultCardInfoBean reslut = RiskReusltRptQueryPlugin.getriskLevelCount(risklevelMap);
        DynamicObject dy = (DynamicObject)rowList.get(0).get(sumColEnum.getGroupField());
        String title = dy.getString("name");
        if (sumColEnum == SumColEnum.RISK) {
            title = String.format(ResManager.loadKDString((String)"%s\u5f02\u5e38", (String)"RiskReusltRptPlugin_5", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), title);
        }
        reslut.setTitle(title);
        reslut.setPkids(rowList.stream().map(v -> v.getString("id")).distinct().collect(Collectors.toList()));
        return reslut;
    }

    private void clearUserSetting() {
        String formId = (String)this.getView().getFormShowParameter().getCustomParams().get("formId");
        String configKey = formId + "_reportlistap_gridConfig";
        UserConfigServiceHelper.clearSetting((long)Long.parseLong(RequestContext.get().getUserId()), (String)configKey);
    }

    private void createDynamicCol() {
        Object val = this.getView().getModel().getValue("totalbase");
        if (ObjectUtils.isEmpty((Object)val)) {
            return;
        }
        ReportList listTable = (ReportList)this.getView().getControl("reportlistap");
        List reportColumnList = listTable.getColumns();
        List removeColList = SumColEnum.getEnumByCode((String)String.valueOf(val)).getRemoveColList();
        reportColumnList.removeIf(v -> removeColList.contains(((ReportColumn)v).getFieldKey()));
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String runorgpkid;
        String riskpkid;
        DynamicObject type = hyperLinkClickEvent.getRowData();
        ListShowParameter param = new ListShowParameter();
        IPageCache pageCache = this.getPageCache();
        List<Map<String, Object>> dyoList = this.getPageCache(pageCache);
        Object val = this.getView().getModel().getValue("totalbase");
        if (SumColEnum.OGR == SumColEnum.getEnumByCode((String)String.valueOf(val))) {
            riskpkid = type.getString("rowpkid");
            runorgpkid = type.getString("cardpkid");
        } else {
            riskpkid = type.getString("cardpkid");
            runorgpkid = type.getString("rowpkid");
        }
        QFilter riskidQ = new QFilter("risk.id", "=", (Object)Long.parseLong(riskpkid));
        QFilter runorgQ = new QFilter("runorg.id", "=", (Object)Long.parseLong(runorgpkid));
        QFilter startdateQ1 = new QFilter("startdate", ">=", this.getModel().getValue("cstartdate"));
        QFilter enddateQ1 = new QFilter("startdate", "<=", (Object)DateUtils.getLastDateOfDay((Date)((Date)this.getModel().getValue("cenddate"))));
        QFilter startdateQ2 = new QFilter("enddate", ">=", this.getModel().getValue("cstartdate"));
        QFilter enddateQ2 = new QFilter("enddate", "<=", (Object)DateUtils.getLastDateOfDay((Date)((Date)this.getModel().getValue("cenddate"))));
        QFilter allQ = riskidQ.and(runorgQ).and(startdateQ1).and(enddateQ1).and(startdateQ2).and(enddateQ2);
        for (int i = 0; i < dyoList.size(); ++i) {
            if (!hyperLinkClickEvent.getFieldName().equalsIgnoreCase("risklevel" + i)) continue;
            allQ = allQ.and(new QFilter("rlevel", "=", dyoList.get(i).get("id")));
            break;
        }
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"tctrc_handle_list", (String)"id", (QFilter[])new QFilter[]{allQ});
        List pkidList = dynamicObjectCollection.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
        LinkQueryPkIdCollection collection = KdToolUtils.listToLinkQueryPkidColl(pkidList);
        param.setLinkQueryPkIdCollection(collection);
        param.setBillFormId("tctrc_handle_list");
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)param);
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        TreeSet<String> unVisbleField = new TreeSet<String>();
        List list = event.getColumns();
        for (AbstractReportColumn abstractReportColumn : list) {
            if (!(abstractReportColumn instanceof ReportColumn)) continue;
            ReportColumn reportColumn = (ReportColumn)abstractReportColumn;
            String field = reportColumn.getFieldKey();
            LocaleString caption = reportColumn.getCaption();
            if (caption.getLocaleValue().startsWith(RiskLevelUtils.getRiskLevel())) {
                unVisbleField.add(field);
            }
            if (!unVisbleField.remove(field)) continue;
            reportColumn.setHide(true);
        }
    }
}

