/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.risk;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.tctrc.common.entity.risk.RiskResultCardInfoBean;
import kd.taxc.tctrc.common.entity.risk.RowMetaMsgInfo;
import kd.taxc.tctrc.common.entity.risk.SortBean;
import kd.taxc.tctrc.common.enums.RiskResultRptColEnum;
import kd.taxc.tctrc.common.enums.SumColEnum;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;
import kd.taxc.tctrc.common.util.biz.BizCommomUtil;
import kd.taxc.tctrc.common.util.biz.RiskLevelUtils;

public class RiskReusltRptQueryPlugin
extends AbstractReportListDataPlugin {
    private static Log logger = LogFactory.getLog(RiskReusltRptQueryPlugin.class);
    public static final String SYSTEM_TYPE = "taxc-tctrc-formplugin";

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List columnList = super.getColumns(columns);
        for (int i = 0; i < columnList.size(); ++i) {
            AbstractReportColumn arc = (AbstractReportColumn)columnList.get(i);
            String str = arc.getCaption().toString();
            if (!str.contains(RiskLevelUtils.getRiskLevel())) continue;
            Integer no = Integer.parseInt(str.replaceAll(RiskLevelUtils.getRiskLevel(), "").trim());
            DynamicObjectCollection dyoList = RiskLevelUtils.getRiskLevelDb();
            if (no >= dyoList.size()) continue;
            arc.setCaption(new LocaleString(((DynamicObject)dyoList.get(no.intValue())).getString("name") + RiskLevelUtils.getStringRiskTotal()));
        }
        return columnList;
    }

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        return this.collectDateSet(this.getFilter(reportQueryParam));
    }

    private DataSet collectDateSet(Map<String, List<QFilter>> type2QFilterListMap) {
        String mainSelectField = "id,risk,rlevel.id,runorg,risk.labelid";
        String[] orderby = this.getorderby();
        FilterInfo filterInfo = this.getQueryParam().getFilter();
        String totalBase = filterInfo.getString("totalbase");
        SumColEnum sumColEnum = SumColEnum.getEnumByCode((String)totalBase);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"tctrc_risk_run_result", (String)mainSelectField, (QFilter[])this.getQueryFilter(type2QFilterListMap, "master"));
        return this.doCollectDateSet(sumColEnum, dynamicObjects);
    }

    private DataSet doCollectDateSet(SumColEnum sumColEnum, DynamicObject[] dynamicObjects) {
        List rowMetaMsgInfos = RiskResultRptColEnum.getDynamicCol((List)sumColEnum.getRemoveColList());
        if (null == dynamicObjects || dynamicObjects.length == 0) {
            ArrayList coll = new ArrayList();
            RowMeta rowMeta = BizCommomUtil.createRowMeta((List)rowMetaMsgInfos);
            CollectionInput inputs = new CollectionInput(rowMeta, coll);
            return Algo.create((String)(((Object)((Object)this)).getClass().getName() + "tctrc_risk_run_result" + "tctrc_risk_definition")).createDataSet(new Input[]{inputs});
        }
        Function<SortBean, RiskResultCardInfoBean> doCreateCardInfoFunc = k -> this.doCreateCardInfo(k.getValue(), sumColEnum);
        Function<Map.Entry, SortBean> createSortBeanFunc = m -> new SortBean((String)m.getKey(), (List)m.getValue(), ((List)m.getValue()).size());
        List<RiskResultCardInfoBean> cardInfoBeanList = Arrays.stream(dynamicObjects).filter(v -> !ObjectUtils.isEmpty((Object)v.getDynamicObject(sumColEnum.getColGroupField()))).collect(Collectors.groupingBy(k -> ((DynamicObject)k.get(sumColEnum.getColGroupField())).getString("id"))).entrySet().stream().map(createSortBeanFunc).sorted(Comparator.comparing(SortBean::getSize).reversed()).map(doCreateCardInfoFunc).collect(Collectors.toList());
        return this.createRowDataList(cardInfoBeanList, rowMetaMsgInfos, dynamicObjects[0]);
    }

    private DataSet createRowDataList(List<RiskResultCardInfoBean> cardInfoBeanList, List<RowMetaMsgInfo> rowMetaMsgInfos, DynamicObject dynamicObject) {
        RowMeta rowMeta = BizCommomUtil.createRowMeta(rowMetaMsgInfos);
        ArrayList<Object[]> coll = new ArrayList<Object[]>();
        for (RiskResultCardInfoBean row : cardInfoBeanList) {
            Object[] resRow = this.createRow(row, rowMetaMsgInfos);
            coll.add(resRow);
        }
        CollectionInput inputs = new CollectionInput(rowMeta, coll);
        return Algo.create((String)(((Object)((Object)this)).getClass().getName() + "tctrc_risk_run_result" + "tctrc_risk_definition")).createDataSet(new Input[]{inputs});
    }

    private Object[] createRow(RiskResultCardInfoBean temp, List<RowMetaMsgInfo> rowMetaMsgInfos) {
        Object[] row = new Object[rowMetaMsgInfos.size()];
        int index = 0;
        row[index++] = "1";
        row[index++] = temp.getCardpkid();
        row[index++] = temp.getRowpkid();
        row[index++] = temp.getNumber();
        row[index++] = temp.getTitle();
        row[index++] = temp.getType();
        row[index++] = temp.getRisktotal();
        row[index++] = temp.getRisklevel0();
        row[index++] = temp.getRisklevel1();
        row[index++] = temp.getRisklevel2();
        row[index++] = temp.getRisklevel3();
        row[index++] = temp.getRisklevel4();
        row[index++] = temp.getRisklevel5();
        row[index++] = temp.getRisklevel6();
        row[index++] = temp.getRisklevel7();
        row[index++] = temp.getRisklevel8();
        row[index++] = temp.getRisklevel9();
        row[index++] = temp.getHighrisktotal();
        row[index++] = temp.getMidrisktotal();
        row[index++] = temp.getLowrisktotal();
        row[index++] = temp.getTaxtype();
        row[index++] = temp.getLabel();
        row[index++] = temp.getRiskdesc();
        return row;
    }

    private RiskResultCardInfoBean doCreateCardInfo(List<DynamicObject> rowList, SumColEnum sumColEnum) {
        DynamicObjectCollection dynamicObjects;
        Map<String, List<DynamicObject>> risklevelMap = rowList.stream().collect(Collectors.groupingBy(k -> k.getString("rlevel.id")));
        RiskResultCardInfoBean reslut = RiskReusltRptQueryPlugin.getriskLevelCount(risklevelMap);
        DynamicObject dy = (DynamicObject)rowList.get(0).get(sumColEnum.getColGroupField());
        String title = dy.getString("name");
        reslut.setTitle(title);
        reslut.setNumber(dy.getString("number"));
        reslut.setRowpkid(dy.getString("id"));
        reslut.setCardpkid(rowList.get(0).getDynamicObject(sumColEnum.getGroupField()).getString("id"));
        DynamicObject risk = (DynamicObject)rowList.get(0).get("risk");
        reslut.setType(risk.getString("riskType"));
        reslut.setRiskdesc(risk.getString("describe"));
        DynamicObjectCollection taxtypes = risk.getDynamicObjectCollection("taxtypemul");
        if (EmptyCheckUtils.isNotEmpty((Object)taxtypes)) {
            String taxTypeName = taxtypes.stream().map(v -> ((DynamicObject)v.get(1)).getLocaleString("name").getLocaleValue()).collect(Collectors.joining("\uff1b"));
            reslut.setTaxtype(taxTypeName);
        }
        if (!CollectionUtils.isEmpty((Collection)(dynamicObjects = risk.getDynamicObjectCollection("labelentity")))) {
            String labelName = dynamicObjects.stream().map(v -> v.getDynamicObject("labelid").getString("name")).collect(Collectors.joining(","));
            reslut.setLabel(labelName);
        }
        reslut.setPkids(rowList.stream().map(v -> v.getString("id")).distinct().collect(Collectors.toList()));
        return reslut;
    }

    public static RiskResultCardInfoBean getriskLevelCount(Map<String, List<DynamicObject>> risklevelMap) {
        HashMap<String, Integer> countMap = new HashMap<String, Integer>(10);
        DynamicObjectCollection dyoList = RiskLevelUtils.getRiskLevelDb();
        for (int i = 0; i < dyoList.size(); ++i) {
            String id = ((DynamicObject)dyoList.get(i)).getString("id");
            if (risklevelMap.get(id) == null) continue;
            countMap.put("risklevel" + i, risklevelMap.get(id).size());
        }
        try {
            return RiskReusltRptQueryPlugin.myObjectField(RiskResultCardInfoBean.class, countMap);
        }
        catch (Exception e) {
            logger.error("\uff08\u98ce\u9669\u9891\u7387\u7edf\u8ba1\uff09RiskResultCardInfoBean\u81ea\u9002\u5e94\u8d4b\u503c\u5931\u8d25", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u98ce\u9669\u9891\u7387\u7edf\u8ba1\u81ea\u9002\u5e94\u98ce\u9669\u7b49\u7ea7\u5931\u8d25\u3002", (String)"RiskReusltRptQueryPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
    }

    public static RiskResultCardInfoBean myObjectField(Class<?> tclass, Map<String, Integer> countMap) throws Exception {
        Class<?> aClass = Class.forName(tclass.getCanonicalName());
        Object bean = aClass.newInstance();
        Field[] fields = aClass.getDeclaredFields();
        PropertyDescriptor descriptor = null;
        Integer totalCount = 0;
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getName().startsWith("risklevel")) continue;
            Integer count = countMap.get(fields[i].getName());
            descriptor = new PropertyDescriptor(fields[i].getName(), aClass);
            Method setMethod = descriptor.getWriteMethod();
            if (count != null) {
                setMethod.invoke(bean, String.valueOf(count));
                totalCount = totalCount + count;
                continue;
            }
            setMethod.invoke(bean, "0");
        }
        RiskResultCardInfoBean cardBean = (RiskResultCardInfoBean)bean;
        cardBean.setRisktotal(String.valueOf(totalCount));
        return cardBean;
    }

    private QFilter[] getQueryFilter(Map<String, List<QFilter>> type2QFilterListMap, String type) {
        if (CollectionUtils.isEmpty((Collection)type2QFilterListMap.get(type))) {
            return null;
        }
        return type2QFilterListMap.get(type).toArray(new QFilter[type2QFilterListMap.get(type).size()]);
    }

    private String[] getorderby() {
        FilterInfo filterInfo = this.getQueryParam().getFilter();
        String totalBase = filterInfo.getString("totalbase");
        if (StringUtil.isEmpty((CharSequence)totalBase)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6c47\u603b\u4f9d\u636e\u201d\u3002", (String)"RiskReusltRptQueryPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        String[] orders = new String[]{"runtime desc"};
        return orders;
    }

    private Map<String, List<QFilter>> getFilter(ReportQueryParam reportQueryParam) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        List list = filterInfo.getFilterItems();
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u8fc7\u6ee4\u6761\u4ef6\u201d\u3002", (String)"RiskReusltRptQueryPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        HashMap<String, List<QFilter>> type2QFilterListMap = new HashMap<String, List<QFilter>>();
        if (CollectionUtils.isEmpty((Collection)reportQueryParam.getFilter().getQFilters())) {
            reportQueryParam.getFilter().setQFilters(Collections.singletonList(new QFilter("id", "=", (Object)0L)));
        }
        type2QFilterListMap.put("master", reportQueryParam.getFilter().getQFilters());
        return type2QFilterListMap;
    }
}

