/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.risk;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.SelectRowsEvent;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.operate.formop.Refresh;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.tree.TreeFilterParameter;
import kd.taxc.tctrc.common.enums.LicenseTaxEnum;
import kd.taxc.tctrc.common.helper.OrgCheckServiceHelper;
import kd.taxc.tctrc.common.helper.OrgServiceHelper;
import kd.taxc.tctrc.common.helper.TaxcMainServiceHelper;
import kd.taxc.tctrc.common.task.RiskSharingDoCalTask;
import kd.taxc.tctrc.common.task.Task;
import kd.taxc.tctrc.common.threadpools.ThreadPoolsService;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;
import kd.taxc.tctrc.common.util.OrgCheckUtil;
import kd.taxc.tctrc.common.util.OrgUtils;
import kd.taxc.tctrc.common.util.StringUtil;
import org.apache.commons.lang3.math.NumberUtils;

public class SharingRiskPlanPlugin
extends AbstractBillPlugIn
implements SelectRowsEventListener,
HyperLinkClickListener {
    private static Log logger = LogFactory.getLog(SharingRiskPlanPlugin.class);
    private static final String ORG = "org";
    private static final String RISK_ASSIGN_ENTITY = "tctrc_risk_assign";
    private static final String CURRENT_PLAN_INDEX = "current_plan_index";
    private static final String RISK_ASSIGN_ORG = "tctrc_risk_assign_org";

    public void initialize() {
        CardEntry planentity = (CardEntry)this.getControl("planentity");
        planentity.addSelectRowsListener((SelectRowsEventListener)this);
    }

    private void initOrg() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (null != customParams.get("orgid")) {
            String orgid = OrgCheckUtil.findTaxOrg((IFormView)this.getView(), (IPageCache)this.getPageCache(), (Long)Long.parseLong(customParams.get("orgid").toString()));
            this.getModel().setValue(ORG, (Object)orgid);
            this.getPageCache().put("orgid", orgid);
        } else {
            Long unitOrgId = RequestContext.get().getOrgId();
            String orgid = OrgCheckUtil.findTaxOrg((IFormView)this.getView(), (IPageCache)this.getPageCache(), (Long)unitOrgId);
            if (null != orgid) {
                this.getModel().setValue(ORG, (Object)orgid);
                this.getPageCache().put("orgid", orgid);
            }
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"flex_addorg", "vector_addorg", "label_addorg", "label_moreorg", "labelcreate", "label_previeworg", "button_addplan"});
        EntryGrid riskentity = (EntryGrid)this.getControl("riskentity");
        riskentity.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit orgBaseData = (BasedataEdit)this.getControl("mulsharingorg");
        orgBaseData.addBeforeF7SelectListener(this::beforeOrgSelect);
        BasedataEdit orgattrBaseData = (BasedataEdit)this.getControl("mulsharingorgattr");
        orgattrBaseData.addBeforeF7SelectListener(this::beforeOrgAttrSelect);
        BasedataEdit org = (BasedataEdit)this.getView().getControl(ORG);
        org.addBeforeF7SelectListener(this::orgAddBeforeF7SelectListener);
    }

    public void orgAddBeforeF7SelectListener(BeforeF7SelectEvent event) {
        OrgServiceHelper.orgAddBeforeF7SelectListener((BeforeF7SelectEvent)event);
    }

    private void beforeOrgAttrSelect(BeforeF7SelectEvent event) {
        ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
        TreeFilterParameter treeFilterParameter = new TreeFilterParameter();
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u88ab\u5171\u4eab\u7ec4\u7ec7\u5c5e\u6027", (String)"SharingRiskPlanPlugin_10", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        treeFilterParameter.getQFilters().add(new QFilter("longnumber", "like", (Object)"org-attribute001%"));
        formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("group.longnumber", "like", (Object)"org-attribute001%"));
        formShowParameter.setTreeFilterParameter(treeFilterParameter);
    }

    private void beforeOrgSelect(BeforeF7SelectEvent event) {
        ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
        formShowParameter.setCustomParam("orgViewSchemeNumber", (Object)"40");
        formShowParameter.getCustomParams().put("orgFuncId", "40");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7", (String)"SharingRiskPlanPlugin_6", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        List<Long> subOrgIds = this.getSubOrgIds();
        QFilter orgIdsFilter = new QFilter("id", "in", subOrgIds);
        formShowParameter.getListFilterParameter().getQFilters().add(orgIdsFilter);
    }

    public void afterCreateNewData(EventObject e) {
        this.initOrg();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initOrg();
        this.resetPlanName(0);
    }

    public void afterBindData(EventObject e) {
        this.setPlanCardRow();
        this.setVisible();
    }

    public void setPlanCardRow() {
        int currentPlanIndex = NumberUtils.toInt((String)this.getPageCache().get(CURRENT_PLAN_INDEX));
        CardEntry cardEntry = (CardEntry)this.getControl("planentity");
        cardEntry.selectCard(Integer.valueOf(currentPlanIndex));
        cardEntry.selectRowsChanged(Collections.singletonList(currentPlanIndex), null);
    }

    private void setVisible() {
        int row = this.getModel().getEntryRowCount("planentity");
        if (row > 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexnodata", "planflex"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexdata", "planentity"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexnodata", "planflex"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexdata", "planentity"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        CardEntry planentity;
        int[] selectRows;
        if (ORG.equals(e.getProperty().getName())) {
            HashMap<String, Object> custom = new HashMap<String, Object>();
            Map map = this.getView().getFormShowParameter().getCustomParams();
            ChangeData[] changeData = e.getChangeSet();
            if (changeData != null && changeData.length > 0) {
                DynamicObject newOrg = (DynamicObject)changeData[0].getNewValue();
                if (null == newOrg) {
                    this.getView().getModel().setValue(ORG, (Object)this.getPageCache().get("orgid"));
                    return;
                }
                if (newOrg.getString("id").equalsIgnoreCase(this.getPageCache().get("orgid"))) {
                    return;
                }
                String neworgid = newOrg.getString("id");
                String appid = this.getView().getFormShowParameter().getAppId();
                LicenseTaxEnum taxEnum = LicenseTaxEnum.getEnumInstanceByAppid((String)appid);
                if (null != taxEnum && OrgCheckUtil.withoutLicenseCheck((IFormView)this.getView(), (String)neworgid, (String)appid, (String)taxEnum.getCategoryCode())) {
                    this.getView().getFormShowParameter().setCustomParam("isNeedClose", (Object)"1");
                    this.getView().getModel().setValue(ORG, (Object)this.getPageCache().get("orgid"));
                    return;
                }
                if (null != map && EmptyCheckUtils.isNotEmpty(map.get("isNeedClose"))) {
                    this.getView().getFormShowParameter().getCustomParams().remove("isNeedClose");
                }
                this.getPageCache().put("orgid", neworgid);
            }
            this.getModel().setDataChanged(false);
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
            if (org != null) {
                String orgid = org.getString("id");
                custom.put("orgid", orgid);
                QFilter filter = new QFilter(ORG, "=", (Object)Long.parseLong(orgid));
                DynamicObject plan = QueryServiceHelper.queryOne((String)RISK_ASSIGN_ENTITY, (String)"id", (QFilter[])new QFilter[]{filter});
                if (plan != null) {
                    this.showBill(plan.getLong("id"), custom);
                } else {
                    this.showBill(null, custom);
                }
                if (map != null && EmptyCheckUtils.isEmpty(map.get("isNeedClose"))) {
                    this.getView().close();
                }
            }
        } else if ("planname".equals(e.getProperty().getName()) && !"true".equals(this.getPageCache().get("refresh")) && (selectRows = (planentity = (CardEntry)this.getControl("planentity")).getSelectRows()) != null && selectRows.length > 0) {
            this.getModel().setValue("name", e.getChangeSet()[0].getNewValue(), selectRows[0]);
        }
    }

    private void showBill(Object pkId, Map<String, Object> customParams) {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setCustomParams(customParams);
        if (pkId != null) {
            billShowParameter.setPkId(pkId);
            billShowParameter.setBillStatus(BillOperationStatus.EDIT);
        } else {
            billShowParameter.setBillStatus(BillOperationStatus.ADDNEW);
        }
        billShowParameter.setFormId(RISK_ASSIGN_ENTITY);
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    public void click(EventObject evt) {
        boolean isAddOrg;
        Object source = evt.getSource();
        boolean bl = isAddOrg = source instanceof Vector && "vector_addorg".equals(((Vector)source).getKey()) || source instanceof Container && "flex_addorg".equals(((Container)source).getKey()) || source instanceof Label && "label_addorg".equals(((Label)source).getKey()) || source instanceof Label && "label_moreorg".equals(((Label)source).getKey());
        if (!isAddOrg || this.checkPlanNotSelected()) {
            if (source instanceof Label && "labelcreate".equals(((Label)source).getKey())) {
                Button button = (Button)this.getControl("button_addplan");
                button.click();
            } else if (source instanceof Label && "label_previeworg".equals(((Label)source).getKey())) {
                this.showPreviewOrgList();
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        Object source = evt.getSource();
        super.beforeClick(evt);
        if (source instanceof Button && "button_addplan".equals(((Button)source).getKey())) {
            ArrayList<Long> orgIds = new ArrayList<Long>(16);
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(ORG);
            if (dynamicObject != null) {
                Long orgid = dynamicObject.getLong("id");
                orgIds.add(orgid);
                Map orgCheckMap = OrgCheckServiceHelper.orgEnableBatch(orgIds);
                for (Boolean isEnable : orgCheckMap.values()) {
                    if (!isEnable.equals(Boolean.TRUE)) continue;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u72b6\u6001\u4e3a\u7981\u7528\uff0c\u4e0d\u53ef\u4ee5\u65b0\u589e\u65b9\u6848\u3002", (String)"SharingRiskPlanPlugin_12", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
            }
        }
    }

    private void showPreviewOrgList() {
        DynamicObjectCollection orgAttrEntity = ((DynamicObject)this.getModel().getEntryEntity("subentryentity").get(0)).getDynamicObjectCollection("mulsharingorgattr");
        List<Long> attrids = orgAttrEntity.stream().map(v -> v.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
        List<Long> previeworgs = this.getOrgsByOrgAttrAndParentOrg(attrids);
        ListSelectedRowCollection listSelectedRowCollection = new ListSelectedRowCollection();
        ArrayList<Long> previeworgs2 = new ArrayList<Long>(10);
        if (EmptyCheckUtils.isNotEmpty(previeworgs)) {
            List structIds = OrgUtils.getStructurePkidsByOrgId(previeworgs.stream().map(v -> String.valueOf(v)).collect(Collectors.toList()));
            for (String orgid : structIds) {
                if (null == orgid || 0 >= orgid.trim().length()) continue;
                ListSelectedRow row = new ListSelectedRow();
                previeworgs2.add(Long.parseLong(orgid));
                row.setPrimaryKeyValue((Object)orgid);
                listSelectedRowCollection.add((Object)row);
            }
        }
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)RISK_ASSIGN_ORG, (boolean)true, (int)2);
        showParameter.setFormId(RISK_ASSIGN_ORG);
        showParameter.setListSelectedRowCollection(listSelectedRowCollection);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("title", (Object)ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7", (String)"SharingRiskPlanPlugin_6", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("980px");
        styleCss.setHeight("550px");
        showParameter.getOpenStyle().setInlineStyleCss(styleCss);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setCustomParam("status", (Object)"2");
        List filters = showParameter.getListFilterParameter().getQFilters();
        if (null != previeworgs2 && 0 < previeworgs2.size()) {
            filters.add(new QFilter("id", "in", (Object)previeworgs2.toArray()));
        } else {
            filters.add(new QFilter("id", "in", Collections.singletonList(0L)));
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private List<Long> getOrgsByOrgAttrAndParentOrg(List<Long> attrids) {
        List previeworgs = TaxcMainServiceHelper.queryTaxcMainOrgIdsByOrgIdsAndOrgAttrIds(new ArrayList(), attrids);
        List<Long> subOrgIds = this.getSubOrgIds();
        if (EmptyCheckUtils.isEmpty(subOrgIds)) {
            return new ArrayList<Long>();
        }
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"tctb_tax_main", (String)"orgattr.fbasedataid,orgid", (QFilter[])new QFilter[]{new QFilter("orgid", "in", subOrgIds)});
        if (EmptyCheckUtils.isEmpty((Object)orgs)) {
            return new ArrayList<Long>();
        }
        List collectOrg = orgs.stream().filter(v -> attrids.contains(v.getLong("orgattr.fbasedataid"))).map(e -> e.getLong("orgid")).collect(Collectors.toList());
        if (EmptyCheckUtils.isEmpty(collectOrg)) {
            return new ArrayList<Long>();
        }
        return previeworgs.stream().filter(v -> collectOrg.contains(v)).collect(Collectors.toList());
    }

    private boolean checkPlanNotSelected() {
        EntryGrid planentity = (EntryGrid)this.getControl("planentity");
        int[] selectedRows = planentity.getSelectRows();
        if (selectedRows == null || selectedRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5171\u4eab\u65b9\u6848\u88ab\u9009\u4e2d\uff0c\u8bf7\u5148\u6dfb\u52a0\u5171\u4eab\u65b9\u6848\u3002", (String)"SharingRiskPlanPlugin_13", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private List<Long> getSubOrgIds() {
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        if (org == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"SharingRiskPlanPlugin_1", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        }
        List<Long> orgList = Collections.singletonList(org.getLong("id"));
        List subOrgList = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)OrgUtils.getLocalDefaultViewId(), orgList, (boolean)true);
        if (EmptyCheckUtils.isNotEmpty((Object)subOrgList)) {
            return OrgCheckUtil.searchCheckBatchTwo((List)subOrgList, (IFormView)this.getView(), (String)"47156aff000000ac");
        }
        return subOrgList;
    }

    public void selectRowsChange(SelectRowsEvent evt) {
        List newRows = evt.getNewRows();
        if (newRows != null && newRows.size() > 0) {
            Integer startRowIndex = (Integer)newRows.get(0);
            this.getPageCache().put(CURRENT_PLAN_INDEX, String.valueOf(startRowIndex));
            this.resetPlanName(startRowIndex);
        }
    }

    private void resetPlanName(Integer startRowIndex) {
        DynamicObject[] planentities = this.getModel().getEntryEntity("planentity", startRowIndex.intValue(), startRowIndex + 1);
        if (planentities != null && planentities.length > 0) {
            this.getModel().setValue("planname", (Object)(StringUtil.isNotEmpty((CharSequence)planentities[0].getString("name")) ? planentities[0].getString("name") : ResManager.loadKDString((String)"\u5171\u4eab\u65b9\u6848\u540d", (String)"SharingRiskPlanPlugin_14", (String)"taxc-tctrc-formplugin", (Object[])new Object[0])));
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        if (e.getEntryProp().getName().equals("planentity")) {
            CardEntry planentity = (CardEntry)this.getControl("planentity");
            RowDataEntity[] rowDataEntities = e.getRowDataEntities();
            if (rowDataEntities != null && rowDataEntities.length > 0) {
                int rowIndex = rowDataEntities[0].getRowIndex();
                planentity.selectCard(Integer.valueOf(rowIndex));
                planentity.selectRowsChanged(Collections.singletonList(rowIndex), null);
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        if (e.getEntryProp().getName().equals("planentity")) {
            this.resetPlanName(e.getRowIndexs()[0]);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        EntryGrid planentity;
        int[] rows;
        ListSelectedRowCollection listSelectedRows;
        Object returnData = evt.getReturnData();
        if ("selectrisk".equals(evt.getActionId()) && (listSelectedRows = (ListSelectedRowCollection)returnData) != null && (rows = (planentity = (EntryGrid)this.getControl("planentity")).getSelectRows()) != null && rows.length > 0) {
            int row = rows[0];
            this.getModel().deleteEntryData("riskentity");
            for (ListSelectedRow selectedRow : listSelectedRows) {
                int index = this.getModel().createNewEntryRow("riskentity");
                this.getModel().setValue("riskid", selectedRow.getPrimaryKeyValue(), index, row);
            }
            this.getView().updateView("riskentity");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            String status;
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
            if (EmptyCheckUtils.isNotEmpty((Object)org) && StringUtil.equals((CharSequence)"0", (CharSequence)(status = OrgUtils.getOrgStatusById((String)org.getString("id"))))) {
                String errMsg = String.format(ResManager.loadKDString((String)"%s\u5c1a\u672a\u542f\u7528", (String)"SharingRiskPlanPlugin_11", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), org.getString("name"));
                this.getView().showTipNotification(errMsg);
                args.setCancel(true);
                return;
            }
            int planCount = this.getModel().getEntryRowCount("planentity");
            if (planCount == 0) {
                return;
            }
            DynamicObjectCollection planentity = this.getModel().getEntryEntity("planentity");
            ArrayList<String> planNames = new ArrayList<String>(10);
            for (int row = 0; row < planentity.size(); ++row) {
                String errMsg;
                this.getModel().setEntryCurrentRowIndex("planentity", row);
                String planName = ((DynamicObject)planentity.get(row)).getString("name");
                if (EmptyCheckUtils.isEmpty((Object)planName)) {
                    errMsg = String.format(ResManager.loadKDString((String)"\u7b2c%s\u4e2a\u65b9\u6848\u540d\u79f0\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u3002", (String)"SharingRiskPlanPlugin_7", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), row + 1);
                    this.getView().showTipNotification(errMsg);
                    args.setCancel(true);
                    return;
                }
                if (planNames.contains(planName)) {
                    errMsg = String.format(ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0\u201c%s\u201d\u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"SharingRiskPlanPlugin_8", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), planName);
                    this.getView().showTipNotification(errMsg);
                    args.setCancel(true);
                    return;
                }
                planNames.add(planName);
                DynamicObjectCollection subentryentity = ((DynamicObject)planentity.get(row)).getDynamicObjectCollection("subentryentity");
                if (null == subentryentity || 0 == subentryentity.size() || ((DynamicObject)subentryentity.get(0)).getDynamicObjectCollection("mulsharingorg").size() == 0 && ((DynamicObject)subentryentity.get(0)).getDynamicObjectCollection("mulsharingorgattr").size() == 0) {
                    String errMsg2 = String.format(ResManager.loadKDString((String)"\u65b9\u6848\u201c%s\u201d\u914d\u7f6e\u6709\u8bef\uff0c\u5171\u4eab\u7a0e\u52a1\u7ec4\u7ec7\u548c\u5171\u4eab\u7ec4\u7ec7\u5c5e\u6027\u90fd\u4e3a\u7a7a\uff0c\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u5171\u4eab\u7a0e\u52a1\u7ec4\u7ec7\u6216\u8005\u5171\u4eab\u7ec4\u7ec7\u5c5e\u6027\u3002", (String)"SharingRiskPlanPlugin_9", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), planName);
                    this.getView().showTipNotification(errMsg2);
                    args.setCancel(true);
                    return;
                }
                DynamicObjectCollection riskentity = ((DynamicObject)planentity.get(row)).getDynamicObjectCollection("riskentity");
                if (null != riskentity && 0 != riskentity.size()) continue;
                String errMsg3 = String.format(ResManager.loadKDString((String)"\u65b9\u6848\u201c%s\u201d\u914d\u7f6e\u6709\u8bef\uff0c\u98ce\u9669\u5217\u8868\u4e3a\u7a7a\uff0c\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u98ce\u9669\u3002", (String)"SharingRiskPlanPlugin_4", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), planName);
                this.getView().showTipNotification(errMsg3);
                args.setCancel(true);
                return;
            }
        } else if (args.getSource() instanceof Refresh) {
            this.getPageCache().put("refresh", "true");
        }
    }

    private void setStatus(BillOperationStatus status) {
        ((IBillView)this.getView()).setBillStatus(status);
        if (BillOperationStatus.EDIT == status) {
            this.getPageCache().put("status", "edit");
        } else {
            this.getPageCache().put("status", "view");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if ("close".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.setStatus(BillOperationStatus.VIEW);
            Button button = (Button)this.getView().getControl("button_addplan");
            button.click();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperateKey().equals("selectrisk")) {
            if (this.checkPlanNotSelected()) {
                return;
            }
            this.showRiskSelect();
        } else if (!args.getOperateKey().equals("edit")) {
            if (args.getOperateKey().equals("save") && args.getOperationResult().isSuccess()) {
                Object pkId = args.getOperationResult().getSuccessPkIds().get(0);
                DynamicObject riskSharing = BusinessDataServiceHelper.loadSingle(pkId, (String)RISK_ASSIGN_ENTITY);
                logger.info("\u5f00\u59cb\u4fdd\u5b58\u5230\u8fd0\u884c\u6e05\u5355\u53bb");
                ThreadPoolsService.getInstance().submitAsync((Task)new RiskSharingDoCalTask(riskSharing));
                this.getView().updateView();
                this.setPlanCardRow();
            } else if (args.getOperateKey().equals("refresh") && "true".equals(this.getPageCache().get("refresh"))) {
                this.getPageCache().put("refresh", "false");
            }
        }
        this.setVisible();
    }

    private void showRiskSelect() {
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"tctrc_risk_definition", (boolean)true, (int)2);
        DynamicObjectCollection riskentity = this.getModel().getEntryEntity("riskentity");
        ListSelectedRowCollection listSelectedRowCollection = new ListSelectedRowCollection();
        for (DynamicObject entity : riskentity) {
            ListSelectedRow row = new ListSelectedRow();
            DynamicObject risk = entity.getDynamicObject("riskid");
            row.setName(risk.getString("name"));
            row.setNumber(risk.getString("number"));
            row.setPrimaryKeyValue(risk.get("id"));
            listSelectedRowCollection.add((Object)row);
        }
        parameter.setFormId("bos_treelistf7");
        parameter.setListSelectedRowCollection(listSelectedRowCollection);
        parameter.getListFilterParameter().setFilter(new QFilter("enable", "=", (Object)"1"));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectrisk"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        if (evt.getFieldName().equals("risknumber")) {
            int rowIndex = evt.getRowIndex();
            DynamicObject risk = (DynamicObject)this.getModel().getValue("riskid", rowIndex);
            Object pkValue = risk.getPkValue();
            String risktype = risk.getString("risktype");
            if ("1".equals(risktype)) {
                this.openBill(pkValue, "tctrc_risk_number");
            } else if ("2".equals(risktype)) {
                this.openBill(pkValue, "tctrc_risk_sampling");
            } else if ("3".equals(risktype)) {
                this.openBill(pkValue, "tctrc_element_verify");
            }
        }
    }

    private void openBill(Object pkValue, String entity) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId(entity);
        if (pkValue == null) {
            parameter.setBillStatus(BillOperationStatus.ADDNEW);
        } else {
            parameter.setStatus(OperationStatus.VIEW);
            parameter.setBillStatus(BillOperationStatus.VIEW);
            parameter.setPageId(pkValue + "#" + entity);
            parameter.setPkId(pkValue);
        }
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, entity);
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)parameter);
    }
}

