/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.risk;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.list.plugin.IListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.taxc.tctrc.common.enums.OrgQueryContainerEnum;
import kd.taxc.tctrc.common.helper.TaxcMainServiceHelper;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;
import kd.taxc.tctrc.common.util.SearchUtil;
import kd.taxc.tctrc.common.util.TreeUtils;
import kd.taxc.tctrc.common.util.biz.BizCommomUtil;
import org.apache.commons.lang3.StringUtils;

public class TctrcRiskAssignOrgPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
ListRowClickListener,
IListPlugin {
    private Log logger = LogFactory.getLog(TctrcRiskAssignOrgPlugin.class);
    private static String TREE_ORG = "treeviewap";
    private static final String CURRENT_NODE = "CURRENT_NODE";
    private static final String ORG_NAME = "ORG_NAME";
    private static final String ROOT_ID = "-1";

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addListRowClickListener((ListRowClickListener)this);
        billList.addSetFilterListener(this::setFilter);
        TreeView tree = (TreeView)this.getView().getControl(TREE_ORG);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{"concel", "save"});
    }

    public void beforeBindData(EventObject e) {
        this.setVisible();
    }

    private void setVisible() {
        if (this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.VIEW)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap3", "splitpanelap_left", "btncancel", "save"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"close"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"close"});
        }
    }

    public void registerListener(EventObject e) {
        Search search = (Search)this.getControl("entitysearchap");
        IFormView view = this.getView();
        IPageCache pageCache = this.getPageCache();
        TreeView treeView = (TreeView)this.getControl(TREE_ORG);
        search.addEnterListener(event -> {
            if (StringUtils.isNotEmpty((CharSequence)event.getText())) {
                SearchUtil.searchMember((String)event.getText().toLowerCase().trim(), (boolean)false, (IFormView)view, (IPageCache)pageCache, (TreeView)treeView, (String)TREE_ORG);
            } else {
                this.getPageCache().put("_resultlist", null);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u6216\u540d\u79f0\u540e\u6309\u56de\u8f66\u952e", (String)"TctrcRiskAssignOrgPlugin_0", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            }
        });
        this.addClickListeners(new String[]{"searchbefore", "searchnext"});
    }

    public void createNewData(BizDataEventArgs e) {
        this.loadTree();
    }

    public void loadTree() {
        String title;
        ArrayList<TreeNode> orgNodeList = new ArrayList<TreeNode>();
        DynamicObjectCollection collection = TreeUtils.getOrgLists();
        if (collection != null) {
            for (DynamicObject entry : collection) {
                String orgId = entry.getString("id");
                String orgName = entry.getString("name");
                String parentid = entry.getString("parentid");
                String status = entry.getString("status");
                TreeNode leftRoot = new TreeNode();
                leftRoot.setParentid(parentid);
                leftRoot.setId(orgId);
                leftRoot.setText(orgName);
                leftRoot.setType(status);
                orgNodeList.add(leftRoot);
            }
        }
        TreeView treeView = (TreeView)this.getView().getControl(TREE_ORG);
        treeView.deleteAllNodes();
        TreeUtils.build((TreeView)treeView, orgNodeList, (IPageCache)this.getPageCache(), (boolean)true);
        Map customMap = this.getView().getFormShowParameter().getCustomParams();
        if (EmptyCheckUtils.isNotEmpty((Object)customMap) && EmptyCheckUtils.isNotEmpty(customMap.get("operationStatus")) && OperationStatus.VIEW.getValue() == Integer.parseInt(String.valueOf(customMap.get("operationStatus")))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"save"});
        }
        if (null != (title = (String)customMap.get("title"))) {
            ((Label)this.getControl("title")).setText(title);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        this.loadTree();
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = evt.getNodeId().toString();
        IPageCache pageCache = this.getPageCache();
        pageCache.put(CURRENT_NODE, nodeId);
        TreeView treeView = (TreeView)this.getControl(TREE_ORG);
        TreeNode treeNode = TreeUtils.getTreeNode((IPageCache)pageCache, (TreeView)treeView, (String)nodeId);
        if (treeNode == null) {
            return;
        }
        this.getPageCache().put(ORG_NAME, treeNode.getText());
        BillList billList = (BillList)this.getControl("billlistap");
        List childNodesList = TreeUtils.getNodeList((TreeNode)treeNode);
        ArrayList idList = new ArrayList(childNodesList.size());
        childNodesList.forEach(node -> idList.add(node.getId()));
        if (!ROOT_ID.equals(treeNode.getId())) {
            QFilter qFilter = new QFilter("org.id", "in", idList.stream().map(v -> Long.parseLong(v)).collect(Collectors.toList()));
            billList.setFilter(qFilter);
        }
        billList.refresh();
        if (OperationStatus.VIEW == this.getView().getFormShowParameter().getCustomParam("operationStatus")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"save"});
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        OrgQueryContainerEnum queryContainerEnum = OrgQueryContainerEnum.getEnumByCode((String)key);
        if (EmptyCheckUtils.isNotEmpty((Object)queryContainerEnum)) {
            Object newVal = e.getChangeSet()[0].getNewValue();
            List newVals = null;
            if (EmptyCheckUtils.isNotEmpty((Object)newVal)) {
                if (newVal instanceof DynamicObjectCollection) {
                    DynamicObjectCollection dys = (DynamicObjectCollection)e.getChangeSet()[0].getNewValue();
                    newVals = BizCommomUtil.getListValByDynamicObjectCollection((DynamicObjectCollection)dys, v -> ((DynamicObject)v.get(1)).getLong("id"));
                } else {
                    newVals = Arrays.stream(String.valueOf(newVal).split(",")).filter(v -> EmptyCheckUtils.isNotEmpty((Object)v)).collect(Collectors.toList());
                }
            }
            QFilter qFilter = OrgQueryContainerEnum.getQFilter((OrgQueryContainerEnum)queryContainerEnum, newVals, (IFormView)this.getView());
            BillList billListap = (BillList)this.getControl("billlistap");
            if (EmptyCheckUtils.isNotEmpty((Object)qFilter)) {
                DynamicObjectCollection dynamicObjects = TaxcMainServiceHelper.queryDiy((QFilter[])new QFilter[]{qFilter}, (String)TaxcMainServiceHelper.selectFields5);
                if (EmptyCheckUtils.isNotEmpty((Object)dynamicObjects)) {
                    List orgids = BizCommomUtil.getListValByDynamicObjectCollection((DynamicObjectCollection)dynamicObjects, v -> v.getString("orgid"));
                    QFilter qFilter1 = new QFilter("org.id", "in", orgids.stream().map(v -> Long.parseLong(v)).collect(Collectors.toList()));
                    billListap.setFilter(qFilter1);
                    billListap.refresh();
                } else {
                    QFilter qFilter1 = new QFilter("org.id", "in", (Object)-1243445L);
                    billListap.setFilter(qFilter1);
                    billListap.refresh();
                }
            } else {
                billListap.refresh();
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String sourceKey = source.getKey();
        if ("concel".equals(sourceKey)) {
            this.getView().close();
        } else if ("save".equals(sourceKey)) {
            BillList billlistap = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billlistap.getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u884c", (String)"TctrcRiskAssignOrgPlugin_2", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().returnDataToParent((Object)selectedRows);
                this.getView().close();
            }
        } else if ("searchbefore".equals(sourceKey) || "searchnext".equals(sourceKey)) {
            String[] btns = new String[]{"searchbefore", "searchnext"};
            SearchUtil.getLeftOrRight((IPageCache)this.getPageCache(), (IFormView)this.getView(), (String)sourceKey, (TreeView)((TreeView)this.getControl("treeviewap")), (String[])btns, (String)"treeviewap");
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
    }

    public void setFilter(SetFilterEvent e) {
        QFilter qFilter = OrgQueryContainerEnum.getQFilter(null, null, (IFormView)this.getView());
        if (EmptyCheckUtils.isNotEmpty((Object)qFilter)) {
            DynamicObjectCollection dynamicObjects = TaxcMainServiceHelper.queryDiy((QFilter[])new QFilter[]{qFilter}, (String)TaxcMainServiceHelper.selectFields5);
            List orgids = BizCommomUtil.getListValByDynamicObjectCollection((DynamicObjectCollection)dynamicObjects, v -> v.getString("orgid"));
            QFilter qFilter1 = new QFilter("org.id", "in", orgids.stream().map(v -> Long.parseLong(v)).collect(Collectors.toList()));
            e.getQFilters().add(qFilter1);
        }
    }
}

