/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.run;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.tctrc.common.task.RiskRunLogHelper;
import kd.taxc.tctrc.common.task.RiskService;
import kd.taxc.tctrc.common.task.ThreadTaskService;
import kd.taxc.tctrc.common.util.DateUtils;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;
import kd.taxc.tctrc.common.util.PageShowCommon;
import kd.taxc.tctrc.common.util.StringUtil;

public class RiskRunDialogPlugin
extends AbstractFormPlugin {
    public static final String LIST_FORM_ID = "tctrc_risk_run_list";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"buttonap", "checkresult", "queryrunlog"});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object count = customParams.get("count");
        if (count != null) {
            Label label = (Label)this.getControl("count");
            label.setText(count + "");
            if (Long.parseLong(String.valueOf(count)) >= 50L) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tctrc_risk_run_log");
                ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
                codeRuleService.getNumber("tctrc_risk_run_log", dynamicObject, null);
                String number = codeRuleService.readNumber("tctrc_risk_run_log", dynamicObject, null);
                if (EmptyCheckUtils.isEmpty((Object)number)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u53bb\u914d\u7f6e\u7f16\u7801\u89c4\u5219\u3002", (String)"RiskRunDialogPlugin_9", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
                }
                this.getModel().setValue("riskrunlogbillno", (Object)number);
                this.getView().setVisible(Boolean.TRUE, new String[]{"riskrunlogbillno", "queryrunlog"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"riskrunlogbillno", "queryrunlog"});
            }
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if ("buttonap".equals(control.getKey())) {
            Date startdate = (Date)this.getModel().getValue("caldate_startdate");
            startdate = DateUtils.getFirstDateOfMonth((Date)startdate);
            Date enddate = (Date)this.getModel().getValue("caldate_enddate");
            enddate = DateUtils.getLastDateOfMonth((Date)enddate);
            if (startdate == null || enddate == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u8ba1\u7b97\u671f\u95f4", (String)"RiskRunDialogPlugin_0", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            if (startdate.compareTo(new Date()) > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u7b97\u671f\u95f4\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u2264\u5f53\u524d\u65f6\u95f4\u3002", (String)"RiskRunDialogPlugin_1", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            if (startdate.compareTo(enddate = DateUtils.getLastDateOfMonth((Date)enddate)) > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u7b97\u671f\u95f4\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u2264\u7ed3\u675f\u65f6\u95f4\u3002", (String)"RiskRunDialogPlugin_2", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            ProgressBar progressBar = (ProgressBar)this.getView().getControl("progressbarap");
            progressBar.setPercent(0);
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String pks = (String)customParams.get("pks");
            String[] ids = pks.split(",");
            String errorMsg = null;
            if (ids.length < 50) {
                Map errorMap;
                progressBar.release();
                progressBar.setPercent(0);
                MainEntityType type = EntityMetadataCache.getDataEntityType((String)LIST_FORM_ID);
                DynamicObject[] objArray = BusinessDataServiceHelper.load((Object[])Arrays.stream(pks.split(",")).map(v -> Long.parseLong(v)).collect(Collectors.toList()).toArray(), (DynamicObjectType)type);
                ArrayList resultList = new ArrayList();
                try {
                    errorMap = RiskService.cal((ProgressBar)progressBar, resultList, (DynamicObject[])objArray, (Date)startdate, (Date)enddate, (String)ResManager.loadKDString((String)"\u624b\u5de5\u8ba1\u7b97\u8fd0\u884c", (String)"RiskRunDialogPlugin_3", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), (Boolean)Boolean.FALSE);
                }
                catch (KDBizException e) {
                    this.getView().showErrorNotification(e.getMessage());
                    return;
                }
                if (null != errorMap && errorMap.size() > 0) {
                    StringBuilder sb = new StringBuilder();
                    errorMap.forEach((k, v) -> sb.append((String)k).append(ResManager.loadKDString((String)"\u5c5e\u671f\u4e3a", (String)"RiskRunDialogPlugin_6", (String)"taxc-tctrc-formplugin", (Object[])new Object[0])).append(v.stream().collect(Collectors.joining(","))).append(ResManager.loadKDString((String)"\u72b6\u6001\u4e3a\u5df2\u5904\u7406\uff0c\u4e0d\u80fd\u91cd\u65b0\u8ba1\u7b97\u3002", (String)"RiskRunDialogPlugin_8", (String)"taxc-tctrc-formplugin", (Object[])new Object[0])));
                    errorMsg = sb.substring(0, sb.length() - 1);
                }
                progressBar.setPercent(100);
                int totalRisk = resultList.size();
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u672c\u6b21\u8ba1\u7b97%s\u9879\u98ce\u9669\uff0c\u53ef\u524d\u5f80\u7ed3\u679c\u5217\u8868\u67e5\u770b\u3002", (String)"RiskRunDialogPlugin_4", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), totalRisk));
            } else {
                progressBar.release();
                progressBar.setPercent(0);
                String no = (String)this.getModel().getValue("riskrunlogbillno");
                DynamicObject riskRunLog = RiskRunLogHelper.addRiskRunLog((String)no, (int)ids.length, (String)"2");
                ThreadTaskService.executorRisk((String[])ids, (ProgressBar)progressBar, (Date)startdate, (Date)enddate, (DynamicObject)riskRunLog);
                progressBar.setPercent(100);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u98ce\u9669\u6b63\u5728\u8fd0\u884c\u4e2d\uff0c\u53ef\u70b9\u51fb\u65e5\u5fd7\u67e5\u770b\u8fd0\u884c\u8fdb\u5ea6\u3002", (String)"RiskRunDialogPlugin_10", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            }
            if (StringUtil.isNotEmpty(errorMsg)) {
                this.getView().showErrorNotification(errorMsg);
            }
        } else if ("checkresult".equals(control.getKey())) {
            PageShowCommon.showBillList((ShowType)ShowType.MainNewTabPage, (String)"tctrc_risk_run_result", (IFormView)this.getView().getParentView(), null);
            this.getView().returnDataToParent((Object)"true");
            this.getView().close();
        } else if ("queryrunlog".equals(control.getKey())) {
            PageShowCommon.showBillList((ShowType)ShowType.MainNewTabPage, (String)"tctrc_risk_run_log", (IFormView)this.getView().getParentView(), null);
            this.getView().returnDataToParent((Object)"true");
            this.getView().close();
        }
    }
}

