/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.run;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.list.column.DynamicTextColumnDesc;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tctrc.common.enums.BooleanEnum;
import kd.taxc.tctrc.common.enums.LicenseTaxEnum;
import kd.taxc.tctrc.common.enums.RiskTypeEnum;
import kd.taxc.tctrc.common.helper.LicenseCheckServiceHelper;
import kd.taxc.tctrc.common.helper.OrgServiceHelper;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;
import kd.taxc.tctrc.common.util.JsonUtil;
import kd.taxc.tctrc.common.util.OrgCheckUtil;
import kd.taxc.tctrc.common.util.OrgUtils;
import kd.taxc.tctrc.common.util.PageShowCommon;
import kd.taxc.tctrc.formplugin.service.RiskListService;

public class RiskRunListPlugin
extends AbstractListPlugin {
    private static final Log LOGGER = LogFactory.getLog(RiskRunListPlugin.class);
    private static final String ITEM_SET_TIME = "settime";
    private static final String ITEM_RUN = "run";
    private static final String RUN_FORMID = "tctrc_risk_run_dialog";
    private static final String SET_TIME_FORMID = "tctrc_risk_set_time";
    private static final String TCTRC_RISK_RUN_LIST = "tctrc_risk_run_list";
    private static final String RISK_TYPE = "risktype";

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        RiskListService.setCommonFilterColumn(args, this.getPageCache(), this.getView());
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String riskLevel = (String)customParams.get(RISK_TYPE);
        Object orgId = customParams.get("orgid");
        List<ComboItem> orgCombos = this.getOrgComboItem();
        if (orgCombos.size() > 0) {
            orgId = orgCombos.get(0).getValue();
        }
        List commonFilters = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilters) {
            String fieldName = filterColumn.getFieldName();
            if (fieldName.contains(RISK_TYPE) && StringUtils.isNotEmpty((CharSequence)riskLevel)) {
                filterColumn.setDefaultValue(riskLevel);
            } else if (orgId != null && fieldName.equals("runorg.name")) {
                ((CommonFilterColumn)filterColumn).setComboItems(orgCombos);
                if (EmptyCheckUtils.isNotEmpty(customParams.get("orgid"))) {
                    filterColumn.setDefaultValue(String.valueOf(customParams.get("orgid")));
                } else {
                    filterColumn.setDefaultValue(String.valueOf(orgId));
                }
            }
            if (!fieldName.equals("taxtype.name")) continue;
            ((CommonFilterColumn)filterColumn).setMulti(true);
        }
    }

    protected List<ComboItem> getOrgComboItem() {
        String orgListCache = "orgListCache";
        String orgListCacheString = this.getPageCache().get(orgListCache);
        List orgList = new ArrayList();
        if (orgListCacheString == null) {
            orgList = OrgUtils.queryOrgListForInitOrgComboItems((IFormView)this.getView(), (String[])new String[]{TCTRC_RISK_RUN_LIST}, null, null);
            this.getPageCache().put(orgListCache, SerializationUtils.toJsonString(orgList));
        } else {
            orgList = (List)SerializationUtils.fromJsonString((String)orgListCacheString, orgList.getClass());
        }
        String orgID = String.valueOf(RequestContext.get().getOrgId());
        int index = -1;
        int orgIndex = -1;
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(orgList.size());
        for (Map map : orgList) {
            ++index;
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString((String)map.get("name")));
            item.setValue((String)map.get("id"));
            combos.add(item);
            if (!orgID.equals(item.getValue())) continue;
            orgIndex = index;
        }
        if (orgIndex > 0) {
            Collections.swap(combos, 0, orgIndex);
        }
        return combos;
    }

    public void filterContainerAfterSearchClick(FilterContainerSearchClickArgs args) {
        RiskListService.setRiskPageCache(args, this.getPageCache());
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilterList = e.getQFilters();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object orgId = customParams.get("orgid");
        RiskListService.replaceOrgFilter(qFilterList, orgId);
        IPageCache pageCache = this.getPageCache();
        RiskListService.setRunListLabelFilter(qFilterList, pageCache);
        ArrayList<QFilter> result = new ArrayList<QFilter>();
        if (qFilterList.size() == 0) {
            List orgList = (List)JsonUtil.fromJson((String)pageCache.get("orgListCache"), List.class);
            List orgIdList = orgList.parallelStream().filter(v -> StringUtils.isNotBlank((CharSequence)((CharSequence)v.get("id")))).map(map -> Long.parseLong((String)map.get("id"))).collect(Collectors.toList());
            QFilter orgFilter = new QFilter("runorg.id", "in", orgIdList);
            result.add(orgFilter);
        } else {
            qFilterList.forEach(filter -> Arrays.stream(filter.recombine()).forEach(qFilter -> {
                this.replaceFilter((QFilter)qFilter);
                result.add((QFilter)qFilter);
            }));
            Iterator iterator = result.iterator();
            HashSet orgIds = new HashSet(16);
            boolean existsRunOrgFilter = false;
            while (iterator.hasNext()) {
                QFilter filter2 = (QFilter)iterator.next();
                if (!"runorg".equals(filter2.getProperty()) || !"in".equals(filter2.getCP())) continue;
                existsRunOrgFilter = true;
                iterator.remove();
                orgIds.addAll((List)filter2.getValue());
            }
            if (existsRunOrgFilter) {
                result.add(new QFilter("runorg", "in", orgIds));
            }
        }
        QFilter qFilter = new QFilter("risk.enable", "=", (Object)BooleanEnum.YES.getCode());
        result.add(qFilter);
        e.getQFilters().clear();
        e.getQFilters().addAll(result);
    }

    private void replaceFilter(QFilter qFilter) {
        switch (qFilter.getProperty()) {
            case "risk.taxtype2.id": {
                qFilter.__setProperty("risk.taxtypemul.fbasedataid");
                break;
            }
            case "licensestatus": {
                List<Long> orgids = LicenseCheckServiceHelper.getOrgByAppId((String)LicenseTaxEnum.TCTRC.getAppid(), (String)String.valueOf(qFilter.getValue()));
                qFilter.__setProperty("runorg");
                qFilter.__setCP("in");
                orgids = EmptyCheckUtils.isEmpty((Object)orgids) ? Collections.singletonList(-1L) : orgids;
                qFilter.__setValue(orgids);
                break;
            }
            case "isentity": {
                qFilter.__setProperty("isvirtual");
                this.setOrgFilter(qFilter);
                break;
            }
            case "status": {
                this.setOrgFilter(qFilter);
                break;
            }
        }
    }

    private void setOrgFilter(QFilter qFilter) {
        String value;
        List orgids = new ArrayList();
        if (qFilter.getProperty().equals("isvirtual")) {
            value = qFilter.getValue().toString();
            Boolean isVirtual = null;
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)value)) {
                isVirtual = null;
            } else if (value.equals("0")) {
                isVirtual = false;
            }
            if (value.equals("1")) {
                isVirtual = true;
            }
            orgids = OrgServiceHelper.getOrgLists(null, (Boolean)isVirtual);
        }
        if (qFilter.getProperty().equals("status")) {
            value = qFilter.getValue().toString();
            Boolean isEnable = null;
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)value)) {
                isEnable = null;
            } else if (value.equals("0")) {
                isEnable = false;
            }
            if (value.equals("1")) {
                isEnable = true;
            }
            orgids = OrgServiceHelper.getOrgLists((Boolean)isEnable, null);
        }
        qFilter.__setProperty("runorg");
        qFilter.__setCP("in");
        orgids = EmptyCheckUtils.isEmpty(orgids) ? Collections.singletonList(-1L) : orgids;
        qFilter.__setValue(orgids);
    }

    public void packageData(PackageDataEvent event) {
        DynamicObject d = event.getRowData();
        Object source = event.getSource();
        if (source instanceof ColumnDesc) {
            String key = ((ColumnDesc)source).getKey();
            if (key.equals("runtime") && StringUtils.isNotEmpty((CharSequence)d.getString("runtime"))) {
                String[] runtime = d.getString("runtime").split(",");
                String calType = d.getString("risk.caltype");
                String month = " ";
                String day = " ";
                if (runtime.length > 1) {
                    month = runtime[0];
                    day = runtime[1];
                } else if (runtime.length == 1) {
                    month = runtime[0];
                }
                RiskListService.setRiskListCalType(event, calType, month, day);
            } else if ("risk.deviatedcount".equals(key)) {
                String deviatedcount = d.getString("risk.deviatedcount");
                String calType = d.getString("risk.calType");
                RiskListService.setRiskCalulationDeviation(event, calType, deviatedcount);
            }
        } else if (source instanceof DynamicTextColumnDesc && ((DynamicTextColumnDesc)source).getKey().equals("label")) {
            DynamicObject rowData = event.getRowData();
            DynamicObject risk = rowData.getDynamicObject("risk");
            if (null == risk) {
                return;
            }
            DynamicObjectCollection labelentity = risk.getDynamicObjectCollection("labelentity");
            ArrayList<String> list = new ArrayList<String>();
            for (DynamicObject label : labelentity) {
                if (label != null && label.getDynamicObject("labelid") != null) {
                    String name = label.getDynamicObject("labelid").getString("name");
                    list.add(name);
                    continue;
                }
                list.add("");
            }
            event.setFormatValue((Object)String.join((CharSequence)",", list));
        }
    }

    private boolean licenseCheck(ListSelectedRowCollection selectedRows) {
        List ids = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        DynamicObject[] dynamicObjectas = BusinessDataServiceHelper.load((String)TCTRC_RISK_RUN_LIST, (String)"runorg", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        String appid = this.getView().getFormShowParameter().getAppId();
        List collect = Arrays.stream(dynamicObjectas).map(selectedRow -> selectedRow.getLong("runorg.id")).distinct().collect(Collectors.toList());
        List checkBatch = OrgCheckUtil.searchCheckBatch(collect, (IFormView)this.getView());
        List checkFailedOrgs = collect.stream().filter(v -> !checkBatch.contains(v)).collect(Collectors.toList());
        if (EmptyCheckUtils.isNotEmpty(checkFailedOrgs)) {
            return OrgCheckUtil.check((IFormView)this.getView(), (String)String.valueOf(checkFailedOrgs.get(0)), (String)appid, null);
        }
        return false;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            if ("donothingsettime".equals(args.getOperateKey())) {
                BillList billList = (BillList)this.getView().getControl("billlistap");
                ListSelectedRowCollection list = billList.getSelectedRows();
                if (this.licenseCheck(list)) {
                    return;
                }
                ArrayList<String> ids = new ArrayList<String>();
                StringBuilder sb = new StringBuilder();
                for (ListSelectedRow row : list) {
                    ids.add(row.getPrimaryKeyValue().toString());
                    if (sb.length() > 0) {
                        sb.append(',');
                    }
                    sb.append(row.getPrimaryKeyValue());
                }
                if (ids.size() > 0) {
                    QFilter qFilter = new QFilter("id", "in", ids.stream().map(Long::parseLong).collect(Collectors.toList()));
                    DynamicObjectCollection docs = QueryServiceHelper.query((String)TCTRC_RISK_RUN_LIST, (String)"risk.risktype,risk.caltype", (QFilter[])new QFilter[]{qFilter});
                    boolean isSameCalType = true;
                    if (docs.size() > 0) {
                        String caltype = "";
                        String type = "";
                        for (DynamicObject d : docs) {
                            if ("".equals(type)) {
                                type = d.getString("risk.risktype");
                                caltype = d.getString("risk.caltype");
                            } else if (!caltype.equals(d.getString("risk.caltype"))) {
                                isSameCalType = false;
                            }
                            if (isSameCalType) continue;
                            break;
                        }
                        if (isSameCalType) {
                            FormShowParameter parameters = new FormShowParameter();
                            parameters.getOpenStyle().setShowType(ShowType.Modal);
                            parameters.setFormId(SET_TIME_FORMID);
                            parameters.setShowTitle(true);
                            parameters.setCustomParam("count", (Object)list.size());
                            parameters.setCustomParam("pks", (Object)sb.toString());
                            parameters.setCustomParam("type", (Object)type);
                            parameters.setCustomParam("caltype", (Object)caltype);
                            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ITEM_SET_TIME);
                            parameters.setCloseCallBack(closeCallBack);
                            this.getView().showForm(parameters);
                            if (null != this.getView().getParentView()) {
                                this.getView().sendFormAction(this.getView().getParentView());
                            }
                        } else {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba1\u7b97\u5468\u671f\u76f8\u540c\u7684\u6570\u636e\u3002", (String)"RiskRunListPlugin_9", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
                        }
                    }
                }
            } else if ("donothingrun".equals(args.getOperateKey())) {
                BillList billList = (BillList)this.getView().getControl("billlistap");
                ListSelectedRowCollection list = billList.getSelectedRows();
                if (this.licenseCheck(list)) {
                    return;
                }
                StringBuilder sb = new StringBuilder();
                for (ListSelectedRow row : list) {
                    if (sb.length() > 0) {
                        sb.append(',');
                    }
                    sb.append(row.getPrimaryKeyValue());
                }
                FormShowParameter parameters = new FormShowParameter();
                parameters.getOpenStyle().setShowType(ShowType.Modal);
                parameters.setFormId(RUN_FORMID);
                parameters.setShowTitle(true);
                parameters.setCustomParam("count", (Object)list.size());
                parameters.setCustomParam("pks", (Object)sb.toString());
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ITEM_RUN);
                parameters.setCloseCallBack(closeCallBack);
                this.getView().showForm(parameters);
                if (null != this.getView().getParentView()) {
                    this.getView().sendFormAction(this.getView().getParentView());
                }
            } else if ("donothingevaluation".equals(args.getOperateKey())) {
                BillList billList = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                if (selectedRows.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"RiskRunListPlugin_11", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject[] objectArr = BusinessDataServiceHelper.load((Object[])selectedRows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)TCTRC_RISK_RUN_LIST));
                ArrayList<Long> numberList = new ArrayList<Long>(objectArr.length);
                String orgid = "";
                String riskname = "";
                Long runid = null;
                for (DynamicObject object : objectArr) {
                    Long numberId = object.getLong("risk.id");
                    numberList.add(numberId);
                    orgid = object.getString("runorg.id");
                    riskname = object.getString("risk.name");
                    runid = object.getLong("id");
                }
                String userId = RequestContext.get().getUserId();
                Map customMap = this.getView().getFormShowParameter().getCustomParams();
                customMap.put("user", String.valueOf(userId));
                customMap.put("number", numberList);
                customMap.put("datasource", "3");
                customMap.put("orgid", orgid);
                customMap.put("riskname", riskname);
                customMap.put("resultid", runid);
                PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"tctrc_evaluation_frame", (IFormView)this.getView(), (Map)customMap, (IFormPlugin)this);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (ITEM_RUN.equals(closedCallBackEvent.getActionId())) {
            String flag = (String)closedCallBackEvent.getReturnData();
            if ("true".equals(flag)) {
                BillList billList = (BillList)this.getView().getControl("billlistap");
                billList.refreshData();
            }
        } else if (ITEM_SET_TIME.equals(closedCallBackEvent.getActionId())) {
            if (null != closedCallBackEvent.getReturnData()) {
                DynamicObject[] obj;
                Map map = (Map)closedCallBackEvent.getReturnData();
                BillList billList = (BillList)this.getView().getControl("billlistap");
                ListSelectedRowCollection list = billList.getSelectedRows();
                if (CollectionUtils.isEmpty((Collection)list)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u8fd0\u884c\u7684\u98ce\u9669\u8bb0\u5f55\u3002", (String)"RiskRunListPlugin_5", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    return;
                }
                ArrayList<String> ids = new ArrayList<String>();
                for (ListSelectedRow row : list) {
                    ids.add(row.getPrimaryKeyValue().toString());
                }
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)TCTRC_RISK_RUN_LIST);
                for (DynamicObject d : obj = BusinessDataServiceHelper.load((Object[])ids.stream().map(v -> Long.parseLong(v)).collect(Collectors.toList()).toArray(), (DynamicObjectType)mainEntityType)) {
                    d.set("runtime", (Object)((String)map.get("month") + "," + (String)map.get("day")));
                    d.set("month", map.get("month"));
                    d.set("day", map.get("day"));
                }
                SaveServiceHelper.save((DynamicObject[])obj);
            }
            BillList billList = (BillList)this.getView().getControl("billlistap");
            billList.refreshData();
        } else if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"tctrc_risk_evaluation")) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            billList.refreshData();
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        HyperLinkClickEvent hyperEvt = args.getHyperLinkClickEvent();
        BillList list = (BillList)hyperEvt.getSource();
        ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)currentSelectedRowInfo.getPrimaryKeyValue(), (String)TCTRC_RISK_RUN_LIST);
        DynamicObject risk = obj.getDynamicObject("risk");
        String risktype = risk.getString(RISK_TYPE);
        this.openBill(risk.getPkValue(), RiskTypeEnum.getEnumByKey((String)risktype));
    }

    private void openBill(Object pkValue, RiskTypeEnum riskTypeEnum) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId(riskTypeEnum.getFormid());
        if (pkValue == null) {
            parameter.setBillStatus(BillOperationStatus.ADDNEW);
        } else {
            parameter.setBillStatus(BillOperationStatus.EDIT);
            parameter.setStatus(OperationStatus.VIEW);
            parameter.setPkId(pkValue);
            parameter.setPageId(riskTypeEnum.getKey() + pkValue);
            parameter.setCaption(riskTypeEnum.getTitle());
        }
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, riskTypeEnum.getFormid());
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)parameter);
    }
}

