/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.run;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.list.column.DynamicTextColumnDesc;
import kd.bos.exception.KDBizException;
import kd.bos.filter.FilterColumn;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.AbstractListColumn;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tctrc.business.riskresult.RiskResultBusiness;
import kd.taxc.tctrc.common.element.TimeDeviatedEnum;
import kd.taxc.tctrc.common.enums.DealStatusEnum;
import kd.taxc.tctrc.common.enums.RiskHandlerEnum;
import kd.taxc.tctrc.common.enums.RiskTypeEnum;
import kd.taxc.tctrc.common.util.BigDecimalUtil;
import kd.taxc.tctrc.common.util.DateUtils;
import kd.taxc.tctrc.common.util.PageShowCommon;
import kd.taxc.tctrc.common.util.biz.RiskDealUtil;
import kd.taxc.tctrc.formplugin.result.AbstractResultPlugin;
import kd.taxc.tctrc.formplugin.service.RiskListService;
import org.apache.commons.lang.math.NumberUtils;

public class RiskRunResultListPlugin
extends AbstractListPlugin {
    private static final String TYPE_SELECT = "select";
    private static final String ENTITY_RUN_RESULT = "tctrc_risk_run_result";
    private int numResult = 0;
    private static final String HANDLE_STATUS = "status";
    private static final String START_DATE = "startdate";
    private static final String END_DATE = "enddate";
    private static final String RISK_LEVEL = "rlevel";
    private static final String RUN_TIME = "runtime";
    private static final String UN_DO_CALL_BACK = "undocallback";
    private DecimalFormat format = new DecimalFormat("#,##0.0000");

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        RiskListService.setCommonFilterColumn(args, this.getPageCache(), this.getView());
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String riskLevel = (String)customParams.get(RISK_LEVEL);
        String handleStatus = (String)customParams.get(HANDLE_STATUS);
        String startdate = null != customParams.get(START_DATE) ? String.valueOf(customParams.get(START_DATE)) : null;
        String enddate = null != customParams.get(END_DATE) ? String.valueOf(customParams.get(END_DATE)) : null;
        Object orgId = customParams.get("orgid");
        Object calType = customParams.get("caltype");
        List commonFilters = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilters) {
            String fieldName = filterColumn.getFieldName();
            if (fieldName.startsWith(RISK_LEVEL) && StringUtils.isNotEmpty((CharSequence)riskLevel)) {
                filterColumn.setDefaultValue(riskLevel);
                continue;
            }
            if (fieldName.contains(HANDLE_STATUS) && StringUtils.isNotEmpty((CharSequence)handleStatus)) {
                filterColumn.setDefaultValue(handleStatus);
                continue;
            }
            if (orgId != null && fieldName.equals("runorg.name")) {
                if (orgId instanceof List) {
                    filterColumn.setDefaultValues((List)orgId);
                    continue;
                }
                if (orgId instanceof String && "all".equals(orgId)) {
                    filterColumn.setDefaultValue(null);
                    continue;
                }
                filterColumn.setDefaultValue(String.valueOf(orgId));
                continue;
            }
            if (fieldName.contains(RUN_TIME) && null != startdate) {
                filterColumn.setDefaultValues(Arrays.asList(startdate, enddate));
                continue;
            }
            if (!fieldName.contains(RUN_TIME) || null == calType) continue;
            filterColumn.setDefaultValue(String.valueOf(calType));
        }
    }

    public void filterContainerAfterSearchClick(FilterContainerSearchClickArgs args) {
        RiskListService.setRiskPageCache(args, this.getPageCache());
    }

    public void setFilter(SetFilterEvent e) {
        Object riskids;
        super.setFilter(e);
        List qFilterList = e.getQFilters();
        IPageCache pageCache = this.getPageCache();
        RiskListService.setRunListLabelFilter(qFilterList, pageCache);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object orgId = customParams.get("orgid");
        RiskListService.replaceOrgFilter(qFilterList, orgId);
        RiskListService.replaceOrgFilter(qFilterList, orgId);
        String startDateStr = (String)customParams.get(START_DATE);
        String endDateStr = (String)customParams.get(END_DATE);
        Date startDate = DateUtils.stringToDate((String)startDateStr);
        Date endDate = DateUtils.stringToDate((String)endDateStr);
        Object val = customParams.remove("riskid");
        if (!ObjectUtils.isEmpty(val)) {
            qFilterList.add(new QFilter("risk.id", "=", (Object)Long.parseLong(String.valueOf(val))));
        }
        if (!ObjectUtils.isEmpty(riskids = customParams.remove("risklist"))) {
            List ids = (List)riskids;
            List idlist = ids.stream().filter(str -> !str.isEmpty()).map(s -> Long.parseLong(s)).collect(Collectors.toList());
            qFilterList.add(new QFilter("id", "in", idlist));
        }
        if (startDate != null) {
            qFilterList.add(new QFilter(START_DATE, ">=", (Object)startDate));
        }
        if (endDate != null) {
            qFilterList.add(new QFilter(END_DATE, "<=", (Object)endDate));
        }
        for (QFilter qFilter : qFilterList) {
            if (!qFilter.getProperty().equalsIgnoreCase("risk.taxtype2.id")) continue;
            qFilter.__setProperty("risk.taxtypemul.fbasedataid");
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String type = (String)customParams.get("querytype");
        if (TYPE_SELECT.equals(type)) {
            List list = args.getListColumns();
            for (IListColumn column : list) {
                AbstractListColumn listColumn = (AbstractListColumn)column;
                if (!HANDLE_STATUS.equals(listColumn.getListFieldKey()) && !"dealresult".equals(listColumn.getListFieldKey())) continue;
                listColumn.setVisible(0);
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        HyperLinkClickEvent hyperEvt = args.getHyperLinkClickEvent();
        BillList list = (BillList)hyperEvt.getSource();
        ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
        FormShowParameter param = new FormShowParameter();
        HashMap<String, Object> customParams = new HashMap<String, Object>(4);
        Object primaryKeyValue = currentSelectedRowInfo.getPrimaryKeyValue();
        QFilter filter = new QFilter("id", "=", primaryKeyValue);
        DynamicObject result = QueryServiceHelper.queryOne((String)ENTITY_RUN_RESULT, (String)"risk.risktype,risk.id,runorg.id,risk.name", (QFilter[])new QFilter[]{filter});
        if (result == null) {
            return;
        }
        String risktype = result.getString("risk.risktype");
        if ("1".equals(risktype)) {
            param.setFormId("tctrc_risk_result_number");
        } else if ("2".equals(risktype)) {
            param.setFormId("tctrc_risk_result_sample");
        } else {
            param.setFormId("tctrc_risk_result_verify");
        }
        customParams.put("resultid", (Long)primaryKeyValue);
        Long numberId = result.getLong("risk.id");
        String orgid = result.getString("runorg.id");
        String riskname = result.getString("risk.name");
        String userId = RequestContext.get().getUserId();
        customParams.put("user", String.valueOf(userId));
        customParams.put("number", numberId);
        customParams.put("datasource", "0");
        customParams.put("orgid", orgid);
        customParams.put("riskname", riskname);
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(param);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            BillList billlistap = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billlistap.getSelectedRows();
            if (selectedRows.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"RiskRunResultListPlugin_4", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
                return;
            }
            if ("donothingundo".equals(args.getOperateKey())) {
                this.undo();
            } else if ("donothingguide".equals(args.getOperateKey())) {
                this.handle((Long)selectedRows.get(0).getPrimaryKeyValue());
            } else if ("donothinghistory".equals(args.getOperateKey()) || "donothingnormal".equals(args.getOperateKey()) || "donothingrisk".equals(args.getOperateKey()) || "donothingtransmit".equals(args.getOperateKey())) {
                String typeKey = args.getOperateKey().substring(9);
                RiskHandlerEnum riskHandlerEnum = RiskHandlerEnum.getEnumByCode((String)typeKey);
                this.openHandler(riskHandlerEnum);
            }
        }
    }

    private void handle(long resultId) {
        DynamicObject riskResultObject = RiskResultBusiness.queryDataById((Long)resultId, (String)"risk.id,risk.risktype,risk.bmvalue,risk.resultshow,result,json,status");
        if (DealStatusEnum.DONE.getCode().equalsIgnoreCase(riskResultObject.getString(HANDLE_STATUS))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u5df2\u5904\u7406\u201d\u72b6\u6001\u7684\u98ce\u9669\u7ed3\u679c\u4e0d\u80fd\u518d\u5f55\u5165\u5904\u7406\u6307\u5f15\u3002", (String)"RiskRunResultListPlugin_6", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        }
        HashMap<String, Object> customMap = new HashMap<String, Object>(5);
        customMap.put("resultid", resultId);
        customMap.put("riskId", riskResultObject.get("risk.id"));
        customMap.put("riskType", riskResultObject.get("risk.risktype"));
        String riskType = riskResultObject.getString("risk.risktype");
        if (RiskTypeEnum.NUMBER.getKey().equals(riskType)) {
            BigDecimal riskResult;
            customMap.put("riskResult", riskResultObject.getString("result"));
            BigDecimal bmValue = riskResultObject.getBigDecimal("risk.bmvalue");
            String resultShow = riskResultObject.getString("risk.resultshow");
            if ("2".equals(resultShow)) {
                bmValue = BigDecimalUtil.divideObject((Object)bmValue, (Object)100, (int)2);
            }
            customMap.put("isHigherStandardValue", (riskResult = riskResultObject.getBigDecimal("result")).compareTo(bmValue) > 0 ? "1" : "0");
        } else {
            customMap.put("riskResult", riskResultObject.getString("json"));
        }
        PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"tctrc_risk_result_handle", (IFormView)this.getView(), customMap, (IFormPlugin)this);
    }

    public void itemClick(ItemClickEvent evt) {
    }

    private void undo() {
        BillList billlistap = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billlistap.getSelectedRows();
        Object[] ids = selectedRows.getPrimaryKeyValues();
        QFilter qFilter = new QFilter("id", "in", (Object)ids);
        DynamicObject[] collection = BusinessDataServiceHelper.load((String)ENTITY_RUN_RESULT, (String)"id,risk,status,transmit", (QFilter[])new QFilter[]{qFilter});
        if (null == collection || collection.length == 0) {
            return;
        }
        for (DynamicObject dynamicObject : collection) {
            RiskDealUtil.undoCheck((DynamicObject)dynamicObject);
            dynamicObject.set(HANDLE_STATUS, (Object)DealStatusEnum.TO_DO.getCode());
        }
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(UN_DO_CALL_BACK, (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u201c\u53d6\u6d88\u5904\u7406\u201d\u540e\u7684\u98ce\u9669\u6570\u636e\u53ef\u4ee5\u91cd\u65b0\u5f55\u5165\u5904\u7406\u6307\u5f15\u4e5f\u53ef\u4ee5\u91cd\u65b0\u8ba1\u7b97\uff0c\u786e\u5b9a\u7ee7\u7eed\u53d6\u6d88\u5417\uff1f", (String)"RiskRunResultListPlugin_3", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBacks);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if (UN_DO_CALL_BACK.equals(event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes) {
            BillList billlistap = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billlistap.getSelectedRows();
            Object[] ids = selectedRows.getPrimaryKeyValues();
            QFilter qFilter = new QFilter("id", "in", (Object)ids);
            DynamicObject[] collection = BusinessDataServiceHelper.load((String)ENTITY_RUN_RESULT, (String)"id,risk,status,transmit", (QFilter[])new QFilter[]{qFilter});
            if (null == collection || collection.length == 0) {
                return;
            }
            for (DynamicObject dynamicObject : collection) {
                dynamicObject.set(HANDLE_STATUS, (Object)DealStatusEnum.TO_DO.getCode());
            }
            SaveServiceHelper.save((DynamicObject[])collection);
            AbstractResultPlugin.cancelundo(ids);
            this.getView().invokeOperation("refresh");
            this.getView().sendFormAction(this.getView());
        }
    }

    private void openHandler(RiskHandlerEnum riskHandlerEnum) {
        BillList billlistap = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billlistap.getSelectedRows();
        HashMap<String, Object> customMap = new HashMap<String, Object>();
        Object result = selectedRows.get(0).getPrimaryKeyValue();
        customMap.put("resultid", result);
        long resultId = (Long)result;
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)resultId, (String)ENTITY_RUN_RESULT);
        RiskDealUtil.checkRecord((DynamicObject)dynamicObject, (RiskHandlerEnum)riskHandlerEnum);
        DynamicObject risk = dynamicObject.getDynamicObject("risk");
        if (null != risk) {
            String riskType = risk.getString("risktype");
            if ("1".equals(riskType)) {
                BigDecimal bmValue = risk.getBigDecimal("bmvalue");
                String resultshow = dynamicObject.getDynamicObject("risk").getString("resultshow");
                if ("2".equals(resultshow)) {
                    bmValue = BigDecimalUtil.divideObject((Object)bmValue, (Object)100, (int)2);
                }
                BigDecimal riskResult = dynamicObject.getBigDecimal("result");
                this.numResult = riskResult.compareTo(bmValue);
                customMap.put("numriskresulttype", String.valueOf(this.numResult));
                customMap.put("json", "null".equals(dynamicObject.getString("result")) ? ResManager.loadKDString((String)"\u65e0\u6570\u636e", (String)"RiskRunResultListPlugin_5", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]) : dynamicObject.getString("result"));
            } else {
                customMap.put("json", dynamicObject.getString("json"));
            }
            customMap.put("runorg", dynamicObject.getLong("runorg.id"));
        }
        PageShowCommon.showForm((ShowType)ShowType.Modal, (String)riskHandlerEnum.getFormId(), (IFormView)this.getView(), customMap, (IFormPlugin)this);
    }

    public void packageData(PackageDataEvent event) {
        Object source = event.getSource();
        DynamicObject rowData = event.getRowData();
        if (source instanceof DynamicTextColumnDesc && ((DynamicTextColumnDesc)source).getKey().equals("label")) {
            DynamicObject risk = rowData.getDynamicObject("risk");
            if (ObjectUtils.isEmpty((Object)risk)) {
                return;
            }
            DynamicObjectCollection labelentity = risk.getDynamicObjectCollection("labelentity");
            ArrayList<String> list = new ArrayList<String>();
            for (DynamicObject label : labelentity) {
                if (label == null || label.getDynamicObject("labelid") == null) continue;
                String name = label.getDynamicObject("labelid").getString("name");
                list.add(name);
            }
            event.setFormatValue((Object)String.join((CharSequence)",", list));
        } else if (source instanceof ColumnDesc && ((ColumnDesc)source).getKey().equals("risk.caltype")) {
            String calType = TimeDeviatedEnum.TIME_DEVIATION_MONTH.getDeviatedType();
            String month = " ";
            String day = " ";
            DynamicObject riskDynamicObject = rowData.getDynamicObject("risk");
            if (riskDynamicObject != null) {
                month = riskDynamicObject.getString("month");
                day = riskDynamicObject.getString("day");
                calType = riskDynamicObject.getString("caltype");
            }
            RiskListService.setRiskListCalType(event, calType, month, day);
        }
        if (!RiskTypeEnum.NUMBER.getKey().equals(rowData.getString("risk.risktype"))) {
            rowData.set("result", (Object)"-");
        } else if ("null".equals(rowData.getString("result"))) {
            rowData.set("result", (Object)ResManager.loadKDString((String)"\u65e0\u6570\u636e", (String)"RiskRunResultListPlugin_5", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        } else if (NumberUtils.isNumber((String)rowData.getString("result"))) {
            BigDecimal result = rowData.getBigDecimal("result");
            rowData.set("result", (Object)this.format.format(result));
        }
    }
}

