/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.orm.query.QFilter;
import kd.taxc.tctrc.common.element.TimeDeviatedEnum;
import kd.taxc.tctrc.common.util.BaseDataUtil;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class RiskListService {
    private static final String RUN_ORG = "runorg";

    public static void setRiskListCalType(PackageDataEvent event, String calType, String month, String day) {
        if (TimeDeviatedEnum.TIME_DEVIATION_MONTH.getDeviatedType().equals(calType) && StringUtils.isNotEmpty((CharSequence)day)) {
            event.setFormatValue((Object)String.format(ResManager.loadKDString((String)"\u6708\u5ea6%s\u53f7", (String)"RiskListService_0", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), day));
        } else if (TimeDeviatedEnum.TIME_DEVIATION_SEASON.getDeviatedType().equals(calType) && StringUtils.isNotEmpty((CharSequence)day) && StringUtils.isNotEmpty((CharSequence)month)) {
            event.setFormatValue((Object)String.format(ResManager.loadKDString((String)"\u5b63\u5ea6\u7b2c%1$s\u4e2a\u6708%2$s\u53f7", (String)"RiskListService_2", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), month, day));
        } else if (TimeDeviatedEnum.TIME_DEVIATION_YEAR.getDeviatedType().equals(calType) && StringUtils.isNotEmpty((CharSequence)day) && StringUtils.isNotEmpty((CharSequence)month)) {
            event.setFormatValue((Object)String.format(ResManager.loadKDString((String)"\u5e74\u5ea6\u7b2c%1$s\u4e2a\u6708%2$s\u53f7", (String)"RiskListService_4", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), month, day));
        } else if (TimeDeviatedEnum.TIME_DEVIATION_HALF_YEAR.getDeviatedType().equals(calType) && StringUtils.isNotEmpty((CharSequence)day) && StringUtils.isNotEmpty((CharSequence)month)) {
            event.setFormatValue((Object)String.format(ResManager.loadKDString((String)"\u534a\u5e74\u5ea6\u7b2c%1$s\u4e2a\u6708%2$s\u53f7", (String)"RiskListService_5", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), month, day));
        }
    }

    public static void setCommonFilterColumn(FilterContainerInitArgs args, IPageCache pageCache, IFormView view) {
        List labelIdList;
        CommonFilterColumn commonFilterColumn = new CommonFilterColumn("risk.labelid.number");
        args.addFilterColumn((FilterColumn)commonFilterColumn);
        commonFilterColumn.setMulti(true);
        commonFilterColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6807\u7b7e", (String)"RiskListService_6", (String)"taxc-tctrc-formplugin", (Object[])new Object[0])));
        String labelId = pageCache.get("labelId");
        if (StringUtils.isNotEmpty((CharSequence)labelId) && CollectionUtils.isNotEmpty((Collection)(labelIdList = SerializationUtils.fromJsonStringToList((String)labelId, String.class))) && !"".equals(labelIdList.get(0))) {
            commonFilterColumn.setDefaultValues(labelIdList.toArray());
        }
        List commonFilters = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilters) {
            String fieldName = filterColumn.getFieldName();
            if (!fieldName.startsWith("runorg.")) continue;
            filterColumn.setDefaultValue(BaseDataUtil.getDefaultOrg((IFormView)view));
        }
        commonFilterColumn.setEntityField(false);
    }

    public static void setRiskPageCache(FilterContainerSearchClickArgs args, IPageCache pageCache) {
        if (null != args.getCurrentCommonFilter()) {
            List list = (List)args.getCurrentCommonFilter().get("FieldName");
            if ("risk.labelid.number".equals(list.get(0))) {
                List labelId = (List)args.getCurrentCommonFilter().get("Value");
                pageCache.put("labelId", SerializationUtils.toJsonString((Object)labelId));
            }
            if ("risk.risktype".equals(list.get(0))) {
                List risktype = (List)args.getCurrentCommonFilter().get("Value");
                pageCache.put("risktype", SerializationUtils.toJsonString((Object)risktype));
            }
        }
    }

    public static void setRunListLabelFilter(List<QFilter> qFilters, IPageCache pageCache) {
        List labelIdList;
        String labelId = pageCache.get("labelId");
        if (StringUtils.isNotEmpty((CharSequence)labelId) && null != (labelIdList = SerializationUtils.fromJsonStringToList((String)labelId, String.class)) && labelIdList.size() > 0 && !"".equals(labelIdList.get(0))) {
            List riskTypeList = null;
            riskTypeList = null != pageCache.get("risktype") ? SerializationUtils.fromJsonStringToList((String)pageCache.get("risktype"), String.class) : new ArrayList();
            if (riskTypeList.isEmpty() || "".equals(riskTypeList.get(0))) {
                riskTypeList.add("1");
                riskTypeList.add("2");
                riskTypeList.add("3");
                qFilters.add(new QFilter("risk.risktype", "in", riskTypeList));
            }
            qFilters.add(new QFilter("risk.labelentity.labelid", "in", labelIdList.stream().map(v -> Long.parseLong(v)).collect(Collectors.toList())));
        }
    }

    public static void replaceOrgFilter(List<QFilter> qFilterList, Object orgId) {
        if (orgId != null) {
            qFilterList.removeIf(qFilter -> RUN_ORG.equals(qFilter.getProperty()));
            if (orgId instanceof List) {
                qFilterList.add(new QFilter(RUN_ORG, "=", orgId));
            } else if (!(orgId instanceof String) || !"all".equals(orgId)) {
                qFilterList.add(new QFilter(RUN_ORG, "=", (Object)Long.parseLong(String.valueOf(orgId))));
            }
        }
    }

    public static void setRiskCalulationDeviation(PackageDataEvent event, String calType, String deviatedcount) {
        if (EmptyCheckUtils.isEmpty((Object)deviatedcount)) {
            return;
        }
        if (EmptyCheckUtils.isEmpty((Object)calType)) {
            return;
        }
        if ("0".equalsIgnoreCase(deviatedcount)) {
            event.setFormatValue((Object)ResManager.loadKDString((String)"\u672c\u671f", (String)"RiskListService_7", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        } else if (TimeDeviatedEnum.checkIsYearOnYear((String)calType, (Integer)Integer.parseInt(deviatedcount))) {
            event.setFormatValue((Object)ResManager.loadKDString((String)"\u4e0a\u5e74\u540c\u671f", (String)"RiskListService_8", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        } else {
            String format = ResManager.loadKDString((String)"\u524d%1$s\u671f", (String)"RiskListService_9", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]);
            event.setFormatValue((Object)String.format(format, deviatedcount));
        }
    }
}

