/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class RiskScoreService {
    private static final String RISK_SCORE_SCHEME = "tctrc_risk_score_scheme";

    public static List<String> getScoresByLevelId(Long levelId) {
        ArrayList<String> scoreList = new ArrayList<String>();
        DynamicObject object = RiskScoreService.getSchemeObject(levelId);
        if (object != null) {
            BigDecimal scorestart = object.getBigDecimal("entryentity.scorestart");
            BigDecimal scoreend = object.getBigDecimal("entryentity.scoreend");
            BigDecimal defaultscore = object.getBigDecimal("entryentity.defaultscore");
            if (scorestart == null || scoreend == null) {
                scoreList.add(defaultscore.setScale(1, 4).toString());
                return scoreList;
            }
            BigDecimal scoreinterval = object.getBigDecimal("scoreinterval");
            BigDecimal score = scorestart;
            if (scoreinterval.compareTo(BigDecimal.ZERO) > 0) {
                while (score.compareTo(scoreend) <= 0) {
                    scoreList.add(score.setScale(1, 4).toString());
                    score = score.add(scoreinterval);
                }
            }
        }
        return scoreList;
    }

    public static String getDefaultScoreByLevelId(Long levelId) {
        DynamicObject object = RiskScoreService.getSchemeObject(levelId);
        if (object != null) {
            BigDecimal defaultscore = object.getBigDecimal("entryentity.defaultscore").setScale(1, 4);
            return defaultscore.toString();
        }
        return null;
    }

    public static DynamicObject getSchemeObject(Long levelId) {
        Date now = new Date();
        QFilter levelFilter = new QFilter("entryentity.risklevel", "=", (Object)levelId);
        QFilter dateFilter = new QFilter("effectdate", "<=", (Object)now).and(new QFilter("invaliddate", ">=", (Object)now));
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject object = QueryServiceHelper.queryOne((String)RISK_SCORE_SCHEME, (String)"id,scoreinterval,entryentity.risklevel,entryentity.scorestart,entryentity.scoreend,entryentity.defaultscore", (QFilter[])new QFilter[]{levelFilter, dateFilter, enableFilter});
        return object;
    }
}

