/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.upgrade;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.id.Base39Coder;
import kd.bos.id.IDService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tctrc.common.util.JsonUtil;
import kd.taxc.tctrc.common.util.MetadataUtil;

public class InvoiceTypeUpgradeService
implements IUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(InvoiceTypeUpgradeService.class);
    private static Map<String, String> map = new HashMap<String, String>();
    private static String[] ENTITY_NAME = new String[]{"tdm_invoice_input", "tdm_invoice_output"};

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        StringBuilder message = new StringBuilder(ResManager.loadKDString((String)"\u66f4\u65b0TCTRC\u53d1\u7968\u7c7b\u578b\u8fc7\u7a0b", (String)"InvoiceTypeUpgradeService_2", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        InvoiceTypeUpgradeService.update();
        result.setLog(ResManager.loadKDString((String)message.toString(), (String)"InvoiceTypeUpgradeService_0", (String)"InvoiceTypeUpgradeService_1", (Object[])new Object[0]));
        return result;
    }

    private static void update() {
        try {
            List<String> entries = Arrays.asList(ENTITY_NAME);
            Boolean isExist = InvoiceTypeUpgradeService.MetaIsExist("bd_invoicetype");
            if (!isExist.booleanValue()) {
                return;
            }
            DynamicObject[] invoicetypes = BusinessDataServiceHelper.load((String)"bd_invoicetype", (String)"id,number,name", null);
            Map<String, String> invoiceTypeMap = Arrays.stream(invoicetypes).collect(Collectors.toMap(o -> o.getString("number"), o -> o.getString("id")));
            String selectCustomFields = null;
            isExist = InvoiceTypeUpgradeService.MetaIsExist("tctb_custom_datasource");
            if (!isExist.booleanValue()) {
                return;
            }
            String allFields = MetadataUtil.getAllFieldString((String)"tctb_custom_datasource");
            selectCustomFields = allFields.contains("formentity") ? "id,formentity" : "id,entityname";
            String[] keyFields = selectCustomFields.split(",");
            DynamicObject[] datasourceConfigs = BusinessDataServiceHelper.load((String)"tctb_custom_datasource", (String)selectCustomFields, null);
            Map<String, String> datasourceConfigMap = Arrays.stream(datasourceConfigs).collect(Collectors.toMap(o -> o.getString(keyFields[0]), o -> o.getString(keyFields[1])));
            Map<String, String> invoiceTypeNameMap = Arrays.stream(invoicetypes).collect(Collectors.toMap(o -> o.getString("number"), o -> o.getString("name")));
            for (Map.Entry<String, String> entry : map.entrySet()) {
                DynamicObject[] dynamicObjects;
                String selectFields = StringUtils.isNotBlank((CharSequence)entry.getValue()) ? "id," + entry.getValue() + ".json_tag" : "id,json_tag,text";
                isExist = InvoiceTypeUpgradeService.MetaIsExist(entry.getKey());
                if (!isExist.booleanValue() || (dynamicObjects = BusinessDataServiceHelper.load((String)entry.getKey(), (String)selectFields, null)) == null || dynamicObjects.length <= 0) continue;
                Arrays.stream(dynamicObjects).forEach(o -> {
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue()))) {
                        DynamicObjectCollection dynamicObjectCollection = o.getDynamicObjectCollection("entryentity");
                        if (dynamicObjectCollection != null && dynamicObjectCollection.size() > 0) {
                            InvoiceTypeUpgradeService.dealData(entries, invoiceTypeMap, datasourceConfigMap, invoiceTypeNameMap, dynamicObjectCollection);
                        }
                    } else {
                        InvoiceTypeUpgradeService.dealJson(entries, invoiceTypeMap, datasourceConfigMap, invoiceTypeNameMap, o, true);
                    }
                });
                SaveServiceHelper.update((DynamicObject[])dynamicObjects);
            }
        }
        catch (Exception e) {
            LOGGER.error("update", (Throwable)e);
            return;
        }
    }

    private static void dealData(List<String> entries, Map<String, String> invoiceTypeMap, Map<String, String> datasourceConfigMap, Map<String, String> invoiceTypeNameMap, DynamicObjectCollection dynamicObjectCollection) {
        try {
            dynamicObjectCollection.stream().forEach(e -> InvoiceTypeUpgradeService.dealJson(entries, invoiceTypeMap, datasourceConfigMap, invoiceTypeNameMap, e, false));
        }
        catch (Exception e2) {
            LOGGER.error("dealData error", (Throwable)e2);
            return;
        }
    }

    private static void dealJson(List<String> entries, Map<String, String> invoiceTypeMap, Map<String, String> datasourceConfigMap, Map<String, String> invoiceTypeNameMap, DynamicObject dynamicObject, boolean needDealText) {
        try {
            String json = dynamicObject.getString("json_tag");
            ArrayList<String> types = new ArrayList<String>();
            if (StringUtils.isNotEmpty((CharSequence)json)) {
                AtomicReference<Boolean> needUpdate = new AtomicReference<Boolean>(Boolean.FALSE);
                Object obj = JSON.parse((String)json);
                if (obj instanceof JSONObject) {
                    Map jsonMap2 = (Map)SerializationUtils.fromJsonString((String)json, Map.class);
                    InvoiceTypeUpgradeService.dealDetailData(entries, invoiceTypeMap, datasourceConfigMap, invoiceTypeNameMap, dynamicObject, needDealText, types, needUpdate, jsonMap2);
                    if (needUpdate.get().booleanValue()) {
                        json = JsonUtil.toJson((Object)jsonMap2);
                        dynamicObject.set("json_tag", (Object)json);
                    }
                } else if (obj instanceof JSONArray) {
                    List jsons = (List)JSONArray.parse((String)json);
                    jsons.stream().forEach(jsonMap -> InvoiceTypeUpgradeService.dealDetailData(entries, invoiceTypeMap, datasourceConfigMap, invoiceTypeNameMap, dynamicObject, needDealText, types, needUpdate, jsonMap));
                    if (needUpdate.get().booleanValue()) {
                        json = JsonUtil.toJson((Object)jsons);
                        dynamicObject.set("json_tag", (Object)json);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("dealJson error", (Throwable)e);
            return;
        }
    }

    private static void dealDetailData(List<String> entries, Map<String, String> invoiceTypeMap, Map<String, String> datasourceConfigMap, Map<String, String> invoiceTypeNameMap, DynamicObject dynamicObject, boolean needDealText, List<String> types, AtomicReference<Boolean> needUpdate, Map<String, String> jsonMap) {
        String tableId = jsonMap.get("tableid");
        String tableIdval = datasourceConfigMap.get(tableId);
        if (null != tableIdval && entries.contains(tableIdval)) {
            needUpdate.set(Boolean.TRUE);
            String conditionJson = jsonMap.get("filterJson");
            HashMap conditionMap = (HashMap)JsonUtil.fromJson((String)conditionJson, Map.class);
            List simpleFilterRows = (List)conditionMap.get("FilterRow");
            simpleFilterRows.forEach(s -> {
                s.put("FieldName", "baseinvoicetype.number");
                ArrayList baseDataIds = new ArrayList();
                List values = (List)s.get("Value");
                values.stream().forEach(v -> {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("Id", Base39Coder.toString((long)IDService.get().genLongId()));
                    map.put("Value", (String)invoiceTypeMap.get(v.get("Value")));
                    types.add((String)invoiceTypeNameMap.get(v.get("Value")));
                    baseDataIds.add(map);
                });
                s.put("BaseDataIds", baseDataIds);
            });
            conditionMap.put("FilterRow", simpleFilterRows);
            jsonMap.put("filterJson", JsonUtil.toJson((Object)conditionMap));
            if (needDealText) {
                Object[] text = dynamicObject.getString("text").split(" ");
                text[0] = ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b\u540d\u79f0", (String)"InvoiceTypeUpgradeService_3", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]);
                text[2] = String.join((CharSequence)";", types);
                dynamicObject.set("text", (Object)StringUtils.join((Object[])text, (String)" "));
            }
        }
    }

    private static Boolean MetaIsExist(String entityName) {
        try {
            MetadataUtil.getEntityById((String)entityName);
            return Boolean.TRUE;
        }
        catch (Exception e) {
            return Boolean.FALSE;
        }
    }

    static {
        map.put("tctrc_element_verify", "entryentity");
        map.put("tctrc_risk_sampling", "entryentity");
        map.put("tctrc_result_records", "");
    }
}

