/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.upgrade;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.tctrc.common.enums.TaxTypeEnum;
import kd.taxc.tctrc.common.util.ComboUpgradeBaseEditUtil;
import kd.taxc.tctrc.common.util.DBUtils;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;

public class TaxTypeUpgradeService
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        StringBuilder message = new StringBuilder(ResManager.loadKDString((String)"==============\u5347\u7ea7TCTRC\u7a0e\u79cd\u8fc7\u7a0b======", (String)"TaxTypeUpgradeService_0", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        String oldField = "FTAXTYPE";
        this.doUpgrade(message, oldField);
        result.setLog(message.toString());
        return result;
    }

    private void doUpgrade(StringBuilder message, String oldField) {
        ComboUpgradeBaseEditUtil.upgrade(this::getHistoryDataSupplier, v -> EmptyCheckUtils.isEmpty(v.get(oldField)) ? null : String.valueOf(v.get(oldField)), TaxTypeUpgradeService::clearNewConsumer, TaxTypeUpgradeService::clearOldConsumer, TaxTypeUpgradeService::setNewValConsumer, (Object)message);
    }

    private List<Map<String, Object>> getHistoryDataSupplier() {
        return DBUtils.query((String)"select FID,FTAXTYPE  FROM  t_tctrc_risk_definition");
    }

    private static void clearOldConsumer(Map<String, Object> oldBeanMap) {
        DBUtils.execute((String)("update t_tctrc_risk_definition set ftaxtype = '  '  where fid = " + oldBeanMap.get("FID")));
    }

    private static void setNewValConsumer(Map<String, Object> pkDataMap, List<String> oldDatas, Object obj) {
        Long fid = Long.parseLong(String.valueOf(pkDataMap.get("FID")));
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
        for (String oldData : oldDatas) {
            TaxTypeEnum taxTypeEnum = TaxTypeEnum.getTaxByType((String)oldData);
            if (null == taxTypeEnum) continue;
            Long pkid = DBUtils.getLongId((String)"t_tctb_datasource_pkrules");
            paramList.add(new Object[]{fid, pkid, Long.parseLong(taxTypeEnum.getBaseTaxType())});
        }
        if (EmptyCheckUtils.isNotEmpty(paramList)) {
            DBUtils.executeBatch((String)" insert into t_tctrc_taxtypemul (FID,FPKID,FBASEDATAID) values (?,?,?) ", paramList);
        }
    }

    private static void clearNewConsumer(Map<String, Object> oldBeanMap) {
        DBUtils.execute((String)("delete from  t_tctrc_taxtypemul where fid = " + oldBeanMap.get("FID")));
    }
}

