/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.upgrade;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.tctrc.common.util.DBUtils;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;

public class TctrcRiskSharingUpgradeService
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        StringBuilder message = new StringBuilder(ResManager.loadKDString((String)"==============\u5347\u7ea7TCTRC\u65b9\u6848\u5206\u914d\u8fc7\u7a0b======", (String)"TctrcRiskSharingUpgradeService_0", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        TctrcRiskSharingUpgradeService.doUpgrade();
        result.setLog(message.toString());
        return result;
    }

    public static void doUpgrade() {
        DynamicObject[] olds = BusinessDataServiceHelper.load((String)"tctrc_risk_assign", (String)"id,planentity,orgentity,orgentity.orgid", null);
        if (EmptyCheckUtils.isEmpty((Object)olds)) {
            return;
        }
        ArrayList<Object[]> subInfoParamList = new ArrayList<Object[]>(10);
        ArrayList<Object[]> orgInfoParamList = new ArrayList<Object[]>(10);
        for (DynamicObject old : olds) {
            DynamicObjectCollection oldplans = old.getDynamicObjectCollection("planentity");
            for (DynamicObject oldplan : oldplans) {
                DynamicObjectCollection oldOrgEntitys = oldplan.getDynamicObjectCollection("orgentity");
                if (null == oldOrgEntitys || oldOrgEntitys.size() == 0) continue;
                Long entryid = oldplan.getLong("id");
                Long detailid = DBUtils.getLongId((String)"t_tctrc_sharingplan_sub");
                subInfoParamList.add(new Object[]{entryid, detailid, 1});
                for (DynamicObject oldOrgEntity : oldOrgEntitys) {
                    Long suborgPkid = DBUtils.getLongId((String)"t_tctrc_sharingplan_sub_o");
                    orgInfoParamList.add(new Object[]{suborgPkid, detailid, oldOrgEntity.getDynamicObject("orgid").get("id")});
                }
            }
        }
        if (EmptyCheckUtils.isNotEmpty(subInfoParamList)) {
            DBUtils.executeBatch((String)" insert into t_tctrc_sharingplan_sub ( FENTRYID, FDETAILID, FSEQ) values (?,?,?) ", subInfoParamList);
            if (EmptyCheckUtils.isNotEmpty(orgInfoParamList)) {
                DBUtils.executeBatch((String)" insert into t_tctrc_sharingplan_sub_o (FPKID, FDETAILID, FBASEDATAID) values (?,?,?) ", orgInfoParamList);
            }
            DBUtils.execute((String)" DELETE FROM  t_tctrc_sharingplan_orgs   ");
        }
    }
}

