/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.common.cal.eval;

import java.math.BigDecimal;
import kd.taxc.tctrc.common.cal.eval.Constant;
import kd.taxc.tctrc.common.cal.eval.Expression;

public class BinaryOperation
implements Expression {
    private final Op op;
    private Expression left;
    private Expression right;
    private boolean sealed = false;
    public static final double EPSILON = 1.0E-10;

    public BinaryOperation(Op op, Expression left, Expression right) {
        this.op = op;
        this.left = left;
        this.right = right;
    }

    public Op getOp() {
        return this.op;
    }

    public Expression getLeft() {
        return this.left;
    }

    public void setLeft(Expression left) {
        this.left = left;
    }

    public Expression getRight() {
        return this.right;
    }

    public void seal() {
        this.sealed = true;
    }

    public boolean isSealed() {
        return this.sealed;
    }

    @Override
    public double evaluate() {
        double a = this.left.evaluate();
        double b = this.right.evaluate();
        switch (this.op) {
            case ADD: {
                return BigDecimal.valueOf(a).add(BigDecimal.valueOf(b)).doubleValue();
            }
            case SUBTRACT: {
                return BigDecimal.valueOf(a).subtract(BigDecimal.valueOf(b)).doubleValue();
            }
            case MULTIPLY: {
                return BigDecimal.valueOf(a).multiply(BigDecimal.valueOf(b)).doubleValue();
            }
            case DIVIDE: {
                return BigDecimal.valueOf(a).divide(BigDecimal.valueOf(b), 10, 4).doubleValue();
            }
            case POWER: {
                return Math.pow(a, b);
            }
            case MODULO: {
                return a % b;
            }
            case LT: {
                return a < b ? 1.0 : 0.0;
            }
            case LT_EQ: {
                return a < b || Math.abs(a - b) < 1.0E-10 ? 1.0 : 0.0;
            }
            case GT: {
                return a > b ? 1.0 : 0.0;
            }
            case GT_EQ: {
                return a > b || Math.abs(a - b) < 1.0E-10 ? 1.0 : 0.0;
            }
            case EQ: {
                return Math.abs(a - b) < 1.0E-10 ? 1.0 : 0.0;
            }
            case NEQ: {
                return Math.abs(a - b) > 1.0E-10 ? 1.0 : 0.0;
            }
            case AND: {
                return Math.abs(a) > 0.0 && Math.abs(b) > 0.0 ? 1.0 : 0.0;
            }
            case OR: {
                return Math.abs(a) > 0.0 || Math.abs(b) > 0.0 ? 1.0 : 0.0;
            }
        }
        throw new UnsupportedOperationException(String.valueOf((Object)this.op));
    }

    @Override
    public Expression simplify() {
        this.left = this.left.simplify();
        this.right = this.right.simplify();
        if (this.left.isConstant() && this.right.isConstant()) {
            return new Constant(this.evaluate());
        }
        if (this.op == Op.ADD || this.op == Op.MULTIPLY) {
            Expression childOp;
            if (this.right.isConstant()) {
                Expression tmp = this.right;
                this.right = this.left;
                this.left = tmp;
            }
            if (this.right instanceof BinaryOperation && (childOp = this.trySimplifyRightSide()) != null) {
                return childOp;
            }
        }
        return Expression.super.simplify();
    }

    private Expression trySimplifyRightSide() {
        BinaryOperation childOp = (BinaryOperation)this.right;
        if (this.op != childOp.op) {
            return null;
        }
        if (this.left.isConstant() && childOp.left.isConstant()) {
            if (this.op == Op.ADD) {
                return new BinaryOperation(this.op, new Constant(this.left.evaluate() + childOp.left.evaluate()), childOp.right);
            }
            if (this.op == Op.MULTIPLY) {
                return new BinaryOperation(this.op, new Constant(this.left.evaluate() * childOp.left.evaluate()), childOp.right);
            }
        }
        if (childOp.left.isConstant()) {
            return new BinaryOperation(this.op, childOp.left, new BinaryOperation(this.op, this.left, childOp.right));
        }
        return null;
    }

    public String toString() {
        return "(" + this.left + " " + (Object)((Object)this.op) + " " + this.right + ")";
    }

    public static enum Op {
        ADD(3),
        SUBTRACT(3),
        MULTIPLY(4),
        DIVIDE(4),
        MODULO(4),
        POWER(5),
        LT(2),
        LT_EQ(2),
        EQ(2),
        GT_EQ(2),
        GT(2),
        NEQ(2),
        AND(1),
        OR(1);

        private final int priority;

        private Op(int priority) {
            this.priority = priority;
        }

        public int getPriority() {
            return this.priority;
        }
    }
}

