/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.common.cal.eval;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import kd.taxc.tctrc.common.cal.eval.Variable;

public class Scope {
    private Scope parent;
    private boolean autocreateVariables = true;
    private Map<String, Variable> context = new ConcurrentHashMap<String, Variable>();
    private static Scope root = new Scope(true);

    public Scope() {
        this(false);
    }

    private Scope(boolean skipParent) {
        if (!skipParent) {
            this.parent = Scope.getRootScope();
        }
    }

    private static Scope getRootScope() {
        return root;
    }

    public Scope withStrictLookup(boolean strictLookup) {
        this.autocreateVariables = !strictLookup;
        return this;
    }

    public Scope withParent(Scope parent) {
        this.parent = parent == null ? Scope.getRootScope() : parent;
        return this;
    }

    private Variable find(String name) {
        Variable variable = this.context.get(name);
        if (null != variable) {
            return variable;
        }
        if (this.parent != null) {
            return this.parent.find(name);
        }
        return null;
    }

    public Variable getVariable(String name) {
        Variable result = this.find(name);
        if (result != null) {
            return result;
        }
        if (!this.autocreateVariables) {
            throw new IllegalArgumentException();
        }
        return this.create(name);
    }

    public Variable create(String name) {
        Variable variable = this.context.get(name);
        if (null != variable) {
            return variable;
        }
        Variable result = new Variable(name);
        this.context.put(name, result);
        return result;
    }

    public Variable remove(String name) {
        if (this.context.containsKey(name)) {
            return this.context.remove(name);
        }
        return null;
    }

    public Set<String> getLocalNames() {
        return this.context.keySet();
    }

    public Set<String> getNames() {
        if (this.parent == null) {
            return this.getLocalNames();
        }
        TreeSet<String> result = new TreeSet<String>();
        result.addAll(this.parent.getNames());
        result.addAll(this.getLocalNames());
        return result;
    }

    public Collection<Variable> getLocalVariables() {
        return this.context.values();
    }

    public Collection<Variable> getVariables() {
        if (this.parent == null) {
            return this.getLocalVariables();
        }
        ArrayList<Variable> result = new ArrayList<Variable>();
        result.addAll(this.parent.getVariables());
        result.addAll(this.getLocalVariables());
        return result;
    }
}

