/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.common.cal.eval.tokenizer;

import kd.taxc.tctrc.common.cal.eval.tokenizer.Position;

public class ParseError {
    private Position pos;
    private String message;
    private final Severity severity;

    protected ParseError(Position pos, String message, Severity severity) {
        this.pos = pos;
        this.message = message;
        this.severity = severity;
    }

    public static ParseError warning(Position pos, String msg) {
        String message = msg;
        if (pos.getLine() > 0) {
            message = String.format("%3d:%2d: %s", pos.getLine(), pos.getPos(), msg);
        }
        return new ParseError(pos, message, Severity.WARNING);
    }

    public static ParseError error(Position pos, String msg) {
        String message = msg;
        if (pos.getLine() > 0) {
            message = String.format("%3d:%2d: %s", pos.getLine(), pos.getPos(), msg);
        }
        return new ParseError(pos, message, Severity.ERROR);
    }

    public Position getPosition() {
        return this.pos;
    }

    public String getMessage() {
        return this.message;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String toString() {
        return String.format("%s %s", new Object[]{this.severity, this.message});
    }

    public static enum Severity {
        WARNING,
        ERROR;

    }
}

