/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.common.element;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tctrc.common.cal.CalculateService;
import kd.taxc.tctrc.common.element.RiskCalSerivce;
import kd.taxc.tctrc.common.element.TimeDeviatedEnum;
import kd.taxc.tctrc.common.element.factory.ElementSqlService;
import kd.taxc.tctrc.common.element.factory.ElementSqlServiceFactory;
import kd.taxc.tctrc.common.entity.ElementCalculateDo;
import kd.taxc.tctrc.common.entity.ElementCalculateResultDo;
import kd.taxc.tctrc.common.entity.ElementDependencyElementDo;
import kd.taxc.tctrc.common.entity.ElementFetchRuleParamDo;
import kd.taxc.tctrc.common.enums.BooleanEnum;
import kd.taxc.tctrc.common.task.ElementCalculateTask;
import kd.taxc.tctrc.common.task.ElementExpressionParseTask;
import kd.taxc.tctrc.common.threadpools.ThreadPoolsService;
import kd.taxc.tctrc.common.util.BigDecimalUtil;
import kd.taxc.tctrc.common.util.CalUtils;
import kd.taxc.tctrc.common.util.DateUtils;
import kd.taxc.tctrc.common.util.ElementUtil;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;

public class ElementCalculateService {
    private static final Log logger = LogFactory.getLog(ElementCalculateService.class);

    public void calculateElementResult(List<String> elementCodes, List<String> runOrgIdList, Date startDate, Date endDate) {
        Map<String, DynamicObject> elementCodeKeyMap = kd.taxc.tctrc.common.element.ElementSqlService.queryAllEnableEleInfoMap();
        ArrayList<DynamicObject> mayNotRecalculateElements = new ArrayList<DynamicObject>(16);
        HashSet<String> topElementCodes = new HashSet<String>(16);
        List<DynamicObject> nonBottomElements = elementCodeKeyMap.values().stream().filter(p -> !p.getBoolean("bottom")).collect(Collectors.toList());
        List<Object> recalculateElements = this.getRecalculateElement(elementCodes, elementCodeKeyMap, nonBottomElements, mayNotRecalculateElements, topElementCodes);
        Map<String, List<ElementDependencyElementDo>> elementDependencyElementMap = this.getElementDependencyElement(recalculateElements.stream().filter(p -> !p.getBoolean("bottom")).collect(Collectors.toList()), elementCodeKeyMap);
        logger.info("===========kd.taxc.tctrc.common.element.ElementCalculateService.calculateElementResult===\u83b7\u53d6\u5230\u5bf9\u5e94\u4f9d\u8d56\u9879\u4e3a:{}", (Object)SerializationUtils.toJsonString(elementDependencyElementMap));
        List<Long> elementIds = elementDependencyElementMap.values().stream().flatMap(p -> p.stream().map(t -> t.getElementId())).distinct().collect(Collectors.toList());
        elementIds.removeAll(recalculateElements.stream().map(p -> p.getLong("id")).collect(Collectors.toList()));
        List<Long> orgIdList = runOrgIdList.stream().map(p -> Long.parseLong(p)).collect(Collectors.toList());
        List<ElementCalculateResultDo> calculatedResults = this.getElementCalculateResult(elementIds, orgIdList, startDate, endDate);
        List<DynamicObject> bottomElements = recalculateElements.stream().filter(p -> p.getBoolean("bottom")).collect(Collectors.toList());
        String bottomElementCalType = bottomElements.stream().map(p -> p.getInt("timedeviationtype")).max(Integer::compareTo).orElse(1).toString();
        List<Map<String, Date>> bottomElementCalculateDateMapList = CalUtils.getCalDate(bottomElementCalType, DateUtils.getFirstDateOfMonth(startDate), DateUtils.getLastDateOfMonth(endDate));
        List<ElementCalculateResultDo> elementRecalculateResults = this.calculateBottomElement(bottomElements, runOrgIdList, bottomElementCalculateDateMapList.get(0).get("startdate"), bottomElementCalculateDateMapList.get(bottomElementCalculateDateMapList.size() - 1).get("enddate"), elementCodes.stream().collect(Collectors.toSet()));
        calculatedResults.addAll(elementRecalculateResults);
        List<Long> mayNotRecalculateElementIds = mayNotRecalculateElements.stream().map(p -> p.getLong("id")).collect(Collectors.toList());
        String calType = mayNotRecalculateElements.stream().map(p -> p.getInt("timedeviationtype")).max(Integer::compareTo).orElse(1).toString();
        List<Map<String, Date>> calculateDateMapList = CalUtils.getCalDate(calType, DateUtils.getFirstDateOfMonth(startDate), DateUtils.getLastDateOfMonth(endDate));
        List<ElementCalculateResultDo> mayNotCalculateResults = this.getElementCalculateResult(mayNotRecalculateElementIds, orgIdList, calculateDateMapList.get(0).get("startdate"), calculateDateMapList.get(calculateDateMapList.size() - 1).get("enddate"));
        List hasResultElementIds = mayNotCalculateResults.stream().map(p -> p.getElementId()).distinct().collect(Collectors.toList());
        recalculateElements = recalculateElements.stream().filter(p -> !p.getBoolean("bottom") && (!mayNotRecalculateElementIds.contains(p.getLong("id")) || hasResultElementIds.contains(p.getLong("id")))).collect(Collectors.toList());
        ArrayList<DynamicObject> elements = new ArrayList<DynamicObject>(elementCodes.size());
        elementCodes.forEach(p -> elements.add((DynamicObject)elementCodeKeyMap.get(p)));
        Set<String> saveDbElementCodes = this.doGetRecalculateElement(elements, nonBottomElements, new HashSet<String>(16), new HashSet<Long>(16), new ArrayList<DynamicObject>(16)).stream().map(p -> p.getString("number")).collect(Collectors.toSet());
        elementRecalculateResults.addAll(this.calculateNonBottomElementResult(recalculateElements, mayNotRecalculateElementIds, elementDependencyElementMap, calculatedResults, mayNotCalculateResults, saveDbElementCodes, topElementCodes, elementCodeKeyMap, runOrgIdList, startDate, endDate));
        logger.info("====\u8ba1\u7b97\u975e\u5e95\u5c42\u5143\u7d20\u6210\u529f");
        this.saveElementRecalculateResult(calculatedResults, orgIdList, startDate, endDate);
        logger.info("====\u4fdd\u5b58\u8ba1\u7b97\u7ed3\u679c\u6210\u529f===\u4fdd\u5b58\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)SerializationUtils.toJsonString(calculatedResults.stream().filter(p -> p.getSaveDb()).collect(Collectors.toList())));
    }

    private List<DynamicObject> getRecalculateElement(List<String> elementCodes, Map<String, DynamicObject> elementCodeKeyMap, List<DynamicObject> nonBottomElements, List<DynamicObject> mayNotRecalculateElements, Set<String> topElementCodes) {
        HashSet<String> mustRecalculateElementCodes = new HashSet<String>(16);
        ArrayList<DynamicObject> nonDependencyElements = new ArrayList<DynamicObject>(16);
        this.getNonDependencyElement(elementCodes, elementCodeKeyMap, mustRecalculateElementCodes, new HashSet<Long>(16), nonDependencyElements);
        ArrayList<DynamicObject> recalculateElements = new ArrayList<DynamicObject>(16);
        this.doGetRecalculateElement(nonDependencyElements, nonBottomElements, topElementCodes, new HashSet<Long>(16), recalculateElements);
        mayNotRecalculateElements.addAll(recalculateElements.stream().filter(p -> !mustRecalculateElementCodes.contains(p.getString("number"))).collect(Collectors.toList()));
        return recalculateElements;
    }

    private void getNonDependencyElement(List<String> elementCodes, Map<String, DynamicObject> elementCodeKeyMap, Set<String> mustRecalculateElementCodes, Set<Long> nonDependencyElementIds, List<DynamicObject> nonDependencyElements) {
        for (String elementCode : elementCodes) {
            mustRecalculateElementCodes.add(elementCode);
            DynamicObject element = elementCodeKeyMap.get(elementCode);
            if (element == null) continue;
            boolean isBottomElement = element.getBoolean("bottom");
            if (isBottomElement && !nonDependencyElementIds.contains(element.getLong("id"))) {
                nonDependencyElements.add(element);
                nonDependencyElementIds.add(element.getLong("id"));
                continue;
            }
            List<String> dependencyElementCodes = this.getElementExpressionElementCode(element.getString("formula"));
            if (CollectionUtils.isEmpty(dependencyElementCodes) && !nonDependencyElementIds.contains(element.getLong("id"))) {
                nonDependencyElements.add(element);
                nonDependencyElementIds.add(element.getLong("id"));
                continue;
            }
            this.getNonDependencyElement(dependencyElementCodes, elementCodeKeyMap, mustRecalculateElementCodes, nonDependencyElementIds, nonDependencyElements);
        }
    }

    private List<String> getElementExpressionElementCode(String formula) {
        List<String> formulaElementInfo = ElementUtil.getFormulaElementInfo(formula);
        return formulaElementInfo.stream().map(p -> p.split("\\|")[1]).collect(Collectors.toList());
    }

    private List<DynamicObject> doGetRecalculateElement(List<DynamicObject> childElements, List<DynamicObject> nonBottomElements, Set<String> topElementCodes, Set<Long> recalculateElementIds, List<DynamicObject> recalculateElements) {
        if (CollectionUtils.isEmpty(childElements)) {
            return new ArrayList<DynamicObject>(0);
        }
        for (DynamicObject childElement : childElements) {
            if (!recalculateElementIds.contains(childElement.getLong("id"))) {
                recalculateElementIds.add(childElement.getLong("id"));
                recalculateElements.add(childElement);
            }
            String elementExpression = childElement.getString("name") + "|" + childElement.getString("number");
            List<DynamicObject> parentElements = nonBottomElements.stream().filter(p -> p.getString("formula").contains(elementExpression)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(parentElements)) {
                topElementCodes.add(childElement.getString("number"));
            }
            this.doGetRecalculateElement(parentElements, nonBottomElements, topElementCodes, recalculateElementIds, recalculateElements);
        }
        return recalculateElements;
    }

    private Map<String, List<ElementDependencyElementDo>> getElementDependencyElement(List<DynamicObject> elements, Map<String, DynamicObject> elementCodeKeyMap) {
        HashMap<String, List<ElementDependencyElementDo>> result = new HashMap<String, List<ElementDependencyElementDo>>(16);
        ElementExpressionParseTask elementExpressionParseTask = new ElementExpressionParseTask(elements, elementCodeKeyMap, this);
        List<Future<Object>> futures = ThreadPoolsService.getInstance().submitReturnFuture(elementExpressionParseTask);
        StringJoiner errorMsg = new StringJoiner("\r\n");
        for (Future<Object> future : futures) {
            try {
                result.putAll((Map)future.get(30L, TimeUnit.SECONDS));
            }
            catch (Exception e) {
                errorMsg.add(e.getMessage());
            }
        }
        if (!StringUtils.isEmpty((Object)errorMsg.toString())) {
            logger.info("=================kd.taxc.tctrc.common.element.ElementCalculateService.getElementDependencyElementResult====error:{}", (Object)errorMsg.toString());
        }
        return result;
    }

    public List<ElementDependencyElementDo> doGetElementDependencyElement(DynamicObject element, Map<String, DynamicObject> elementCodeKeyMap) {
        String formula = element.getString("formula");
        return ElementUtil.parseElementDependencyElement(formula, elementCodeKeyMap);
    }

    private List<ElementCalculateResultDo> getElementCalculateResult(List<Long> elementIds, List<Long> runOrgIds, Date startDate, Date endDate) {
        Date endDateLastDate = DateUtils.getLastDateOfDay(endDate);
        Date startDateFirstDate = DateUtils.getFirstDateOfDay(startDate);
        QFilter filter = new QFilter("elementdef", "in", elementIds).and("org", "in", runOrgIds).and("startdata", ">=", (Object)startDateFirstDate).and("enddata", "<=", (Object)endDateLastDate);
        DynamicObjectCollection elementResults = QueryServiceHelper.query((String)"tdm_element_result", (String)"elementdef.id as elementid,elementdef.number as elementcode,elementdef.name as elementname,org.id as orgid,startdata,enddata,value,runtime,elestartdate,eleenddate,isemptyfield,isdenominatorzero", (QFilter[])new QFilter[]{filter});
        return elementResults.stream().map(p -> new ElementCalculateResultDo(p.getLong("elementid"), p.getString("elementcode"), p.getString("elementname"), p.getString("orgid"), p.getDate("startdata"), DateUtils.getLastDateOfDay(p.getDate("enddata")), p.getString("value"), p.getDate("runtime"), p.getDate("elestartdate"), p.getDate("eleenddate"), p.getBoolean("isdenominatorzero"), p.getBoolean("isemptyfield"), 0)).collect(Collectors.toList());
    }

    private List<ElementCalculateResultDo> calculateBottomElement(List<DynamicObject> bottomElements, List<String> runOrgIdList, Date startDate, Date endDate, Set<String> elementCodes) {
        ArrayList<ElementCalculateDo> elementCalculateParams = new ArrayList<ElementCalculateDo>(16);
        for (String orgId : runOrgIdList) {
            for (DynamicObject bottomElement : bottomElements) {
                String calType = bottomElement.getString("timedeviationtype");
                List<Map<String, Date>> calculateDateMapList = CalUtils.getCalDate(calType, DateUtils.getFirstDateOfMonth(startDate), DateUtils.getLastDateOfMonth(endDate));
                for (Map<String, Date> map : calculateDateMapList) {
                    ElementCalculateDo elementCalculateDo = new ElementCalculateDo(bottomElement, orgId, startDate, map.get("startdate"), map.get("enddate"), bottomElement.getString("formula"));
                    elementCalculateDo.setElementFetchRuleParam(this.getElementFetchRuleParam(bottomElement, elementCalculateDo.getStartDate(), elementCalculateDo.getEndDate(), orgId));
                    elementCalculateParams.add(elementCalculateDo);
                }
            }
        }
        List tableIds = elementCalculateParams.stream().filter(p -> !CollectionUtils.isEmpty(p.getElementFetchRuleParam().getRuleMapList())).flatMap(p -> p.getElementFetchRuleParam().getRuleMapList().stream().filter(p1 -> !StringUtils.isEmpty(p1.get("tableidd")))).map(p1 -> Long.parseLong((String)p1.get("tableidd"))).distinct().collect(Collectors.toList());
        DynamicObjectCollection datasourceList = QueryServiceHelper.query((String)"tctb_custom_datasource", (String)"id,name,type,subname as zbsubname,ischild,entryentity.id,entryentity.fieldsubname,entryentity.fieldname,entryentity.orgstate,entryentity.datastate,entryentity.yearstate,entryentity.monthstate", (QFilter[])new QFilter[]{new QFilter("id", "in", tableIds)});
        Map<String, List<DynamicObject>> datasourceMap = datasourceList.stream().collect(Collectors.groupingBy(k -> k.getString("id")));
        ArrayList result = new ArrayList(16);
        ElementCalculateTask elementCalculateTask = new ElementCalculateTask(elementCalculateParams, datasourceMap, this);
        List<Future<Object>> futures = ThreadPoolsService.getInstance().submitReturnFuture(elementCalculateTask);
        StringJoiner errorMsg = new StringJoiner("\r\n");
        for (Future<Object> future : futures) {
            try {
                result.addAll((List)future.get(30L, TimeUnit.SECONDS));
            }
            catch (Exception e) {
                errorMsg.add(e.getMessage());
            }
        }
        if (!StringUtils.isEmpty((Object)errorMsg.toString())) {
            logger.info("=================kd.taxc.tctrc.common.element.ElementCalculateService.calculateBottomElement====error:{}", (Object)errorMsg.toString());
        }
        List<ElementCalculateResultDo> list = result.stream().map(ElementCalculateDo::getElementCalculateResult).collect(Collectors.toList());
        for (ElementCalculateResultDo resultDatum : list) {
            if (!elementCodes.contains(resultDatum.getElementCode())) continue;
            list.forEach(p -> p.setSaveDb(true));
        }
        return list;
    }

    private ElementFetchRuleParamDo getElementFetchRuleParam(DynamicObject element, Date startDate, Date endDate, String orgId) {
        int timeDeviationCount = EmptyCheckUtils.isEmpty(element.getString("timedeviationcount")) ? 0 : Integer.parseInt(element.getString("timedeviationcount").trim());
        String deviatedStartDate = TimeDeviatedEnum.getDeviatedDateByMonth(DateUtils.formatHMS(startDate), timeDeviationCount, "-");
        String deviatedEndDate = TimeDeviatedEnum.getDeviatedDateByMonth(DateUtils.formatHMS(endDate), timeDeviationCount, "-");
        String deviatedOriginalStartDate = DateUtils.format(DateUtils.getFirstDateOfYear(DateUtils.stringToDate(deviatedEndDate)));
        Date startDateByDataType = DateUtils.stringToDate(deviatedStartDate, "yyyy-MM-dd");
        Date endDateByDataType = DateUtils.getLastDateOfMonth(DateUtils.stringToDate(deviatedEndDate, "yyyy-MM-dd"));
        Date dataSourceDate = null;
        String dataType = element.getString("datatype");
        if (!"SUM".equals(dataType)) {
            if ("START".equals(dataType)) {
                endDateByDataType = DateUtils.getLastDateOfMonth(startDateByDataType);
                dataSourceDate = DateUtils.getFirstDateOfMonth(endDateByDataType);
            } else if ("CUMULATIVE".equals(dataType)) {
                startDateByDataType = DateUtils.getFirstDateOfMonth(DateUtils.stringToDate(deviatedOriginalStartDate));
            } else {
                startDateByDataType = DateUtils.getFirstDateOfMonth(endDateByDataType);
                dataSourceDate = DateUtils.getFirstDateOfMonth(endDateByDataType);
            }
        }
        List<Map<String, String>> ruleMapList = ElementUtil.findNewRule(element.getString("json_tag"), orgId, startDateByDataType, endDateByDataType, dataSourceDate);
        return new ElementFetchRuleParamDo(ruleMapList, deviatedStartDate, deviatedEndDate, startDateByDataType, endDateByDataType);
    }

    public ElementCalculateResultDo doCalculateBottomElement(ElementCalculateDo elementCalculateParam, Map<String, List<DynamicObject>> datasourceMap) {
        List<Map<String, String>> ruleMapList = elementCalculateParam.getElementFetchRuleParam().getRuleMapList();
        Date runTime = new Date();
        DynamicObject element = elementCalculateParam.getElement();
        ElementCalculateResultDo emptyResult = new ElementCalculateResultDo(element.getLong("id"), element.getString("number"), element.getString("name"), elementCalculateParam.getOrgId(), elementCalculateParam.getStartDate(), elementCalculateParam.getEndDate(), "null", runTime, elementCalculateParam.getElementFetchRuleParam().getStartDateByDataType(), elementCalculateParam.getElementFetchRuleParam().getEndDateByDataType(), false, true, element.getInt("timedeviationtype"));
        if (CollectionUtils.isEmpty(ruleMapList)) {
            return emptyResult;
        }
        ArrayList<BigDecimal> values = new ArrayList<BigDecimal>();
        for (Map<String, String> ruleMap : ruleMapList) {
            String tableId;
            List<DynamicObject> datasourceList;
            if (null == ruleMap || EmptyCheckUtils.isEmpty(ruleMap.get("tableidd")) || CollectionUtils.isEmpty(datasourceList = datasourceMap.get(tableId = ruleMap.get("tableidd")))) continue;
            values.addAll(this.getFetchRuleValue(elementCalculateParam, datasourceList, ruleMap));
        }
        if (CollectionUtils.isEmpty(values)) {
            return emptyResult;
        }
        BigDecimal value = ((BigDecimal)values.stream().reduce(BigDecimal::add).get()).setScale(4, RoundingMode.HALF_UP);
        emptyResult.setValue(value.toString());
        emptyResult.setEmptyField(false);
        return emptyResult;
    }

    public List<BigDecimal> getFetchRuleValue(ElementCalculateDo elementCalculateParam, List<DynamicObject> datasourceList, Map<String, String> ruleMap) {
        Date queryStartDate = BooleanEnum.YES.getCode().equalsIgnoreCase(ruleMap.get("isNeedChangeQueryDate")) ? DateUtils.getFirstDateOfMonth(DateUtils.stringToDate(ruleMap.get("querystartdate"))) : elementCalculateParam.getElementFetchRuleParam().getStartDateByDataType();
        Date queryEndDate = BooleanEnum.YES.getCode().equalsIgnoreCase(ruleMap.get("isNeedChangeQueryDate")) ? DateUtils.getLastDateOfMonth(DateUtils.stringToDate(ruleMap.get("queryenddate"))) : elementCalculateParam.getElementFetchRuleParam().getEndDateByDataType();
        String tableName = datasourceList.get(0).getString("name");
        ArrayList<BigDecimal> result = new ArrayList<BigDecimal>(16);
        if ("tpo_declare_main_tsd".equals(tableName) || "tpo_declare_main_tsc".equals(tableName)) {
            ElementSqlService elementSqlService = ElementSqlServiceFactory.factory(true, tableName);
            BigDecimal bigDecimal = elementSqlService.queryElementByMultiData(elementCalculateParam.getOrgId(), queryStartDate, queryEndDate, datasourceList.get(0).getString("type"), tableName, null, elementCalculateParam.getElement().getLong("taxtype"), elementCalculateParam.getElement().getString("draftpurpose"), ruleMap);
            if (null != bigDecimal) {
                result.add(bigDecimal);
            }
            return result;
        }
        ArrayList<DynamicObject> fields = new ArrayList<DynamicObject>(16);
        DynamicObject orgFieldObject = null;
        DynamicObject dateFieldObject = null;
        DynamicObject yearFieldObject = null;
        DynamicObject monthFieldObject = null;
        String[] fieldIdArray = ruleMap.get("fieldidd").split(",");
        for (DynamicObject datasource : datasourceList) {
            if (Arrays.stream(fieldIdArray).anyMatch(p -> datasource.getString("entryentity.id").equals(p))) {
                fields.add(datasource);
            }
            if ("true".equals(datasource.getString("entryentity.orgstate"))) {
                orgFieldObject = datasource;
            }
            if ("true".equals(datasource.getString("entryentity.datastate"))) {
                dateFieldObject = datasource;
            }
            if ("true".equals(datasource.getString("entryentity.yearstate"))) {
                yearFieldObject = datasource;
            }
            if (!"true".equals(datasource.getString("entryentity.monthstate"))) continue;
            monthFieldObject = datasource;
        }
        if (fields.size() == 0) {
            return result;
        }
        boolean isChild = ((DynamicObject)fields.get(0)).getBoolean("ischild");
        String name = ((DynamicObject)fields.get(0)).getString("name");
        String subName = ((DynamicObject)fields.get(0)).getString("zbsubname");
        String tableType = ((DynamicObject)fields.get(0)).getString("type");
        logger.info("kd.taxc.tctrc.common.element.ElementCalculateService.getFetchRuleValue====ischild={};name={};subname={};tabletype={}", new Object[]{isChild, name, subName, tableType});
        if (EmptyCheckUtils.isEmpty(orgFieldObject)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u653f\u7b56\u8fd0\u7ef4 \u53d6\u6570\u8868\u914d\u7f6e\u51fa\u9519\u3002\u9519\u8bef\u539f\u56e0\uff1a \u5b9e\u4f53\u540d\u79f0\u4e3a\u201c%1$s\u201d\uff0c\u5b57\u8868\u540d\u79f0\u4e3a \u201c%2$s \u201d\uff0c\u7ec4\u7ec7\u5b57\u6bb5\u4e3a\u7a7a\u3002", (String)"ElementSqlService_0", (String)"taxc-tctrc-common", (Object[])new Object[0]), name, subName));
        }
        ElementSqlService elementSqlService = ElementSqlServiceFactory.factory(isChild, name);
        List<String> selectFieldList = elementSqlService.findSelectFieldList(isChild, fields, name, subName, ruleMap);
        selectFieldList = selectFieldList.stream().distinct().collect(Collectors.toList());
        String selectFields = String.join((CharSequence)",", selectFieldList);
        if ("itp_proviston_taxes".equals(name)) {
            BigDecimal bigDecimal = elementSqlService.queryElementByMultiData(elementCalculateParam.getOrgId(), queryStartDate, queryEndDate, tableType, name, selectFields, elementCalculateParam.getElement().getLong("taxtype"), elementCalculateParam.getElement().getString("draftpurpose"), ruleMap);
            if (null != bigDecimal) {
                result.add(bigDecimal);
            }
        } else if ("tdm_balance_new".equals(name) || "gl_balance".equals(name)) {
            BigDecimal bigDecimal = elementSqlService.queryElementCommonService(elementCalculateParam.getOrgId(), queryStartDate, queryEndDate, tableType, name, selectFields, elementCalculateParam.getElement().getLong("taxtype"), ruleMap);
            if (null != bigDecimal) {
                result.add(bigDecimal);
            }
        } else {
            DynamicObjectCollection dynamicObjects = elementSqlService.queryElement(elementCalculateParam.getOrgId(), queryStartDate, queryEndDate, ruleMap, orgFieldObject, dateFieldObject, name, subName, selectFields, tableType, yearFieldObject, monthFieldObject, elementCalculateParam.getElementFetchRuleParam().getDeviatedStartDate(), elementCalculateParam.getElementFetchRuleParam().getDeviatedEndDate(), elementCalculateParam.getElement().getString("datatype"));
            for (DynamicObject dynamicObject : dynamicObjects) {
                result.add(dynamicObject.getBigDecimal(0));
            }
        }
        return result;
    }

    public List<ElementCalculateResultDo> calculateNonBottomElementResult(List<DynamicObject> recalculateElements, List<Long> mayNotRecalculateElementIds, Map<String, List<ElementDependencyElementDo>> elementDependencyElementMap, List<ElementCalculateResultDo> calculatedResults, List<ElementCalculateResultDo> mayNotCalculatedResults, Set<String> elementCodes, Set<String> topCodes, Map<String, DynamicObject> elementCodeKeyMap, List<String> runOrgIdList, Date startDate, Date endDate) {
        ArrayList<String> canRecalculateElementCodes = new ArrayList<String>(16);
        List hasRecalculateElementCodes = calculatedResults.stream().map(ElementCalculateResultDo::getElementCode).distinct().collect(Collectors.toList());
        for (Map.Entry<String, List<ElementDependencyElementDo>> elementDependencyElementEntry : elementDependencyElementMap.entrySet()) {
            if (elementDependencyElementEntry.getValue().size() != 0 && !hasRecalculateElementCodes.containsAll(elementDependencyElementEntry.getValue().stream().filter(p -> p.getElementId() != 0L).map(p -> p.getElementCode()).collect(Collectors.toList()))) continue;
            canRecalculateElementCodes.add(elementDependencyElementEntry.getKey());
        }
        List canRecalculateElements = recalculateElements.stream().filter(p -> canRecalculateElementCodes.contains(p.getString("number"))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(canRecalculateElements)) {
            List reCalElementCodes = recalculateElements.stream().map(p -> p.getString("number")).collect(Collectors.toList());
            logger.info("==========kd.taxc.tctrc.common.element.ElementCalculateService.calculateNonBottomElementResult===\u8fdb\u5165\u65e0\u7ebf\u5faa\u574f\uff0c\u65e0\u6cd5\u7b97\u51fa\u7684\u5143\u7d20\u7f16\u7801\u4e3a:{}==\u5176\u4f9d\u8d56\u5143\u7d20\u4e3a:{}====\u5df2\u6709\u7ed3\u679c\u7684\u5143\u7d20\u7f16\u7801\u4e3a\uff1a{}", new Object[]{String.join((CharSequence)",", reCalElementCodes), SerializationUtils.toJsonString(elementDependencyElementMap.entrySet().stream().filter(p -> reCalElementCodes.contains(p.getKey())).collect(Collectors.toMap(k -> (String)k.getKey(), v -> (List)v.getValue()))), String.join((CharSequence)",", calculatedResults.stream().map(p -> p.getElementCode()).collect(Collectors.toList()))});
            return new ArrayList<ElementCalculateResultDo>(0);
        }
        ArrayList<ElementCalculateDo> elementCalculateParams = new ArrayList<ElementCalculateDo>(16);
        for (String orgId : runOrgIdList) {
            for (DynamicObject recalculateElement : canRecalculateElements) {
                String calType = recalculateElement.getString("timedeviationtype");
                List<Map<String, Date>> list = CalUtils.getCalDate(calType, DateUtils.getFirstDateOfMonth(startDate), DateUtils.getLastDateOfMonth(endDate));
                for (Map<String, Date> calculateDateMap : list) {
                    boolean isNotRecalculate;
                    boolean bl = isNotRecalculate = mayNotRecalculateElementIds.contains(recalculateElement.getLong("id")) && mayNotCalculatedResults.stream().anyMatch(p -> p.getElementId().equals(recalculateElement.getLong("id")) && p.getOrgId().equals(orgId) && p.getStartDate().compareTo((Date)calculateDateMap.get("startdate")) == 0 && p.getEndDate().compareTo((Date)calculateDateMap.get("enddate")) == 0);
                    if (isNotRecalculate) continue;
                    ElementCalculateDo elementCalculateParam = new ElementCalculateDo(recalculateElement, orgId, startDate, calculateDateMap.get("startdate"), calculateDateMap.get("enddate"), recalculateElement.getString("formula"));
                    this.replaceFormulaElementWithValue(elementCodeKeyMap, elementCalculateParam, elementDependencyElementMap, calculatedResults, elementCodes);
                    elementCalculateParams.add(elementCalculateParam);
                }
            }
        }
        ArrayList elementCalculates = new ArrayList(16);
        ElementCalculateTask elementCalculateTask = new ElementCalculateTask(elementCalculateParams, null, this);
        List<Future<Object>> futures = ThreadPoolsService.getInstance().submitReturnFuture(elementCalculateTask);
        StringJoiner errorMsg = new StringJoiner("\r\n");
        for (Future future : futures) {
            try {
                elementCalculates.addAll((List)future.get(30L, TimeUnit.SECONDS));
            }
            catch (Exception e) {
                errorMsg.add(e.getMessage());
            }
        }
        if (!StringUtils.isEmpty((Object)errorMsg.toString())) {
            logger.info("=================kd.taxc.tctrc.common.element.ElementCalculateService.getElementDependencyElementResult====error:{}", (Object)errorMsg.toString());
        }
        List<ElementCalculateResultDo> result = elementCalculates.stream().map(ElementCalculateDo::getElementCalculateResult).collect(Collectors.toList());
        result.forEach(p -> {
            if (elementCodes.contains(p.getElementCode()) || topCodes.contains(p.getElementCode()) || mayNotRecalculateElementIds.contains(p.getElementId())) {
                p.setSaveDb(true);
            }
        });
        recalculateElements = recalculateElements.stream().filter(p -> !canRecalculateElementCodes.contains(p.getString("number"))).collect(Collectors.toList());
        calculatedResults.addAll(result);
        if (CollectionUtils.isEmpty(recalculateElements)) {
            return result;
        }
        result.addAll(this.calculateNonBottomElementResult(recalculateElements, mayNotRecalculateElementIds, elementDependencyElementMap, calculatedResults, mayNotCalculatedResults, elementCodes, topCodes, elementCodeKeyMap, runOrgIdList, startDate, endDate));
        return result;
    }

    private void replaceFormulaElementWithValue(Map<String, DynamicObject> elementCodeKeyMap, ElementCalculateDo elementCalculateParam, Map<String, List<ElementDependencyElementDo>> elementDependencyElementMap, List<ElementCalculateResultDo> calculatedResults, Set<String> elementCodes) {
        DynamicObject element = elementCalculateParam.getElement();
        List<ElementDependencyElementDo> dependencyElements = elementDependencyElementMap.get(element.getString("number"));
        if (CollectionUtils.isEmpty(dependencyElements)) {
            return;
        }
        String formula = elementCalculateParam.getFormula();
        HashMap<String, String> replaceValueMap = new HashMap<String, String>(dependencyElements.size());
        Boolean isEmptyField = true;
        for (ElementDependencyElementDo elementDependencyElementDo : dependencyElements) {
            if (elementDependencyElementDo.getElementId() == 0L) continue;
            String replaceValue = "0";
            String originalValue = formula.substring(elementDependencyElementDo.getStartIndex(), elementDependencyElementDo.getEndIndex());
            Map<String, Date> dependencyActualDate = this.getDependencyActualDate(elementCodeKeyMap.get(elementDependencyElementDo.getElementCode()), elementCalculateParam.getStartDate(), elementCalculateParam.getEndDate());
            ElementCalculateResultDo elementCalculateResult = calculatedResults.stream().filter(p -> p.getElementId().longValue() == dependencyElement.getElementId().longValue() && p.getOrgId().equals(elementCalculateParam.getOrgId()) && p.getStartDate().equals(dependencyActualDate.get("startDate")) && p.getEndDate().equals(DateUtils.getFirstDateOfDay((Date)dependencyActualDate.get("endDate")))).findFirst().orElse(null);
            if (elementCalculateResult != null) {
                if (elementCodes.contains(elementCalculateParam.getElement().getString("number"))) {
                    this.addSaveDbChildElement(elementCodeKeyMap, elementDependencyElementDo, elementCalculateParam, elementDependencyElementMap, calculatedResults);
                }
                if (!elementCalculateResult.getEmptyField().booleanValue()) {
                    isEmptyField = false;
                    if (!elementCalculateResult.getDenominatorZero().booleanValue()) {
                        replaceValue = elementCalculateResult.getValue();
                    }
                }
            }
            replaceValueMap.put(originalValue, replaceValue);
        }
        if (isEmptyField.booleanValue()) {
            elementCalculateParam.setElementCalculateResult(new ElementCalculateResultDo(element.getLong("id"), element.getString("number"), element.getString("name"), elementCalculateParam.getOrgId(), elementCalculateParam.getStartDate(), elementCalculateParam.getEndDate(), "null", new Date(), elementCalculateParam.getStartDate(), elementCalculateParam.getEndDate(), false, true, element.getInt("timedeviationtype")));
            return;
        }
        logger.info("======elementCode:{}===formula:{};     originalValue:{};       replaceValue:{}", new Object[]{element.getString("number"), formula, SerializationUtils.toJsonString(replaceValueMap.keySet()), SerializationUtils.toJsonString(replaceValueMap.values())});
        for (Map.Entry entry : replaceValueMap.entrySet()) {
            formula = formula.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        elementCalculateParam.setFormula(formula);
    }

    private void addSaveDbChildElement(Map<String, DynamicObject> elementCodeKeyMap, ElementDependencyElementDo dependencyElement, ElementCalculateDo elementCalculateParam, Map<String, List<ElementDependencyElementDo>> elementDependencyElementMap, List<ElementCalculateResultDo> calculatedResults) {
        Map<String, Date> dependencyActualDate = this.getDependencyActualDate(elementCodeKeyMap.get(dependencyElement.getElementCode()), elementCalculateParam.getStartDate(), elementCalculateParam.getEndDate());
        ElementCalculateResultDo elementCalculateResult = calculatedResults.stream().filter(p -> p.getElementId().longValue() == dependencyElement.getElementId().longValue() && p.getOrgId().equals(elementCalculateParam.getOrgId()) && p.getStartDate().equals(dependencyActualDate.get("startDate")) && p.getEndDate().equals(DateUtils.getFirstDateOfDay((Date)dependencyActualDate.get("endDate")))).findFirst().orElse(null);
        if (elementCalculateResult == null) {
            return;
        }
        ElementCalculateResultDo actualDependencyElementResult = calculatedResults.stream().filter(p -> p.getElementId().longValue() == dependencyElement.getElementId().longValue() && p.getOrgId().equals(elementCalculateParam.getOrgId()) && p.getStartDate().equals(elementCalculateParam.getStartDate()) && p.getEndDate().equals(elementCalculateParam.getEndDate())).findFirst().orElse(null);
        if (actualDependencyElementResult == null) {
            actualDependencyElementResult = new ElementCalculateResultDo(elementCalculateResult.getElementId(), elementCalculateResult.getElementCode(), elementCalculateResult.getElementName(), elementCalculateResult.getOrgId(), elementCalculateParam.getStartDate(), elementCalculateParam.getEndDate(), elementCalculateResult.getValue(), elementCalculateResult.getRunTime(), elementCalculateResult.getEleStartDate(), elementCalculateResult.getEleEndDate(), elementCalculateResult.getDenominatorZero(), elementCalculateResult.getEmptyField(), elementCalculateResult.getElementCalCycle());
            actualDependencyElementResult.setSaveDb(true);
            calculatedResults.add(actualDependencyElementResult);
        } else {
            actualDependencyElementResult.setSaveDb(true);
        }
        List<ElementDependencyElementDo> dependencyElements = elementDependencyElementMap.get(actualDependencyElementResult.getElementCode());
        if (CollectionUtils.isEmpty(dependencyElements)) {
            return;
        }
        for (ElementDependencyElementDo dependencyElementDo : dependencyElements) {
            this.addSaveDbChildElement(elementCodeKeyMap, dependencyElementDo, elementCalculateParam, elementDependencyElementMap, calculatedResults);
        }
    }

    private Map<String, Date> getDependencyActualDate(DynamicObject dependencyElement, Date startDate, Date endDate) {
        HashMap<String, Date> result = new HashMap<String, Date>(2);
        result.put("startDate", startDate);
        result.put("endDate", endDate);
        String deviationType = dependencyElement.getString("timedeviationtype");
        if (deviationType.equals(TimeDeviatedEnum.TIME_DEVIATION_SEASON.getDeviatedType())) {
            result.put("startDate", DateUtils.getFirstDateOfSeason(startDate));
            result.put("endDate", DateUtils.getLastDateOfSeason(endDate));
        } else if (deviationType.equals(TimeDeviatedEnum.TIME_DEVIATION_HALF_YEAR.getDeviatedType())) {
            result.put("startDate", DateUtils.getFirstDateOfHalfYear(startDate));
            result.put("endDate", DateUtils.getLastDateOfHalfYear(endDate));
        } else if (deviationType.equals(TimeDeviatedEnum.TIME_DEVIATION_YEAR.getDeviatedType())) {
            result.put("startDate", DateUtils.getFirstDateOfYear(startDate));
            result.put("endDate", DateUtils.getLastDateOfYear(endDate));
        }
        return result;
    }

    public ElementCalculateResultDo doCalculateElement(ElementCalculateDo elementCalculateParam) {
        if (elementCalculateParam.getElementCalculateResult() != null && elementCalculateParam.getElementCalculateResult().getEmptyField().booleanValue()) {
            return elementCalculateParam.getElementCalculateResult();
        }
        DynamicObject element = elementCalculateParam.getElement();
        String formula = elementCalculateParam.getFormula();
        boolean isDenominatorZero = RiskCalSerivce.isDenominatorZero(formula);
        if (isDenominatorZero) {
            return new ElementCalculateResultDo(element.getLong("id"), element.getString("number"), element.getString("name"), elementCalculateParam.getOrgId(), elementCalculateParam.getStartDate(), elementCalculateParam.getEndDate(), "null", new Date(), elementCalculateParam.getStartDate(), elementCalculateParam.getEndDate(), true, false, element.getInt("timedeviationtype"));
        }
        String value = BigDecimalUtil.setScale(CalculateService.calculate(formula), 4).toPlainString();
        return new ElementCalculateResultDo(element.getLong("id"), element.getString("number"), element.getString("name"), elementCalculateParam.getOrgId(), elementCalculateParam.getStartDate(), elementCalculateParam.getEndDate(), value, new Date(), elementCalculateParam.getStartDate(), elementCalculateParam.getEndDate(), false, false, element.getInt("timedeviationtype"));
    }

    private void saveElementRecalculateResult(List<ElementCalculateResultDo> elementCalculateResults, List<Long> runOrgIds, Date startDate, Date endDate) {
        List elementIds = elementCalculateResults.stream().map(ElementCalculateResultDo::getElementId).distinct().collect(Collectors.toList());
        String calType = elementCalculateResults.stream().map(p -> p.getElementCalCycle()).max(Integer::compareTo).orElse(1).toString();
        List<Map<String, Date>> calculateDateMapList = CalUtils.getCalDate(calType, DateUtils.getFirstDateOfMonth(startDate), DateUtils.getLastDateOfMonth(endDate));
        QFilter filter = new QFilter("elementdef", "in", elementIds).and("org", "in", runOrgIds).and("startdata", ">=", (Object)DateUtils.getFirstDateOfDay(calculateDateMapList.get(0).get("startdate"))).and("enddata", "<=", (Object)DateUtils.getLastDateOfDay(calculateDateMapList.get(calculateDateMapList.size() - 1).get("enddate")));
        List elementResultIds = QueryServiceHelper.query((String)"tdm_element_result", (String)"id", (QFilter[])new QFilter[]{filter}).stream().map(p -> p.getLong("id")).collect(Collectors.toList());
        DynamicObject[] elementResults = BusinessDataServiceHelper.load((Object[])elementResultIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tdm_element_result"));
        ArrayList<DynamicObject> saveElementResults = new ArrayList<DynamicObject>(elementCalculateResults.size());
        for (ElementCalculateResultDo elementCalculateResult : elementCalculateResults) {
            if (!elementCalculateResult.getSaveDb().booleanValue()) continue;
            Date firstTimeOfEndDate = DateUtils.getFirstDateOfDay(elementCalculateResult.getEndDate());
            Predicate<DynamicObject> predicate = p -> elementCalculateResult.getOrgId().equals(p.getString("org.id")) && p.getLong("elementdef.id") == elementCalculateResult.getElementId().longValue() && p.getDate("startdata").compareTo(elementCalculateResult.getStartDate()) == 0 && p.getDate("enddata").compareTo(firstTimeOfEndDate) == 0;
            Optional<DynamicObject> optional = Arrays.stream(elementResults).filter(predicate).sorted((a, b) -> b.getDate("runtime").compareTo(a.getDate("runtime"))).findFirst();
            DynamicObject elementResultObject = optional.orElseGet(this::newElementResultObject);
            if (elementResultObject.get("org") == null) {
                elementResultObject.set("org", (Object)elementCalculateResult.getOrgId());
                elementResultObject.set("elementDef", (Object)elementCalculateResult.getElementId());
            }
            elementResultObject.set("element", (Object)elementCalculateResult.getElementCode());
            elementResultObject.set("name", (Object)elementCalculateResult.getElementName());
            elementResultObject.set("startdata", (Object)elementCalculateResult.getStartDate());
            elementResultObject.set("enddata", (Object)firstTimeOfEndDate);
            elementResultObject.set("value", (Object)elementCalculateResult.getValue());
            elementResultObject.set("runtime", (Object)elementCalculateResult.getRunTime());
            elementResultObject.set("elestartdate", (Object)elementCalculateResult.getEleStartDate());
            elementResultObject.set("eleenddate", (Object)elementCalculateResult.getEleEndDate());
            elementResultObject.set("usetype", (Object)"1");
            elementResultObject.set("isdenominatorzero", (Object)elementCalculateResult.getDenominatorZero());
            elementResultObject.set("isemptyfield", (Object)elementCalculateResult.getEmptyField());
            saveElementResults.add(elementResultObject);
        }
        SaveServiceHelper.save((DynamicObject[])saveElementResults.toArray(new DynamicObject[saveElementResults.size()]));
    }

    private DynamicObject newElementResultObject() {
        return BusinessDataServiceHelper.newDynamicObject((String)"tdm_element_result");
    }
}

