/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.common.element;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tctrc.common.element.RiskCalSerivce;
import kd.taxc.tctrc.common.element.impl.NumberRisk;
import kd.taxc.tctrc.common.util.DateUtils;
import kd.taxc.tctrc.common.util.ElementUtil;

public class RecalculateRiskResult {
    private static final String FIELD_RUNTIME = "runtime";
    private static final String FIELD_RISKLEVEL = "risklevel";
    private static final String FIELD_RISKDESC = "riskdesc";
    private static final String FIELD_RESULT = "result";

    public static void expressionToElement(String json, Map<String, String> elementCode2FormulaMap, Map<String, String> codesMap) {
        if (!json.isEmpty()) {
            String[] expressionArr;
            for (String eleOrOperator : expressionArr = json.split(" ")) {
                if ("+-*/()<><=>=abs(".contains(eleOrOperator = ElementUtil.splitElementFormula(eleOrOperator)) || null == elementCode2FormulaMap.get(eleOrOperator)) continue;
                codesMap.put(eleOrOperator, eleOrOperator);
                String[] eleInfoArr = elementCode2FormulaMap.get(eleOrOperator).split(",");
                if (!"false".equals(eleInfoArr[1])) continue;
                RecalculateRiskResult.expressionToElement(eleInfoArr[0], elementCode2FormulaMap, codesMap);
            }
        }
    }

    public static void splitElements(Set<String> codes, Map<String, String> elementMap, Map<String, String> codesMap) {
        if (!codes.isEmpty()) {
            for (String code : codes) {
                String content = elementMap.get(code);
                if (null == content) continue;
                codesMap.put(code, code);
                if (!"false".equals(content.split(",")[1])) continue;
                String json = content.split(",")[0];
                RecalculateRiskResult.expressionToElement(json, elementMap, codesMap);
            }
        }
    }

    public static void updateRiskResult(Map<String, DynamicObject> eleCode2InfoMap, List<DynamicObject> eleResults, String originalStartDate, String desc) {
        if (!eleResults.isEmpty()) {
            ArrayList<String> eleCodes = new ArrayList<String>();
            ArrayList<String> orgids = new ArrayList<String>();
            eleResults.forEach(ele -> {
                eleCodes.add(ele.getString("element"));
                if (!orgids.contains(ele.getString("org"))) {
                    orgids.add(ele.getString("org"));
                }
            });
            NumberRisk numberRisk = new NumberRisk();
            List<Long> riskIds = numberRisk.queryRiskByElementCodes(eleCodes);
            if (!riskIds.isEmpty()) {
                List<DynamicObject> numberRiskResults = numberRisk.queryRiskResult(eleResults, orgids, riskIds);
                RecalculateRiskResult.calRiskResult(eleCode2InfoMap, numberRiskResults.toArray(new DynamicObject[numberRiskResults.size()]), desc, originalStartDate);
            }
        }
    }

    public static void calRiskResult(Map<String, DynamicObject> eleCode2InfoMap, DynamicObject[] objArray, String decs, String originalStartDate) {
        ArrayList<DynamicObject> resultUpdate = new ArrayList<DynamicObject>();
        for (DynamicObject obj : objArray) {
            String riskNumber = obj.getString("risk.number");
            String runOrgid = obj.getDynamicObject("runorg").getString("id");
            DynamicObject resultObj = obj;
            Map<String, String> map = RiskCalSerivce.calRisk(resultObj.getString("id"), eleCode2InfoMap, obj.getString("risk.risktype"), runOrgid, riskNumber, originalStartDate, DateUtils.format(obj.getDate("startdate")), DateUtils.format(obj.getDate("enddate")));
            if (map == null) continue;
            resultObj.set(FIELD_RUNTIME, (Object)new Date());
            resultObj.set(FIELD_RISKLEVEL, (Object)map.get(FIELD_RISKLEVEL));
            resultObj.set(FIELD_RISKDESC, (Object)map.get(FIELD_RISKDESC));
            resultObj.set(FIELD_RESULT, (Object)map.get(FIELD_RESULT));
            resultUpdate.add(resultObj);
        }
        if (!resultUpdate.isEmpty()) {
            Object[] pkarray = SaveServiceHelper.save((DynamicObject[])resultUpdate.toArray(new DynamicObject[0]));
            String userId = RequestContext.get().getUserId();
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(pkarray.length);
            for (Object obj : pkarray) {
                DynamicObject dobj = (DynamicObject)obj;
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tctrc_handle_entity");
                dynamicObject.set("handler", (Object)userId);
                dynamicObject.set(FIELD_RESULT, (Object)"1");
                dynamicObject.set("time", (Object)new Date());
                dynamicObject.set("resultid", (Object)dobj.getString("id"));
                dynamicObject.set("type", (Object)"sdjs");
                DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
                DynamicObject object = entryentity.addNew();
                object.set("suggestion", (Object)decs);
                list.add(dynamicObject);
            }
            SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
        }
    }
}

