/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.common.element;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tctrc.common.cal.eval.Parser;
import kd.taxc.tctrc.common.cal.eval.tokenizer.ParseException;
import kd.taxc.tctrc.common.element.ElementSqlService;
import kd.taxc.tctrc.common.element.Formula;
import kd.taxc.tctrc.common.element.IRiskCalService;
import kd.taxc.tctrc.common.element.impl.ElementVerifyService;
import kd.taxc.tctrc.common.element.impl.NumberNewCalService;
import kd.taxc.tctrc.common.element.impl.SamplingService;
import kd.taxc.tctrc.common.util.DateUtils;
import kd.taxc.tctrc.common.util.ElementUtil;
import org.apache.commons.lang3.math.NumberUtils;

public class RiskCalSerivce {
    private static Log logger = LogFactory.getLog(RiskCalSerivce.class);

    public static Map<String, String> calRisk(String resultid, Map<String, DynamicObject> eleCode2InfoMap, String risktype, String orgid, String riskCode, String originalStartDate, String startData, String endData) {
        IRiskCalService service = "1".equals(risktype) ? new NumberNewCalService() : ("2".equals(risktype) ? new SamplingService() : new ElementVerifyService());
        return service.calVerify(eleCode2InfoMap, resultid, orgid, riskCode, originalStartDate, startData, endData);
    }

    public static List<Formula> queryFormula(String json, String type, Date startdate, Date enddate, String orgid, Map<String, DynamicObject> code2EleInfoMap) {
        String[] formulaArr;
        logger.info("queryFormula\u3002\u67e5\u8be2\u5e95\u5c42\u6216\u8005\u975e\u4f4e\u5c42\u5143\u7d20\u3002type\u4e3a0\u662f\u975e\u4f4e\u5c42\u5143\u7d20\uff0c1\u662f\u4f4e\u5c42\u5143\u7d20\u3002type\u503c\u4e3a\uff1a" + type);
        ArrayList<Formula> list = new ArrayList<Formula>();
        for (String f : formulaArr = json.split(" ")) {
            Formula fvo;
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)(f = ElementUtil.splitElementFormula(f)))) continue;
            if ("+-*/()<><=>=abs(".contains(f)) {
                fvo = new Formula("2");
                fvo.setName(f);
                fvo.setStartDate(startdate);
                fvo.setEndDate(enddate);
                list.add(fvo);
                continue;
            }
            if (ElementUtil.isConstantNumber(f, code2EleInfoMap)) {
                fvo = new Formula("3");
                fvo.setName(f);
                fvo.setStartDate(startdate);
                fvo.setEndDate(enddate);
                list.add(fvo);
                continue;
            }
            fvo = new Formula("1");
            fvo.setCode(f);
            RiskCalSerivce.queryElement(fvo, list, type, startdate, enddate, code2EleInfoMap);
        }
        if (!CollectionUtils.isEmpty(list)) {
            List<Formula> formulas = ElementSqlService.queryElementValues(orgid, list, startdate, enddate);
            for (Formula formula : list) {
                for (Formula formula1 : formulas) {
                    if (!formula1.getCode().equals(formula.getCode()) || !DateUtils.format(formula1.getStartDate()).equals(DateUtils.format(formula.getStartDate())) || !DateUtils.format(formula1.getEndDate()).equals(DateUtils.format(formula1.getEndDate()))) continue;
                    formula.setValue(formula1.getValue());
                    formula.setIsEmptyField(formula1.getIsEmptyField());
                    formula.setIsDenominatorZero(formula1.getIsDenominatorZero());
                }
            }
        }
        return list;
    }

    public static List<Formula> queryFormulaByeElement(DynamicObject result, DynamicObject element, Map<String, DynamicObject> ele2EleInfoMap) {
        if (null == element) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5143\u7d20\u4e0d\u80fd\u4e3a\u7a7a", (String)"RiskCalSerivce_0", (String)"taxc-tctrc-common", (Object[])new Object[0]));
        }
        if (null == result) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u8fd0\u884c\u8bb0\u5f55\u201d\u3002", (String)"RiskCalSerivce_1", (String)"taxc-tctrc-common", (Object[])new Object[0]));
        }
        logger.info("queryFormula\u3002\u67e5\u8be2\u5143\u7d20\u8868\u8fbe\u5f0f\u3002");
        ArrayList<Formula> list = new ArrayList<Formula>();
        Boolean isbotton = element.getBoolean("bottom");
        String json = element.getString("formula");
        String[] formulass = json.split(" ");
        Date startdate = result.getDate("startdate");
        Date enddate = result.getDate("enddate");
        String orgid = result.getDynamicObject("runorg").getString("id");
        if (!isbotton.booleanValue()) {
            for (String f : formulass) {
                f = ElementUtil.splitElementFormula(f);
                Formula fvo = null;
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)f)) continue;
                if ("+-*/()<><=>=abs(".contains(f)) {
                    fvo = new Formula("2");
                    fvo.setName(f);
                    fvo.setStartDate(startdate);
                    fvo.setEndDate(enddate);
                    list.add(fvo);
                    continue;
                }
                if (ElementUtil.isConstantNumber(f, ele2EleInfoMap)) {
                    fvo = new Formula("3");
                    fvo.setName(f);
                    fvo.setStartDate(startdate);
                    fvo.setEndDate(enddate);
                    list.add(fvo);
                    continue;
                }
                fvo = new Formula("1");
                fvo.setCode(f);
                fvo.setName(f);
                fvo.setStartDate(startdate);
                fvo.setEndDate(enddate);
                list.add(fvo);
            }
        } else {
            return new ArrayList<Formula>();
        }
        if (!CollectionUtils.isEmpty(list)) {
            List<Formula> formulas = ElementSqlService.queryElementValues(orgid, list, startdate, enddate);
            for (Formula formula : list) {
                for (Formula formula1 : formulas) {
                    if (!formula1.getCode().equals(formula.getCode()) || !DateUtils.format(formula1.getStartDate()).equals(DateUtils.format(formula.getStartDate())) || !DateUtils.format(formula1.getEndDate()).equals(DateUtils.format(formula1.getEndDate()))) continue;
                    formula.setValue(formula1.getValue());
                    formula.setName(formula1.getName());
                    formula.setIsEmptyField(formula1.getIsEmptyField());
                }
            }
        }
        return list;
    }

    private static void queryElementByBottom(Formula fvo, List<Formula> list, String type) {
        QFilter org = new QFilter("number", "=", (Object)fvo.getCode());
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"tdm_element_group", (String)" name,json_tag,bottom,describe ", (QFilter[])new QFilter[]{org});
        String bottom = ((DynamicObject)doc.get(0)).getString("bottom");
        if (doc.size() > 0) {
            if ("1".equals(type)) {
                if ("true".equals(bottom)) {
                    fvo.setName(((DynamicObject)doc.get(0)).getString("name"));
                    fvo.setDescribe(((DynamicObject)doc.get(0)).getString("describe"));
                    list.add(fvo);
                }
            } else if (!"true".equals(bottom)) {
                fvo.setName(((DynamicObject)doc.get(0)).getString("name"));
                fvo.setDescribe(((DynamicObject)doc.get(0)).getString("describe"));
                list.add(fvo);
            }
        }
    }

    private static void queryElement(Formula fvo, List<Formula> list, String type, Date startDate, Date endDate, Map<String, DynamicObject> code2EleInfoMap) {
        DynamicObject element = code2EleInfoMap.get(fvo.getCode());
        if (element == null) {
            return;
        }
        if ("0".equals(type)) {
            fvo.setName(element.getString("name"));
            fvo.setDescribe(element.getString("describe"));
            fvo.setStartDate(startDate);
            fvo.setEndDate(endDate);
            list.add(fvo);
        } else {
            String bottom = element.getString("bottom");
            if ("true".equals(bottom)) {
                fvo.setName(element.getString("name"));
                fvo.setDescribe(element.getString("describe"));
                fvo.setStartDate(startDate);
                fvo.setEndDate(endDate);
                list.add(fvo);
            } else {
                String[] formula;
                Formula left = new Formula("2");
                left.setName("(");
                left.setStartDate(startDate);
                left.setEndDate(endDate);
                list.add(left);
                String json = (String)((Map)SerializationUtils.fromJsonString((String)element.getString("json_tag"), Map.class)).get("formula");
                for (String f : formula = json.split(" ")) {
                    f = ElementUtil.splitElementFormula(f);
                    Formula fvo2 = null;
                    if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)f)) continue;
                    if ("+-*/()<><=>=abs(".contains(f)) {
                        fvo2 = new Formula("2");
                        fvo2.setName(f);
                        fvo2.setStartDate(startDate);
                        fvo2.setEndDate(endDate);
                        list.add(fvo2);
                        continue;
                    }
                    if (ElementUtil.isConstantNumber(f, code2EleInfoMap)) {
                        fvo = new Formula("3");
                        fvo.setName(f);
                        fvo.setStartDate(startDate);
                        fvo.setEndDate(endDate);
                        list.add(fvo);
                        continue;
                    }
                    fvo2 = new Formula("1");
                    fvo2.setCode(f);
                    RiskCalSerivce.queryElement(fvo2, list, type, startDate, endDate, code2EleInfoMap);
                }
                Formula right = new Formula("2");
                right.setName(")");
                right.setStartDate(startDate);
                right.setEndDate(endDate);
                list.add(right);
            }
        }
    }

    public static BigDecimal getRangeBigDecimal(String range) {
        if ("-\u221e".equals(range)) {
            return BigDecimal.valueOf(Integer.MIN_VALUE);
        }
        if ("+\u221e".equals(range)) {
            return BigDecimal.valueOf(Integer.MAX_VALUE);
        }
        if (StringUtils.isEmpty((CharSequence)range)) {
            return BigDecimal.ZERO;
        }
        if (!NumberUtils.isNumber((String)range)) {
            return null;
        }
        return new BigDecimal(range);
    }

    public static String getRangeValueString(String range) {
        if (range == null) {
            return null;
        }
        return String.valueOf(RiskCalSerivce.getRangeBigDecimal(range));
    }

    public static boolean isDenominatorZero(String formula) {
        block5: {
            logger.info("\u5143\u7d20\u8868\u8fbe\u5f0f\u7684\u503c\u4e3a\uff1a" + formula);
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)formula)) {
                return false;
            }
            if (formula.trim().endsWith("/")) {
                return true;
            }
            try {
                Parser.parse(formula).evaluate();
            }
            catch (ParseException e) {
                logger.error("\u8868\u8fbe\u5f0f\u89e3\u6790\u51fa\u9519\u3002", (Throwable)e);
            }
            catch (ArithmeticException e) {
                if (!"/ by zero".equals(e.getMessage())) break block5;
                return true;
            }
        }
        return false;
    }

    public static boolean isDenominatorZerothrows(String formula) throws Exception {
        logger.info("\u5143\u7d20\u8868\u8fbe\u5f0f\u7684\u503c\u4e3a\uff1a" + formula);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)formula)) {
            return false;
        }
        if (formula.trim().endsWith("/")) {
            return true;
        }
        Parser.parse(formula).evaluate();
        return false;
    }
}

