/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.common.element;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tctrc.common.element.ElementSqlService;
import kd.taxc.tctrc.common.element.TimeDeviatedEnum;
import kd.taxc.tctrc.common.helper.LicenseCheckServiceHelper;
import kd.taxc.tctrc.common.task.RiskService;
import kd.taxc.tctrc.common.util.DateUtils;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;

public class RiskCalculateCommonSerivce {
    private static final String RISK_RUN_LIST = "tctrc_risk_run_list";
    private static Log logger = LogFactory.getLog(RiskCalculateCommonSerivce.class);

    public static void calculate(Map<String, Object> params) {
        logger.info("RiskCalculateCommonSerivce calculate params:" + SerializationUtils.toJsonString(params));
        RiskCalculateCommonSerivce.task(RiskCalculateCommonSerivce.getRunIdList(params), params.get("skssqq").toString(), params.getOrDefault("skssqz", "").toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void task(List<Long> list, String startDate, String endDate) {
        logger.info("\u5f00\u59cb\u6267\u884c\u5373\u65f6\u8ba1\u7b97\u4efb\u52a1.." + Arrays.toString(list.toArray()));
        if (EmptyCheckUtils.isEmpty(list)) {
            return;
        }
        Map<String, DynamicObject> eleCode2InfoMap = ElementSqlService.queryAllEnableEleInfoMap();
        try (TXHandle txHandle = TX.required();){
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)RISK_RUN_LIST);
            ArrayList<Long> hasRightOrgIds = new ArrayList<Long>(10);
            ArrayList<Long> noRightOrgIds = new ArrayList<Long>(10);
            long count = 0L;
            for (Long id : list) {
                DynamicObject objArray = BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)type);
                Long orgid = objArray.getLong("runorg.id");
                if (noRightOrgIds.contains(orgid)) {
                    logger.info("\u8df3\u8fc7\u8bb0\u5f55 fid [" + id + "] ,\u8bb0\u5f55\u7684\u8fd0\u884c\u7ec4\u7ec7\u672a\u6388\u6743\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6388\u6743");
                    continue;
                }
                if (!hasRightOrgIds.contains(orgid)) {
                    if (RiskCalculateCommonSerivce.licenseCheck(objArray)) {
                        noRightOrgIds.add(orgid);
                        logger.info("\u8df3\u8fc7\u8bb0\u5f55 fid [" + id + "] ,\u8bb0\u5f55\u7684\u8fd0\u884c\u7ec4\u7ec7\u672a\u6388\u6743\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6388\u6743");
                        continue;
                    }
                    hasRightOrgIds.add(orgid);
                }
                ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>(10);
                DynamicObject risk = objArray.getDynamicObject("risk");
                String caltype = risk.getString("caltype");
                int deviatedcount = EmptyCheckUtils.isEmpty(risk.getString("deviatedcount")) ? 0 : Integer.parseInt(risk.getString("deviatedcount"));
                Date calStartDate = DateUtils.stringToDate(TimeDeviatedEnum.getDeviatedDate(startDate, "-", deviatedcount, caltype));
                Date calEndDate = DateUtils.stringToDate(TimeDeviatedEnum.getDeviatedDate(endDate, "-", deviatedcount, caltype));
                RiskService.cal(null, resultList, new DynamicObject[]{objArray}, calStartDate, calEndDate, ResManager.loadKDString((String)"\u5b9a\u65f6\u8ba1\u7b97\u8fd0\u884c", (String)"RiskCalTask_0", (String)"taxc-tctrc-business", (Object[])new Object[0]), Boolean.TRUE, eleCode2InfoMap);
                ++count;
            }
            logger.info("\u4efb\u52a1\u6267\u884c\u6210\u529f : \u4e00\u5171\u6267\u884c\u3010" + count + "\u3011\u6761,\u8df3\u8fc7\u3010" + ((long)list.size() - count) + "\u3011\u6761\u3002\u5171\u8ba1\u3010" + list.size() + "\u3011\u6761");
            logger.info("\u7ed3\u675f");
        }
    }

    private static boolean licenseCheck(DynamicObject object) {
        if (LicenseCheckServiceHelper.check(object.getString("runorg.id"), null, "tctrc")) {
            return true;
        }
        logger.info("license\u6821\u9a8c\u901a\u8fc7 orgid" + object.getString("runorg.id"));
        return false;
    }

    private static List<Long> getRunIdList(Map<String, Object> params) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        QFilter orgFilter = new QFilter("runorg", "=", params.getOrDefault("orgid", ""));
        QFilter templateTypeFilter = new QFilter("risk.sbbtype.fbasedataid", "=", params.getOrDefault("templatetype", ""));
        qFilterList.add(orgFilter);
        qFilterList.add(templateTypeFilter);
        if (EmptyCheckUtils.isNotEmpty(params.get("modelid"))) {
            QFilter draftPurposeFilter = new QFilter("risk.draftpurpose", "=", params.getOrDefault("draftpurpose", ""));
            QFilter taxtypeFilter = new QFilter("risk.taxtypemul.fbasedataid", "=", (Object)Long.parseLong(params.getOrDefault("taxcategory", "0").toString()));
            qFilterList.add(draftPurposeFilter);
            qFilterList.add(taxtypeFilter);
        }
        List list = QueryServiceHelper.queryPrimaryKeys((String)RISK_RUN_LIST, (QFilter[])qFilterList.toArray(new QFilter[0]), null, (int)-1);
        return list.stream().map(v -> Long.parseLong(v.toString())).collect(Collectors.toList());
    }
}

