/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.common.element;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.tctrc.common.cal.CalculateService;
import kd.taxc.tctrc.common.element.ElementSqlService;
import kd.taxc.tctrc.common.element.RiskCalSerivce;
import kd.taxc.tctrc.common.element.TimeDeviatedEnum;
import kd.taxc.tctrc.common.entity.ElementDependencyElementDo;
import kd.taxc.tctrc.common.enums.RiskCalTimeEnum;
import kd.taxc.tctrc.common.util.BigDecimalUtil;
import kd.taxc.tctrc.common.util.DateUtils;
import kd.taxc.tctrc.common.util.ElementUtil;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;

public class RiskElementSqlService
extends ElementSqlService {
    private static Log logger = LogFactory.getLog(RiskElementSqlService.class);

    @Override
    protected String getUserType() {
        return "0";
    }

    @Override
    public Map<String, String> calElement(Map<String, String> codeNameMappings, Map<String, DynamicObject> eleCode2InfoMap, Map<String, Map<String, String>> eleKey2EleResultMap, List<DynamicObject> elementResultList, String orgid, String code, String originalStartDate, String startDateStr, String endDateStr, String topdatatype) {
        String key = this.getKey(orgid, code, startDateStr, endDateStr);
        logger.info("\u5f00\u59cb\u91cd\u65b0\u8ba1\u7b97\u5143\u7d20 key = " + key);
        if (null != eleKey2EleResultMap && null != eleKey2EleResultMap.get(key)) {
            logger.info("query for local cache : key = " + key);
            return eleKey2EleResultMap.get(key);
        }
        DynamicObject element = eleCode2InfoMap.get(code);
        HashMap<String, String> elementResultMap = new HashMap<String, String>();
        if (element != null) {
            String json;
            String bottom = element.getString("bottom");
            String elementName = element.getString("name");
            Long eleId = element.getLong("id");
            Date runtime = new Date();
            String risktimedeviationtype = element.getString("risktimedeviationtype");
            String startDateStr2 = startDateStr;
            String endDateStr2 = endDateStr;
            String dataType = element.getString("datatype");
            RiskCalTimeEnum riskCalTimeEnum = RiskCalTimeEnum.getEnumByFieldId(risktimedeviationtype);
            if (null != riskCalTimeEnum && RiskCalTimeEnum.NONE != riskCalTimeEnum) {
                TimeDeviatedEnum enumByDeviatedType = TimeDeviatedEnum.getEnumByDeviatedType(topdatatype);
                if (RiskCalTimeEnum.TB == riskCalTimeEnum) {
                    enumByDeviatedType = TimeDeviatedEnum.TIME_DEVIATION_YEAR;
                }
                int month = null == enumByDeviatedType ? 0 : enumByDeviatedType.getDeviatedCount();
                startDateStr2 = DateUtils.format(DateUtils.getFirstDateOfMonth(DateUtils.addMonth(DateUtils.stringToDate(startDateStr2), -month)));
                endDateStr2 = DateUtils.format(DateUtils.getLastDateOfMonth(DateUtils.addMonth(DateUtils.stringToDate(endDateStr2), -month)));
            }
            String deviatedStartDate = TimeDeviatedEnum.getDeviatedDateByMonth(startDateStr2, 0, "-");
            deviatedStartDate = DateUtils.format(DateUtils.getFirstDateOfMonth(DateUtils.stringToDate(deviatedStartDate)));
            String deviatedEndDate = TimeDeviatedEnum.getDeviatedDateByMonth(endDateStr2, 0, "-");
            deviatedEndDate = DateUtils.format(DateUtils.getLastDateOfMonth(DateUtils.stringToDate(deviatedEndDate)));
            String deviatedOriginalStartDate = DateUtils.format(DateUtils.getFirstDateOfYear(DateUtils.stringToDate(deviatedEndDate)));
            String jsonTag = element.getString("json_tag");
            Long taxType = element.getLong("taxtype");
            String draftPurpose = element.getString("draftpurpose");
            if ("true".equals(bottom)) {
                boolean isEmptyField = true;
                Map<String, Object> resMap = RiskElementSqlService.querySql(jsonTag, orgid, deviatedOriginalStartDate, deviatedStartDate, deviatedEndDate, dataType, taxType, draftPurpose);
                BigDecimal elementResultValue = null;
                Map eleDateMap = EmptyCheckUtils.isNotEmpty(resMap.get("eledatekey")) ? (Map)resMap.get("eledatekey") : new HashMap();
                if (EmptyCheckUtils.isEmpty(resMap) || EmptyCheckUtils.isEmpty(resMap.get("elevalkey"))) {
                    logger.info("=========== \u672a\u67e5\u8be2\u5230\u6570\u636e======");
                } else {
                    List vals = (List)resMap.get("elevalkey");
                    for (BigDecimal bigDecimal : vals) {
                        elementResultValue = BigDecimalUtil.addObject(elementResultValue, bigDecimal);
                        if (null == bigDecimal) continue;
                        isEmptyField = false;
                    }
                }
                String value = EmptyCheckUtils.isEmpty(elementResultValue) ? "null" : BigDecimalUtil.setScale(elementResultValue, 4).toPlainString();
                elementResultMap.put("value", value);
                elementResultMap.put("isEmptyField", String.valueOf(isEmptyField));
                this.addNoRepeatElementResultList(elementResultList, orgid, code, startDateStr, endDateStr, elementName, eleId, runtime, value, isEmptyField, false, eleKey2EleResultMap, eleDateMap);
                String key1 = this.getKey(orgid, code, startDateStr, endDateStr);
                if (null != key1 && key1.trim().length() > 0) {
                    eleKey2EleResultMap.put(key1, elementResultMap);
                }
                return elementResultMap;
            }
            HashMap<String, Date> eleDateMap = new HashMap<String, Date>(8);
            eleDateMap.put("elestartdate", DateUtils.getFirstDateOfMonth(DateUtils.stringToDate(startDateStr2)));
            eleDateMap.put("eleenddate", DateUtils.getLastDateOfMonth(DateUtils.stringToDate(endDateStr2)));
            String temp = json = (String)((Map)SerializationUtils.fromJsonString((String)jsonTag, Map.class)).get("formula");
            boolean isEmptyField = true;
            List<ElementDependencyElementDo> elementDependencyElements = ElementUtil.parseElementDependencyElement(json, eleCode2InfoMap);
            for (ElementDependencyElementDo elementDependencyElement : elementDependencyElements) {
                Map<String, String> map = this.calElement(codeNameMappings, eleCode2InfoMap, eleKey2EleResultMap, elementResultList, orgid, elementDependencyElement.getElementCode(), originalStartDate, startDateStr, endDateStr, topdatatype);
                String value = map.get("value");
                if (!"true".equals(map.get("isEmptyField"))) {
                    isEmptyField = false;
                }
                if (value == null) continue;
                value = "null".equalsIgnoreCase(value) ? "0" : value;
                String originalValue = json.substring(elementDependencyElement.getStartIndex(), elementDependencyElement.getEndIndex());
                temp = temp.replace(originalValue, value);
            }
            boolean isDenominatorZero = RiskCalSerivce.isDenominatorZero(temp);
            String value = isEmptyField || isDenominatorZero ? "null" : BigDecimalUtil.setScale(CalculateService.calculate(temp), 4).toPlainString();
            elementResultMap.put("value", value);
            elementResultMap.put("isEmptyField", String.valueOf(isEmptyField));
            elementResultMap.put("isDenominatorZero", String.valueOf(isDenominatorZero));
            this.addNoRepeatElementResultList(elementResultList, orgid, code, startDateStr, endDateStr, elementName, eleId, runtime, value, isEmptyField, isDenominatorZero, eleKey2EleResultMap, eleDateMap);
            eleKey2EleResultMap.put(key, elementResultMap);
            return elementResultMap;
        }
        return elementResultMap;
    }
}

