/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.common.element;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tctrc.common.element.RiskElementSqlService;
import kd.taxc.tctrc.common.element.TimeDeviatedEnum;
import kd.taxc.tctrc.common.element.impl.NumberCalService;
import kd.taxc.tctrc.common.util.BigDecimalUtil;
import kd.taxc.tctrc.common.util.DateUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class VariableService {
    private static final String TRUE_STRING = "true";
    private static final String VALUE = "value";
    private static final String IS_EMPTY_FIELD = "isEmptyField";

    public static int getMonthDifference(String startDateStr, String endDateStr) {
        Date startDate = DateUtils.stringToDate(startDateStr);
        Date endDate = DateUtils.stringToDate(endDateStr);
        return DateUtils.getMonthDiff(endDate, startDate);
    }

    public static Integer getElementDeviatedMonth(String elementNumber) {
        QFilter codeFilter = new QFilter("number", "=", (Object)elementNumber);
        DynamicObject element = QueryServiceHelper.queryOne((String)"tdm_element_group", (String)"id,name,json_tag,bottom,timedeviationcount,timedeviationtype,timedeviationdirection,autorefresh,isvariable,describe", (QFilter[])new QFilter[]{codeFilter});
        int deviatedMonth = 0;
        if (element != null) {
            String deviationType = element.getString("timedeviationtype");
            String deviationDirection = element.getString("timedeviationdirection");
            int timeDeviationCount = element.getInt("timedeviationcount");
            deviatedMonth = TimeDeviatedEnum.getDeviatedMonth(deviationDirection, timeDeviationCount, deviationType);
        }
        return deviatedMonth * -1;
    }

    public static String replaceVariable(Map<String, DynamicObject> eleCode2InfoMap, String orgid, String explain, String originalStartDate, String startDateStr, String endDateStr, String calType) {
        if (explain == null) {
            return null;
        }
        while (explain.contains("${") && explain.contains("}")) {
            String[] splitStrArr = explain.split("[$][{]");
            String variableNumber = splitStrArr[1].split("}")[0];
            String value = VariableService.calculateVariableValue(eleCode2InfoMap, orgid, originalStartDate, startDateStr, endDateStr, variableNumber, calType);
            if (value != null) {
                value = BigDecimalUtil.setScale(value, 4).toString();
                explain = explain.replaceFirst("[$][{][^$]*}", value);
                continue;
            }
            explain = explain.replaceFirst("[$][{][^$]*}", ResManager.loadKDString((String)"\u4e3a\u7a7a", (String)"VariableService_0", (String)"taxc-tctrc-common", (Object[])new Object[0]));
        }
        return explain;
    }

    public static String calculateVariableValue(Map<String, DynamicObject> eleCode2InfoMap, String orgid, String originalStartDate, String startDateStr, String endDateStr, String variableNumber, String calType) {
        if (StringUtils.isEmpty((CharSequence)variableNumber)) {
            return variableNumber;
        }
        String[] splitStr = variableNumber.split("_");
        String type = ResManager.loadKDString((String)"\u5143\u7d20", (String)"VariableService_1", (String)"taxc-tctrc-common", (Object[])new Object[0]);
        int deviationCount = 0;
        if (splitStr.length > 1) {
            type = splitStr[1];
        }
        if (splitStr.length > 2) {
            deviationCount = NumberUtils.toInt((String)splitStr[2]);
        }
        String value = null;
        if (ResManager.loadKDString((String)"\u5143\u7d20", (String)"VariableService_1", (String)"taxc-tctrc-common", (Object[])new Object[0]).equals(type)) {
            Map<String, String> map = VariableService.calElementVariable(eleCode2InfoMap, orgid, variableNumber, originalStartDate, startDateStr, endDateStr, calType);
            value = map.get(VALUE);
            String isEmptyField = map.get(IS_EMPTY_FIELD);
            if (TRUE_STRING.equals(isEmptyField) && BigDecimal.ZERO.compareTo(BigDecimalUtil.toBigDecimal(value)) == 0) {
                value = null;
            }
        } else if (ResManager.loadKDString((String)"\u98ce\u9669", (String)"VariableService_2", (String)"taxc-tctrc-common", (Object[])new Object[0]).equals(type)) {
            value = VariableService.calRiskVariable(eleCode2InfoMap, orgid, variableNumber, originalStartDate, startDateStr, endDateStr);
        }
        return value;
    }

    public static String calRiskVariable(Map<String, DynamicObject> eleCode2InfoMap, String orgid, String variableNumber, String originalStartDate, String startDateStr, String endDateStr) {
        String variableValue = null;
        QFilter qFilter = new QFilter("number", "=", (Object)variableNumber);
        DynamicObject variable = QueryServiceHelper.queryOne((String)"tctrc_variable_info", (String)"id,name,number,risknumber,selectednumber,rowid,orderno,bottom,json,timedeviationcount,timedeviationtype,timedeviationdirection", (QFilter[])new QFilter[]{qFilter});
        if (variable != null) {
            String riskNumber = variable.getString("selectednumber");
            String deviationType = variable.getString("timedeviationtype");
            String deviationDirection = variable.getString("timedeviationdirection");
            int timeDeviationCount = variable.getInt("timedeviationcount");
            int monthDiff = VariableService.getMonthDifference(startDateStr, endDateStr);
            startDateStr = TimeDeviatedEnum.getDeviatedDate(startDateStr, deviationDirection, timeDeviationCount, deviationType);
            Date lastDateOfMonth = DateUtils.getLastDateOfMonth(DateUtils.stringToDate(startDateStr));
            endDateStr = DateUtils.format(DateUtils.addMonth(lastDateOfMonth, monthDiff));
            NumberCalService numberCalService = new NumberCalService();
            Map<String, String> map = numberCalService.calVerify(eleCode2InfoMap, null, orgid, riskNumber, originalStartDate, startDateStr, endDateStr);
            variableValue = map.get("result");
            if (TRUE_STRING.equals(map.get("isDenominatorZero")) || TRUE_STRING.equals(map.get(IS_EMPTY_FIELD))) {
                variableValue = null;
            }
            return variableValue;
        }
        return variableValue;
    }

    public static Map<String, String> calElementVariable(Map<String, DynamicObject> eleCode2InfoMap, String orgid, String variableNumber, String originalStartDate, String startDateStr, String endDateStr, String calType) {
        ArrayList<DynamicObject> elementResultList = new ArrayList<DynamicObject>();
        Map<String, String> map = new HashMap<String, String>();
        QFilter qFilter = new QFilter("number", "=", (Object)variableNumber);
        DynamicObject variable = QueryServiceHelper.queryOne((String)"tctrc_variable_info", (String)"id,number,name,risknumber,selectednumber,rowid,orderno,bottom,json,timedeviationcount,timedeviationtype,timedeviationdirection", (QFilter[])new QFilter[]{qFilter});
        if (variable != null) {
            String elementNumber = variable.getString("selectednumber");
            String deviationType = variable.getString("timedeviationtype");
            String deviationDirection = variable.getString("timedeviationdirection");
            int timeDeviationCount = variable.getInt("timedeviationcount");
            int monthDiff = VariableService.getMonthDifference(startDateStr, endDateStr);
            startDateStr = TimeDeviatedEnum.getDeviatedDate(startDateStr, deviationDirection, timeDeviationCount, deviationType);
            Integer deviatedMonth = VariableService.getElementDeviatedMonth(elementNumber);
            Date calDate = DateUtils.addMonth(DateUtils.stringToDate(startDateStr), deviatedMonth);
            startDateStr = DateUtils.format(calDate);
            Date lastDateOfMonth = DateUtils.getLastDateOfMonth(DateUtils.stringToDate(startDateStr));
            endDateStr = DateUtils.format(DateUtils.addMonth(lastDateOfMonth, monthDiff));
            HashMap<String, Map<String, String>> eleKey2EleResultMap = new HashMap<String, Map<String, String>>(16);
            RiskElementSqlService riskElementSqlService = new RiskElementSqlService();
            map = riskElementSqlService.calElement(eleCode2InfoMap, eleKey2EleResultMap, elementResultList, orgid, elementNumber, originalStartDate, startDateStr, endDateStr, calType);
        }
        return map;
    }
}

