/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.common.element.factory;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tctrc.common.element.TimeDeviatedEnum;
import kd.taxc.tctrc.common.element.factory.AbstractElementSqlService;
import kd.taxc.tctrc.common.enums.BalanceFieldEnum;
import kd.taxc.tctrc.common.util.BigDecimalUtil;
import kd.taxc.tctrc.common.util.CalUtils;
import kd.taxc.tctrc.common.util.DateUtils;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;
import kd.taxc.tctrc.common.util.FilterBuilderUtils;

public class ElementSqlServiceByFinance
extends AbstractElementSqlService {
    @Override
    public DynamicObjectCollection queryElement(String orgid, Date startDate, Date endDate, Map<String, String> map, DynamicObject orgstate, DynamicObject datastate, String name, String subname, String selectFields, String tabletype, DynamicObject yearstate, DynamicObject monthstate, String startDateStr, String endDateStr, String dataType) {
        return this.queryDataByDefaultWay(orgid, startDate, endDate, map, orgstate, datastate, name, selectFields, yearstate, monthstate, startDateStr, endDateStr, dataType);
    }

    @Override
    public BigDecimal queryElementByBalance(String orgid, Date startDate, Date endDate, Map<String, String> ruleMap, DynamicObject orgstate, DynamicObject datastate, String name, String subname, String selectFields, String tabletype, DynamicObject yearstate, DynamicObject monthstate, String startDateStr, String endDateStr, String dataType) {
        String jineziduan = ruleMap.get("fieldidd");
        if (Arrays.stream(BalanceFieldEnum.values()).map(BalanceFieldEnum::getFieldId).anyMatch(v -> v.equalsIgnoreCase(jineziduan))) {
            BalanceFieldEnum balanceFieldEnum = BalanceFieldEnum.getEnumByFieldId(jineziduan);
            return this.doQueryElement(balanceFieldEnum, orgid, startDate, endDate, ruleMap, orgstate, datastate, name, selectFields, yearstate, monthstate, startDateStr, endDateStr, dataType);
        }
        return this.doQueryElementByDefault(orgid, startDate, endDate, ruleMap, orgstate, datastate, name, selectFields, yearstate, monthstate, startDateStr, endDateStr, dataType);
    }

    private BigDecimal doQueryElementByDefault(String orgid, Date startDate, Date endDate, Map<String, String> ruleMap, DynamicObject orgstate, DynamicObject datastate, String name, String selectFields, DynamicObject yearstate, DynamicObject monthstate, String startDateStr, String endDateStr, String dataType) {
        QFilter org = new QFilter(orgstate.getString("entryentity.fieldname"), "=", (Object)Long.parseLong(orgid));
        List<Map<String, Date>> calDateMapList = CalUtils.getCalDate(TimeDeviatedEnum.TIME_DEVIATION_MONTH.getDeviatedType(), DateUtils.getFirstDateOfMonth(startDate), DateUtils.getLastDateOfMonth(endDate));
        QFilter q = FilterBuilderUtils.buildFilter(EmptyCheckUtils.isEmpty(ruleMap.get("filterjsond")) ? ruleMap.get("filterJson") : ruleMap.get("filterjsond"), name);
        DynamicObjectCollection dynamicObjects = null;
        ArrayList<Integer> months = new ArrayList<Integer>(32);
        for (Map<String, Date> calDateMap : calDateMapList) {
            months.add(DateUtils.getMonthOfDate(calDateMap.get("startdate")));
            QFilter skssqq = new QFilter("period.begindate", "<=", (Object)calDateMap.get("startdate"));
            QFilter skssqz = new QFilter("endperiod.enddate", ">", (Object)DateUtils.getLastDateOfMonth(calDateMap.get("enddate")));
            skssqz.or("endperiod", "=", (Object)99999999999L);
            DynamicObjectCollection dynamicObjects2 = QueryServiceHelper.query((String)name, (String)(selectFields + ",period.begindate"), (QFilter[])new QFilter[]{org, skssqq, skssqz, q});
            if (null == dynamicObjects && EmptyCheckUtils.isNotEmpty(dynamicObjects2)) {
                dynamicObjects = dynamicObjects2;
                continue;
            }
            if (null == dynamicObjects || !EmptyCheckUtils.isNotEmpty(dynamicObjects2)) continue;
            List ids = dynamicObjects.stream().map(v -> v.getLong("id")).distinct().collect(Collectors.toList());
            for (DynamicObject d : dynamicObjects2) {
                if (ids.contains(d.getLong("id"))) continue;
                dynamicObjects.add((Object)d);
                ids.add(d.getLong("id"));
            }
        }
        if (dynamicObjects == null || dynamicObjects.size() == 0) {
            return null;
        }
        BigDecimal qichu = BigDecimal.ZERO;
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (!this.inss(dynamicObject, months)) continue;
            qichu = BigDecimalUtil.addObject(qichu, dynamicObject.getBigDecimal(0));
        }
        return qichu;
    }

    private BigDecimal doQueryElement(BalanceFieldEnum balanceFieldEnum, String orgid, Date startDate, Date endDate, Map<String, String> ruleMap, DynamicObject orgstate, DynamicObject datastate, String name, String selectFields, DynamicObject yearstate, DynamicObject monthstate, String startDateStr, String endDateStr, String dataType) {
        QFilter org = new QFilter(orgstate.getString("entryentity.fieldname"), "=", (Object)Long.parseLong(orgid));
        List<Map<String, Date>> calDateMapList = CalUtils.getCalDate(TimeDeviatedEnum.TIME_DEVIATION_MONTH.getDeviatedType(), DateUtils.getFirstDateOfMonth(startDate), DateUtils.getLastDateOfMonth(endDate));
        QFilter q = FilterBuilderUtils.buildFilter(EmptyCheckUtils.isEmpty(ruleMap.get("filterjsond")) ? ruleMap.get("filterJson") : ruleMap.get("filterjsond"), name);
        DynamicObjectCollection dynamicObjects = null;
        ArrayList<Integer> months = new ArrayList<Integer>(32);
        for (Map<String, Date> calDateMap : calDateMapList) {
            months.add(DateUtils.getMonthOfDate(calDateMap.get("startdate")));
            QFilter skssqq = new QFilter("period.begindate", "<=", (Object)calDateMap.get("startdate"));
            QFilter skssqz = new QFilter("endperiod.enddate", ">", (Object)DateUtils.getLastDateOfMonth(calDateMap.get("enddate")));
            skssqz.or("endperiod", "=", (Object)99999999999L);
            DynamicObjectCollection dynamicObjects2 = QueryServiceHelper.query((String)name, (String)("id," + balanceFieldEnum.getSelectField()), (QFilter[])new QFilter[]{org, skssqq, skssqz, q});
            if (null == dynamicObjects && EmptyCheckUtils.isNotEmpty(dynamicObjects2)) {
                dynamicObjects = dynamicObjects2;
                continue;
            }
            if (null == dynamicObjects || !EmptyCheckUtils.isNotEmpty(dynamicObjects2)) continue;
            List ids = dynamicObjects.stream().map(v -> v.getLong("id")).distinct().collect(Collectors.toList());
            for (DynamicObject d : dynamicObjects2) {
                if (ids.contains(d.getLong("id"))) continue;
                dynamicObjects.add((Object)d);
                ids.add(d.getLong("id"));
            }
        }
        if (dynamicObjects == null || dynamicObjects.size() == 0) {
            return null;
        }
        BigDecimal qichu = BigDecimal.ZERO;
        BigDecimal qimo = BigDecimal.ZERO;
        Boolean isNeedAddQiMo = EmptyCheckUtils.isNotEmpty(balanceFieldEnum.getElseFieldCode());
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (this.inss(dynamicObject, months)) {
                qichu = BigDecimalUtil.addObject(qichu, dynamicObject.get(balanceFieldEnum.getFieldCode()));
                continue;
            }
            if (!isNeedAddQiMo.booleanValue()) continue;
            qimo = BigDecimalUtil.addObject(qimo, dynamicObject.get(balanceFieldEnum.getElseFieldCode()));
        }
        if (isNeedAddQiMo.booleanValue()) {
            qichu = BigDecimalUtil.addObject(qichu, qimo);
        }
        return qichu;
    }

    private boolean inss(DynamicObject dynamicObject, List<Integer> months) {
        Date date = dynamicObject.getDate("period.begindate");
        return months.contains(DateUtils.getMonthOfDate(date));
    }
}

