/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.common.element.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tctrc.common.element.factory.AbstractElementSqlService;
import kd.taxc.tctrc.common.enums.TableTypeMapTemplateTypeEnum;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;
import kd.taxc.tctrc.common.util.FilterBuilderUtils;
import org.apache.commons.lang3.StringUtils;

public class ElementSqlServiceByMain
extends AbstractElementSqlService {
    private static final List<String> SPECAIL_LIST = Collections.singletonList("bdtaxr_pay_record");

    @Override
    public DynamicObjectCollection queryElement(String orgid, Date startDate, Date endDate, Map<String, String> ruleMap, DynamicObject orgstate, DynamicObject datastate, String name, String subname, String selectFields, String tabletype, DynamicObject yearstate, DynamicObject monthstate, String startDateStr, String endDateStr, String dataType) {
        QFilter nrxtype;
        QFilter org = new QFilter(orgstate.getString("entryentity.fieldname"), "=", (Object)Long.parseLong(orgid));
        QFilter skssqq = new QFilter(datastate.getString("entryentity.fieldname"), ">=", (Object)startDate);
        QFilter skssqz = new QFilter(datastate.getString("entryentity.fieldname"), "<=", (Object)endDate);
        boolean isCCXWS = false;
        boolean isSepcail = false;
        if (StringUtils.isNotEmpty((CharSequence)subname)) {
            TableTypeMapTemplateTypeEnum typeEnum = TableTypeMapTemplateTypeEnum.getEnumByTableType(tabletype);
            if (null != typeEnum) {
                isCCXWS = TableTypeMapTemplateTypeEnum.CCXWS == typeEnum;
                isSepcail = SPECAIL_LIST.contains(subname.toLowerCase());
                if ("tcret_ccxws_info".equalsIgnoreCase(subname)) {
                    isCCXWS = false;
                }
                nrxtype = new QFilter("type", "=", (Object)typeEnum.getTemplateType());
            } else {
                QFilter entryid = new QFilter("entryentity.entityid", "=", (Object)subname);
                DynamicObjectCollection typeCollection = QueryServiceHelper.query((String)"tctb_template_type", (String)"id", (QFilter[])new QFilter[]{entryid});
                if (null == typeCollection) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e entryentity.entityid =%s\uff0c\u67e5\u8be2 tctb_template_type \u4e0d\u5b58\u5728 \u3002", (String)"ElementSqlServiceByMain_4", (String)"taxc-tctrc-common", (Object[])new Object[0]), subname));
                }
                if (typeCollection.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e entryentity.entityid =%s\uff0c\u67e5\u8be2 tctb_template_type \u5b58\u5728\u591a\u6761\u8bb0\u5f55 \u3002", (String)"ElementSqlServiceByMain_5", (String)"taxc-tctrc-common", (Object[])new Object[0]), subname));
                }
                nrxtype = new QFilter("type", "=", ((DynamicObject)typeCollection.get(0)).get(0));
            }
        } else {
            QFilter entryid = new QFilter("entryentity.entityid", "=", (Object)subname);
            DynamicObjectCollection type = QueryServiceHelper.query((String)"tctb_template_type", (String)"id", (QFilter[])new QFilter[]{entryid});
            nrxtype = new QFilter("type", "=", ((DynamicObject)type.get(0)).get(0));
        }
        DynamicObjectCollection fidCollection = isCCXWS || isSepcail ? QueryServiceHelper.query((String)name, (String)"id", (QFilter[])new QFilter[]{org, nrxtype}) : QueryServiceHelper.query((String)name, (String)"id", (QFilter[])new QFilter[]{org, skssqq, skssqz, nrxtype});
        if (EmptyCheckUtils.isNotEmpty(fidCollection)) {
            QFilter q;
            ArrayList<String> sbbids = new ArrayList<String>();
            for (DynamicObject dynamicObject : fidCollection) {
                sbbids.add(dynamicObject.getString("id"));
            }
            QFilter filter = new QFilter("sbbid", "in", sbbids);
            if (isCCXWS || isSepcail) {
                filter.and(skssqq).and(skssqz);
            }
            if ((q = FilterBuilderUtils.buildFilter(EmptyCheckUtils.isEmpty(ruleMap.get("filterjsond")) ? ruleMap.get("filterJson") : ruleMap.get("filterjsond"), subname)) != null) {
                filter = filter.and(q);
            }
            return QueryServiceHelper.query((String)subname, (String)selectFields, (QFilter[])new QFilter[]{filter});
        }
        return new DynamicObjectCollection();
    }

    @Override
    public List<String> findSelectFieldList(boolean ischild, List<DynamicObject> fields, String name, String subname, Map<String, String> ruleMap) {
        ArrayList<String> selectFieldList = new ArrayList<String>(fields.size());
        for (DynamicObject field : fields) {
            String tbFlag = field.getString("entryentity.fieldsubname");
            String fieldname = field.getString("entryentity.fieldname");
            if (!subname.trim().equalsIgnoreCase(tbFlag.trim())) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u91d1\u989d\u5b57\u6bb5\u4e0d\u80fd\u6709\u4e3b\u8868\u5b57\u6bb5zhubiaosubname:%1$s;fieldsubname:%2$s", (String)"ElementSqlServiceByMain_3", (String)"taxc-tctrc-common", (Object[])new Object[0]), subname, tbFlag));
            }
            if (selectFieldList.contains(fieldname)) continue;
            selectFieldList.add(fieldname);
        }
        QFilter qFilter = FilterBuilderUtils.buildFilter(EmptyCheckUtils.isEmpty(ruleMap.get("filterjsond")) ? ruleMap.get("filterJson") : ruleMap.get("filterjsond"), subname);
        if (null != qFilter) {
            List qFilters;
            if (!selectFieldList.contains(qFilter.getProperty())) {
                selectFieldList.add(qFilter.getProperty());
            }
            if (EmptyCheckUtils.isNotEmpty(qFilters = qFilter.getNests(true))) {
                for (QFilter.QFilterNest filterNest : qFilters) {
                    String field = filterNest.getFilter().getProperty();
                    if (selectFieldList.contains(field)) continue;
                    selectFieldList.add(field);
                }
            }
        }
        selectFieldList.add("id");
        return selectFieldList;
    }
}

