/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.common.element.factory;

import java.util.HashSet;
import java.util.Set;
import kd.taxc.tctrc.common.element.factory.ElementSqlService;
import kd.taxc.tctrc.common.element.factory.ElementSqlServiceByFinance;
import kd.taxc.tctrc.common.element.factory.ElementSqlServiceByMain;
import kd.taxc.tctrc.common.element.factory.ElementSqlServiceByMultiData;
import kd.taxc.tctrc.common.element.factory.ElementSqlServiceByParentDefault;
import kd.taxc.tctrc.common.element.factory.ElementSqlServiceBySubDefault;
import kd.taxc.tctrc.common.element.factory.ElementSqlServiceBySummary;

public class ElementSqlServiceFactory {
    private static final Set<String> serviceByMainList = new HashSet<String>(){
        {
            this.add("tcvat_nsrxx");
            this.add("tdm_finance_main");
        }
    };
    private static final Set<String> serviceBySummaryList = new HashSet<String>(){
        {
            this.add("tcvat_account_summary");
            this.add("tcvat_deduction_summary");
            this.add("tcvat_diffdeduct_temp");
            this.add("tcvat_roll_out_summary");
            this.add("tcvat_income_add_temp");
        }
    };
    private static final Set<String> serviceByFinance = new HashSet<String>(){};
    private static final Set<String> serviceCustomDataSourceHelper = new HashSet<String>(){
        {
            this.add("tpo_declare_main_tsd");
            this.add("tpo_declare_main_tsc");
            this.add("itp_proviston_taxes");
            this.add("gl_balance");
            this.add("tdm_balance_new");
        }
    };

    public static ElementSqlService factory(boolean ischild, String name) {
        if (!ischild) {
            if (serviceByMainList.contains(name.toLowerCase())) {
                return new ElementSqlServiceByMain();
            }
            if (serviceBySummaryList.contains(name.toLowerCase())) {
                return new ElementSqlServiceBySummary();
            }
            if (serviceByFinance.contains(name.toLowerCase())) {
                return new ElementSqlServiceByFinance();
            }
            return new ElementSqlServiceByParentDefault();
        }
        if (serviceByFinance.contains(name.toLowerCase())) {
            return new ElementSqlServiceByFinance();
        }
        if (serviceCustomDataSourceHelper.contains(name.toLowerCase())) {
            return new ElementSqlServiceByMultiData();
        }
        return new ElementSqlServiceBySubDefault();
    }
}

