/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.common.element.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tctrc.common.cal.CalculateService;
import kd.taxc.tctrc.common.element.IRiskCalService;
import kd.taxc.tctrc.common.element.RiskCalSerivce;
import kd.taxc.tctrc.common.element.RiskElementSqlService;
import kd.taxc.tctrc.common.element.VariableService;
import kd.taxc.tctrc.common.util.BigDecimalUtil;
import kd.taxc.tctrc.common.util.ElementUtil;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;
import org.apache.commons.lang3.StringUtils;

public class NumberCalService
implements IRiskCalService {
    private static final String VALUE = "value";
    private static final String JSON = "json";
    private static final String IS_DENOMINATOR_ZERO = "isDenominatorZero";
    private static final String RESULT = "result";
    private static final String RISK_DESC = "riskdesc";
    private static final String RISK_LEVEL = "risklevel";
    private static final String RISK_SCORE = "riskscore";
    private static Log logger = LogFactory.getLog(NumberCalService.class);
    private static final String TYPE_NUMBER = "1";
    private static final String TYPE_RATE = "2";
    private static final String BORDER_NO_INCLUDE = "1";
    private static final String BORDER_INCLUDE = "2";
    private static final String IS_EMPTY_FIELD = "isEmptyField";

    @Override
    public Map<String, String> calVerify(Map<String, DynamicObject> eleCode2InfoMap, String resultid, String orgid, String riskCode, String originalStartDate, String startDate, String endDate) {
        HashMap<String, String> map = new HashMap<String, String>();
        QFilter code = new QFilter("number", "=", (Object)riskCode);
        DynamicObjectCollection riskDefinitionCollection = QueryServiceHelper.query((String)"tctrc_risk_definition", (String)"json,variableids,caltype,entryentity.itemid,entryentity.bmvalue1,entryentity.benchmarking1,entryentity.offset,entryentity.orgs1,entryentity.minborder,entryentity.range,entryentity.rangemax,entryentity.maxborder,entryentity.rlevel,entryentity.riskscore,entryentity.explain,entryentity.id ", (QFilter[])new QFilter[]{code});
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>();
        HashMap<String, Map<String, String>> eleKey2EleResultMap = new HashMap<String, Map<String, String>>(16);
        if (riskDefinitionCollection.size() > 0) {
            Map<String, String> codeNameMappings = ElementUtil.getCodeNameMappings(eleCode2InfoMap);
            String formula = ((DynamicObject)riskDefinitionCollection.get(0)).getString(JSON);
            String calType = ((DynamicObject)riskDefinitionCollection.get(0)).getString("caltype");
            logger.info("\u5143\u7d20\u8868\u8fbe\u5f0ffjson\uff1a" + formula);
            map.put(JSON, formula);
            boolean isEmptyField = true;
            if (StringUtils.isNotEmpty((CharSequence)formula)) {
                String[] expression = formula.split(" ");
                RiskElementSqlService riskElementSqlService = new RiskElementSqlService();
                for (String elementNumber : expression) {
                    String target = codeNameMappings.get(elementNumber);
                    if (!EmptyCheckUtils.isNotEmpty(target) || "+-*/()<><=>=abs(".contains(target)) continue;
                    Map<String, String> elementResultMap = riskElementSqlService.calElement(codeNameMappings, eleCode2InfoMap, eleKey2EleResultMap, dynamicObjectList, orgid, target, originalStartDate, startDate, endDate, calType);
                    String value = elementResultMap.get(VALUE);
                    if ("false".equals(elementResultMap.get(IS_EMPTY_FIELD)) || EmptyCheckUtils.isEmpty(elementResultMap)) {
                        isEmptyField = false;
                    }
                    if (value == null) continue;
                    value = "null".equalsIgnoreCase(value) ? "0" : value;
                    formula = formula.replace(elementNumber, value);
                }
            } else {
                formula = "0";
            }
            map.put(IS_EMPTY_FIELD, String.valueOf(isEmptyField));
            Boolean isDenominatorZero = RiskCalSerivce.isDenominatorZero(formula);
            map.put(IS_DENOMINATOR_ZERO, String.valueOf(isDenominatorZero));
            String riskResult = isDenominatorZero != false || isEmptyField ? "null" : BigDecimalUtil.setScale(BigDecimalUtil.toBigDecimal(CalculateService.calculate(formula)), 4).toPlainString();
            map.put(RESULT, riskResult);
            logger.info("\u5143\u7d20\u8868\u8fbe\u5f0f\u8ba1\u7b97\u7ed3\u679c\uff1a" + formula);
            boolean isRisk = false;
            if (!riskResult.equals("null")) {
                ArrayList<DynamicObject> defaultPianchaList = new ArrayList<DynamicObject>();
                ArrayList<DynamicObject> customPianchaList = new ArrayList<DynamicObject>();
                for (DynamicObject riskDefinition : riskDefinitionCollection) {
                    if (EmptyCheckUtils.isEmpty(riskDefinition.get("entryentity.itemid")) || "0".equals(riskDefinition.get("entryentity.itemid")) || EmptyCheckUtils.isEmpty(riskDefinition.get("entryentity.orgs1"))) {
                        defaultPianchaList.add(riskDefinition);
                        continue;
                    }
                    if (String.valueOf(riskDefinition.get("entryentity.orgs1")).indexOf(orgid) <= -1) continue;
                    customPianchaList.add(riskDefinition);
                }
                ArrayList<DynamicObject> pianchaList = EmptyCheckUtils.isEmpty(customPianchaList) ? defaultPianchaList : customPianchaList;
                for (DynamicObject riskDefinition : pianchaList) {
                    double bmValue;
                    String benchMarking;
                    double offsetResult = 0.0;
                    String offsetType = riskDefinition.getString("entryentity.offset");
                    if (!(isRisk = this.analyzeIsRisk(isRisk, riskDefinition, offsetResult = this.getOffsetResult(riskResult, offsetResult, offsetType, benchMarking = riskDefinition.getString("entryentity.benchmarking1"), bmValue = BigDecimalUtil.toBigDecimal(riskDefinition.getBigDecimal("entryentity.bmvalue1")).doubleValue())))) continue;
                    map.put(RISK_LEVEL, riskDefinition.getString("entryentity.rlevel"));
                    map.put(RISK_SCORE, riskDefinition.getString("entryentity.riskscore"));
                    String explain = riskDefinition.getString("entryentity.explain");
                    if (resultid != null) {
                        explain = VariableService.replaceVariable(eleCode2InfoMap, orgid, explain, originalStartDate, startDate, endDate, calType);
                    }
                    map.put(RISK_DESC, explain);
                    break;
                }
            }
            if (!isRisk) {
                map.put(RISK_LEVEL, "5");
                map.put(RISK_SCORE, "");
                map.put(RISK_DESC, "");
            }
            if (isEmptyField) {
                map.put(RISK_LEVEL, "4");
                map.put(RISK_SCORE, "");
            }
        } else {
            map.put(RESULT, "");
            map.put(RISK_LEVEL, null);
            map.put(RISK_SCORE, "");
            map.put(RISK_DESC, "");
        }
        return map;
    }

    public double getOffsetResult(String riskResult, double offsetResult, String offsetType, String benchMarking, double bmValue) {
        Double risk = "null".equalsIgnoreCase(riskResult) ? 0.0 : Double.parseDouble(riskResult);
        if ("1".equals(offsetType)) {
            if ("1".equals(benchMarking)) {
                offsetResult = risk - bmValue;
            }
        } else if ("2".equals(offsetType) && "1".equals(benchMarking)) {
            offsetResult = (risk - bmValue) / bmValue * 100.0;
        }
        return BigDecimalUtil.setScale(offsetResult, 4).doubleValue();
    }

    public boolean analyzeIsRisk(boolean isRisk, DynamicObject riskDefinition, double offsetResult) {
        boolean isBigThanMinBorder = false;
        boolean isSmallThanMaxBorder = false;
        if (!isRisk) {
            String minBorder = riskDefinition.getString("entryentity.minborder");
            double range = RiskCalSerivce.getRangeBigDecimal(riskDefinition.getString("entryentity.range")).doubleValue();
            String rangeString = riskDefinition.getString("entryentity.range");
            String maxBorder = riskDefinition.getString("entryentity.maxborder");
            double rangeMax = RiskCalSerivce.getRangeBigDecimal(riskDefinition.getString("entryentity.rangemax")).doubleValue();
            String rangeMaxString = riskDefinition.getString("entryentity.rangemax");
            if ((offsetResult > range || StringUtils.equals((CharSequence)rangeString, (CharSequence)"-\u221e")) && "1".equals(minBorder)) {
                isBigThanMinBorder = true;
            } else if ((offsetResult >= range || StringUtils.equals((CharSequence)rangeString, (CharSequence)"-\u221e")) && "2".equals(minBorder)) {
                isBigThanMinBorder = true;
            }
            if ((offsetResult < rangeMax || StringUtils.equals((CharSequence)rangeMaxString, (CharSequence)"+\u221e")) && "1".equals(maxBorder)) {
                isSmallThanMaxBorder = true;
            } else if ((offsetResult <= rangeMax || StringUtils.equals((CharSequence)rangeMaxString, (CharSequence)"+\u221e")) && "2".equals(maxBorder)) {
                isSmallThanMaxBorder = true;
            }
            if (isBigThanMinBorder && isSmallThanMaxBorder) {
                isRisk = true;
            }
        }
        return isRisk;
    }
}

