/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.common.element.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tctrc.common.element.AbstractRiskOperate;
import kd.taxc.tctrc.common.element.TimeDeviatedEnum;
import kd.taxc.tctrc.common.util.DateUtils;
import kd.taxc.tctrc.common.util.ElementUtil;

public class NumberRisk
extends AbstractRiskOperate {
    @Override
    public List<Long> queryRiskByElementCodes(List<String> eleCodes) {
        ArrayList<Long> riskIds = new ArrayList<Long>();
        QFilter qRiskTypeNumber = new QFilter("risktype", "=", (Object)"1");
        DynamicObjectCollection riskNumberDefs = QueryServiceHelper.query((String)"tctrc_risk_definition", (String)"id,json,risktype", (QFilter[])new QFilter[]{qRiskTypeNumber});
        QFilter qNoBottom = new QFilter("bottom", "=", (Object)"false");
        DynamicObjectCollection eleDefCollection = QueryServiceHelper.query((String)"tdm_element_group", (String)"number,bottom,json,timedeviationcount,timedeviationtype,timedeviationdirection", null);
        HashMap<String, String> elementMap = new HashMap<String, String>();
        for (DynamicObject element : eleDefCollection) {
            elementMap.put(element.getString("number"), element.getString("json") + "," + element.getString("bottom"));
        }
        block1: for (DynamicObject riskDef : riskNumberDefs) {
            String json = riskDef.getString("json").replaceAll(" +", " ");
            HashMap<String, String> codesMap = new HashMap<String, String>();
            NumberRisk.expressionToElement(json, elementMap, codesMap);
            for (String code : eleCodes) {
                if (null == codesMap.get(code)) continue;
                riskIds.add(riskDef.getLong("id"));
                continue block1;
            }
        }
        return riskIds;
    }

    private static void expressionToElement(String json, Map<String, String> elementMap, Map<String, String> codesMap) {
        if (!json.isEmpty()) {
            String[] expression;
            for (String express : expression = json.split(" ")) {
                if ("+-*/()<><=>=abs(".contains(express = ElementUtil.splitElementFormula(express)) || null == elementMap.get(express)) continue;
                codesMap.put(express, express);
                if (!"false".equals(elementMap.get(express).split(",")[1])) continue;
                String json1 = elementMap.get(express);
                NumberRisk.expressionToElement(json1, elementMap, codesMap);
            }
        }
    }

    @Override
    public List<DynamicObject> queryRiskResult(List<DynamicObject> elementUpdateList, List<String> orgList, List<Long> riskIds) {
        ArrayList<DynamicObject> isUpdateResults = new ArrayList<DynamicObject>();
        QFilter qOrgs = new QFilter("runorg", "in", orgList);
        QFilter qRisks = new QFilter("risk", "in", riskIds);
        QFilter qRiskType = new QFilter("risk.risktype", "=", (Object)"1");
        DynamicObject[] riskResultArr = BusinessDataServiceHelper.load((String)"tctrc_risk_run_result", (String)"id,assignorg,plannumber,runorg,risk,runtime,risklevel,riskdesc,result,datestring,caltype,status,dealresult,startdate,enddate,transmit,runtime", (QFilter[])new QFilter[]{qOrgs, qRisks, qRiskType});
        DynamicObjectCollection eleDefCollection = QueryServiceHelper.query((String)"tdm_element_group", (String)"number,bottom,json,timedeviationcount,timedeviationtype,timedeviationdirection", null);
        HashMap<String, String> elementMap = new HashMap<String, String>();
        for (DynamicObject element : eleDefCollection) {
            String deviationType = element.getString("timedeviationtype");
            String deviationDirection = element.getString("timedeviationdirection");
            int timeDeviationCount = element.getInt("timedeviationcount");
            int diffMonth = TimeDeviatedEnum.getDeviatedMonth(deviationDirection, timeDeviationCount, deviationType);
            String bottom = element.getString("bottom");
            elementMap.put(element.getString("number"), element.getString("json") + "," + diffMonth + "," + bottom);
        }
        HashMap<String, String> updateElementMap = new HashMap<String, String>(elementUpdateList.size());
        for (DynamicObject updateEle : elementUpdateList) {
            String number = updateEle.getString("element");
            String start = DateUtils.format(updateEle.getDate("startdata"));
            String end = DateUtils.format(updateEle.getDate("enddata"));
            updateElementMap.put(number + "," + start + "," + end, number);
        }
        for (DynamicObject result : riskResultArr) {
            HashMap<String, String> codePeriodMap = new HashMap<String, String>();
            String start = DateUtils.format(result.getDate("startdate"));
            String end = DateUtils.format(result.getDate("enddate"));
            String json = result.getString("risk.json");
            this.resolveExpressionByPeriod(json, elementMap, codePeriodMap, 0, start, end);
            Iterator it = codePeriodMap.entrySet().iterator();
            boolean isUpdate = false;
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String key = (String)entry.getKey();
                if (null == updateElementMap.get(key)) continue;
                isUpdate = true;
                break;
            }
            if (!isUpdate) continue;
            isUpdateResults.add(result);
        }
        return isUpdateResults;
    }
}

