/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.common.enums;

import kd.bos.dataentity.resource.ResManager;
import kd.taxc.tctrc.common.enums.MultiLangEnumBridge;

public enum TaxTypeEnum {
    TAX_VAT("1", "1", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u589e\u503c\u7a0e", (String)"TaxTypeEnum_0", (String)"taxc-tctrc-common", (Object[])new Object[0]), "TaxTypeEnum_0", "taxc-tctrc-common")),
    TAX_CCT("2", "3", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u4f01\u4e1a\u6240\u5f97\u7a0e", (String)"TaxTypeEnum_1", (String)"taxc-tctrc-common", (Object[])new Object[0]), "TaxTypeEnum_1", "taxc-tctrc-common")),
    TAX_CIT("3", "1031650785223514112", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u9644\u52a0\u7a0e\u8d39", (String)"TaxTypeEnum_2", (String)"taxc-tctrc-common", (Object[])new Object[0]), "TaxTypeEnum_2", "taxc-tctrc-common")),
    TAX_PIT("4", "7", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u623f\u4ea7\u7a0e", (String)"TaxTypeEnum_3", (String)"taxc-tctrc-common", (Object[])new Object[0]), "TaxTypeEnum_3", "taxc-tctrc-common")),
    TAX_RT("5", "9", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u57ce\u5e02\u571f\u5730\u4f7f\u7528\u7a0e", (String)"TaxTypeEnum_4", (String)"taxc-tctrc-common", (Object[])new Object[0]), "TaxTypeEnum_4", "taxc-tctrc-common")),
    TAX_UMCT("6", "8", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u5370\u82b1\u7a0e", (String)"TaxTypeEnum_5", (String)"taxc-tctrc-common", (Object[])new Object[0]), "TaxTypeEnum_5", "taxc-tctrc-common")),
    TAX_CRET("7", "2", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u6d88\u8d39\u7a0e", (String)"TaxTypeEnum_6", (String)"taxc-tctrc-common", (Object[])new Object[0]), "TaxTypeEnum_6", "taxc-tctrc-common")),
    TAX_CSD("8", "18", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u73af\u4fdd\u7a0e", (String)"TaxTypeEnum_7", (String)"taxc-tctrc-common", (Object[])new Object[0]), "TaxTypeEnum_7", "taxc-tctrc-common"));

    private String taxType;
    private String baseTaxType;
    private MultiLangEnumBridge bridge;

    public String getBaseTaxType() {
        return this.baseTaxType;
    }

    private TaxTypeEnum(String taxType, String baseTaxType, MultiLangEnumBridge bridge) {
        this.taxType = taxType;
        this.baseTaxType = baseTaxType;
        this.bridge = bridge;
    }

    public static String getTaxNameByType(String taxType) {
        for (TaxTypeEnum value : TaxTypeEnum.values()) {
            if (!value.getTaxType().equals(taxType)) continue;
            return value.getTaxTypeName();
        }
        return "";
    }

    public static TaxTypeEnum getTaxByType(String taxType) {
        for (TaxTypeEnum taxTypeEnum : TaxTypeEnum.values()) {
            if (!taxTypeEnum.getTaxType().equals(taxType)) continue;
            return taxTypeEnum;
        }
        return TAX_VAT;
    }

    public static String getName(String code) {
        if (code == null) {
            return null;
        }
        for (TaxTypeEnum se : TaxTypeEnum.values()) {
            if (!code.equals(se.getTaxType())) continue;
            return se.getTaxTypeName();
        }
        return null;
    }

    public String getTaxType() {
        return this.taxType;
    }

    public String getTaxTypeName() {
        return this.bridge.loadKDString();
    }
}

