/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.common.helper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.mvc.list.ListView;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.tctrc.common.helper.AbstractServiceHelper;
import org.apache.commons.lang3.ObjectUtils;

public class OrgCheckServiceHelper
extends AbstractServiceHelper {
    public static boolean orgEnable(IFormView view, DynamicObjectCollection org, boolean needErrorMsg) {
        Map map;
        if (null != org && !org.isEmpty() && StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)(map = (Map)OrgCheckServiceHelper.invokeService("OrgCheckService", "orgEnable", ((DynamicObject)org.get(0)).getLong("id"), needErrorMsg)).get("code")), (CharSequence)"true")) {
            if (needErrorMsg && null != view) {
                view.showErrorNotification((String)map.get("failInfo"));
            }
            return true;
        }
        return false;
    }

    public static Map<Long, Boolean> orgEnableBatch(List<Long> orgIds) {
        HashMap<Long, Boolean> map = new HashMap<Long, Boolean>();
        TaxResult taxResult = TaxcOrgDataServiceHelper.queryTaxcOrgByIds(orgIds, null);
        if (taxResult != null && ObjectUtils.isNotEmpty((Object)taxResult.getData())) {
            List collection = (List)taxResult.getData();
            collection.stream().forEach(row -> {
                Long orgid = row.getLong("id");
                map.put(orgid, Boolean.FALSE);
            });
            orgIds.stream().forEach(orgid -> {
                if (!map.containsKey(orgid)) {
                    map.put((Long)orgid, Boolean.TRUE);
                }
            });
        }
        return map;
    }

    public static boolean isTaxPayerAuth(IFormView view, String orgId, boolean needErrorMsg) {
        Map map;
        String entityName = view.getEntityId();
        if (view instanceof ListView) {
            entityName = ((ListView)view).getBillFormId();
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)(map = (Map)OrgCheckServiceHelper.invokeService("OrgCheckService", "isTaxPayerAuth", orgId, entityName, needErrorMsg)).get("code")), (CharSequence)"true")) {
            if (needErrorMsg && null != view) {
                view.showErrorNotification((String)map.get("failInfo"));
            }
            return true;
        }
        return false;
    }

    public static Long setDefaultOrg(IFormView getView, Long orgid, DynamicObjectCollection permOrgs) {
        if (null == permOrgs) {
            return null;
        }
        List orgList = permOrgs.stream().map(p -> p.getLong("id")).collect(Collectors.toList());
        Map map = (Map)OrgCheckServiceHelper.invokeService("OrgCheckService", "setDefaultOrg", orgid, orgList);
        if (ObjectUtils.isEmpty(map.get("orgid"))) {
            getView.showErrorNotification((String)map.get("failInfo"));
            return null;
        }
        return (Long)map.get("orgid");
    }
}

