/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.common.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.tctrc.common.helper.AbstractServiceHelper;
import org.apache.commons.lang3.ObjectUtils;

public class OrgServiceHelper
extends AbstractServiceHelper {
    public static void orgAddBeforeF7SelectListener(BeforeF7SelectEvent event) {
        ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
        List<Long> orgList = OrgServiceHelper.getAllOrgEnable();
        QFilter orgIdsFilter = new QFilter("id", "in", orgList);
        formShowParameter.getListFilterParameter().getQFilters().add(orgIdsFilter);
    }

    public static List<Long> getAllOrgEnable() {
        TaxResult result = TaxcCombineDataServiceHelper.queryTaxcOrgIdWithPerm((Long)RequestContext.get().getCurrUserId(), null);
        if (!result.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)result.getData()))) {
            return new ArrayList<Long>();
        }
        return (List)result.getData();
    }

    public static List<Long> getAllOrgEnable(long userId, String appId, String entityNumber, String permItemId) {
        TaxResult result = TaxcCombineDataServiceHelper.queryTaxcOrgIdWithPerm((Long)userId, (String)appId, (String)entityNumber, (String)permItemId, null);
        if (!result.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)result.getData()))) {
            return new ArrayList<Long>();
        }
        return (List)result.getData();
    }

    public static List<Long> getOrgLists(Boolean isEnable, Boolean isVirtual) {
        TaxResult result = TaxcOrgDataServiceHelper.queryTaxOrgIdsByStatusAndIsvirtual((Boolean)isEnable, (Boolean)isVirtual);
        if (!result.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)result.getData()))) {
            return new ArrayList<Long>();
        }
        return (List)result.getData();
    }

    public static DynamicObjectCollection getOrgLists() {
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        List list = (List)OrgServiceHelper.invokeService("OrgService", "getOrgLists", new Object[0]);
        list.stream().forEach(map -> {
            DynamicObject row = BusinessDataServiceHelper.newDynamicObject((String)"tctb_org_entity");
            DataEntityPropertyCollection properties = row.getDynamicObjectType().getProperties();
            map.keySet().stream().forEach(key -> row.set(key, map.get(key)));
            dynamicObjectCollection.add((Object)row);
        });
        return dynamicObjectCollection;
    }

    public static DynamicObjectCollection queryOrgListByCondition(Map<String, List<Object>> condition) {
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        List list = (List)OrgServiceHelper.invokeService("OrgService", "queryOrgListByCondition", condition);
        list.stream().forEach(map -> {
            DynamicObject row = BusinessDataServiceHelper.newDynamicObject((String)"tctb_org_entity");
            DataEntityPropertyCollection properties = row.getDynamicObjectType().getProperties();
            map.keySet().stream().forEach(key -> row.set(key, map.get(key)));
            dynamicObjectCollection.add((Object)row);
        });
        return dynamicObjectCollection;
    }

    public static String getOrgStatusById(String orgid) {
        return (String)OrgServiceHelper.invokeService("OrgService", "getOrgStatusById", orgid);
    }

    public static Long getDefaultViewSchemaInfoId() {
        return (Long)OrgServiceHelper.invokeService("OrgService", "getDefaultViewSchemaInfoId", new Object[0]);
    }

    public static Long getLocalDefaultViewId() {
        return (Long)OrgServiceHelper.invokeService("OrgService", "getLocalDefaultViewId", new Object[0]);
    }

    public static List<Long> mergeOrgIds(List<Long> idList, String status) {
        return (List)OrgServiceHelper.invokeService("OrgService", "mergeOrgIds", idList, status);
    }

    public static List<TreeNode> getAllPermNodes(String appNumber, String entityId, String type) {
        String result = (String)OrgServiceHelper.invokeService("OrgService", "getAllPermNodes", appNumber, entityId, type);
        List list = SerializationUtils.fromJsonStringToList((String)result, TreeNode.class);
        return list;
    }

    public static Map<String, DynamicObject> getAllOrgByView(Long orgViewSchemaId, QFilter qFilter) {
        QFilter orgIdFilter;
        DynamicObject[] ordDynamicObjects;
        List ids;
        HashMap<String, DynamicObject> orgTreeMap = new HashMap<String, DynamicObject>();
        String qFilterJson = null;
        if (null != qFilter) {
            qFilterJson = SerializationUtils.toJsonString((Object)qFilter);
        }
        if (ObjectUtils.isNotEmpty((Object)(ids = (List)OrgServiceHelper.invokeService("OrgService", "getAllOrgByView", orgViewSchemaId, qFilterJson))) && Objects.nonNull(ordDynamicObjects = BusinessDataServiceHelper.load((String)"bos_org", (String)"id,uniformsocialcreditcode,orgpattern,registeredcapital,establishmentdate,frepresentative", (QFilter[])new QFilter[]{orgIdFilter = new QFilter("id", "in", (Object)ids)})) && ordDynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : ordDynamicObjects) {
                String orgId = dynamicObject.getString("id");
                orgTreeMap.put(orgId, dynamicObject);
            }
        }
        return orgTreeMap;
    }

    public static Map<String, Map<String, String>> getAllOrgByViewId(Long orgViewSchemaId, QFilter qFilter) {
        HashMap<String, Map<String, String>> map = new HashMap();
        String qFilterJson = null;
        if (null != qFilter) {
            qFilterJson = SerializationUtils.toJsonString((Object)qFilter);
        }
        String result = (String)OrgServiceHelper.invokeService("OrgService", "getAllOrgByViewId", orgViewSchemaId, qFilterJson);
        map = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
        return map;
    }
}

