/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.common.helper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;

public class RiskNumberHelper {
    private static final Map<String, String> operationCharacterSymbol = new HashMap<String, String>(){
        private static final long serialVersionUID = -6264470238648123248L;
        {
            this.put("+", "+");
            this.put("-", "-");
            this.put("*", "*");
            this.put("/", "/");
            this.put("=", "=");
            this.put("<", "<");
            this.put("<=", "<=");
            this.put("(", "(");
            this.put(">", ">");
            this.put(">=", ">=");
            this.put("<>", "<>");
            this.put(")", ")");
            this.put("and", "and");
            this.put("IN", "IN");
            this.put("NOTIN", "NOTIN");
            this.put("NOT", "NOT");
            this.put("LIKE", "LIKE");
            this.put("NOT LIKE", "NOT LIKE");
            this.put("or", "or");
            this.put("abs(", "abs(");
            this.put("CLR", "CLR");
        }
    };

    public static String transformNumberToName(String json, Long objectiId, DynamicObjectCollection collection) {
        if (StringUtils.isEmpty((CharSequence)json)) {
            return "";
        }
        String[] formula = json.split(" ");
        StringBuilder nameStrBuilder = new StringBuilder();
        List list = collection.stream().filter(v -> v.getLong("id") != objectiId.longValue()).collect(Collectors.toList());
        for (String content : formula) {
            if (!StringUtils.isEmpty((CharSequence)content) && operationCharacterSymbol.get(content) == null) {
                boolean isConstant = true;
                for (DynamicObject dynamicObject : list) {
                    String number = dynamicObject.getString("number");
                    String name = dynamicObject.getString("name");
                    if (!content.trim().equals(number)) continue;
                    nameStrBuilder.append(name).append(' ');
                    isConstant = false;
                    break;
                }
                if (!isConstant) continue;
                nameStrBuilder.append(content).append(' ');
                continue;
            }
            nameStrBuilder.append(content).append(' ');
        }
        return nameStrBuilder.toString();
    }
}

