/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.common.task;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.tctrc.common.element.ElementSqlService;
import kd.taxc.tctrc.common.entity.EleTreeInfo;
import kd.taxc.tctrc.common.enums.BooleanEnum;
import kd.taxc.tctrc.common.task.EleDoCheckPlanExe;
import kd.taxc.tctrc.common.task.helper.EleCheckPlanHelper;
import kd.taxc.tctrc.common.threadpools.ThreadPoolsService;
import kd.taxc.tctrc.common.util.DateUtils;
import kd.taxc.tctrc.common.util.EleTreeUtil;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;

public class EleCheckPlanExeTask
extends AbstractTask {
    public void execute(RequestContext arg0, Map<String, Object> arg1) throws KDException {
        EleCheckPlanExeTask.executeCheck();
    }

    public static void executeCheck() {
        QFilter qFilter = new QFilter("enable", "=", (Object)BooleanEnum.YES.getCode());
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"tdm_ele_check_plan", (String)"planno,planname,checkrange,plandatestart,plandateend,checkeles,checkorgs,runtime", (QFilter[])new QFilter[]{qFilter});
        if (EmptyCheckUtils.isEmpty(dynamicObjects)) {
            return;
        }
        long today = DateUtils.stringToDate(DateUtils.format(DateUtils.stringToDate(DateUtils.format(new Date())))).getTime();
        List needExeCheckPlans = Arrays.stream(dynamicObjects).filter(v -> EmptyCheckUtils.isEmpty(v.get("runtime")) || today >= DateUtils.stringToDate(DateUtils.format(DateUtils.addDay(DateUtils.stringToDate(DateUtils.format(v.getDate("runtime"))), v.getInt("checkrange")))).getTime()).collect(Collectors.toList());
        if (EmptyCheckUtils.isEmpty(needExeCheckPlans)) {
            return;
        }
        Map<String, DynamicObject> code2InfoMap = ElementSqlService.queryAllEnableEleInfoMap();
        List<EleTreeInfo> eleTreeInfos = EleTreeUtil.createEleTree();
        EleCheckPlanHelper.distant();
        for (DynamicObject checkPlan : needExeCheckPlans) {
            ThreadPoolsService.getInstance().submit(new EleDoCheckPlanExe(checkPlan, eleTreeInfos, code2InfoMap));
        }
    }
}

