/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.common.task;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.taxc.tctrc.common.element.ElementCalculateService;
import kd.taxc.tctrc.common.entity.ElementCalculateDo;
import kd.taxc.tctrc.common.entity.ElementCalculateResultDo;
import kd.taxc.tctrc.common.task.Task;

public class ElementCalculateTask
extends Task<List<ElementCalculateDo>> {
    private List<ElementCalculateDo> elementDoCalculateList;
    private Map<String, List<DynamicObject>> datasourceMap;
    private ElementCalculateService elementCalculateService;

    public ElementCalculateTask(List<ElementCalculateDo> elementDoCalculateList, Map<String, List<DynamicObject>> datasourceMap, ElementCalculateService elementCalculateService) {
        this.elementDoCalculateList = elementDoCalculateList;
        this.datasourceMap = datasourceMap;
        this.elementCalculateService = elementCalculateService;
    }

    @Override
    public List<List<ElementCalculateDo>> getValue() {
        return Lists.partition(this.elementDoCalculateList, (int)10);
    }

    @Override
    public List<ElementCalculateDo> executor(List<ElementCalculateDo> elementCalculateParams) {
        for (ElementCalculateDo elementCalculateParam : elementCalculateParams) {
            ElementCalculateResultDo elementCalculateResult = elementCalculateParam.getElement().getBoolean("bottom") ? this.elementCalculateService.doCalculateBottomElement(elementCalculateParam, this.datasourceMap) : this.elementCalculateService.doCalculateElement(elementCalculateParam);
            elementCalculateParam.setElementCalculateResult(elementCalculateResult);
        }
        return elementCalculateParams;
    }
}

