/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.common.task;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.tctrc.common.element.ElementSqlService;
import kd.taxc.tctrc.common.entity.ElementResultDo;
import kd.taxc.tctrc.common.task.Task;

public class ElementDoCalTask
extends Task<List<ElementResultDo>> {
    private static Log logger = LogFactory.getLog(ElementDoCalTask.class);
    private List<ElementResultDo> elementResultDoList;
    private Map<String, DynamicObject> eleCode2InfoMap;
    private Map<String, String> codeNameMappings;

    public ElementDoCalTask(List<ElementResultDo> elementResultDoList, Map<String, DynamicObject> eleCode2InfoMap, Map<String, String> codeNameMappings) {
        this.elementResultDoList = elementResultDoList;
        this.eleCode2InfoMap = eleCode2InfoMap;
        this.codeNameMappings = codeNameMappings;
    }

    @Override
    public List<List<ElementResultDo>> getValue() {
        return Lists.partition(this.elementResultDoList, (int)this.elementResultDoList.size());
    }

    @Override
    public List<ElementResultDo> executor(List<ElementResultDo> partitionList) {
        if (logger.isDebugEnabled()) {
            logger.debug("-------------->\u6267\u884c\u591a\u7ebf\u7a0b\u8fdb\u884c\u5143\u7d20\u8ba1\u7b97\u3002");
        }
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>();
        HashMap<String, Map<String, String>> eleKey2EleResultMap = new HashMap<String, Map<String, String>>();
        ElementSqlService sqlService = new ElementSqlService();
        for (ElementResultDo elementResultDo : partitionList) {
            sqlService.calElement(this.codeNameMappings, this.eleCode2InfoMap, eleKey2EleResultMap, dynamicObjectList, elementResultDo.getOgrId(), elementResultDo.getElementNumber(), elementResultDo.getOriginalStartDate(), elementResultDo.getStartDate(), elementResultDo.getEndDate(), null);
        }
        return partitionList;
    }

    public Map<String, DynamicObject> getEleCode2InfoMap() {
        return this.eleCode2InfoMap;
    }

    public void setEleCode2InfoMap(Map<String, DynamicObject> eleCode2InfoMap) {
        this.eleCode2InfoMap = eleCode2InfoMap;
    }
}

