/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.common.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.taxc.tctrc.common.element.ElementCalculateService;
import kd.taxc.tctrc.common.entity.ElementDependencyElementDo;
import kd.taxc.tctrc.common.task.Task;

public class ElementExpressionParseTask
extends Task<Map<String, List<ElementDependencyElementDo>>> {
    private List<DynamicObject> toParseElements;
    private Map<String, DynamicObject> elementCodeKeyMap;
    private ElementCalculateService elementCalculateService;

    public ElementExpressionParseTask(List<DynamicObject> toParseElements, Map<String, DynamicObject> elementCodeKeyMap, ElementCalculateService elementCalculateService) {
        this.toParseElements = toParseElements;
        this.elementCodeKeyMap = elementCodeKeyMap;
        this.elementCalculateService = elementCalculateService;
    }

    @Override
    public List<Map<String, List<ElementDependencyElementDo>>> getValue() {
        ArrayList<Map<String, List<ElementDependencyElementDo>>> result = new ArrayList<Map<String, List<ElementDependencyElementDo>>>(this.toParseElements.size() / 10 + 1);
        HashMap map = null;
        for (int i = 0; i < this.toParseElements.size(); ++i) {
            boolean isPartition;
            boolean bl = isPartition = i % 10 == 0 && i != 0 && map != null;
            if (isPartition) {
                result.add(map);
            }
            if (i % 10 == 0) {
                map = new HashMap(10);
            }
            if (map != null) {
                map.put(this.toParseElements.get(i).getString("number"), new ArrayList(16));
            }
            if (i != this.toParseElements.size() - 1 || map == null) continue;
            result.add(map);
        }
        return result;
    }

    @Override
    public Map<String, List<ElementDependencyElementDo>> executor(Map<String, List<ElementDependencyElementDo>> ex) {
        for (Map.Entry<String, List<ElementDependencyElementDo>> entry : ex.entrySet()) {
            DynamicObject element = this.elementCodeKeyMap.get(entry.getKey());
            entry.getValue().addAll(this.elementCalculateService.doGetElementDependencyElement(element, this.elementCodeKeyMap));
        }
        return ex;
    }
}

