/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.common.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.form.control.ProgressBar;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.FunctionMutex;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tctrc.common.element.ElementSqlService;
import kd.taxc.tctrc.common.element.RiskCalSerivce;
import kd.taxc.tctrc.common.element.TimeDeviatedEnum;
import kd.taxc.tctrc.common.enums.BooleanEnum;
import kd.taxc.tctrc.common.enums.DealStatusEnum;
import kd.taxc.tctrc.common.util.CalUtils;
import kd.taxc.tctrc.common.util.DateUtils;
import kd.taxc.tctrc.common.util.ListUtils;
import kd.taxc.tctrc.common.util.biz.BizCommomUtil;

public class RiskService {
    private static Log logger = LogFactory.getLog(RiskService.class);
    public static final String FIELD_RISK = "risk";
    public static final String FIELD_RISK_JSON = "json";
    public static final String FIELD_ASSIGNORG = "assignorg";
    public static final String FIELD_RUNORG = "runorg";
    public static final String FIELD_PLANNUMBER = "plannumber";
    public static final String FIELD_RUNTIME = "runtime";
    public static final String FIELD_RISK_LEVEL = "rlevel";
    public static final String FIELD_RISK_SCORE = "riskscore";
    public static final String FIELD_RISK_DESC = "riskdesc";
    public static final String FIELD_RESULT = "result";
    public static final String FIELD_START_DATE = "startdate";
    public static final String FIELD_END_DATE = "enddate";
    public static final String FIELD_LAST_UPDATE_BY = "lastupdateby";
    public static final String FIELD_DATE_STRING = "datestring";
    public static final String FIELD_STATUS = "status";
    public static final String FIELD_DEAL_RESULT = "dealresult";
    public static final String FIELD_LAST_RUNTIME = "lastruntime";
    public static final String FIELD_CALTYPE = "caltype";
    public static final String FIELD_RISK_LEVEL_CAL_ERROR = "4";
    public static final String IS_EMPTY_FIELD = "isemptyfield";
    public static final String IS_DENOMINATOR_ZERO = "isdenominatorzero";
    private static final String RESULT_FORM_ID = "tctrc_risk_run_result";
    public static final String TRUE_STRING = "true";
    private static final String NUMBER = "number";

    public static Map<String, List<String>> cal(ProgressBar progressBar, List<DynamicObject> resultList, DynamicObject[] objArray, Date startdate, Date enddate, String decs, Boolean isTask, Map<String, DynamicObject> eleCode2InfoMap) {
        return RiskService.getRiskCalResultErrorMap(progressBar, resultList, objArray, startdate, enddate, decs, isTask, eleCode2InfoMap);
    }

    public static Map<String, List<String>> cal(ProgressBar progressBar, List<DynamicObject> resultList, DynamicObject[] objArray, Date startdate, Date enddate, String decs, Boolean isTask) {
        Map<String, DynamicObject> eleCode2InfoMap = ElementSqlService.queryAllEnableEleInfoMap();
        return RiskService.getRiskCalResultErrorMap(progressBar, resultList, objArray, startdate, enddate, decs, isTask, eleCode2InfoMap);
    }

    private static Map<String, List<String>> getRiskCalResultErrorMap(ProgressBar progressBar, List<DynamicObject> resultList, DynamicObject[] objArray, Date startdate, Date enddate, String decs, Boolean isTask, Map<String, DynamicObject> eleCode2InfoMap) {
        int sum = 0;
        int procss = 80 / objArray.length;
        if (procss < 1) {
            procss = 1;
        }
        HashMap<String, List<String>> errorMap = new HashMap<String, List<String>>();
        ArrayList<DynamicObject> resultInsert = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> resultUpdate = new ArrayList<DynamicObject>();
        for (DynamicObject obj : objArray) {
            DynamicObject risk = obj.getDynamicObject(FIELD_RISK);
            String enable = risk.getString("enable");
            if (!enable.equalsIgnoreCase(BooleanEnum.YES.getCode())) continue;
            sum = RiskService.doCal(progressBar, startdate, enddate, sum, procss, resultInsert, resultUpdate, obj, isTask, errorMap, eleCode2InfoMap);
        }
        resultList.addAll(resultUpdate);
        resultList.addAll(resultInsert);
        if (!resultList.isEmpty()) {
            if (null != progressBar) {
                progressBar.setPercent(sum + 10);
            }
            try {
                objArray[0].set(FIELD_LAST_RUNTIME, (Object)new Date());
                SaveServiceHelper.save((DynamicObject[])objArray);
            }
            catch (Exception e) {
                logger.info("======\u53ef\u80fd\u6ca1\u6709\u8fd9\u4e2a\u5c5e\u6027=====");
            }
            ArrayList<Object> pkList = new ArrayList<Object>();
            logger.info("\u5f00\u59cb\u65b0\u589e/\u66f4\u65b0\u98ce\u9669\u8fd0\u884c\u7ed3\u679c\u8868\u3002");
            for (DynamicObject dynamicObject : resultList) {
                String risk = dynamicObject.getString("risk.id");
                String runorg = dynamicObject.getString(FIELD_RUNORG);
                String startdate1 = dynamicObject.getString(FIELD_START_DATE);
                String enddate1 = dynamicObject.getString(FIELD_END_DATE);
                String caltype = dynamicObject.getString(FIELD_CALTYPE);
                try {
                    FunctionMutex funMutex = FunctionMutex.create();
                    Throwable throwable = null;
                    try {
                        boolean success = funMutex.require(Long.parseLong(risk), "RiskService.cal" + runorg + caltype + startdate1 + enddate1);
                        logger.info("RiskService.cal Lock " + String.format("%s-%s-%s-%s", risk, runorg, caltype, startdate1, enddate1));
                        if (!success) continue;
                        Object[] pkarray1 = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                        pkList.addAll(Arrays.asList(pkarray1));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (funMutex == null) continue;
                        if (throwable != null) {
                            try {
                                funMutex.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        funMutex.close();
                    }
                }
                catch (Exception e) {
                    logger.error("\u4e92\u65a5\u9501\u5931\u8d25\uff1a" + e.getMessage());
                }
            }
            RiskService.generateHandleEntity(decs, pkList);
        }
        return errorMap;
    }

    private static int doCal(ProgressBar progressBar, Date startdate, Date enddate, int sum, int procss, List<DynamicObject> resultInsert, List<DynamicObject> resultUpdate, DynamicObject obj, Boolean isTask, Map<String, List<String>> errorMap, Map<String, DynamicObject> eleCode2InfoMap) {
        sum += procss;
        DynamicObject risk = obj.getDynamicObject(FIELD_RISK);
        DynamicObject runOrg = obj.getDynamicObject(FIELD_RUNORG);
        String caltype = risk.getString(FIELD_CALTYPE);
        String riskNumber = risk.getString(NUMBER);
        String runOrgid = runOrg.getString("id");
        Long deviatedcountL = risk.getLong("deviatedcount");
        int deviatedcount = null == deviatedcountL ? 0 : Integer.parseInt(String.valueOf(deviatedcountL));
        try {
            obj.set(FIELD_LAST_RUNTIME, (Object)new Date());
        }
        catch (Exception e) {
            logger.info("======\u53ef\u80fd\u6ca1\u6709\u8fd9\u4e2a\u5c5e\u6027=====");
        }
        String startdateStr = TimeDeviatedEnum.getDeviatedDate(DateUtils.format(startdate), "+", deviatedcount, caltype);
        String enddateStr = TimeDeviatedEnum.getDeviatedDate(DateUtils.format(enddate), "+", deviatedcount, caltype);
        startdate = DateUtils.stringToDate(startdateStr);
        enddate = DateUtils.stringToDate(enddateStr);
        List<Map<String, Date>> dateList = CalUtils.getCalDate(caltype, startdate, enddate);
        long[] genLongIds = DB.genLongIds((String)RESULT_FORM_ID, (int)dateList.size());
        int index = 0;
        for (Map<String, Date> dateMap : dateList) {
            Map<String, String> map;
            QFilter qcaltype;
            QFilter qPeriod;
            QFilter qRisk;
            QFilter qOrg = new QFilter(FIELD_RUNORG, "=", (Object)Long.parseLong(runOrgid));
            DynamicObject resultObj = BusinessDataServiceHelper.loadSingle((String)RESULT_FORM_ID, (String)"id,assignorg,plannumber,runorg,risk,runtime,risklevel,rlevel,riskscore,riskdesc,result,datestring,caltype,status,dealresult,startdate,lastupdateby,enddate,transmit,isemptyfield,isdenominatorzero,json", (QFilter[])new QFilter[]{qOrg, qRisk = new QFilter(FIELD_RISK, "=", (Object)risk.getLong("id")), qPeriod = new QFilter(FIELD_START_DATE, ">=", (Object)dateMap.get(FIELD_START_DATE)).and(FIELD_END_DATE, "<=", (Object)DateUtils.getLastDateOfMonth(dateMap.get(FIELD_END_DATE))), qcaltype = new QFilter(FIELD_CALTYPE, "=", (Object)caltype)});
            if (!BizCommomUtil.isCanCal(resultObj, errorMap)) continue;
            Boolean isUpdate = Boolean.TRUE;
            if (null == resultObj) {
                isUpdate = Boolean.FALSE;
                resultObj = BusinessDataServiceHelper.newDynamicObject((String)RESULT_FORM_ID);
                resultObj.set("id", (Object)genLongIds[index++]);
            }
            if ((map = RiskCalSerivce.calRisk(resultObj.getString("id"), eleCode2InfoMap, risk.getString("risktype"), runOrgid, riskNumber, DateUtils.format(startdate), DateUtils.format(dateMap.get(FIELD_START_DATE)), DateUtils.format(dateMap.get(FIELD_END_DATE)))) == null) continue;
            resultObj.set(FIELD_RISK, (Object)risk);
            resultObj.set(FIELD_RISK_JSON, (Object)map.get(FIELD_RISK_JSON));
            resultObj.set(FIELD_RUNORG, (Object)runOrg);
            resultObj.set(FIELD_LAST_UPDATE_BY, (Object)RequestContext.get().getUserId());
            resultObj.set(FIELD_START_DATE, (Object)dateMap.get(FIELD_START_DATE));
            resultObj.set(FIELD_END_DATE, (Object)dateMap.get(FIELD_END_DATE));
            resultObj.set(FIELD_ASSIGNORG, obj.get(FIELD_ASSIGNORG));
            resultObj.set(FIELD_PLANNUMBER, obj.get(FIELD_PLANNUMBER));
            resultObj.set(FIELD_RUNTIME, (Object)new Date());
            resultObj.set(FIELD_RISK_LEVEL, (Object)map.get("risklevel"));
            resultObj.set(FIELD_RISK_SCORE, (Object)map.get(FIELD_RISK_SCORE));
            resultObj.set(FIELD_RISK_DESC, (Object)map.get(FIELD_RISK_DESC));
            resultObj.set(FIELD_RESULT, (Object)map.get(FIELD_RESULT));
            if (TRUE_STRING.equals(map.get("isDenominatorZero"))) {
                resultObj.set(IS_DENOMINATOR_ZERO, (Object)Boolean.TRUE);
                resultObj.set(FIELD_RISK_LEVEL, (Object)FIELD_RISK_LEVEL_CAL_ERROR);
                resultObj.set(FIELD_RISK_DESC, (Object)"");
            } else {
                resultObj.set(IS_DENOMINATOR_ZERO, (Object)Boolean.FALSE);
            }
            if (TRUE_STRING.equals(map.get("isEmptyField"))) {
                resultObj.set(IS_EMPTY_FIELD, (Object)Boolean.TRUE);
                resultObj.set(FIELD_RISK_LEVEL, (Object)FIELD_RISK_LEVEL_CAL_ERROR);
                resultObj.set(FIELD_RISK_DESC, (Object)"");
            } else {
                resultObj.set(IS_EMPTY_FIELD, (Object)Boolean.FALSE);
            }
            List<String> filterFieldValueList = ListUtils.stringToList(map.get("filterFieldValueList"));
            if (filterFieldValueList != null) {
                for (String filterFieldValue : filterFieldValueList) {
                    if (!StringUtils.isEmpty((CharSequence)filterFieldValue)) continue;
                    resultObj.set(IS_EMPTY_FIELD, (Object)Boolean.TRUE);
                    break;
                }
            }
            if (!DealStatusEnum.CHANING.getCode().equalsIgnoreCase(resultObj.getString(FIELD_STATUS))) {
                resultObj.set(FIELD_STATUS, (Object)DealStatusEnum.TO_DO.getCode());
            }
            resultObj.set(FIELD_DEAL_RESULT, (Object)"1");
            resultObj.set(FIELD_CALTYPE, (Object)caltype);
            RiskService.setDateStrByCalType(caltype, dateMap, resultObj);
            boolean isRepeat = false;
            List<DynamicObject> tempList = isUpdate != false ? resultUpdate : resultInsert;
            for (DynamicObject dynamicObject : tempList) {
                if (!runOrgid.equals(dynamicObject.getDynamicObject(FIELD_RUNORG).getString("id")) || risk.getLong("id") != dynamicObject.getDynamicObject(FIELD_RISK).getLong("id") || !resultObj.getString(FIELD_DATE_STRING).equals(dynamicObject.getString(FIELD_DATE_STRING))) continue;
                isRepeat = true;
                break;
            }
            if (isRepeat) continue;
            if (isUpdate.booleanValue()) {
                resultUpdate.add(resultObj);
                continue;
            }
            resultInsert.add(resultObj);
        }
        if (null != progressBar) {
            progressBar.setPercent(sum);
        }
        return sum;
    }

    public static void setDateStrByCalType(String caltype, Map<String, Date> dateMap, DynamicObject resultObj) {
        if (TimeDeviatedEnum.TIME_DEVIATION_MONTH.getDeviatedType().equals(caltype)) {
            resultObj.set(FIELD_DATE_STRING, (Object)DateUtils.format(dateMap.get(FIELD_START_DATE), "yyyy-MM"));
        } else if (TimeDeviatedEnum.TIME_DEVIATION_SEASON.getDeviatedType().equals(caltype)) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(dateMap.get(FIELD_END_DATE));
            int q = (calendar.get(2) + 1) / 3;
            resultObj.set(FIELD_DATE_STRING, (Object)String.format(ResManager.loadKDString((String)"%1$s\u5e740%2$s\u5b63\u5ea6", (String)"RiskService_0", (String)"taxc-tctrc-common", (Object[])new Object[0]), DateUtils.format(dateMap.get(FIELD_START_DATE), "yyyy"), q));
        } else if (TimeDeviatedEnum.TIME_DEVIATION_YEAR.getDeviatedType().equals(caltype)) {
            resultObj.set(FIELD_DATE_STRING, (Object)String.format(ResManager.loadKDString((String)"%s\u5e74\u5ea6", (String)"RiskService_1", (String)"taxc-tctrc-common", (Object[])new Object[0]), DateUtils.format(dateMap.get(FIELD_START_DATE), "yyyy")));
        } else if (TimeDeviatedEnum.TIME_DEVIATION_HALF_YEAR.getDeviatedType().equals(caltype)) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(dateMap.get(FIELD_END_DATE));
            int q = (calendar.get(2) + 1) / 6;
            String param = q == 1 ? ResManager.loadKDString((String)"\u4e0a", (String)"RiskService_4", (String)"taxc-tctrc-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e0b", (String)"RiskService_5", (String)"taxc-tctrc-common", (Object[])new Object[0]);
            resultObj.set(FIELD_DATE_STRING, (Object)String.format(ResManager.loadKDString((String)"%1$s\u5e74%2$s\u534a\u5e74\u5ea6", (String)"RiskService_2", (String)"taxc-tctrc-common", (Object[])new Object[0]), DateUtils.format(dateMap.get(FIELD_START_DATE), "yyyy"), param));
        }
    }

    public static void generateHandleEntity(String decs, List<Object> pkList) {
        Object[] pkarray = pkList.toArray(new Object[0]);
        String userId = RequestContext.get().getUserId();
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(pkList.size());
        for (Object obj : pkarray) {
            DynamicObject dobj = (DynamicObject)obj;
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tctrc_handle_entity");
            dynamicObject.set("handler", (Object)userId);
            dynamicObject.set(FIELD_RESULT, (Object)"1");
            dynamicObject.set("time", (Object)new Date());
            dynamicObject.set("resultid", (Object)dobj.getString("id"));
            dynamicObject.set("type", (Object)"sdjs");
            dynamicObject.set("handleoption", (Object)decs);
            list.add(dynamicObject);
        }
        SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
    }
}

