/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.common.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.control.ProgressBar;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.tctrc.common.task.RiskRunLogHelper;
import kd.taxc.tctrc.common.task.RiskService;
import kd.taxc.tctrc.common.task.Task;

public class RiskTask
extends Task {
    private static Log logger = LogFactory.getLog(RiskTask.class);
    private String entry = "tctrc_risk_run_list";
    private String[] ids;
    private ProgressBar progressBar;
    private Date startdate;
    private Date enddate;
    private volatile double num = 1.0;
    private volatile int sum = 0;
    private AtomicInteger count = new AtomicInteger(1);
    private AtomicInteger logCount = new AtomicInteger(0);
    private volatile DynamicObject riskRunLog;

    public RiskTask(String[] ids, ProgressBar progressBar, Date startdate, Date enddate, DynamicObject riskRunLog) {
        this.ids = ids;
        this.progressBar = progressBar;
        this.startdate = startdate;
        this.enddate = enddate;
        this.riskRunLog = riskRunLog;
    }

    public List<DynamicObject> getValue() {
        this.progressBar.run(true);
        this.sum = 10;
        this.progressBar.setPercent(this.sum);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)this.entry);
        DynamicObject[] objArray = BusinessDataServiceHelper.load((Object[])Arrays.stream(this.ids).map(Long::parseLong).collect(Collectors.toList()).toArray(), (DynamicObjectType)type);
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(objArray.length);
        for (DynamicObject obj : objArray) {
            list.add(obj);
        }
        this.sum += 10;
        this.progressBar.setPercent(this.sum);
        this.num = 70.0 / (double)list.size();
        return list;
    }

    public Object executor(Object ex) {
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>();
        try {
            RiskService.cal(null, resultList, new DynamicObject[]{(DynamicObject)ex}, this.startdate, this.enddate, ResManager.loadKDString((String)"\u624b\u5de5\u8ba1\u7b97\u8fd0\u884c", (String)"RiskTask_0", (String)"taxc-tctrc-common", (Object[])new Object[0]), Boolean.FALSE);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        this.sum += (int)(this.num * (double)this.count.addAndGet(1));
        int decrementAndGet = this.logCount.incrementAndGet();
        if (decrementAndGet <= this.ids.length) {
            RiskRunLogHelper.updateRunLog(decrementAndGet, this.ids.length, this.riskRunLog);
        }
        this.progressBar.setPercent(this.sum);
        if (logger.isDebugEnabled()) {
            logger.debug("--------------" + this.sum);
        }
        return resultList;
    }
}

