/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.common.task.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tctrc.common.cal.CalculateService;
import kd.taxc.tctrc.common.element.RiskCalSerivce;
import kd.taxc.tctrc.common.entity.EleTreeInfo;
import kd.taxc.tctrc.common.task.helper.ErrorFlag;
import kd.taxc.tctrc.common.util.BigDecimalUtil;
import kd.taxc.tctrc.common.util.DBUtils;
import kd.taxc.tctrc.common.util.DateUtils;
import kd.taxc.tctrc.common.util.EleTreeUtil;
import kd.taxc.tctrc.common.util.ElementUtil;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;
import org.apache.commons.lang3.StringUtils;

public class EleCheckPlanHelper {
    public static boolean distant() {
        return DBUtils.execute("DELETE FROM t_tdm_element_result WHERE fid IN ( SELECT fid FROM  (SELECT MIN(fid) AS fid  FROM t_tdm_element_result GROUP BY forg,felement,fstartdata,fenddata HAVING COUNT(1)>1 ) AS temp_table_a )");
    }

    public static void check(DynamicObject checkPlan, List<EleTreeInfo> eleTreeInfos, Map<String, DynamicObject> code2InfoMap) {
        DynamicObject planResult = BusinessDataServiceHelper.newDynamicObject((String)"tdm_ele_check_plan_res");
        planResult.set("planno", checkPlan.get("planno"));
        planResult.set("planname", checkPlan.get("planname"));
        planResult.set("runtime", (Object)new Date());
        planResult.set("isrecal", (Object)"0");
        DynamicObjectCollection treeentryentity = planResult.getDynamicObjectCollection("treeentryentity");
        checkPlan.set("runtime", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkPlan});
        List<QFilter> qFilters = EleCheckPlanHelper.prepareQFilter(checkPlan, eleTreeInfos);
        QFilter qFilter = new QFilter("usetype", "=", (Object)"1");
        DynamicObject[] eleResList = BusinessDataServiceHelper.load((String)"tdm_element_result", (String)"org,element,elementdef,value,startdata,enddata,runtime", (QFilter[])qFilters.toArray(new QFilter[]{qFilter}));
        ArrayList<Map<String, String>> errorTops = new ArrayList<Map<String, String>>(10);
        if (EmptyCheckUtils.isEmpty(eleResList)) {
            planResult.set("unnormalcount", (Object)0);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{planResult});
            return;
        }
        ErrorFlag errorFlag = new ErrorFlag(false);
        EleCheckPlanHelper.createTree(null, Arrays.stream(eleResList).collect(Collectors.toList()), treeentryentity, code2InfoMap, errorFlag, errorTops);
        planResult.set("unnormalcount", (Object)treeentryentity.stream().filter(v -> 0 == v.getInt("pid")).count());
        if (EmptyCheckUtils.isNotEmpty(errorTops)) {
            planResult.set("errorelemsg_tag", (Object)SerializationUtils.toJsonString(errorTops));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{planResult});
    }

    private static Map<String, String> createTopEleMap(DynamicObject tree) {
        HashMap<String, String> topMap = new HashMap<String, String>(16);
        topMap.put("number", tree.getString("ele.number"));
        topMap.put("orgid", tree.getString("org.id"));
        topMap.put("startdate", DateUtils.format(tree.getDate("startdata")));
        topMap.put("enddate", DateUtils.format(tree.getDate("enddata")));
        return topMap;
    }

    private static BigDecimal getChildrenTotal(Map<String, DynamicObject> code2InfoMap, DynamicObject result, List<DynamicObject> childrens, StringBuilder errormsgsb) {
        String[] formula;
        String formula1 = ElementUtil.getFormula(code2InfoMap.get(result.getString("element")));
        if (EmptyCheckUtils.isEmpty(formula1)) {
            return BigDecimal.ZERO;
        }
        String temp = formula1;
        for (String content : formula = formula1.split(" ")) {
            String target = ElementUtil.splitElementFormula(content);
            if (StringUtils.isEmpty((CharSequence)target) || "+-*/()<><=>=abs(".contains(target) || ElementUtil.isConstantNumber(target, code2InfoMap)) continue;
            boolean isHaveResult = false;
            for (DynamicObject childrenTemp : childrens) {
                if (!target.equalsIgnoreCase(childrenTemp.getString("element"))) continue;
                isHaveResult = true;
                temp = temp.replace(content, EleCheckPlanHelper.getEleResultVal(childrenTemp));
                break;
            }
            if (isHaveResult) continue;
            errormsgsb.append(content).append(" \u3001");
            temp = temp.replace(content, "0");
        }
        return RiskCalSerivce.isDenominatorZero(temp) ? BigDecimal.ZERO.setScale(4, RoundingMode.HALF_UP) : BigDecimalUtil.setScale(CalculateService.calculate(temp), 4);
    }

    private static void createTree(DynamicObject parentTree, List<DynamicObject> childrens, DynamicObjectCollection treeentryentity, Map<String, DynamicObject> code2InfoMap, ErrorFlag isError, List<Map<String, String>> errorTops) {
        boolean isTop = null == parentTree;
        for (DynamicObject childrenResult : childrens) {
            if (isTop) {
                isError.setError(false);
            }
            DynamicObject childrenTree = treeentryentity.addNew();
            DynamicObject ele = childrenResult.getDynamicObject("elementdef");
            EleCheckPlanHelper.initTree(childrenTree, childrenResult, parentTree);
            if (null == ele) {
                isError.setError(true);
                String msg = String.format(ResManager.loadKDString((String)"\u5143\u7d20\u201c%s\u201d\u4e0d\u5b58\u5728\u6216\u8005\u88ab\u7981\u7528\u3002", (String)"EleCheckPlanHelper_1", (String)"taxc-tctrc-common", (Object[])new Object[0]), childrenResult.getString("element"));
                childrenTree.set("errorreport_tag", (Object)msg);
                continue;
            }
            DynamicObject childrenELe = childrenResult.getDynamicObject("elementdef");
            if (childrenELe.getBoolean("bottom")) continue;
            StringBuilder errormsgsb = new StringBuilder();
            errormsgsb.append(ResManager.loadKDString((String)"\u4e0b\u5217\u5b50\u9879\u4e0d\u5b58\u5728\u8ba1\u7b97\u7ed3\u679c\uff1a", (String)"EleCheckPlanHelper_0", (String)"taxc-tctrc-common", (Object[])new Object[0]));
            List<DynamicObject> childrenNextLevels = EleCheckPlanHelper.findChildrenResult(childrenResult, code2InfoMap);
            BigDecimal childrenTotal = EleCheckPlanHelper.getChildrenTotal(code2InfoMap, childrenResult, childrenNextLevels, errormsgsb);
            BigDecimal parentVal = BigDecimalUtil.toBigDecimal(EleCheckPlanHelper.getEleResultVal(childrenResult)).setScale(4, RoundingMode.HALF_UP);
            if (errormsgsb.toString().indexOf(12289) > 0) {
                isError.setError(true);
                childrenTree.set("errorreport_tag", (Object)errormsgsb.toString());
            } else {
                if (parentVal.compareTo(childrenTotal) != 0) {
                    isError.setError(true);
                    childrenTree.set("diff", (Object)parentVal.subtract(childrenTotal).setScale(4, RoundingMode.HALF_UP));
                    childrenTree.set("childrentotal", (Object)childrenTotal);
                }
                EleCheckPlanHelper.createTree(childrenTree, childrenNextLevels, treeentryentity, code2InfoMap, isError, errorTops);
            }
            if (!isTop) continue;
            if (!isError.isError()) {
                EleCheckPlanHelper.removeChildren(treeentryentity, childrenTree);
                continue;
            }
            errorTops.add(EleCheckPlanHelper.createTopEleMap(childrenTree));
        }
    }

    private static void removeChildren(DynamicObjectCollection treeentryentity, DynamicObject parent) {
        ArrayList<Long> ids = new ArrayList<Long>(10);
        EleCheckPlanHelper.findChildrenIds(ids, treeentryentity, parent);
        List<DynamicObject> childrens = treeentryentity.stream().filter(v -> ids.contains(v.getLong("id"))).collect(Collectors.toList());
        childrens.forEach(v -> treeentryentity.remove(v));
    }

    private static void findChildrenIds(List<Long> ids, DynamicObjectCollection treeentryentity, DynamicObject parent) {
        if (!ids.contains(parent.getLong("id"))) {
            ids.add(parent.getLong("id"));
        }
        Long pid = parent.getLong("id");
        for (DynamicObject children : treeentryentity) {
            Long parentid = children.getLong("pid");
            if (!parentid.equals(pid)) continue;
            EleCheckPlanHelper.findChildrenIds(ids, treeentryentity, children);
        }
    }

    private static void initTree(DynamicObject tree, DynamicObject result, DynamicObject parentTree) {
        if (null != parentTree) {
            tree.set("pid", parentTree.get("id"));
        }
        tree.set("id", (Object)DBUtils.getLongId("t_tdm_ele_check_res_entry"));
        tree.set("ele", result.get("elementdef"));
        tree.set("org", result.get("org"));
        tree.set("startdata", result.get("startdata"));
        tree.set("enddata", result.get("enddata"));
        tree.set("eleruntime", result.get("runtime"));
        tree.set("curval", (Object)BigDecimalUtil.toBigDecimal(EleCheckPlanHelper.getEleResultVal(result)).setScale(4, RoundingMode.HALF_UP).toString());
        tree.set("formula", EmptyCheckUtils.isEmpty(result.getDynamicObject("elementdef")) ? null : ElementUtil.getFormula(result.getDynamicObject("elementdef")));
    }

    private static String getEleResultVal(DynamicObject ele) {
        return "null".equalsIgnoreCase(ele.getString("value")) ? "0" : ele.getString("value");
    }

    private static List<DynamicObject> findChildrenResult(DynamicObject result, Map<String, DynamicObject> code2InfoMap) {
        DynamicObject ele = result.getDynamicObject("elementdef");
        Date startdata = result.getDate("startdata");
        Date enddata = result.getDate("enddata");
        List<String> nextLevelEles = ElementUtil.getUnBottomNextLevelEles(ele, code2InfoMap);
        QFilter startQ = new QFilter("startdata", "=", (Object)startdata);
        QFilter endQ = new QFilter("enddata", "=", (Object)enddata);
        QFilter eleCodesQ = new QFilter("element", "in", nextLevelEles);
        QFilter orgQ = new QFilter("org", "=", result.get("org.id"));
        DynamicObject[] eles = BusinessDataServiceHelper.load((String)"tdm_element_result", (String)"org,element,elementdef,value,startdata,enddata,runtime", (QFilter[])new QFilter[]{startQ, endQ, eleCodesQ, orgQ});
        return Arrays.stream(eles).collect(Collectors.toList());
    }

    private static List<QFilter> prepareQFilter(DynamicObject checkPlan, List<EleTreeInfo> eleTreeInfos) {
        DynamicObjectCollection eles;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        QFilter startQFilter = new QFilter("startdata", ">=", (Object)checkPlan.getDate("plandatestart"));
        qFilters.add(startQFilter);
        QFilter endQFilter = new QFilter("enddata", "<=", (Object)checkPlan.getDate("plandateend"));
        qFilters.add(endQFilter);
        DynamicObjectCollection orgs = checkPlan.getDynamicObjectCollection("checkorgs");
        if (EmptyCheckUtils.isNotEmpty(orgs)) {
            QFilter orgQFilter = new QFilter("org", "in", orgs.stream().map(v -> v.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()));
            qFilters.add(orgQFilter);
        }
        if (EmptyCheckUtils.isNotEmpty(eles = checkPlan.getDynamicObjectCollection("checkeles"))) {
            List<String> eleCodes = eles.stream().map(v -> v.getDynamicObject("fbasedataid").getString("number")).collect(Collectors.toList());
            List<String> topEles = EleTreeUtil.findTopEleCodesByBottoms(eleTreeInfos, eleCodes);
            QFilter eleQFilter = new QFilter("elementdef.number", "in", topEles);
            qFilters.add(eleQFilter);
        } else {
            QFilter eleQFilter = new QFilter("elementdef.number", "in", EleTreeUtil.findAllTopEleCodes(eleTreeInfos));
            qFilters.add(eleQFilter);
        }
        return qFilters;
    }
}

