/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.common.util;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.taxc.tctrc.common.element.TimeDeviatedEnum;
import kd.taxc.tctrc.common.util.DateUtils;

public class CalUtils {
    public static final String FIELD_STARTDATE = "startdate";
    public static final String FIELD_ENDDATE = "enddate";
    public static final String TIMEDEVIATIONTYPE = "timedeviationtype";
    public static final String TIMEDEVIATIONCOUNT = "timedeviationcount";

    public static List<Map<String, Date>> getCalDate(String calType, Date startDate, Date endDate) {
        ArrayList<Map<String, Date>> list = new ArrayList<Map<String, Date>>();
        Date startdate = DateUtils.trunc(startDate);
        Date enddate = endDate;
        if (TimeDeviatedEnum.TIME_DEVIATION_MONTH.getDeviatedType().equals(calType)) {
            CalUtils.getMonthTypeList(list, startdate, enddate);
        } else if (TimeDeviatedEnum.TIME_DEVIATION_SEASON.getDeviatedType().equals(calType)) {
            CalUtils.getSeasonTypeList(list, startdate, enddate);
        } else if (TimeDeviatedEnum.TIME_DEVIATION_YEAR.getDeviatedType().equals(calType)) {
            CalUtils.getYearTypeList(list, startdate, enddate);
        } else if (TimeDeviatedEnum.TIME_DEVIATION_HALF_YEAR.getDeviatedType().equals(calType)) {
            CalUtils.getHalfYearTypeList(list, startdate, enddate);
        }
        return list;
    }

    private static void getMonthTypeList(List<Map<String, Date>> list, Date startDate, Date endDate) {
        startDate = DateUtils.getFirstDateOfMonth(startDate);
        endDate = DateUtils.getLastDateOfMonth(endDate);
        while (startDate.compareTo(endDate) < 0) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(startDate);
            Date lastDateOfMonth = DateUtils.trunc(DateUtils.getLastDateOfMonth(startDate));
            if (lastDateOfMonth.compareTo(endDate) > 0) break;
            HashMap<String, Date> map = new HashMap<String, Date>();
            map.put(FIELD_STARTDATE, startDate);
            map.put(FIELD_ENDDATE, lastDateOfMonth);
            startDate = DateUtils.addMonth(DateUtils.getFirstDateOfMonth(startDate), 1);
            list.add(map);
        }
    }

    private static void getSeasonTypeList(List<Map<String, Date>> list, Date startdate, Date enddate) {
        startdate = DateUtils.getFirstDateOfSeason(startdate);
        enddate = DateUtils.getLastDateOfSeason(enddate);
        while (startdate.compareTo(enddate) < 0) {
            Calendar dar = Calendar.getInstance();
            dar.setTime(startdate);
            HashMap<String, Date> map = new HashMap<String, Date>();
            Date end = DateUtils.getLastDateOfMonth(DateUtils.addMonth(startdate, 2));
            if (DateUtils.trunc(end).compareTo(enddate) > 0) break;
            map.put(FIELD_STARTDATE, startdate);
            map.put(FIELD_ENDDATE, DateUtils.trunc(end));
            list.add(map);
            startdate = DateUtils.addMonth(DateUtils.getFirstDateOfMonth(startdate), 3);
        }
    }

    private static void getYearTypeList(List<Map<String, Date>> list, Date startdate, Date enddate) {
        startdate = DateUtils.getFirstDateOfYear(startdate);
        enddate = DateUtils.getLastDateOfYear(enddate);
        while (startdate.compareTo(enddate) < 0) {
            Calendar dar = Calendar.getInstance();
            dar.setTime(startdate);
            HashMap<String, Date> map = new HashMap<String, Date>();
            String end = DateUtils.getYearOfDate(startdate) + "-12-31";
            Date endData = DateUtils.stringToDate(end);
            if (DateUtils.trunc(endData).compareTo(enddate) > 0) break;
            map.put(FIELD_STARTDATE, startdate);
            map.put(FIELD_ENDDATE, DateUtils.trunc(endData));
            list.add(map);
            startdate = DateUtils.addYear(DateUtils.getFirstDateOfMonth(startdate), 1);
        }
    }

    private static void getHalfYearTypeList(List<Map<String, Date>> list, Date startdate, Date enddate) {
        startdate = DateUtils.getFirstDateOfHalfYear(startdate);
        enddate = DateUtils.getLastDateOfHalfYear(enddate);
        while (startdate.compareTo(enddate) < 0) {
            Calendar dar = Calendar.getInstance();
            dar.setTime(startdate);
            HashMap<String, Date> map = new HashMap<String, Date>();
            Date end = DateUtils.getLastDateOfMonth(DateUtils.addMonth(startdate, 5));
            if (DateUtils.trunc(end).compareTo(enddate) > 0) break;
            map.put(FIELD_STARTDATE, startdate);
            map.put(FIELD_ENDDATE, DateUtils.trunc(end));
            list.add(map);
            startdate = DateUtils.addMonth(DateUtils.getFirstDateOfMonth(startdate), 6);
        }
    }
}

