/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.common.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.taxc.tctrc.common.element.Formula;
import kd.taxc.tctrc.common.entity.ElementDependencyElementDo;
import kd.taxc.tctrc.common.enums.BooleanEnum;
import kd.taxc.tctrc.common.util.DateUtils;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;
import org.apache.commons.lang.math.NumberUtils;

public class ElementUtil {
    public static final String EXPRESSION_ELEMENT_PREFIX = "${";
    public static final String EXPRESSION_ELEMENT_SUFFIX = "}";
    public static final String EXPRESSION_ELEMENT_NAME_CODE_DELIMITER = "\\|";

    public static final List<Map<String, String>> parseJson(String json) {
        if (StringUtils.isEmpty((CharSequence)json.trim())) {
            return new ArrayList<Map<String, String>>(0);
        }
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        try {
            List map = SerializationUtils.fromJsonStringToList((String)json, Map.class);
            list.addAll(map);
        }
        catch (Exception e) {
            Map map = (Map)SerializationUtils.fromJsonString((String)json, Map.class);
            list.add(map);
        }
        return list;
    }

    public static final Map<String, String> findRule(String json, String orgid) {
        List<Map<String, String>> ruleList = ElementUtil.parseJson(json);
        if (1 == ruleList.size()) {
            return ruleList.get(0);
        }
        Map<String, String> defaultRule = null;
        for (Map<String, String> rule : ruleList) {
            if (BooleanEnum.YES.getCode().equalsIgnoreCase(rule.get("isdefaultrule"))) {
                defaultRule = rule;
                continue;
            }
            if (!EmptyCheckUtils.isNotEmpty(rule.get("orgs")) || rule.get("orgs").indexOf(orgid) <= -1) continue;
            return rule;
        }
        return defaultRule;
    }

    public static List<Map<String, String>> findNewRule(String json_tag, String orgid, Date startDate, Date endDate, Date dataSourceDate) {
        ArrayList<Map<String, String>> resList = new ArrayList<Map<String, String>>(10);
        List<Map<String, String>> ruleList = ElementUtil.parseJson(json_tag);
        boolean isSingleRule = null != dataSourceDate;
        boolean isDefaultRule = ruleList.size() == 1;
        String defaultname = ResManager.loadKDString((String)"\u9ed8\u8ba4\u89c4\u5219", (String)"ElementUtil_0", (String)"taxc-tctrc-common", (Object[])new Object[0]);
        Map<String, String> defaultRuleMap = null;
        for (Map<String, String> ruleMap : ruleList) {
            String rulename = ruleMap.get("rulename");
            if (defaultname.equalsIgnoreCase(rulename)) {
                defaultRuleMap = ruleMap;
            }
            String datasourcestr = ruleMap.get("datasoucejson");
            if (!isDefaultRule && (isDefaultRule || !EmptyCheckUtils.isNotEmpty(ruleMap.get("orgs")) || ruleMap.get("orgs").indexOf(orgid) <= -1)) continue;
            return ElementUtil.getMaps(startDate, endDate, dataSourceDate, resList, isSingleRule, rulename, datasourcestr);
        }
        if (null != defaultRuleMap) {
            String datasourcestr = (String)defaultRuleMap.get("datasoucejson");
            return ElementUtil.getMaps(startDate, endDate, dataSourceDate, resList, isSingleRule, defaultname, datasourcestr);
        }
        return null;
    }

    protected static List<Map<String, String>> getMaps(Date startDate, Date endDate, Date dataSourceDate, List<Map<String, String>> resList, boolean isSingleRule, String rulename, String datasourcestr) {
        List<Map<String, String>> dataSourceMapList = ElementUtil.parseJson(datasourcestr);
        for (Map<String, String> dataSourceMap : dataSourceMapList) {
            if (isSingleRule) {
                if (!ElementUtil.doFindNewRuleBySingleDate(dataSourceDate, rulename, dataSourceMap)) continue;
                resList.add(dataSourceMap);
                return resList;
            }
            if (!ElementUtil.doFindNewRule(startDate, endDate, rulename, dataSourceMap)) continue;
            resList.add(dataSourceMap);
        }
        return EmptyCheckUtils.isEmpty(resList) ? null : resList;
    }

    private static boolean doFindNewRule(Date startDate, Date endDate, String rulename, Map<String, String> dataSourceMap) {
        Date ruleStartDate = DateUtils.getFirstDateOfMonth(DateUtils.stringToDate(dataSourceMap.get("startdated")));
        Date ruleEndDate = EmptyCheckUtils.isEmpty(dataSourceMap.get("enddated")) ? DateUtils.getLastDateOfMonth(DateUtils.stringToDate("2099-12-31")) : DateUtils.getLastDateOfMonth(DateUtils.stringToDate(dataSourceMap.get("enddated")));
        dataSourceMap.put("rulename", rulename);
        if (DateUtils.isEffectiveDate(startDate, endDate, ruleStartDate, ruleEndDate)) {
            dataSourceMap.put("isNeedChangeQueryDate", "0");
            return true;
        }
        if (DateUtils.isEffectiveDate(ruleStartDate, ruleEndDate, startDate, endDate)) {
            dataSourceMap.put("isNeedChangeQueryDate", "1");
            dataSourceMap.put("querystartdate", DateUtils.format(ruleStartDate));
            dataSourceMap.put("queryenddate", DateUtils.format(ruleEndDate));
            return true;
        }
        if (DateUtils.isEffectiveDate(startDate, ruleStartDate, ruleEndDate)) {
            dataSourceMap.put("isNeedChangeQueryDate", "1");
            dataSourceMap.put("querystartdate", DateUtils.format(startDate));
            dataSourceMap.put("queryenddate", DateUtils.format(ruleEndDate));
            return true;
        }
        if (DateUtils.isEffectiveDate(endDate, ruleStartDate, ruleEndDate)) {
            dataSourceMap.put("isNeedChangeQueryDate", "1");
            dataSourceMap.put("querystartdate", DateUtils.format(ruleStartDate));
            dataSourceMap.put("queryenddate", DateUtils.format(endDate));
            return true;
        }
        return false;
    }

    private static boolean doFindNewRuleBySingleDate(Date endDate, String rulename, Map<String, String> dataSourceMap) {
        Date ruleEndDate;
        Date ruleStartDate = DateUtils.getFirstDateOfMonth(DateUtils.stringToDate(dataSourceMap.get("startdated")));
        Date date = ruleEndDate = EmptyCheckUtils.isEmpty(dataSourceMap.get("enddated")) ? DateUtils.getLastDateOfMonth(DateUtils.stringToDate("2099-12-31")) : DateUtils.getLastDateOfMonth(DateUtils.stringToDate(dataSourceMap.get("enddated")));
        if (DateUtils.isEffectiveDate(endDate, ruleStartDate, ruleEndDate)) {
            dataSourceMap.put("isNeedChangeQueryDate", "0");
            dataSourceMap.put("rulename", rulename);
            return true;
        }
        return false;
    }

    public static boolean isConstantNumber(String number, Map<String, DynamicObject> code2EleInfoMap) {
        return null == code2EleInfoMap.get(number) && NumberUtils.isNumber((String)number);
    }

    public static boolean isConstantNumberNew(String content, Map<String, String> codeNameMappings) {
        return null == codeNameMappings.get(content) && NumberUtils.isNumber((String)content);
    }

    public static String getFormula(DynamicObject ele) {
        return null == ele ? null : ele.getString("formula");
    }

    public static List<String> getUnBottomNextLevelEles(DynamicObject ele, Map<String, DynamicObject> code2InfoMap) {
        String formula;
        ArrayList<String> eleCodes = new ArrayList<String>(10);
        if (!ele.getBoolean("bottom") && EmptyCheckUtils.isNotEmpty(formula = ElementUtil.getFormula(ele))) {
            String[] formulas;
            for (String f : formulas = formula.split(" ")) {
                if ("+-*/()<><=>=abs(".contains(f) || ElementUtil.isConstantNumber(f, code2InfoMap)) continue;
                eleCodes.add(f);
            }
        }
        return eleCodes.stream().distinct().collect(Collectors.toList());
    }

    public static String splitElementFormula(String elementContent) {
        String result = "";
        if (EmptyCheckUtils.isNotEmpty(elementContent)) {
            String[] split = elementContent.replace(EXPRESSION_ELEMENT_PREFIX, "").replace(EXPRESSION_ELEMENT_SUFFIX, "").split(EXPRESSION_ELEMENT_NAME_CODE_DELIMITER);
            result = split.length == 1 ? elementContent : split[1];
        }
        return result;
    }

    public static Map<String, String> getCodeNameMappings(Map<String, DynamicObject> eleCode2InfoMap) {
        if (EmptyCheckUtils.isEmpty(eleCode2InfoMap)) {
            return new HashMap<String, String>(1);
        }
        Map<String, String> mapping = eleCode2InfoMap.entrySet().stream().collect(Collectors.toMap(k -> EXPRESSION_ELEMENT_PREFIX + ((DynamicObject)k.getValue()).getString("name") + "|" + (String)k.getKey() + EXPRESSION_ELEMENT_SUFFIX, Map.Entry::getKey));
        Map<String, String> numberMapings = eleCode2InfoMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getKey));
        mapping.putAll(numberMapings);
        return mapping;
    }

    public static List<String> getFormulaElementInfo(String formula) {
        ArrayList<String> result = new ArrayList<String>(16);
        ElementUtil.parseFormulaElementInfo(formula, result);
        return result;
    }

    private static void parseFormulaElementInfo(String formula, List<String> elementList) {
        if (StringUtils.isEmpty((CharSequence)formula)) {
            return;
        }
        if (formula.indexOf(EXPRESSION_ELEMENT_PREFIX) < 0) {
            return;
        }
        int suffixIndex = (formula = formula.substring(formula.indexOf(EXPRESSION_ELEMENT_PREFIX) + EXPRESSION_ELEMENT_PREFIX.length())).indexOf(EXPRESSION_ELEMENT_SUFFIX);
        if (suffixIndex < 0) {
            return;
        }
        String elementInfo = formula.substring(0, suffixIndex).trim();
        elementList.add(elementInfo);
        ElementUtil.parseFormulaElementInfo(formula.substring(suffixIndex + EXPRESSION_ELEMENT_SUFFIX.length()), elementList);
    }

    public static List<Integer[]> getFormulaElementIndexRange(String formula) {
        ArrayList<Integer[]> result = new ArrayList<Integer[]>(16);
        ElementUtil.parseFormulaElementIndex(formula, result, 0);
        return result;
    }

    private static void parseFormulaElementIndex(String formula, List<Integer[]> elementIndexRange, int startIndex) {
        if (StringUtils.isEmpty((CharSequence)formula)) {
            return;
        }
        if (formula.indexOf(EXPRESSION_ELEMENT_PREFIX) < 0) {
            return;
        }
        Integer[] indexRange = new Integer[2];
        int prefixIndex = formula.indexOf(EXPRESSION_ELEMENT_PREFIX);
        indexRange[0] = prefixIndex + startIndex;
        formula = formula.substring(prefixIndex + EXPRESSION_ELEMENT_PREFIX.length());
        int suffixIndex = formula.indexOf(EXPRESSION_ELEMENT_SUFFIX);
        indexRange[1] = prefixIndex + EXPRESSION_ELEMENT_PREFIX.length() + suffixIndex + EXPRESSION_ELEMENT_SUFFIX.length() + startIndex;
        elementIndexRange.add(indexRange);
        ElementUtil.parseFormulaElementIndex(formula.substring(suffixIndex + EXPRESSION_ELEMENT_SUFFIX.length()), elementIndexRange, indexRange[1]);
    }

    public static List<ElementDependencyElementDo> parseElementDependencyElement(String formula, Map<String, DynamicObject> elementCodeKeyMap) {
        List<Integer[]> formulaElementIndexRanges = ElementUtil.getFormulaElementIndexRange(formula);
        ArrayList<ElementDependencyElementDo> result = new ArrayList<ElementDependencyElementDo>(formulaElementIndexRanges.size());
        for (Integer[] formulaElementIndexRange : formulaElementIndexRanges) {
            String elementInfo = formula.substring(formulaElementIndexRange[0] + EXPRESSION_ELEMENT_PREFIX.length(), formulaElementIndexRange[1] - EXPRESSION_ELEMENT_SUFFIX.length());
            String elementCode = elementInfo.split(EXPRESSION_ELEMENT_NAME_CODE_DELIMITER)[1];
            long elementId = elementCodeKeyMap.containsKey(elementCode) ? elementCodeKeyMap.get(elementCode).getLong("id") : 0L;
            result.add(new ElementDependencyElementDo(elementId, elementCode, formulaElementIndexRange[0], formulaElementIndexRange[1]));
        }
        return result;
    }

    public static List<Formula> getFormulaObject(String formula) {
        String regex = "(\\+|\\-|\\*|\\/|\\(|\\)|abs|\\d+|\\$\\{[^{}]*\\})";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(formula);
        ArrayList<Formula> result = new ArrayList<Formula>(16);
        while (matcher.find()) {
            String value = matcher.group();
            if (NumberUtils.isNumber((String)value)) {
                result.add(new Formula("3", value));
                continue;
            }
            if (value.startsWith(EXPRESSION_ELEMENT_PREFIX)) {
                value = value.substring(2, value.length() - 1);
                String[] elementInfo = value.split(EXPRESSION_ELEMENT_NAME_CODE_DELIMITER);
                result.add(new Formula("1", elementInfo[0].trim(), elementInfo[1].trim()));
                continue;
            }
            result.add(new Formula("2", value));
        }
        return result;
    }

    public static String replaceContentToValue(String json, Formula formula) {
        return json.replace(EXPRESSION_ELEMENT_PREFIX + formula.getName() + "|" + formula.getCode() + EXPRESSION_ELEMENT_SUFFIX, String.valueOf(formula.getValue()));
    }
}

