/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.AdminDivisionProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IconProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.metadata.dao.EntityMetadataUtil;
import kd.taxc.tctrc.common.util.TreeUtils;

public class EntityMetadataUtils
extends EntityMetadataUtil {
    public static TreeNode buildFieldTreeNode(String entityNumber, String entityName) {
        return EntityMetadataUtils.buildFieldTreeNode(entityNumber, entityName, null);
    }

    public static TreeNode buildFieldTreeNode(String entityNumber, String entityName, Object filterFieldProp) {
        List<TreeNode> childList = EntityMetadataUtils.getListTreeFields(entityNumber);
        childList = EntityMetadataUtils.filterFieldProp(childList, filterFieldProp);
        childList.forEach(o -> o.setData(null));
        TreeNode root = new TreeNode(null, "", entityName);
        root.setIsOpened(true);
        TreeNode treeNode = TreeUtils.buildChildren(childList, root);
        return treeNode;
    }

    public static List<TreeNode> getListTreeFields(String entityNumber) {
        ArrayList<TreeNode> childrens = new ArrayList<TreeNode>();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Map entityMap = entityType.getAllEntities();
        for (Map.Entry entry : entityMap.entrySet()) {
            DataEntityPropertyCollection pros = ((EntityType)entry.getValue()).getProperties();
            for (IDataEntityProperty property : pros) {
                if (property.getDisplayName() == null) continue;
                String[] parentIdAndId = EntityMetadataUtils.generateId(property, entityNumber);
                childrens.add(new TreeNode(parentIdAndId[0], parentIdAndId[1], property.getDisplayName().getLocaleValue(), EntityMetadataUtils.convertPropType(property)));
            }
        }
        return childrens;
    }

    private static String[] generateId(IDataEntityProperty property, String entityNumber) {
        String[] id = new String[2];
        List<String> list = EntityMetadataUtils.findParentId(property.getParent());
        list.remove(entityNumber);
        Collections.reverse(list);
        id[0] = String.join((CharSequence)".", list);
        list.add(property.getName());
        id[1] = String.join((CharSequence)".", list);
        return id;
    }

    private static List<String> findParentId(IDataEntityType dataEntityType) {
        ArrayList<String> id = new ArrayList<String>();
        if (null == dataEntityType) {
            return id;
        }
        id.add(dataEntityType.getName());
        id.addAll(EntityMetadataUtils.findParentId(dataEntityType.getParent()));
        return id;
    }

    private static List<TreeNode> filterFieldProp(List<TreeNode> childList, Object filterFieldProp) {
        List<Object> list = childList;
        if (filterFieldProp instanceof PKFieldProp) {
            list = childList.stream().filter(o -> o.getData() instanceof PKFieldProp || o.getData() instanceof EntryProp).collect(Collectors.toList());
        } else if (filterFieldProp instanceof AdminDivisionProp) {
            list = childList.stream().filter(o -> o.getData() instanceof AdminDivisionProp || o.getData() instanceof EntryProp).collect(Collectors.toList());
        } else if (filterFieldProp instanceof DecimalProp) {
            list = childList.stream().filter(o -> o.getData() instanceof DecimalProp || o.getData() instanceof EntryProp).collect(Collectors.toList());
        } else if (filterFieldProp instanceof BooleanProp) {
            list = childList.stream().filter(o -> o.getData() instanceof BooleanProp || o.getData() instanceof EntryProp).collect(Collectors.toList());
        } else if (filterFieldProp instanceof ComboProp) {
            list = childList.stream().filter(o -> o.getData() instanceof ComboProp || o.getData() instanceof EntryProp).collect(Collectors.toList());
        } else if (filterFieldProp instanceof TextProp) {
            list = childList.stream().filter(o -> o.getData() instanceof TextProp || o.getData() instanceof EntryProp).collect(Collectors.toList());
        } else if (filterFieldProp instanceof TimeProp) {
            list = childList.stream().filter(o -> o.getData() instanceof TimeProp || o.getData() instanceof EntryProp).collect(Collectors.toList());
        } else if (filterFieldProp instanceof PictureProp) {
            list = childList.stream().filter(o -> o.getData() instanceof PictureProp || o.getData() instanceof EntryProp).collect(Collectors.toList());
        } else if (filterFieldProp instanceof IconProp) {
            list = childList.stream().filter(o -> o.getData() instanceof IconProp || o.getData() instanceof EntryProp).collect(Collectors.toList());
        } else if (filterFieldProp instanceof DateTimeProp) {
            list = childList.stream().filter(o -> o.getData() instanceof DateTimeProp || o.getData() instanceof EntryProp).collect(Collectors.toList());
        } else if (filterFieldProp instanceof BasedataProp) {
            list = childList.stream().filter(o -> o.getData() instanceof BasedataProp || o.getData() instanceof EntryProp).collect(Collectors.toList());
        } else if (filterFieldProp instanceof EntryProp) {
            list = childList.stream().filter(o -> o.getData() instanceof EntryProp).collect(Collectors.toList());
        } else if (filterFieldProp instanceof MulBasedataProp) {
            list = childList.stream().filter(o -> o.getData() instanceof MulBasedataProp || o.getData() instanceof EntryProp).collect(Collectors.toList());
        } else if (filterFieldProp instanceof DynamicLocaleProperty) {
            list = childList.stream().filter(o -> o.getData() instanceof DynamicLocaleProperty || o.getData() instanceof EntryProp).collect(Collectors.toList());
        }
        return list;
    }

    private static Object convertPropType(IDataEntityProperty property) {
        if (property instanceof PKFieldProp) {
            return new PKFieldProp();
        }
        if (property instanceof AdminDivisionProp) {
            return new AdminDivisionProp();
        }
        if (property instanceof DecimalProp) {
            return new DecimalProp();
        }
        if (property instanceof BooleanProp) {
            return new BooleanProp();
        }
        if (property instanceof ComboProp) {
            return new ComboProp();
        }
        if (property instanceof TextProp) {
            return new TextProp();
        }
        if (property instanceof TimeProp) {
            return new TimeProp();
        }
        if (property instanceof PictureProp) {
            return new PictureProp();
        }
        if (property instanceof IconProp) {
            return new IconProp();
        }
        if (property instanceof DateTimeProp) {
            return new DateTimeProp();
        }
        if (property instanceof BasedataProp) {
            return new BasedataProp();
        }
        if (property instanceof EntryProp) {
            return new EntryProp();
        }
        if (property instanceof MulBasedataProp) {
            return new MulBasedataProp();
        }
        if (property instanceof DynamicLocaleProperty) {
            return new DynamicLocaleProperty();
        }
        return null;
    }
}

