/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.taxc.tctrc.common.enums.LicenseTaxEnum;
import kd.taxc.tctrc.common.helper.LicenseCheckServiceHelper;
import kd.taxc.tctrc.common.helper.OrgCheckServiceHelper;
import kd.taxc.tctrc.common.helper.TaxcMainServiceHelper;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;
import kd.taxc.tctrc.common.util.PermissionUtils;
import kd.taxc.tctrc.common.util.StringUtil;
import kd.taxc.tctrc.common.util.TreeUtils;

public class OrgCheckUtil {
    private static final Log logger = LogFactory.getLog(OrgCheckUtil.class);

    public static boolean checkById(IFormView view, String orgId, String appid, String entityid) {
        DynamicObjectCollection org = TreeUtils.queryOrgListByCondition(TreeUtils.convertParam("id", orgId));
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs(appid, entityid, "4715a0df000000ac");
        if (!hasPermOrgResult.hasAllOrgPerm() && !hasPermOrgResult.getHasPermOrgs().contains(Long.parseLong(orgId))) {
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u7ec4\u7ec7\u201c%s\u201d\u7684\u64cd\u4f5c\u6743\u9650\uff0c\u5982\u9700\u64cd\u4f5c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u7528\u6237\u6388\u6743\u3002", (String)"OrgCheckUtil_2", (String)"taxc-tctrc-common", (Object[])new Object[0]), ((DynamicObject)org.get(0)).getString("name")));
            return true;
        }
        if (LicenseCheckServiceHelper.check(orgId, view, appid)) {
            return true;
        }
        return OrgCheckUtil.orgEnable(view, org, true);
    }

    public static boolean checkByElseForm(IFormView view, String orgId, String appid, String categoryType, String formid) {
        DynamicObjectCollection org = TreeUtils.queryOrgListByCondition(TreeUtils.convertParam("id", orgId));
        if (EmptyCheckUtils.isEmpty(orgId) || Objects.equals("0", orgId)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u7528\u7684\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"OrgCheckUtil_3", (String)"taxc-tctrc-common", (Object[])new Object[0]));
            return true;
        }
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs(appid, formid, "47150e89000000ac");
        if (!hasPermOrgResult.hasAllOrgPerm() && !hasPermOrgResult.getHasPermOrgs().contains(Long.parseLong(orgId))) {
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u7ec4\u7ec7\u201c%s\u201d\u7684\u64cd\u4f5c\u6743\u9650\uff0c\u5982\u9700\u64cd\u4f5c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u7528\u6237\u6388\u6743\u3002", (String)"OrgCheckUtil_2", (String)"taxc-tctrc-common", (Object[])new Object[0]), ((DynamicObject)org.get(0)).getString("name")));
            return true;
        }
        if (LicenseCheckServiceHelper.check(orgId, view, appid)) {
            return true;
        }
        if (OrgCheckUtil.orgEnable(view, org, true)) {
            return true;
        }
        return OrgCheckUtil.isTaxPayerAuth(view, orgId, true);
    }

    public static Long setDefaultOrg(IFormView getView, Long orgid, DynamicObjectCollection permOrgs) {
        return OrgCheckServiceHelper.setDefaultOrg(getView, orgid, permOrgs);
    }

    public static boolean check(IFormView view, String orgId, String appid, String categoryType) {
        DynamicObjectCollection org = TreeUtils.queryOrgListByCondition(TreeUtils.convertParam("id", orgId));
        if (EmptyCheckUtils.isEmpty(orgId) || Objects.equals("0", orgId)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u7528\u7684\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"OrgCheckUtil_3", (String)"taxc-tctrc-common", (Object[])new Object[0]));
            return true;
        }
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs(view);
        if (!hasPermOrgResult.hasAllOrgPerm() && !hasPermOrgResult.getHasPermOrgs().contains(Long.parseLong(orgId))) {
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u7ec4\u7ec7\u201c%s\u201d\u7684\u64cd\u4f5c\u6743\u9650\uff0c\u5982\u9700\u64cd\u4f5c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u7528\u6237\u6388\u6743\u3002", (String)"OrgCheckUtil_2", (String)"taxc-tctrc-common", (Object[])new Object[0]), ((DynamicObject)org.get(0)).getString("name")));
            return true;
        }
        if (LicenseCheckServiceHelper.check(orgId, view, appid)) {
            return true;
        }
        if (OrgCheckUtil.orgEnable(view, org, true)) {
            return true;
        }
        return OrgCheckUtil.isTaxPayerAuth(view, orgId, true);
    }

    private static String getCategoryentName(String categoryType) {
        switch (categoryType) {
            case "qysds": {
                return ResManager.loadKDString((String)"\u4f01\u4e1a\u6240\u5f97\u7a0e", (String)"OrgCheckUtil_4", (String)"taxc-tctrc-common", (Object[])new Object[0]);
            }
            case "yhs": {
                return ResManager.loadKDString((String)"\u5370\u82b1\u7a0e", (String)"OrgCheckUtil_5", (String)"taxc-tctrc-common", (Object[])new Object[0]);
            }
            case "fcscztdsys": {
                return ResManager.loadKDString((String)"\u623f\u4ea7\u7a0e", (String)"OrgCheckUtil_6", (String)"taxc-tctrc-common", (Object[])new Object[0]);
            }
            case "fjsf": {
                return ResManager.loadKDString((String)"\u9644\u52a0\u7a0e", (String)"OrgCheckUtil_7", (String)"taxc-tctrc-common", (Object[])new Object[0]);
            }
            case "tcvat": 
            case "zzs": {
                return ResManager.loadKDString((String)"\u589e\u503c\u7a0e", (String)"OrgCheckUtil_8", (String)"taxc-tctrc-common", (Object[])new Object[0]);
            }
            case "xfs": {
                return ResManager.loadKDString((String)"\u6d88\u8d39\u7a0e", (String)"OrgCheckUtil_9", (String)"taxc-tctrc-common", (Object[])new Object[0]);
            }
        }
        return "xxxx";
    }

    public static boolean withoutLicenseCheck(IFormView view, String orgId, String appid, String categoryType) {
        return OrgCheckUtil.withoutLicenseCheck(view, orgId, appid, categoryType, true);
    }

    public static boolean withoutLicenseCheck(IFormView view, String orgId, String appid, String categoryType, boolean needErrorMsg) {
        return false;
    }

    public static boolean isTaxPayerAuth(IFormView view, String orgId, boolean needErrorMsg) {
        return OrgCheckServiceHelper.isTaxPayerAuth(view, orgId, needErrorMsg);
    }

    public static boolean orgEnable(IFormView view, DynamicObjectCollection org, boolean needErrorMsg) {
        return OrgCheckServiceHelper.orgEnable(view, org, needErrorMsg);
    }

    public static List<Long> getTaxPayerOrgBatch(List<Long> orgids) {
        List<Long> mainlist = TaxcMainServiceHelper.queryTaxcMainOrgIdsByTaxpayer();
        mainlist.retainAll(orgids);
        return orgids;
    }

    public static List<Long> searchCheckBatch(List<Long> orgIds, IFormView view) {
        return OrgCheckUtil.searchCheckBatch(orgIds, view, "47150e89000000ac");
    }

    public static String findTaxOrg(IFormView view, IPageCache pageCache, Long unitOrgId) {
        List<Long> orgids;
        List<Long> checkResult;
        String perm = StringUtil.equals((CharSequence)"tctrc_risk_assign", (CharSequence)view.getEntityId()) ? "47156aff000000ac" : "47150e89000000ac";
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs(view, perm);
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission(hasPermOrgs, true);
        pageCache.put("orgList", SerializationUtils.toJsonString((Object)col));
        if (!CollectionUtils.isEmpty((Collection)col) && EmptyCheckUtils.isNotEmpty(checkResult = OrgCheckUtil.searchCheckBatch2(orgids = col.stream().map(v -> v.getLong("id")).collect(Collectors.toList()), view, perm, false, unitOrgId))) {
            if (checkResult.contains(unitOrgId)) {
                logger.info(unitOrgId + "\u53d6\u4e1a\u52a1\u5355\u5143OrgCheckUtil");
                return String.valueOf(unitOrgId);
            }
            logger.info("{}\u53d6\u7b2c\u4e00\u4e2a\u7a0e\u52a1\u7ec4\u7ec7OrgCheckUtil{}", (Object)unitOrgId, (Object)checkResult.get(0));
            return String.valueOf(checkResult.get(0));
        }
        return null;
    }

    private static List<Long> searchCheckBatch2(List<Long> orgIds, IFormView view, String perm, boolean checkTaxPayer, Long unitOrgId) {
        if (!orgIds.contains(unitOrgId)) {
            logger.info(unitOrgId + "\u8be5\u7ec4\u7ec7\u4e0d\u5728\u6709\u6743\u9650\u7684\u7ec4\u7ec7\u7ed3\u679c\u96c6\u4e2d\u3002OrgCheckUtil.orgIds");
        }
        ArrayList orgResList = new ArrayList(10);
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs(view, perm);
        List<Object> permOrg = new ArrayList(orgIds.size());
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            List hasPermOrgs = hasPermOrgResult.getHasPermOrgs();
            permOrg = orgIds.stream().filter(hasPermOrgs::contains).collect(Collectors.toList());
        } else {
            permOrg = orgIds;
        }
        String appid = view.getFormShowParameter().getAppId();
        logger.info("OrgCheckUtil.getAppId={}", (Object)appid);
        LicenseTaxEnum taxEnum = LicenseTaxEnum.getEnumInstanceByAppid(appid);
        ArrayList<Long> licenseOrg = new ArrayList<Long>(orgIds.size());
        if (EmptyCheckUtils.isNotEmpty((Object)taxEnum)) {
            logger.info("\u4e0d\u6821\u9a8clicense.OrgCheckUtil");
            licenseOrg.addAll(orgIds);
        } else {
            logger.info("\u83b7\u53d6\u5df2\u6388\u6743\u7684license.OrgCheckUtil");
            Map<Long, Boolean> licenseCheckMap = LicenseCheckServiceHelper.checkBatch(orgIds, appid);
            licenseOrg.addAll(licenseCheckMap.entrySet().stream().filter(e -> (Boolean)e.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toList()));
        }
        orgResList.add(new HashSet(permOrg));
        orgResList.add(new HashSet(licenseOrg));
        if (checkTaxPayer) {
            List<Long> taxPayerOrg = OrgCheckUtil.getTaxPayerOrgBatch(orgIds);
            orgResList.add(new HashSet<Long>(taxPayerOrg));
            if (!taxPayerOrg.contains(unitOrgId)) {
                logger.info("{}\u8be5\u7ec4\u7ec7\u4e0d\u662f\u7eb3\u7a0e\u4e3b\u4f53\u3002OrgCheckUtil.enableOrg", (Object)unitOrgId);
            }
        }
        if (!permOrg.contains(unitOrgId)) {
            logger.info("{}\u6ca1\u6709\u8be5\u7ec4\u7ec7\u7684\u6743\u9650\u3002OrgCheckUtil.permOrg", (Object)unitOrgId);
        }
        if (!licenseOrg.contains(unitOrgId)) {
            logger.info("{}\u6ca1\u6709\u8be5\u7ec4\u7ec7\u7684license\u3002OrgCheckUtil.licenseOrg", (Object)unitOrgId);
        }
        Set subOrgResList = orgResList.stream().reduce((v1, v2) -> {
            v1.retainAll((Collection<?>)v2);
            return v1;
        }).orElseGet(Collections::emptySet);
        return new ArrayList<Long>(subOrgResList);
    }

    private static List<Long> searchCheckBatchDetail(List<Long> orgIds, IFormView view, String perm, int checkTaxPayer) {
        List<Long> taxPayerOrg;
        ArrayList orgResList = new ArrayList(10);
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs(view, perm);
        List<Object> permOrg = new ArrayList(orgIds.size());
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            List hasPermOrgs = hasPermOrgResult.getHasPermOrgs();
            permOrg = orgIds.stream().filter(hasPermOrgs::contains).collect(Collectors.toList());
        } else {
            permOrg = orgIds;
        }
        String appid = view.getFormShowParameter().getAppId();
        LicenseTaxEnum taxEnum = LicenseTaxEnum.getEnumInstanceByAppid(appid);
        ArrayList<Long> licenseOrg = new ArrayList<Long>(orgIds.size());
        if (EmptyCheckUtils.isEmpty((Object)taxEnum)) {
            licenseOrg.addAll(orgIds);
        } else {
            Map<Long, Boolean> licenseCheckMap = LicenseCheckServiceHelper.checkBatch(orgIds, appid);
            licenseOrg.addAll(licenseCheckMap.entrySet().stream().filter(e -> (Boolean)e.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toList()));
        }
        ArrayList enableOrg = new ArrayList(orgIds.size());
        Map<Long, Boolean> orgCheckMap = OrgCheckServiceHelper.orgEnableBatch(orgIds);
        enableOrg.addAll(orgCheckMap.entrySet().stream().filter(e -> (Boolean)e.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toList()));
        orgResList.add(new HashSet(permOrg));
        orgResList.add(new HashSet(licenseOrg));
        orgResList.add(new HashSet(enableOrg));
        if (checkTaxPayer == 1) {
            taxPayerOrg = OrgCheckUtil.getTaxPayerOrgBatch(orgIds);
            orgResList.add(new HashSet<Long>(taxPayerOrg));
        } else if (checkTaxPayer == 2) {
            taxPayerOrg = TaxcMainServiceHelper.queryTaxcMainOrgIds();
            taxPayerOrg.retainAll(orgIds);
            orgResList.add(new HashSet<Long>(taxPayerOrg));
        }
        Set subOrgResList = orgResList.stream().reduce((v1, v2) -> {
            v1.retainAll((Collection<?>)v2);
            return v1;
        }).orElseGet(Collections::emptySet);
        return new ArrayList<Long>(subOrgResList);
    }

    public static List<Long> searchCheckBatch(List<Long> orgIds, IFormView view, String perm) {
        return OrgCheckUtil.searchCheckBatchDetail(orgIds, view, perm, 1);
    }

    public static List<Long> searchCheckBatchTwo(List<Long> orgIds, IFormView view, String perm) {
        return OrgCheckUtil.searchCheckBatchDetail(orgIds, view, perm, 2);
    }
}

