/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.common.util;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.taxc.tctrc.common.enums.BooleanEnum;
import kd.taxc.tctrc.common.helper.OrgServiceHelper;
import kd.taxc.tctrc.common.helper.TaxcMainServiceHelper;
import kd.taxc.tctrc.common.util.DateUtils;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;
import kd.taxc.tctrc.common.util.PageShowCommon;
import kd.taxc.tctrc.common.util.PermissionUtils;
import kd.taxc.tctrc.common.util.TreeUtils;

public class OrgUtils {
    private static final Log logger = LogFactory.getLog(OrgUtils.class);
    private static Comparator<Object> CHINA_COMPARATOR;
    private static final boolean DISABLED_FILTER = true;
    public static final String FORM_ORG_GROUP = "tctb_org_group_latest";
    public static final String TCCIT_NSSB_POLICY = "tccit_seasonal_policy";
    public static final String FORM_ORG_GROUP_ENTRY = "orgrow";
    private static final String FIELD_EFFECTDATE = "effectdate";
    private static final String FIELD_INVALIDDATE = "invaliddate";
    public static final Set<String> MUST_IS_TAXPAYER;

    public static Boolean checkOrgDeclaration(Long orgid, Date startDate, Date endDate, String declaration) {
        QFilter statusFilter = new QFilter("status", "=", (Object)"2");
        QFilter summaryorgtype = new QFilter("summaryorgtype", "=", (Object)"1");
        QFilter q1 = new QFilter("orgrow.orgid", "=", (Object)orgid);
        QFilter q2 = new QFilter("taxtype", "=", (Object)"zzs");
        QFilter q3 = new QFilter("orgrow.declaration", "=", (Object)declaration);
        QFilter q4 = new QFilter(FIELD_EFFECTDATE, "<=", (Object)startDate);
        QFilter q5 = new QFilter(FIELD_INVALIDDATE, "is null", null).or(new QFilter(FIELD_INVALIDDATE, ">=", (Object)endDate));
        return QueryServiceHelper.exists((String)FORM_ORG_GROUP, (QFilter[])new QFilter[]{statusFilter, summaryorgtype, q1, q2, q3, q4, q5});
    }

    public static DynamicObject getOrgDeclarePlan(Long orgid, Date startDate, Date endDate) {
        QFilter statusFilter = new QFilter("status", "=", (Object)"2");
        QFilter q1 = new QFilter("orgrow.orgid", "=", (Object)orgid);
        QFilter q2 = new QFilter("taxtype", "=", (Object)"zzs");
        QFilter q4 = new QFilter(FIELD_EFFECTDATE, "<=", (Object)startDate);
        QFilter q5 = new QFilter(FIELD_INVALIDDATE, "is null", null).or(new QFilter(FIELD_INVALIDDATE, ">=", (Object)endDate));
        QFilter q6 = new QFilter("status", "=", (Object)"2");
        return BusinessDataServiceHelper.loadSingle((String)FORM_ORG_GROUP, (String)"id, summaryorgtype, summaryway,orgrow.orgid,orgrow.orgname,orgrow.declaration", (QFilter[])new QFilter[]{statusFilter, q1, q2, q4, q5, q6});
    }

    public static DynamicObjectCollection queryOrgGroupDetailForCollected(String type) {
        String fields = "orgrow.orgid as orgid";
        Date now = new Date();
        QFilter statusFilter = new QFilter("status", "=", (Object)"2");
        QFilter typeFilter = new QFilter("taxtype", "=", (Object)type);
        QFilter declaration = new QFilter("orgrow.declaration", "=", (Object)"3");
        QFilter[] filters = new QFilter[]{statusFilter, typeFilter, declaration, OrgUtils.getQFilter(now)};
        DynamicObjectCollection collection = QueryServiceHelper.query((String)FORM_ORG_GROUP, (String)fields, (QFilter[])filters);
        return collection;
    }

    public static List<TreeNode> getAllPermNodes(String appNumber, String entityId, String type) {
        return OrgServiceHelper.getAllPermNodes(appNumber, entityId, type);
    }

    public static String getOrgStatusById(String orgid) {
        return OrgServiceHelper.getOrgStatusById(orgid);
    }

    public static Long getDefaultViewSchemaInfoId() {
        return OrgServiceHelper.getDefaultViewSchemaInfoId();
    }

    public static Map<String, Map<String, String>> getAllOrgByViewId(Long orgViewSchemaId) {
        return OrgUtils.getAllOrgByViewId(orgViewSchemaId, null);
    }

    public static Map<String, Map<String, String>> getAllOrgByViewId(Long orgViewSchemaId, QFilter qFilter) {
        QFilter orgViewIdFilter = new QFilter("view", "=", (Object)orgViewSchemaId);
        if (qFilter != null) {
            orgViewIdFilter.and(qFilter);
        }
        orgViewIdFilter.and(new QFilter("org.enable", "=", (Object)"1"));
        HashMap<String, Map<String, String>> orgTreeMap = new HashMap<String, Map<String, String>>();
        try (DataSet data = QueryServiceHelper.queryDataSet((String)"kd.tmc.fbd.formplugin.companysys.CompanySysViewEdit.getAllOrgByViewId()", (String)"bos_org_structure", (String)"id,org.id,org.name,org.number,parent.id,isleaf,longnumber", (QFilter[])orgViewIdFilter.toArray(), (String)"longnumber");){
            while (data.hasNext()) {
                HashMap<String, String> mtree = new HashMap<String, String>();
                Row row = data.next();
                String id = String.valueOf(row.getLong("org.id"));
                mtree.put("id", id);
                mtree.put("name", row.getString("org.name"));
                mtree.put("number", row.getString("org.number"));
                mtree.put("parentid", String.valueOf(row.getLong("parent.id")));
                mtree.put("isleaf", row.getBoolean("isleaf") != false ? "1" : "0");
                mtree.put("longnumber", row.getString("longnumber"));
                orgTreeMap.put(id, mtree);
            }
        }
        return orgTreeMap;
    }

    public static Map<String, DynamicObject> getAllOrgByView(Long orgViewSchemaId, QFilter qFilter) {
        return OrgServiceHelper.getAllOrgByView(orgViewSchemaId, qFilter);
    }

    public static Map<String, List<Map<String, String>>> getOrgTreeMap(Map<String, Map<String, String>> orgMap) {
        HashMap<String, List<Map<String, String>>> orgTreeMap = new HashMap<String, List<Map<String, String>>>();
        for (Map.Entry<String, Map<String, String>> orgId : orgMap.entrySet()) {
            OrgUtils.buildOrgTree(orgId.getValue(), orgMap, orgTreeMap);
        }
        return orgTreeMap;
    }

    public static void buildOrgTree(Map<String, String> org, Map<String, Map<String, String>> orgMap, Map<String, List<Map<String, String>>> orgTreeMap) {
        List<Map<String, String>> parentList;
        String orgid = org.get("id");
        if (orgid == null || orgid.equalsIgnoreCase("0")) {
            return;
        }
        String parentid = org.get("parentid");
        Map<String, String> parentOrg = orgMap.get(parentid);
        if (orgTreeMap.get(orgid) == null) {
            orgTreeMap.put(orgid, new ArrayList());
        }
        if (parentOrg == null) {
            return;
        }
        if (orgTreeMap.get(parentid) == null) {
            OrgUtils.buildOrgTree(parentOrg, orgMap, orgTreeMap);
        }
        if ((parentList = orgTreeMap.get(parentid)) == null) {
            return;
        }
        if (!parentList.contains(org)) {
            parentList.add(org);
        }
    }

    public static TreeNode createTreeNode(Map<String, Map<String, String>> orgTreeMap) {
        Map<String, Map> rootIdMap = orgTreeMap.entrySet().stream().filter(v -> "0".equals(((Map)v.getValue()).get("parentid"))).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Map)e.getValue()));
        Set<String> rootIdSet = rootIdMap.keySet();
        if (rootIdSet.isEmpty()) {
            return null;
        }
        String rootId = rootIdSet.toArray(new String[0])[0];
        String rootName = orgTreeMap.get(rootId).get("name");
        TreeNode root = new TreeNode();
        root.setParentid("");
        root.setId(rootId);
        root.setText(rootName);
        root.setIsOpened(true);
        root.setLongNumber(orgTreeMap.get(rootId).get("longnumber"));
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("isleaf", "0");
        dataMap.put("level", "1");
        dataMap.put("fullname", rootName);
        root.setData(dataMap);
        return root;
    }

    public static TreeNode createChildNodes(Map<String, List<Map<String, String>>> orgTreeMap, String rootId, TreeNode root) {
        if (orgTreeMap == null || rootId == null || orgTreeMap.size() == 0 || root == null) {
            return null;
        }
        OrgUtils.buildTreeNode(orgTreeMap, rootId, root);
        return root;
    }

    public static void buildTreeNode(Map<String, List<Map<String, String>>> orgTreeMap, String rootId, TreeNode treeNode) {
        List<Map<String, String>> childList = orgTreeMap.get(rootId);
        HashMap dataMap = (HashMap)treeNode.getData();
        if (childList == null || childList.size() == 0) {
            dataMap.put("isleaf", "1");
            return;
        }
        String parentLongNumber = treeNode.getLongNumber();
        int parentLevel = Integer.parseInt((String)dataMap.get("level"));
        String parentName = (String)dataMap.get("fullname");
        for (Map<String, String> org : childList) {
            TreeNode childrenTree = new TreeNode();
            String orgid = org.get("id");
            if ("0".equals(orgid) || StringUtils.isEmpty((CharSequence)org.get("name"))) continue;
            childrenTree.setParentid(org.get("parentid"));
            childrenTree.setId(orgid);
            childrenTree.setText(org.get("name"));
            childrenTree.setIsOpened(false);
            childrenTree.setLongNumber(parentLongNumber + "!" + orgid);
            HashMap<String, String> childDataMap = new HashMap<String, String>();
            childDataMap.put("isleaf", "0");
            childDataMap.put("level", String.valueOf(parentLevel + 1));
            childDataMap.put("fullname", parentName + "_" + org.get("name"));
            childrenTree.setData(childDataMap);
            treeNode.addChild(childrenTree);
            OrgUtils.buildTreeNode(orgTreeMap, orgid, childrenTree);
        }
        OrgUtils.sortTreeNode(treeNode.getChildren());
    }

    public static void sortTreeNode(List<TreeNode> nodes) {
        if (nodes != null && !nodes.isEmpty()) {
            Collections.sort(nodes, (node1, node2) -> CHINA_COMPARATOR.compare(node1.getText(), node2.getText()));
        }
    }

    public static Long getLocalDefaultViewId() {
        return OrgServiceHelper.getLocalDefaultViewId();
    }

    public static QFilter getQFilter(Date enddate) {
        QFilter q = new QFilter(FIELD_EFFECTDATE, "<=", (Object)DateUtils.getLastDateOfMonth1(enddate)).and(FIELD_INVALIDDATE, ">=", (Object)DateUtils.getLastDateOfMonth1(enddate));
        q = q.or(new QFilter(FIELD_EFFECTDATE, "<=", (Object)DateUtils.getLastDateOfMonth1(enddate)).and(QFilter.isNull((String)FIELD_INVALIDDATE)));
        return q;
    }

    public static final List<String> getOrgIdByStructurePkids(List<String> structureIds) {
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"bos_org_structure", (String)"org", (QFilter[])new QFilter[]{new QFilter("id", "in", structureIds.stream().map(v -> Long.parseLong(v)).collect(Collectors.toList()))});
        return EmptyCheckUtils.isEmpty(dys) ? new ArrayList<String>() : dys.stream().map(v -> v.getString("org")).collect(Collectors.toList());
    }

    public static final List<String> getStructurePkidsByOrgId(List<String> orgIds) {
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"bos_org_structure", (String)"id", (QFilter[])new QFilter[]{new QFilter("org.id", "in", orgIds.stream().map(v -> Long.parseLong(v)).collect(Collectors.toList())), OrgUtils.getDefaultTaxOrgStructureViewQfilter()});
        return EmptyCheckUtils.isEmpty(dys) ? new ArrayList<String>() : dys.stream().map(v -> v.getString("id")).distinct().collect(Collectors.toList());
    }

    public static List<Long> mergeOrgIds(List<Long> idList, String status) {
        return OrgServiceHelper.mergeOrgIds(idList, status);
    }

    public static List<Map<String, String>> queryOrgListForInitOrgComboItems(IFormView view, String[] excludeFormArray, String permissionEntiyId, String permissionConstant) {
        DynamicObjectCollection collection;
        ArrayList<Map<String, String>> orgItems = new ArrayList<Map<String, String>>();
        HasPermOrgResult hasPermOrgResult = StringUtils.isBlank((CharSequence)permissionEntiyId) ? PermissionUtils.getAllPermOrgs(view) : PermissionUtils.getAllPermOrgs(view, permissionEntiyId, permissionConstant);
        if (EmptyCheckUtils.isNotEmpty(hasPermOrgResult) && !hasPermOrgResult.hasAllOrgPerm()) {
            List<Long> orgList = hasPermOrgResult.getHasPermOrgs();
            HashMap<String, List<Object>> convertParam = new HashMap<String, List<Object>>(2);
            if (EmptyCheckUtils.isNotEmpty(excludeFormArray) && Arrays.stream(excludeFormArray).anyMatch(v -> v.equals(PageShowCommon.getMetadataNumberByView(view)))) {
                orgList = OrgUtils.mergeOrgIds(orgList, "3");
            }
            TreeUtils.convertParam("id", orgList, convertParam);
            collection = TreeUtils.queryOrgListByCondition(convertParam);
        } else {
            collection = TreeUtils.getOrgLists();
        }
        if (!CollectionUtils.isEmpty((Collection)collection)) {
            collection.stream().forEach(v -> {
                HashMap<String, String> item = new HashMap<String, String>(16);
                item.put("id", v.getString("id"));
                item.put("number", v.getString("number"));
                item.put("name", v.getString("name"));
                item.put("parentid", v.getString("parentid"));
                item.put("status", v.getString("status"));
                item.put("longnumber", v.getString("longnumber"));
                orgItems.add(item);
            });
        }
        return orgItems;
    }

    public static QFilter getDefaultTaxOrgStructureViewQfilter() {
        return new QFilter("view.treetype", "=", (Object)String.valueOf(OrgUtils.getDefaultViewSchemaInfoId())).and("view.number", "=", (Object)"40");
    }

    public static final DynamicObjectCollection getTaxOrgListHasPermission(QFilter qFilter) {
        List<Long> orgids = OrgUtils.getOrgListHasPermission();
        if (EmptyCheckUtils.isEmpty(orgids)) {
            return null;
        }
        return OrgUtils.filterNonTaxPayerOrg(orgids, qFilter);
    }

    public static final List<Long> getOrgListHasPermission() {
        ArrayList<Long> orgIds = new ArrayList<Long>();
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs("tctrc", "tctrc_analysis_parent", "47150e89000000ac");
        if (!hasPermOrgs.hasAllOrgPerm() && EmptyCheckUtils.isEmpty(hasPermOrgs.getHasPermOrgs())) {
            return null;
        }
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission(hasPermOrgs, false);
        if (!CollectionUtils.isEmpty((Collection)col)) {
            for (DynamicObject obj : col) {
                orgIds.add(obj.getLong("id"));
            }
        }
        return orgIds;
    }

    public static DynamicObjectCollection filterNonTaxPayerOrg(List<Long> orgids, QFilter qFilter) {
        QFilter istaxpayerFilter = new QFilter("taxorg.istaxpayer", "=", (Object)BooleanEnum.YES.getCode());
        QFilter orgFilter = new QFilter("orgid", "in", orgids);
        DynamicObjectCollection taxmainCollection = EmptyCheckUtils.isEmpty(qFilter) ? TaxcMainServiceHelper.queryDiy(new QFilter[]{istaxpayerFilter, orgFilter}, TaxcMainServiceHelper.selectFields2) : TaxcMainServiceHelper.queryDiy(new QFilter[]{istaxpayerFilter, orgFilter, qFilter}, TaxcMainServiceHelper.selectFields2);
        return taxmainCollection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> getInfoByOrgIdFromErp(String orgId, String ... selectFields) {
        QFilter id = new QFilter("id", "=", (Object)Long.parseLong(orgId));
        StringBuilder selectStrBuilder = new StringBuilder();
        int len = selectFields.length;
        for (int i = 0; i < len; ++i) {
            selectStrBuilder.append(selectFields[i]);
            selectStrBuilder.append(',');
        }
        String temp = selectStrBuilder.toString();
        String selectStr = temp.substring(0, temp.length() - 1);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)OrgViewServiceHelper.class.getName(), (String)"bos_org", (String)selectStr, (QFilter[])new QFilter[]{id}, (String)"id");){
            HashMap<String, String> map = new HashMap<String, String>();
            Iterator iter = ds.iterator();
            if (iter.hasNext()) {
                Row row = (Row)iter.next();
                for (int key = 0; key < selectFields.length; ++key) {
                    map.put(selectFields[key], row.getString(selectFields[key]));
                }
            }
            HashMap<String, String> hashMap = map;
            return hashMap;
        }
        catch (Exception e) {
            logger.info("OrgUtils.getInfoByOrgIdFromErp", (Object)e);
            return new HashMap<String, String>();
        }
    }

    public static List<Long> getChildrenIds(List<Long> orgIds) {
        Map<String, Map<String, String>> viewTreeMap = OrgUtils.getAllOrgByViewId(Long.parseLong("40"));
        Map<String, List<Map<String, String>>> flatOrgTreeMap = OrgUtils.getOrgTreeMap(viewTreeMap);
        TreeNode viewRoot = OrgUtils.createTreeNode(viewTreeMap);
        if (viewRoot == null) {
            return orgIds;
        }
        OrgUtils.createChildNodes(flatOrgTreeMap, viewRoot.getId(), viewRoot);
        ArrayList childNodes = new ArrayList();
        orgIds.stream().forEach(node -> {
            TreeNode parentNode = viewRoot.getTreeNode(String.valueOf(node), 10);
            childNodes.addAll(TreeUtils.getChildIdList(parentNode));
        });
        List childNodesTemp = childNodes.stream().map(o -> Long.valueOf(o)).collect(Collectors.toList());
        orgIds.addAll(childNodesTemp);
        return orgIds;
    }

    public static List<Long> getTaxPermOrgs(IFormView view) {
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs(view);
        List allOrg = OrgUnitServiceHelper.getAllOrg((String)"40");
        if (hasPermOrgResult.hasAllOrgPerm()) {
            return allOrg;
        }
        List orgList = hasPermOrgResult.getHasPermOrgs();
        List<Long> colls = orgList.stream().filter(allOrg::contains).collect(Collectors.toList());
        return colls;
    }

    static {
        MUST_IS_TAXPAYER = new HashSet<String>(Arrays.asList("tccit_seasonal_declare", "tccit_seasonal_declare2", "tccit_mainpage", "tccit_newmainpage", "tcvat_draft_page", "tcvat_declare_home", "tcvat_declare_edit", "tcret_pbt_declare_home", "tcct_draft_edit", "tcct_declare_new", "tcvat_apphome", "tccit_apphome", "tcret_apphome_new", "tcct_apphome", "tsate_declare_config"));
        CHINA_COMPARATOR = Collator.getInstance(Locale.CHINA);
    }
}

